/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qbusiness.model.HookConfiguration;
import software.amazon.awssdk.services.qbusiness.model.InlineDocumentEnrichmentConfiguration;
import software.amazon.awssdk.services.qbusiness.model.InlineDocumentEnrichmentConfigurationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DocumentEnrichmentConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DocumentEnrichmentConfiguration> {
    private static final SdkField<List<InlineDocumentEnrichmentConfiguration>> INLINE_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("inlineConfigurations").getter(DocumentEnrichmentConfiguration.getter(DocumentEnrichmentConfiguration::inlineConfigurations)).setter(DocumentEnrichmentConfiguration.setter(Builder::inlineConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inlineConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InlineDocumentEnrichmentConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<HookConfiguration> PRE_EXTRACTION_HOOK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("preExtractionHookConfiguration").getter(DocumentEnrichmentConfiguration.getter(DocumentEnrichmentConfiguration::preExtractionHookConfiguration)).setter(DocumentEnrichmentConfiguration.setter(Builder::preExtractionHookConfiguration)).constructor(HookConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preExtractionHookConfiguration").build()}).build();
    private static final SdkField<HookConfiguration> POST_EXTRACTION_HOOK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("postExtractionHookConfiguration").getter(DocumentEnrichmentConfiguration.getter(DocumentEnrichmentConfiguration::postExtractionHookConfiguration)).setter(DocumentEnrichmentConfiguration.setter(Builder::postExtractionHookConfiguration)).constructor(HookConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("postExtractionHookConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INLINE_CONFIGURATIONS_FIELD, PRE_EXTRACTION_HOOK_CONFIGURATION_FIELD, POST_EXTRACTION_HOOK_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DocumentEnrichmentConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<InlineDocumentEnrichmentConfiguration> inlineConfigurations;
    private final HookConfiguration preExtractionHookConfiguration;
    private final HookConfiguration postExtractionHookConfiguration;

    private DocumentEnrichmentConfiguration(BuilderImpl builder) {
        this.inlineConfigurations = builder.inlineConfigurations;
        this.preExtractionHookConfiguration = builder.preExtractionHookConfiguration;
        this.postExtractionHookConfiguration = builder.postExtractionHookConfiguration;
    }

    public final boolean hasInlineConfigurations() {
        return this.inlineConfigurations != null && !(this.inlineConfigurations instanceof SdkAutoConstructList);
    }

    public final List<InlineDocumentEnrichmentConfiguration> inlineConfigurations() {
        return this.inlineConfigurations;
    }

    public final HookConfiguration preExtractionHookConfiguration() {
        return this.preExtractionHookConfiguration;
    }

    public final HookConfiguration postExtractionHookConfiguration() {
        return this.postExtractionHookConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInlineConfigurations() ? this.inlineConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.preExtractionHookConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.postExtractionHookConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentEnrichmentConfiguration)) {
            return false;
        }
        DocumentEnrichmentConfiguration other = (DocumentEnrichmentConfiguration)obj;
        return this.hasInlineConfigurations() == other.hasInlineConfigurations() && Objects.equals(this.inlineConfigurations(), other.inlineConfigurations()) && Objects.equals(this.preExtractionHookConfiguration(), other.preExtractionHookConfiguration()) && Objects.equals(this.postExtractionHookConfiguration(), other.postExtractionHookConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"DocumentEnrichmentConfiguration").add("InlineConfigurations", this.hasInlineConfigurations() ? this.inlineConfigurations() : null).add("PreExtractionHookConfiguration", (Object)this.preExtractionHookConfiguration()).add("PostExtractionHookConfiguration", (Object)this.postExtractionHookConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "inlineConfigurations": {
                return Optional.ofNullable(clazz.cast(this.inlineConfigurations()));
            }
            case "preExtractionHookConfiguration": {
                return Optional.ofNullable(clazz.cast(this.preExtractionHookConfiguration()));
            }
            case "postExtractionHookConfiguration": {
                return Optional.ofNullable(clazz.cast(this.postExtractionHookConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("inlineConfigurations", INLINE_CONFIGURATIONS_FIELD);
        map.put("preExtractionHookConfiguration", PRE_EXTRACTION_HOOK_CONFIGURATION_FIELD);
        map.put("postExtractionHookConfiguration", POST_EXTRACTION_HOOK_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DocumentEnrichmentConfiguration, T> g) {
        return obj -> g.apply((DocumentEnrichmentConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<InlineDocumentEnrichmentConfiguration> inlineConfigurations = DefaultSdkAutoConstructList.getInstance();
        private HookConfiguration preExtractionHookConfiguration;
        private HookConfiguration postExtractionHookConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentEnrichmentConfiguration model) {
            this.inlineConfigurations(model.inlineConfigurations);
            this.preExtractionHookConfiguration(model.preExtractionHookConfiguration);
            this.postExtractionHookConfiguration(model.postExtractionHookConfiguration);
        }

        public final List<InlineDocumentEnrichmentConfiguration.Builder> getInlineConfigurations() {
            List<InlineDocumentEnrichmentConfiguration.Builder> result = InlineDocumentEnrichmentConfigurationsCopier.copyToBuilder(this.inlineConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInlineConfigurations(Collection<InlineDocumentEnrichmentConfiguration.BuilderImpl> inlineConfigurations) {
            this.inlineConfigurations = InlineDocumentEnrichmentConfigurationsCopier.copyFromBuilder(inlineConfigurations);
        }

        @Override
        public final Builder inlineConfigurations(Collection<InlineDocumentEnrichmentConfiguration> inlineConfigurations) {
            this.inlineConfigurations = InlineDocumentEnrichmentConfigurationsCopier.copy(inlineConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inlineConfigurations(InlineDocumentEnrichmentConfiguration ... inlineConfigurations) {
            this.inlineConfigurations(Arrays.asList(inlineConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inlineConfigurations(Consumer<InlineDocumentEnrichmentConfiguration.Builder> ... inlineConfigurations) {
            this.inlineConfigurations(Stream.of(inlineConfigurations).map(c -> (InlineDocumentEnrichmentConfiguration)((InlineDocumentEnrichmentConfiguration.Builder)InlineDocumentEnrichmentConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final HookConfiguration.Builder getPreExtractionHookConfiguration() {
            return this.preExtractionHookConfiguration != null ? this.preExtractionHookConfiguration.toBuilder() : null;
        }

        public final void setPreExtractionHookConfiguration(HookConfiguration.BuilderImpl preExtractionHookConfiguration) {
            this.preExtractionHookConfiguration = preExtractionHookConfiguration != null ? preExtractionHookConfiguration.build() : null;
        }

        @Override
        public final Builder preExtractionHookConfiguration(HookConfiguration preExtractionHookConfiguration) {
            this.preExtractionHookConfiguration = preExtractionHookConfiguration;
            return this;
        }

        public final HookConfiguration.Builder getPostExtractionHookConfiguration() {
            return this.postExtractionHookConfiguration != null ? this.postExtractionHookConfiguration.toBuilder() : null;
        }

        public final void setPostExtractionHookConfiguration(HookConfiguration.BuilderImpl postExtractionHookConfiguration) {
            this.postExtractionHookConfiguration = postExtractionHookConfiguration != null ? postExtractionHookConfiguration.build() : null;
        }

        @Override
        public final Builder postExtractionHookConfiguration(HookConfiguration postExtractionHookConfiguration) {
            this.postExtractionHookConfiguration = postExtractionHookConfiguration;
            return this;
        }

        public DocumentEnrichmentConfiguration build() {
            return new DocumentEnrichmentConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DocumentEnrichmentConfiguration> {
        public Builder inlineConfigurations(Collection<InlineDocumentEnrichmentConfiguration> var1);

        public Builder inlineConfigurations(InlineDocumentEnrichmentConfiguration ... var1);

        public Builder inlineConfigurations(Consumer<InlineDocumentEnrichmentConfiguration.Builder> ... var1);

        public Builder preExtractionHookConfiguration(HookConfiguration var1);

        default public Builder preExtractionHookConfiguration(Consumer<HookConfiguration.Builder> preExtractionHookConfiguration) {
            return this.preExtractionHookConfiguration((HookConfiguration)((HookConfiguration.Builder)HookConfiguration.builder().applyMutation(preExtractionHookConfiguration)).build());
        }

        public Builder postExtractionHookConfiguration(HookConfiguration var1);

        default public Builder postExtractionHookConfiguration(Consumer<HookConfiguration.Builder> postExtractionHookConfiguration) {
            return this.postExtractionHookConfiguration((HookConfiguration)((HookConfiguration.Builder)HookConfiguration.builder().applyMutation(postExtractionHookConfiguration)).build());
        }
    }
}

