/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qbusiness.model.CustomPluginConfiguration;
import software.amazon.awssdk.services.qbusiness.model.PluginAuthConfiguration;
import software.amazon.awssdk.services.qbusiness.model.PluginBuildStatus;
import software.amazon.awssdk.services.qbusiness.model.PluginState;
import software.amazon.awssdk.services.qbusiness.model.PluginType;
import software.amazon.awssdk.services.qbusiness.model.QBusinessResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetPluginResponse
extends QBusinessResponse
implements ToCopyableBuilder<Builder, GetPluginResponse> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationId").getter(GetPluginResponse.getter(GetPluginResponse::applicationId)).setter(GetPluginResponse.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationId").build()}).build();
    private static final SdkField<String> PLUGIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pluginId").getter(GetPluginResponse.getter(GetPluginResponse::pluginId)).setter(GetPluginResponse.setter(Builder::pluginId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pluginId").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(GetPluginResponse.getter(GetPluginResponse::displayName)).setter(GetPluginResponse.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(GetPluginResponse.getter(GetPluginResponse::typeAsString)).setter(GetPluginResponse.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> SERVER_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serverUrl").getter(GetPluginResponse.getter(GetPluginResponse::serverUrl)).setter(GetPluginResponse.setter(Builder::serverUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverUrl").build()}).build();
    private static final SdkField<PluginAuthConfiguration> AUTH_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("authConfiguration").getter(GetPluginResponse.getter(GetPluginResponse::authConfiguration)).setter(GetPluginResponse.setter(Builder::authConfiguration)).constructor(PluginAuthConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authConfiguration").build()}).build();
    private static final SdkField<CustomPluginConfiguration> CUSTOM_PLUGIN_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("customPluginConfiguration").getter(GetPluginResponse.getter(GetPluginResponse::customPluginConfiguration)).setter(GetPluginResponse.setter(Builder::customPluginConfiguration)).constructor(CustomPluginConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customPluginConfiguration").build()}).build();
    private static final SdkField<String> BUILD_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("buildStatus").getter(GetPluginResponse.getter(GetPluginResponse::buildStatusAsString)).setter(GetPluginResponse.setter(Builder::buildStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildStatus").build()}).build();
    private static final SdkField<String> PLUGIN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pluginArn").getter(GetPluginResponse.getter(GetPluginResponse::pluginArn)).setter(GetPluginResponse.setter(Builder::pluginArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pluginArn").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(GetPluginResponse.getter(GetPluginResponse::stateAsString)).setter(GetPluginResponse.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GetPluginResponse.getter(GetPluginResponse::createdAt)).setter(GetPluginResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(GetPluginResponse.getter(GetPluginResponse::updatedAt)).setter(GetPluginResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, PLUGIN_ID_FIELD, DISPLAY_NAME_FIELD, TYPE_FIELD, SERVER_URL_FIELD, AUTH_CONFIGURATION_FIELD, CUSTOM_PLUGIN_CONFIGURATION_FIELD, BUILD_STATUS_FIELD, PLUGIN_ARN_FIELD, STATE_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetPluginResponse.memberNameToFieldInitializer();
    private final String applicationId;
    private final String pluginId;
    private final String displayName;
    private final String type;
    private final String serverUrl;
    private final PluginAuthConfiguration authConfiguration;
    private final CustomPluginConfiguration customPluginConfiguration;
    private final String buildStatus;
    private final String pluginArn;
    private final String state;
    private final Instant createdAt;
    private final Instant updatedAt;

    private GetPluginResponse(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.pluginId = builder.pluginId;
        this.displayName = builder.displayName;
        this.type = builder.type;
        this.serverUrl = builder.serverUrl;
        this.authConfiguration = builder.authConfiguration;
        this.customPluginConfiguration = builder.customPluginConfiguration;
        this.buildStatus = builder.buildStatus;
        this.pluginArn = builder.pluginArn;
        this.state = builder.state;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String pluginId() {
        return this.pluginId;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final PluginType type() {
        return PluginType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String serverUrl() {
        return this.serverUrl;
    }

    public final PluginAuthConfiguration authConfiguration() {
        return this.authConfiguration;
    }

    public final CustomPluginConfiguration customPluginConfiguration() {
        return this.customPluginConfiguration;
    }

    public final PluginBuildStatus buildStatus() {
        return PluginBuildStatus.fromValue(this.buildStatus);
    }

    public final String buildStatusAsString() {
        return this.buildStatus;
    }

    public final String pluginArn() {
        return this.pluginArn;
    }

    public final PluginState state() {
        return PluginState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.pluginId());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.authConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.customPluginConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.buildStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.pluginArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPluginResponse)) {
            return false;
        }
        GetPluginResponse other = (GetPluginResponse)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.pluginId(), other.pluginId()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.serverUrl(), other.serverUrl()) && Objects.equals(this.authConfiguration(), other.authConfiguration()) && Objects.equals(this.customPluginConfiguration(), other.customPluginConfiguration()) && Objects.equals(this.buildStatusAsString(), other.buildStatusAsString()) && Objects.equals(this.pluginArn(), other.pluginArn()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"GetPluginResponse").add("ApplicationId", (Object)this.applicationId()).add("PluginId", (Object)this.pluginId()).add("DisplayName", (Object)this.displayName()).add("Type", (Object)this.typeAsString()).add("ServerUrl", (Object)this.serverUrl()).add("AuthConfiguration", (Object)this.authConfiguration()).add("CustomPluginConfiguration", (Object)this.customPluginConfiguration()).add("BuildStatus", (Object)this.buildStatusAsString()).add("PluginArn", (Object)this.pluginArn()).add("State", (Object)this.stateAsString()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "pluginId": {
                return Optional.ofNullable(clazz.cast(this.pluginId()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "serverUrl": {
                return Optional.ofNullable(clazz.cast(this.serverUrl()));
            }
            case "authConfiguration": {
                return Optional.ofNullable(clazz.cast(this.authConfiguration()));
            }
            case "customPluginConfiguration": {
                return Optional.ofNullable(clazz.cast(this.customPluginConfiguration()));
            }
            case "buildStatus": {
                return Optional.ofNullable(clazz.cast(this.buildStatusAsString()));
            }
            case "pluginArn": {
                return Optional.ofNullable(clazz.cast(this.pluginArn()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("applicationId", APPLICATION_ID_FIELD);
        map.put("pluginId", PLUGIN_ID_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("serverUrl", SERVER_URL_FIELD);
        map.put("authConfiguration", AUTH_CONFIGURATION_FIELD);
        map.put("customPluginConfiguration", CUSTOM_PLUGIN_CONFIGURATION_FIELD);
        map.put("buildStatus", BUILD_STATUS_FIELD);
        map.put("pluginArn", PLUGIN_ARN_FIELD);
        map.put("state", STATE_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetPluginResponse, T> g) {
        return obj -> g.apply((GetPluginResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QBusinessResponse.BuilderImpl
    implements Builder {
        private String applicationId;
        private String pluginId;
        private String displayName;
        private String type;
        private String serverUrl;
        private PluginAuthConfiguration authConfiguration;
        private CustomPluginConfiguration customPluginConfiguration;
        private String buildStatus;
        private String pluginArn;
        private String state;
        private Instant createdAt;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPluginResponse model) {
            super(model);
            this.applicationId(model.applicationId);
            this.pluginId(model.pluginId);
            this.displayName(model.displayName);
            this.type(model.type);
            this.serverUrl(model.serverUrl);
            this.authConfiguration(model.authConfiguration);
            this.customPluginConfiguration(model.customPluginConfiguration);
            this.buildStatus(model.buildStatus);
            this.pluginArn(model.pluginArn);
            this.state(model.state);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getPluginId() {
            return this.pluginId;
        }

        public final void setPluginId(String pluginId) {
            this.pluginId = pluginId;
        }

        @Override
        public final Builder pluginId(String pluginId) {
            this.pluginId = pluginId;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(PluginType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getServerUrl() {
            return this.serverUrl;
        }

        public final void setServerUrl(String serverUrl) {
            this.serverUrl = serverUrl;
        }

        @Override
        public final Builder serverUrl(String serverUrl) {
            this.serverUrl = serverUrl;
            return this;
        }

        public final PluginAuthConfiguration.Builder getAuthConfiguration() {
            return this.authConfiguration != null ? this.authConfiguration.toBuilder() : null;
        }

        public final void setAuthConfiguration(PluginAuthConfiguration.BuilderImpl authConfiguration) {
            this.authConfiguration = authConfiguration != null ? authConfiguration.build() : null;
        }

        @Override
        public final Builder authConfiguration(PluginAuthConfiguration authConfiguration) {
            this.authConfiguration = authConfiguration;
            return this;
        }

        public final CustomPluginConfiguration.Builder getCustomPluginConfiguration() {
            return this.customPluginConfiguration != null ? this.customPluginConfiguration.toBuilder() : null;
        }

        public final void setCustomPluginConfiguration(CustomPluginConfiguration.BuilderImpl customPluginConfiguration) {
            this.customPluginConfiguration = customPluginConfiguration != null ? customPluginConfiguration.build() : null;
        }

        @Override
        public final Builder customPluginConfiguration(CustomPluginConfiguration customPluginConfiguration) {
            this.customPluginConfiguration = customPluginConfiguration;
            return this;
        }

        public final String getBuildStatus() {
            return this.buildStatus;
        }

        public final void setBuildStatus(String buildStatus) {
            this.buildStatus = buildStatus;
        }

        @Override
        public final Builder buildStatus(String buildStatus) {
            this.buildStatus = buildStatus;
            return this;
        }

        @Override
        public final Builder buildStatus(PluginBuildStatus buildStatus) {
            this.buildStatus(buildStatus == null ? null : buildStatus.toString());
            return this;
        }

        public final String getPluginArn() {
            return this.pluginArn;
        }

        public final void setPluginArn(String pluginArn) {
            this.pluginArn = pluginArn;
        }

        @Override
        public final Builder pluginArn(String pluginArn) {
            this.pluginArn = pluginArn;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(PluginState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public GetPluginResponse build() {
            return new GetPluginResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends QBusinessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetPluginResponse> {
        public Builder applicationId(String var1);

        public Builder pluginId(String var1);

        public Builder displayName(String var1);

        public Builder type(String var1);

        public Builder type(PluginType var1);

        public Builder serverUrl(String var1);

        public Builder authConfiguration(PluginAuthConfiguration var1);

        default public Builder authConfiguration(Consumer<PluginAuthConfiguration.Builder> authConfiguration) {
            return this.authConfiguration((PluginAuthConfiguration)((PluginAuthConfiguration.Builder)PluginAuthConfiguration.builder().applyMutation(authConfiguration)).build());
        }

        public Builder customPluginConfiguration(CustomPluginConfiguration var1);

        default public Builder customPluginConfiguration(Consumer<CustomPluginConfiguration.Builder> customPluginConfiguration) {
            return this.customPluginConfiguration((CustomPluginConfiguration)((CustomPluginConfiguration.Builder)CustomPluginConfiguration.builder().applyMutation(customPluginConfiguration)).build());
        }

        public Builder buildStatus(String var1);

        public Builder buildStatus(PluginBuildStatus var1);

        public Builder pluginArn(String var1);

        public Builder state(String var1);

        public Builder state(PluginState var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);
    }
}

