/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qbusiness.model.DocumentAttribute;
import software.amazon.awssdk.services.qbusiness.model.DocumentAttributesCopier;
import software.amazon.awssdk.services.qbusiness.model.ScoreAttributes;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RelevantContent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RelevantContent> {
    private static final SdkField<String> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("content").getter(RelevantContent.getter(RelevantContent::content)).setter(RelevantContent.setter(Builder::content)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()}).build();
    private static final SdkField<String> DOCUMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("documentId").getter(RelevantContent.getter(RelevantContent::documentId)).setter(RelevantContent.setter(Builder::documentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentId").build()}).build();
    private static final SdkField<String> DOCUMENT_TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("documentTitle").getter(RelevantContent.getter(RelevantContent::documentTitle)).setter(RelevantContent.setter(Builder::documentTitle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentTitle").build()}).build();
    private static final SdkField<String> DOCUMENT_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("documentUri").getter(RelevantContent.getter(RelevantContent::documentUri)).setter(RelevantContent.setter(Builder::documentUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentUri").build()}).build();
    private static final SdkField<List<DocumentAttribute>> DOCUMENT_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("documentAttributes").getter(RelevantContent.getter(RelevantContent::documentAttributes)).setter(RelevantContent.setter(Builder::documentAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DocumentAttribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ScoreAttributes> SCORE_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("scoreAttributes").getter(RelevantContent.getter(RelevantContent::scoreAttributes)).setter(RelevantContent.setter(Builder::scoreAttributes)).constructor(ScoreAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scoreAttributes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_FIELD, DOCUMENT_ID_FIELD, DOCUMENT_TITLE_FIELD, DOCUMENT_URI_FIELD, DOCUMENT_ATTRIBUTES_FIELD, SCORE_ATTRIBUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RelevantContent.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String content;
    private final String documentId;
    private final String documentTitle;
    private final String documentUri;
    private final List<DocumentAttribute> documentAttributes;
    private final ScoreAttributes scoreAttributes;

    private RelevantContent(BuilderImpl builder) {
        this.content = builder.content;
        this.documentId = builder.documentId;
        this.documentTitle = builder.documentTitle;
        this.documentUri = builder.documentUri;
        this.documentAttributes = builder.documentAttributes;
        this.scoreAttributes = builder.scoreAttributes;
    }

    public final String content() {
        return this.content;
    }

    public final String documentId() {
        return this.documentId;
    }

    public final String documentTitle() {
        return this.documentTitle;
    }

    public final String documentUri() {
        return this.documentUri;
    }

    public final boolean hasDocumentAttributes() {
        return this.documentAttributes != null && !(this.documentAttributes instanceof SdkAutoConstructList);
    }

    public final List<DocumentAttribute> documentAttributes() {
        return this.documentAttributes;
    }

    public final ScoreAttributes scoreAttributes() {
        return this.scoreAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentTitle());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDocumentAttributes() ? this.documentAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.scoreAttributes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RelevantContent)) {
            return false;
        }
        RelevantContent other = (RelevantContent)obj;
        return Objects.equals(this.content(), other.content()) && Objects.equals(this.documentId(), other.documentId()) && Objects.equals(this.documentTitle(), other.documentTitle()) && Objects.equals(this.documentUri(), other.documentUri()) && this.hasDocumentAttributes() == other.hasDocumentAttributes() && Objects.equals(this.documentAttributes(), other.documentAttributes()) && Objects.equals(this.scoreAttributes(), other.scoreAttributes());
    }

    public final String toString() {
        return ToString.builder((String)"RelevantContent").add("Content", (Object)this.content()).add("DocumentId", (Object)this.documentId()).add("DocumentTitle", (Object)this.documentTitle()).add("DocumentUri", (Object)this.documentUri()).add("DocumentAttributes", this.hasDocumentAttributes() ? this.documentAttributes() : null).add("ScoreAttributes", (Object)this.scoreAttributes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "documentId": {
                return Optional.ofNullable(clazz.cast(this.documentId()));
            }
            case "documentTitle": {
                return Optional.ofNullable(clazz.cast(this.documentTitle()));
            }
            case "documentUri": {
                return Optional.ofNullable(clazz.cast(this.documentUri()));
            }
            case "documentAttributes": {
                return Optional.ofNullable(clazz.cast(this.documentAttributes()));
            }
            case "scoreAttributes": {
                return Optional.ofNullable(clazz.cast(this.scoreAttributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("content", CONTENT_FIELD);
        map.put("documentId", DOCUMENT_ID_FIELD);
        map.put("documentTitle", DOCUMENT_TITLE_FIELD);
        map.put("documentUri", DOCUMENT_URI_FIELD);
        map.put("documentAttributes", DOCUMENT_ATTRIBUTES_FIELD);
        map.put("scoreAttributes", SCORE_ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RelevantContent, T> g) {
        return obj -> g.apply((RelevantContent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String content;
        private String documentId;
        private String documentTitle;
        private String documentUri;
        private List<DocumentAttribute> documentAttributes = DefaultSdkAutoConstructList.getInstance();
        private ScoreAttributes scoreAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(RelevantContent model) {
            this.content(model.content);
            this.documentId(model.documentId);
            this.documentTitle(model.documentTitle);
            this.documentUri(model.documentUri);
            this.documentAttributes(model.documentAttributes);
            this.scoreAttributes(model.scoreAttributes);
        }

        public final String getContent() {
            return this.content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final String getDocumentId() {
            return this.documentId;
        }

        public final void setDocumentId(String documentId) {
            this.documentId = documentId;
        }

        @Override
        public final Builder documentId(String documentId) {
            this.documentId = documentId;
            return this;
        }

        public final String getDocumentTitle() {
            return this.documentTitle;
        }

        public final void setDocumentTitle(String documentTitle) {
            this.documentTitle = documentTitle;
        }

        @Override
        public final Builder documentTitle(String documentTitle) {
            this.documentTitle = documentTitle;
            return this;
        }

        public final String getDocumentUri() {
            return this.documentUri;
        }

        public final void setDocumentUri(String documentUri) {
            this.documentUri = documentUri;
        }

        @Override
        public final Builder documentUri(String documentUri) {
            this.documentUri = documentUri;
            return this;
        }

        public final List<DocumentAttribute.Builder> getDocumentAttributes() {
            List<DocumentAttribute.Builder> result = DocumentAttributesCopier.copyToBuilder(this.documentAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDocumentAttributes(Collection<DocumentAttribute.BuilderImpl> documentAttributes) {
            this.documentAttributes = DocumentAttributesCopier.copyFromBuilder(documentAttributes);
        }

        @Override
        public final Builder documentAttributes(Collection<DocumentAttribute> documentAttributes) {
            this.documentAttributes = DocumentAttributesCopier.copy(documentAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentAttributes(DocumentAttribute ... documentAttributes) {
            this.documentAttributes(Arrays.asList(documentAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentAttributes(Consumer<DocumentAttribute.Builder> ... documentAttributes) {
            this.documentAttributes(Stream.of(documentAttributes).map(c -> (DocumentAttribute)((DocumentAttribute.Builder)DocumentAttribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ScoreAttributes.Builder getScoreAttributes() {
            return this.scoreAttributes != null ? this.scoreAttributes.toBuilder() : null;
        }

        public final void setScoreAttributes(ScoreAttributes.BuilderImpl scoreAttributes) {
            this.scoreAttributes = scoreAttributes != null ? scoreAttributes.build() : null;
        }

        @Override
        public final Builder scoreAttributes(ScoreAttributes scoreAttributes) {
            this.scoreAttributes = scoreAttributes;
            return this;
        }

        public RelevantContent build() {
            return new RelevantContent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RelevantContent> {
        public Builder content(String var1);

        public Builder documentId(String var1);

        public Builder documentTitle(String var1);

        public Builder documentUri(String var1);

        public Builder documentAttributes(Collection<DocumentAttribute> var1);

        public Builder documentAttributes(DocumentAttribute ... var1);

        public Builder documentAttributes(Consumer<DocumentAttribute.Builder> ... var1);

        public Builder scoreAttributes(ScoreAttributes var1);

        default public Builder scoreAttributes(Consumer<ScoreAttributes.Builder> scoreAttributes) {
            return this.scoreAttributes((ScoreAttributes)((ScoreAttributes.Builder)ScoreAttributes.builder().applyMutation(scoreAttributes)).build());
        }
    }
}

