/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.qbusiness.model.AuthorizationResponseMapCopier;
import software.amazon.awssdk.services.qbusiness.model.ChatInputStream;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AuthChallengeResponseEvent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AuthChallengeResponseEvent>,
ChatInputStream {
    private static final SdkField<Map<String, String>> RESPONSE_MAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("responseMap").getter(AuthChallengeResponseEvent.getter(AuthChallengeResponseEvent::responseMap)).setter(AuthChallengeResponseEvent.setter(Builder::responseMap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseMap").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESPONSE_MAP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AuthChallengeResponseEvent.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Map<String, String> responseMap;

    protected AuthChallengeResponseEvent(BuilderImpl builder) {
        this.responseMap = builder.responseMap;
    }

    public final boolean hasResponseMap() {
        return this.responseMap != null && !(this.responseMap instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> responseMap() {
        return this.responseMap;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResponseMap() ? this.responseMap() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthChallengeResponseEvent)) {
            return false;
        }
        AuthChallengeResponseEvent other = (AuthChallengeResponseEvent)obj;
        return this.hasResponseMap() == other.hasResponseMap() && Objects.equals(this.responseMap(), other.responseMap());
    }

    public final String toString() {
        return ToString.builder((String)"AuthChallengeResponseEvent").add("ResponseMap", this.hasResponseMap() ? this.responseMap() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "responseMap": {
                return Optional.ofNullable(clazz.cast(this.responseMap()));
            }
        }
        return Optional.empty();
    }

    public final AuthChallengeResponseEvent copy(Consumer<? super Builder> modifier) {
        return (AuthChallengeResponseEvent)super.copy(modifier);
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Map<String, String>>> map = new HashMap<String, SdkField<Map<String, String>>>();
        map.put("responseMap", RESPONSE_MAP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AuthChallengeResponseEvent, T> g) {
        return obj -> g.apply((AuthChallengeResponseEvent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    protected static class BuilderImpl
    implements Builder {
        private Map<String, String> responseMap = DefaultSdkAutoConstructMap.getInstance();

        protected BuilderImpl() {
        }

        protected BuilderImpl(AuthChallengeResponseEvent model) {
            this.responseMap(model.responseMap);
        }

        public final Map<String, String> getResponseMap() {
            if (this.responseMap instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.responseMap;
        }

        public final void setResponseMap(Map<String, String> responseMap) {
            this.responseMap = AuthorizationResponseMapCopier.copy(responseMap);
        }

        @Override
        public final Builder responseMap(Map<String, String> responseMap) {
            this.responseMap = AuthorizationResponseMapCopier.copy(responseMap);
            return this;
        }

        public AuthChallengeResponseEvent build() {
            return new AuthChallengeResponseEvent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AuthChallengeResponseEvent> {
        public Builder responseMap(Map<String, String> var1);
    }
}

