/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qbusiness.model.QBusinessResponse;
import software.amazon.awssdk.services.qbusiness.model.RelevantContent;
import software.amazon.awssdk.services.qbusiness.model.RelevantContentListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchRelevantContentResponse
extends QBusinessResponse
implements ToCopyableBuilder<Builder, SearchRelevantContentResponse> {
    private static final SdkField<List<RelevantContent>> RELEVANT_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("relevantContent").getter(SearchRelevantContentResponse.getter(SearchRelevantContentResponse::relevantContent)).setter(SearchRelevantContentResponse.setter(Builder::relevantContent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relevantContent").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RelevantContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(SearchRelevantContentResponse.getter(SearchRelevantContentResponse::nextToken)).setter(SearchRelevantContentResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RELEVANT_CONTENT_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SearchRelevantContentResponse.memberNameToFieldInitializer();
    private final List<RelevantContent> relevantContent;
    private final String nextToken;

    private SearchRelevantContentResponse(BuilderImpl builder) {
        super(builder);
        this.relevantContent = builder.relevantContent;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasRelevantContent() {
        return this.relevantContent != null && !(this.relevantContent instanceof SdkAutoConstructList);
    }

    public final List<RelevantContent> relevantContent() {
        return this.relevantContent;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRelevantContent() ? this.relevantContent() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchRelevantContentResponse)) {
            return false;
        }
        SearchRelevantContentResponse other = (SearchRelevantContentResponse)((Object)obj);
        return this.hasRelevantContent() == other.hasRelevantContent() && Objects.equals(this.relevantContent(), other.relevantContent()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"SearchRelevantContentResponse").add("RelevantContent", this.hasRelevantContent() ? this.relevantContent() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "relevantContent": {
                return Optional.ofNullable(clazz.cast(this.relevantContent()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("relevantContent", RELEVANT_CONTENT_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchRelevantContentResponse, T> g) {
        return obj -> g.apply((SearchRelevantContentResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QBusinessResponse.BuilderImpl
    implements Builder {
        private List<RelevantContent> relevantContent = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchRelevantContentResponse model) {
            super(model);
            this.relevantContent(model.relevantContent);
            this.nextToken(model.nextToken);
        }

        public final List<RelevantContent.Builder> getRelevantContent() {
            List<RelevantContent.Builder> result = RelevantContentListCopier.copyToBuilder(this.relevantContent);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRelevantContent(Collection<RelevantContent.BuilderImpl> relevantContent) {
            this.relevantContent = RelevantContentListCopier.copyFromBuilder(relevantContent);
        }

        @Override
        public final Builder relevantContent(Collection<RelevantContent> relevantContent) {
            this.relevantContent = RelevantContentListCopier.copy(relevantContent);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relevantContent(RelevantContent ... relevantContent) {
            this.relevantContent(Arrays.asList(relevantContent));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relevantContent(Consumer<RelevantContent.Builder> ... relevantContent) {
            this.relevantContent(Stream.of(relevantContent).map(c -> (RelevantContent)((RelevantContent.Builder)RelevantContent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public SearchRelevantContentResponse build() {
            return new SearchRelevantContentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends QBusinessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchRelevantContentResponse> {
        public Builder relevantContent(Collection<RelevantContent> var1);

        public Builder relevantContent(RelevantContent ... var1);

        public Builder relevantContent(Consumer<RelevantContent.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

