/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qbusiness.model.PermissionCondition;
import software.amazon.awssdk.services.qbusiness.model.PermissionConditionsCopier;
import software.amazon.awssdk.services.qbusiness.model.QBusinessRequest;
import software.amazon.awssdk.services.qbusiness.model.QIamActionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociatePermissionRequest
extends QBusinessRequest
implements ToCopyableBuilder<Builder, AssociatePermissionRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationId").getter(AssociatePermissionRequest.getter(AssociatePermissionRequest::applicationId)).setter(AssociatePermissionRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()}).build();
    private static final SdkField<String> STATEMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statementId").getter(AssociatePermissionRequest.getter(AssociatePermissionRequest::statementId)).setter(AssociatePermissionRequest.setter(Builder::statementId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statementId").build()}).build();
    private static final SdkField<List<String>> ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("actions").getter(AssociatePermissionRequest.getter(AssociatePermissionRequest::actions)).setter(AssociatePermissionRequest.setter(Builder::actions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<PermissionCondition>> CONDITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("conditions").getter(AssociatePermissionRequest.getter(AssociatePermissionRequest::conditions)).setter(AssociatePermissionRequest.setter(Builder::conditions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conditions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PermissionCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PRINCIPAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("principal").getter(AssociatePermissionRequest.getter(AssociatePermissionRequest::principal)).setter(AssociatePermissionRequest.setter(Builder::principal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principal").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, STATEMENT_ID_FIELD, ACTIONS_FIELD, CONDITIONS_FIELD, PRINCIPAL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AssociatePermissionRequest.memberNameToFieldInitializer();
    private final String applicationId;
    private final String statementId;
    private final List<String> actions;
    private final List<PermissionCondition> conditions;
    private final String principal;

    private AssociatePermissionRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.statementId = builder.statementId;
        this.actions = builder.actions;
        this.conditions = builder.conditions;
        this.principal = builder.principal;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String statementId() {
        return this.statementId;
    }

    public final boolean hasActions() {
        return this.actions != null && !(this.actions instanceof SdkAutoConstructList);
    }

    public final List<String> actions() {
        return this.actions;
    }

    public final boolean hasConditions() {
        return this.conditions != null && !(this.conditions instanceof SdkAutoConstructList);
    }

    public final List<PermissionCondition> conditions() {
        return this.conditions;
    }

    public final String principal() {
        return this.principal;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statementId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActions() ? this.actions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConditions() ? this.conditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.principal());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociatePermissionRequest)) {
            return false;
        }
        AssociatePermissionRequest other = (AssociatePermissionRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.statementId(), other.statementId()) && this.hasActions() == other.hasActions() && Objects.equals(this.actions(), other.actions()) && this.hasConditions() == other.hasConditions() && Objects.equals(this.conditions(), other.conditions()) && Objects.equals(this.principal(), other.principal());
    }

    public final String toString() {
        return ToString.builder((String)"AssociatePermissionRequest").add("ApplicationId", (Object)this.applicationId()).add("StatementId", (Object)this.statementId()).add("Actions", this.hasActions() ? this.actions() : null).add("Conditions", this.hasConditions() ? this.conditions() : null).add("Principal", (Object)this.principal()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "statementId": {
                return Optional.ofNullable(clazz.cast(this.statementId()));
            }
            case "actions": {
                return Optional.ofNullable(clazz.cast(this.actions()));
            }
            case "conditions": {
                return Optional.ofNullable(clazz.cast(this.conditions()));
            }
            case "principal": {
                return Optional.ofNullable(clazz.cast(this.principal()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("applicationId", APPLICATION_ID_FIELD);
        map.put("statementId", STATEMENT_ID_FIELD);
        map.put("actions", ACTIONS_FIELD);
        map.put("conditions", CONDITIONS_FIELD);
        map.put("principal", PRINCIPAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociatePermissionRequest, T> g) {
        return obj -> g.apply((AssociatePermissionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QBusinessRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private String statementId;
        private List<String> actions = DefaultSdkAutoConstructList.getInstance();
        private List<PermissionCondition> conditions = DefaultSdkAutoConstructList.getInstance();
        private String principal;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociatePermissionRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.statementId(model.statementId);
            this.actions(model.actions);
            this.conditions(model.conditions);
            this.principal(model.principal);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getStatementId() {
            return this.statementId;
        }

        public final void setStatementId(String statementId) {
            this.statementId = statementId;
        }

        @Override
        public final Builder statementId(String statementId) {
            this.statementId = statementId;
            return this;
        }

        public final Collection<String> getActions() {
            if (this.actions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.actions;
        }

        public final void setActions(Collection<String> actions) {
            this.actions = QIamActionsCopier.copy(actions);
        }

        @Override
        public final Builder actions(Collection<String> actions) {
            this.actions = QIamActionsCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(String ... actions) {
            this.actions(Arrays.asList(actions));
            return this;
        }

        public final List<PermissionCondition.Builder> getConditions() {
            List<PermissionCondition.Builder> result = PermissionConditionsCopier.copyToBuilder(this.conditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConditions(Collection<PermissionCondition.BuilderImpl> conditions) {
            this.conditions = PermissionConditionsCopier.copyFromBuilder(conditions);
        }

        @Override
        public final Builder conditions(Collection<PermissionCondition> conditions) {
            this.conditions = PermissionConditionsCopier.copy(conditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditions(PermissionCondition ... conditions) {
            this.conditions(Arrays.asList(conditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditions(Consumer<PermissionCondition.Builder> ... conditions) {
            this.conditions(Stream.of(conditions).map(c -> (PermissionCondition)((PermissionCondition.Builder)PermissionCondition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPrincipal() {
            return this.principal;
        }

        public final void setPrincipal(String principal) {
            this.principal = principal;
        }

        @Override
        public final Builder principal(String principal) {
            this.principal = principal;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociatePermissionRequest build() {
            return new AssociatePermissionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends QBusinessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociatePermissionRequest> {
        public Builder applicationId(String var1);

        public Builder statementId(String var1);

        public Builder actions(Collection<String> var1);

        public Builder actions(String ... var1);

        public Builder conditions(Collection<PermissionCondition> var1);

        public Builder conditions(PermissionCondition ... var1);

        public Builder conditions(Consumer<PermissionCondition.Builder> ... var1);

        public Builder principal(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

