/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.qbusiness.model.ChatResponseConfigurationStatus;
import software.amazon.awssdk.services.qbusiness.model.ErrorDetail;
import software.amazon.awssdk.services.qbusiness.model.ResponseConfiguration;
import software.amazon.awssdk.services.qbusiness.model.ResponseConfigurationType;
import software.amazon.awssdk.services.qbusiness.model.ResponseConfigurationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChatResponseConfigurationDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ChatResponseConfigurationDetail> {
    private static final SdkField<Map<String, ResponseConfiguration>> RESPONSE_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("responseConfigurations").getter(ChatResponseConfigurationDetail.getter(ChatResponseConfigurationDetail::responseConfigurationsAsStrings)).setter(ChatResponseConfigurationDetail.setter(Builder::responseConfigurationsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseConfigurations").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResponseConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> RESPONSE_CONFIGURATION_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("responseConfigurationSummary").getter(ChatResponseConfigurationDetail.getter(ChatResponseConfigurationDetail::responseConfigurationSummary)).setter(ChatResponseConfigurationDetail.setter(Builder::responseConfigurationSummary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseConfigurationSummary").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ChatResponseConfigurationDetail.getter(ChatResponseConfigurationDetail::statusAsString)).setter(ChatResponseConfigurationDetail.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<ErrorDetail> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("error").getter(ChatResponseConfigurationDetail.getter(ChatResponseConfigurationDetail::error)).setter(ChatResponseConfigurationDetail.setter(Builder::error)).constructor(ErrorDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(ChatResponseConfigurationDetail.getter(ChatResponseConfigurationDetail::updatedAt)).setter(ChatResponseConfigurationDetail.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESPONSE_CONFIGURATIONS_FIELD, RESPONSE_CONFIGURATION_SUMMARY_FIELD, STATUS_FIELD, ERROR_FIELD, UPDATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ChatResponseConfigurationDetail.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Map<String, ResponseConfiguration> responseConfigurations;
    private final String responseConfigurationSummary;
    private final String status;
    private final ErrorDetail error;
    private final Instant updatedAt;

    private ChatResponseConfigurationDetail(BuilderImpl builder) {
        this.responseConfigurations = builder.responseConfigurations;
        this.responseConfigurationSummary = builder.responseConfigurationSummary;
        this.status = builder.status;
        this.error = builder.error;
        this.updatedAt = builder.updatedAt;
    }

    public final Map<ResponseConfigurationType, ResponseConfiguration> responseConfigurations() {
        return ResponseConfigurationsCopier.copyStringToEnum(this.responseConfigurations);
    }

    public final boolean hasResponseConfigurations() {
        return this.responseConfigurations != null && !(this.responseConfigurations instanceof SdkAutoConstructMap);
    }

    public final Map<String, ResponseConfiguration> responseConfigurationsAsStrings() {
        return this.responseConfigurations;
    }

    public final String responseConfigurationSummary() {
        return this.responseConfigurationSummary;
    }

    public final ChatResponseConfigurationStatus status() {
        return ChatResponseConfigurationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final ErrorDetail error() {
        return this.error;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResponseConfigurations() ? this.responseConfigurationsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.responseConfigurationSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChatResponseConfigurationDetail)) {
            return false;
        }
        ChatResponseConfigurationDetail other = (ChatResponseConfigurationDetail)obj;
        return this.hasResponseConfigurations() == other.hasResponseConfigurations() && Objects.equals(this.responseConfigurationsAsStrings(), other.responseConfigurationsAsStrings()) && Objects.equals(this.responseConfigurationSummary(), other.responseConfigurationSummary()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.error(), other.error()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"ChatResponseConfigurationDetail").add("ResponseConfigurations", this.hasResponseConfigurations() ? this.responseConfigurationsAsStrings() : null).add("ResponseConfigurationSummary", (Object)this.responseConfigurationSummary()).add("Status", (Object)this.statusAsString()).add("Error", (Object)this.error()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "responseConfigurations": {
                return Optional.ofNullable(clazz.cast(this.responseConfigurationsAsStrings()));
            }
            case "responseConfigurationSummary": {
                return Optional.ofNullable(clazz.cast(this.responseConfigurationSummary()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("responseConfigurations", RESPONSE_CONFIGURATIONS_FIELD);
        map.put("responseConfigurationSummary", RESPONSE_CONFIGURATION_SUMMARY_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("error", ERROR_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChatResponseConfigurationDetail, T> g) {
        return obj -> g.apply((ChatResponseConfigurationDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, ResponseConfiguration> responseConfigurations = DefaultSdkAutoConstructMap.getInstance();
        private String responseConfigurationSummary;
        private String status;
        private ErrorDetail error;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(ChatResponseConfigurationDetail model) {
            this.responseConfigurationsWithStrings(model.responseConfigurations);
            this.responseConfigurationSummary(model.responseConfigurationSummary);
            this.status(model.status);
            this.error(model.error);
            this.updatedAt(model.updatedAt);
        }

        public final Map<String, ResponseConfiguration.Builder> getResponseConfigurations() {
            Map<String, ResponseConfiguration.Builder> result = ResponseConfigurationsCopier.copyToBuilder(this.responseConfigurations);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setResponseConfigurations(Map<String, ResponseConfiguration.BuilderImpl> responseConfigurations) {
            this.responseConfigurations = ResponseConfigurationsCopier.copyFromBuilder(responseConfigurations);
        }

        @Override
        public final Builder responseConfigurationsWithStrings(Map<String, ResponseConfiguration> responseConfigurations) {
            this.responseConfigurations = ResponseConfigurationsCopier.copy(responseConfigurations);
            return this;
        }

        @Override
        public final Builder responseConfigurations(Map<ResponseConfigurationType, ResponseConfiguration> responseConfigurations) {
            this.responseConfigurations = ResponseConfigurationsCopier.copyEnumToString(responseConfigurations);
            return this;
        }

        public final String getResponseConfigurationSummary() {
            return this.responseConfigurationSummary;
        }

        public final void setResponseConfigurationSummary(String responseConfigurationSummary) {
            this.responseConfigurationSummary = responseConfigurationSummary;
        }

        @Override
        public final Builder responseConfigurationSummary(String responseConfigurationSummary) {
            this.responseConfigurationSummary = responseConfigurationSummary;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ChatResponseConfigurationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final ErrorDetail.Builder getError() {
            return this.error != null ? this.error.toBuilder() : null;
        }

        public final void setError(ErrorDetail.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(ErrorDetail error) {
            this.error = error;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public ChatResponseConfigurationDetail build() {
            return new ChatResponseConfigurationDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ChatResponseConfigurationDetail> {
        public Builder responseConfigurationsWithStrings(Map<String, ResponseConfiguration> var1);

        public Builder responseConfigurations(Map<ResponseConfigurationType, ResponseConfiguration> var1);

        public Builder responseConfigurationSummary(String var1);

        public Builder status(String var1);

        public Builder status(ChatResponseConfigurationStatus var1);

        public Builder error(ErrorDetail var1);

        default public Builder error(Consumer<ErrorDetail.Builder> error) {
            return this.error((ErrorDetail)((ErrorDetail.Builder)ErrorDetail.builder().applyMutation(error)).build());
        }

        public Builder updatedAt(Instant var1);
    }
}

