/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.qbusiness.QBusinessClient;
import software.amazon.awssdk.services.qbusiness.internal.UserAgentUtils;
import software.amazon.awssdk.services.qbusiness.model.ChatResponseConfiguration;
import software.amazon.awssdk.services.qbusiness.model.ListChatResponseConfigurationsRequest;
import software.amazon.awssdk.services.qbusiness.model.ListChatResponseConfigurationsResponse;

public class ListChatResponseConfigurationsIterable
implements SdkIterable<ListChatResponseConfigurationsResponse> {
    private final QBusinessClient client;
    private final ListChatResponseConfigurationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListChatResponseConfigurationsIterable(QBusinessClient client, ListChatResponseConfigurationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListChatResponseConfigurationsResponseFetcher();
    }

    public Iterator<ListChatResponseConfigurationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ChatResponseConfiguration> chatResponseConfigurations() {
        Function<ListChatResponseConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.chatResponseConfigurations() != null) {
                return response.chatResponseConfigurations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListChatResponseConfigurationsResponseFetcher
    implements SyncPageFetcher<ListChatResponseConfigurationsResponse> {
        private ListChatResponseConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListChatResponseConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListChatResponseConfigurationsResponse nextPage(ListChatResponseConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListChatResponseConfigurationsIterable.this.client.listChatResponseConfigurations(ListChatResponseConfigurationsIterable.this.firstRequest);
            }
            return ListChatResponseConfigurationsIterable.this.client.listChatResponseConfigurations((ListChatResponseConfigurationsRequest)((Object)ListChatResponseConfigurationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

