/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.qbusiness.QBusinessAsyncClient;
import software.amazon.awssdk.services.qbusiness.internal.UserAgentUtils;
import software.amazon.awssdk.services.qbusiness.model.ListPluginTypeMetadataRequest;
import software.amazon.awssdk.services.qbusiness.model.ListPluginTypeMetadataResponse;
import software.amazon.awssdk.services.qbusiness.model.PluginTypeMetadataSummary;

public class ListPluginTypeMetadataPublisher
implements SdkPublisher<ListPluginTypeMetadataResponse> {
    private final QBusinessAsyncClient client;
    private final ListPluginTypeMetadataRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPluginTypeMetadataPublisher(QBusinessAsyncClient client, ListPluginTypeMetadataRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPluginTypeMetadataPublisher(QBusinessAsyncClient client, ListPluginTypeMetadataRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPluginTypeMetadataResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPluginTypeMetadataResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PluginTypeMetadataSummary> items() {
        Function<ListPluginTypeMetadataResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPluginTypeMetadataResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPluginTypeMetadataResponseFetcher
    implements AsyncPageFetcher<ListPluginTypeMetadataResponse> {
        private ListPluginTypeMetadataResponseFetcher() {
        }

        public boolean hasNextPage(ListPluginTypeMetadataResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPluginTypeMetadataResponse> nextPage(ListPluginTypeMetadataResponse previousPage) {
            if (previousPage == null) {
                return ListPluginTypeMetadataPublisher.this.client.listPluginTypeMetadata(ListPluginTypeMetadataPublisher.this.firstRequest);
            }
            return ListPluginTypeMetadataPublisher.this.client.listPluginTypeMetadata((ListPluginTypeMetadataRequest)((Object)ListPluginTypeMetadataPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

