/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies an allowed action and its associated filter configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ActionConfiguration.Builder, ActionConfiguration> {
    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("action")
            .getter(getter(ActionConfiguration::action)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final SdkField<ActionFilterConfiguration> FILTER_CONFIGURATION_FIELD = SdkField
            .<ActionFilterConfiguration> builder(MarshallingType.SDK_POJO).memberName("filterConfiguration")
            .getter(getter(ActionConfiguration::filterConfiguration)).setter(setter(Builder::filterConfiguration))
            .constructor(ActionFilterConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD,
            FILTER_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String action;

    private final ActionFilterConfiguration filterConfiguration;

    private ActionConfiguration(BuilderImpl builder) {
        this.action = builder.action;
        this.filterConfiguration = builder.filterConfiguration;
    }

    /**
     * <p>
     * The Amazon Q Business action that is allowed.
     * </p>
     * 
     * @return The Amazon Q Business action that is allowed.
     */
    public final String action() {
        return action;
    }

    /**
     * <p>
     * The filter configuration for the action, if any.
     * </p>
     * 
     * @return The filter configuration for the action, if any.
     */
    public final ActionFilterConfiguration filterConfiguration() {
        return filterConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(action());
        hashCode = 31 * hashCode + Objects.hashCode(filterConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionConfiguration)) {
            return false;
        }
        ActionConfiguration other = (ActionConfiguration) obj;
        return Objects.equals(action(), other.action()) && Objects.equals(filterConfiguration(), other.filterConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ActionConfiguration").add("Action", action()).add("FilterConfiguration", filterConfiguration())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "action":
            return Optional.ofNullable(clazz.cast(action()));
        case "filterConfiguration":
            return Optional.ofNullable(clazz.cast(filterConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("action", ACTION_FIELD);
        map.put("filterConfiguration", FILTER_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ActionConfiguration, T> g) {
        return obj -> g.apply((ActionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActionConfiguration> {
        /**
         * <p>
         * The Amazon Q Business action that is allowed.
         * </p>
         * 
         * @param action
         *        The Amazon Q Business action that is allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(String action);

        /**
         * <p>
         * The filter configuration for the action, if any.
         * </p>
         * 
         * @param filterConfiguration
         *        The filter configuration for the action, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterConfiguration(ActionFilterConfiguration filterConfiguration);

        /**
         * <p>
         * The filter configuration for the action, if any.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActionFilterConfiguration.Builder}
         * avoiding the need to create one manually via {@link ActionFilterConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActionFilterConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #filterConfiguration(ActionFilterConfiguration)}.
         * 
         * @param filterConfiguration
         *        a consumer that will call methods on {@link ActionFilterConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filterConfiguration(ActionFilterConfiguration)
         */
        default Builder filterConfiguration(Consumer<ActionFilterConfiguration.Builder> filterConfiguration) {
            return filterConfiguration(ActionFilterConfiguration.builder().applyMutation(filterConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String action;

        private ActionFilterConfiguration filterConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionConfiguration model) {
            action(model.action);
            filterConfiguration(model.filterConfiguration);
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        public final ActionFilterConfiguration.Builder getFilterConfiguration() {
            return filterConfiguration != null ? filterConfiguration.toBuilder() : null;
        }

        public final void setFilterConfiguration(ActionFilterConfiguration.BuilderImpl filterConfiguration) {
            this.filterConfiguration = filterConfiguration != null ? filterConfiguration.build() : null;
        }

        @Override
        public final Builder filterConfiguration(ActionFilterConfiguration filterConfiguration) {
            this.filterConfiguration = filterConfiguration;
            return this;
        }

        @Override
        public ActionConfiguration build() {
            return new ActionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
