/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Updates a blocked phrases configuration in your Amazon Q Business application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BlockedPhrasesConfigurationUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<BlockedPhrasesConfigurationUpdate.Builder, BlockedPhrasesConfigurationUpdate> {
    private static final SdkField<List<String>> BLOCKED_PHRASES_TO_CREATE_OR_UPDATE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("blockedPhrasesToCreateOrUpdate")
            .getter(getter(BlockedPhrasesConfigurationUpdate::blockedPhrasesToCreateOrUpdate))
            .setter(setter(Builder::blockedPhrasesToCreateOrUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockedPhrasesToCreateOrUpdate")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> BLOCKED_PHRASES_TO_DELETE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("blockedPhrasesToDelete")
            .getter(getter(BlockedPhrasesConfigurationUpdate::blockedPhrasesToDelete))
            .setter(setter(Builder::blockedPhrasesToDelete))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockedPhrasesToDelete").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SYSTEM_MESSAGE_OVERRIDE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("systemMessageOverride").getter(getter(BlockedPhrasesConfigurationUpdate::systemMessageOverride))
            .setter(setter(Builder::systemMessageOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("systemMessageOverride").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            BLOCKED_PHRASES_TO_CREATE_OR_UPDATE_FIELD, BLOCKED_PHRASES_TO_DELETE_FIELD, SYSTEM_MESSAGE_OVERRIDE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> blockedPhrasesToCreateOrUpdate;

    private final List<String> blockedPhrasesToDelete;

    private final String systemMessageOverride;

    private BlockedPhrasesConfigurationUpdate(BuilderImpl builder) {
        this.blockedPhrasesToCreateOrUpdate = builder.blockedPhrasesToCreateOrUpdate;
        this.blockedPhrasesToDelete = builder.blockedPhrasesToDelete;
        this.systemMessageOverride = builder.systemMessageOverride;
    }

    /**
     * For responses, this returns true if the service returned a value for the BlockedPhrasesToCreateOrUpdate property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasBlockedPhrasesToCreateOrUpdate() {
        return blockedPhrasesToCreateOrUpdate != null && !(blockedPhrasesToCreateOrUpdate instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Creates or updates a blocked phrases configuration in your Amazon Q Business application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBlockedPhrasesToCreateOrUpdate} method.
     * </p>
     * 
     * @return Creates or updates a blocked phrases configuration in your Amazon Q Business application.
     */
    public final List<String> blockedPhrasesToCreateOrUpdate() {
        return blockedPhrasesToCreateOrUpdate;
    }

    /**
     * For responses, this returns true if the service returned a value for the BlockedPhrasesToDelete property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasBlockedPhrasesToDelete() {
        return blockedPhrasesToDelete != null && !(blockedPhrasesToDelete instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Deletes a blocked phrases configuration in your Amazon Q Business application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBlockedPhrasesToDelete} method.
     * </p>
     * 
     * @return Deletes a blocked phrases configuration in your Amazon Q Business application.
     */
    public final List<String> blockedPhrasesToDelete() {
        return blockedPhrasesToDelete;
    }

    /**
     * <p>
     * The configured custom message displayed to your end user when they use blocked phrase during chat.
     * </p>
     * 
     * @return The configured custom message displayed to your end user when they use blocked phrase during chat.
     */
    public final String systemMessageOverride() {
        return systemMessageOverride;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode
                + Objects.hashCode(hasBlockedPhrasesToCreateOrUpdate() ? blockedPhrasesToCreateOrUpdate() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasBlockedPhrasesToDelete() ? blockedPhrasesToDelete() : null);
        hashCode = 31 * hashCode + Objects.hashCode(systemMessageOverride());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlockedPhrasesConfigurationUpdate)) {
            return false;
        }
        BlockedPhrasesConfigurationUpdate other = (BlockedPhrasesConfigurationUpdate) obj;
        return hasBlockedPhrasesToCreateOrUpdate() == other.hasBlockedPhrasesToCreateOrUpdate()
                && Objects.equals(blockedPhrasesToCreateOrUpdate(), other.blockedPhrasesToCreateOrUpdate())
                && hasBlockedPhrasesToDelete() == other.hasBlockedPhrasesToDelete()
                && Objects.equals(blockedPhrasesToDelete(), other.blockedPhrasesToDelete())
                && Objects.equals(systemMessageOverride(), other.systemMessageOverride());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("BlockedPhrasesConfigurationUpdate")
                .add("BlockedPhrasesToCreateOrUpdate",
                        hasBlockedPhrasesToCreateOrUpdate() ? blockedPhrasesToCreateOrUpdate() : null)
                .add("BlockedPhrasesToDelete", hasBlockedPhrasesToDelete() ? blockedPhrasesToDelete() : null)
                .add("SystemMessageOverride", systemMessageOverride()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "blockedPhrasesToCreateOrUpdate":
            return Optional.ofNullable(clazz.cast(blockedPhrasesToCreateOrUpdate()));
        case "blockedPhrasesToDelete":
            return Optional.ofNullable(clazz.cast(blockedPhrasesToDelete()));
        case "systemMessageOverride":
            return Optional.ofNullable(clazz.cast(systemMessageOverride()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("blockedPhrasesToCreateOrUpdate", BLOCKED_PHRASES_TO_CREATE_OR_UPDATE_FIELD);
        map.put("blockedPhrasesToDelete", BLOCKED_PHRASES_TO_DELETE_FIELD);
        map.put("systemMessageOverride", SYSTEM_MESSAGE_OVERRIDE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BlockedPhrasesConfigurationUpdate, T> g) {
        return obj -> g.apply((BlockedPhrasesConfigurationUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BlockedPhrasesConfigurationUpdate> {
        /**
         * <p>
         * Creates or updates a blocked phrases configuration in your Amazon Q Business application.
         * </p>
         * 
         * @param blockedPhrasesToCreateOrUpdate
         *        Creates or updates a blocked phrases configuration in your Amazon Q Business application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockedPhrasesToCreateOrUpdate(Collection<String> blockedPhrasesToCreateOrUpdate);

        /**
         * <p>
         * Creates or updates a blocked phrases configuration in your Amazon Q Business application.
         * </p>
         * 
         * @param blockedPhrasesToCreateOrUpdate
         *        Creates or updates a blocked phrases configuration in your Amazon Q Business application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockedPhrasesToCreateOrUpdate(String... blockedPhrasesToCreateOrUpdate);

        /**
         * <p>
         * Deletes a blocked phrases configuration in your Amazon Q Business application.
         * </p>
         * 
         * @param blockedPhrasesToDelete
         *        Deletes a blocked phrases configuration in your Amazon Q Business application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockedPhrasesToDelete(Collection<String> blockedPhrasesToDelete);

        /**
         * <p>
         * Deletes a blocked phrases configuration in your Amazon Q Business application.
         * </p>
         * 
         * @param blockedPhrasesToDelete
         *        Deletes a blocked phrases configuration in your Amazon Q Business application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockedPhrasesToDelete(String... blockedPhrasesToDelete);

        /**
         * <p>
         * The configured custom message displayed to your end user when they use blocked phrase during chat.
         * </p>
         * 
         * @param systemMessageOverride
         *        The configured custom message displayed to your end user when they use blocked phrase during chat.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder systemMessageOverride(String systemMessageOverride);
    }

    static final class BuilderImpl implements Builder {
        private List<String> blockedPhrasesToCreateOrUpdate = DefaultSdkAutoConstructList.getInstance();

        private List<String> blockedPhrasesToDelete = DefaultSdkAutoConstructList.getInstance();

        private String systemMessageOverride;

        private BuilderImpl() {
        }

        private BuilderImpl(BlockedPhrasesConfigurationUpdate model) {
            blockedPhrasesToCreateOrUpdate(model.blockedPhrasesToCreateOrUpdate);
            blockedPhrasesToDelete(model.blockedPhrasesToDelete);
            systemMessageOverride(model.systemMessageOverride);
        }

        public final Collection<String> getBlockedPhrasesToCreateOrUpdate() {
            if (blockedPhrasesToCreateOrUpdate instanceof SdkAutoConstructList) {
                return null;
            }
            return blockedPhrasesToCreateOrUpdate;
        }

        public final void setBlockedPhrasesToCreateOrUpdate(Collection<String> blockedPhrasesToCreateOrUpdate) {
            this.blockedPhrasesToCreateOrUpdate = BlockedPhrasesCopier.copy(blockedPhrasesToCreateOrUpdate);
        }

        @Override
        public final Builder blockedPhrasesToCreateOrUpdate(Collection<String> blockedPhrasesToCreateOrUpdate) {
            this.blockedPhrasesToCreateOrUpdate = BlockedPhrasesCopier.copy(blockedPhrasesToCreateOrUpdate);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockedPhrasesToCreateOrUpdate(String... blockedPhrasesToCreateOrUpdate) {
            blockedPhrasesToCreateOrUpdate(Arrays.asList(blockedPhrasesToCreateOrUpdate));
            return this;
        }

        public final Collection<String> getBlockedPhrasesToDelete() {
            if (blockedPhrasesToDelete instanceof SdkAutoConstructList) {
                return null;
            }
            return blockedPhrasesToDelete;
        }

        public final void setBlockedPhrasesToDelete(Collection<String> blockedPhrasesToDelete) {
            this.blockedPhrasesToDelete = BlockedPhrasesCopier.copy(blockedPhrasesToDelete);
        }

        @Override
        public final Builder blockedPhrasesToDelete(Collection<String> blockedPhrasesToDelete) {
            this.blockedPhrasesToDelete = BlockedPhrasesCopier.copy(blockedPhrasesToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockedPhrasesToDelete(String... blockedPhrasesToDelete) {
            blockedPhrasesToDelete(Arrays.asList(blockedPhrasesToDelete));
            return this;
        }

        public final String getSystemMessageOverride() {
            return systemMessageOverride;
        }

        public final void setSystemMessageOverride(String systemMessageOverride) {
            this.systemMessageOverride = systemMessageOverride;
        }

        @Override
        public final Builder systemMessageOverride(String systemMessageOverride) {
            this.systemMessageOverride = systemMessageOverride;
            return this;
        }

        @Override
        public BlockedPhrasesConfigurationUpdate build() {
            return new BlockedPhrasesConfigurationUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
