/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChatRequest extends QBusinessRequest implements ToCopyableBuilder<ChatRequest.Builder, ChatRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationId").getter(getter(ChatRequest::applicationId)).setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()).build();

    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("userId")
            .getter(getter(ChatRequest::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("userId").build()).build();

    private static final SdkField<List<String>> USER_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("userGroups")
            .getter(getter(ChatRequest::userGroups))
            .setter(setter(Builder::userGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("userGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CONVERSATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("conversationId").getter(getter(ChatRequest::conversationId)).setter(setter(Builder::conversationId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("conversationId").build())
            .build();

    private static final SdkField<String> PARENT_MESSAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("parentMessageId").getter(getter(ChatRequest::parentMessageId)).setter(setter(Builder::parentMessageId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("parentMessageId").build())
            .build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(ChatRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            USER_ID_FIELD, USER_GROUPS_FIELD, CONVERSATION_ID_FIELD, PARENT_MESSAGE_ID_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String applicationId;

    private final String userId;

    private final List<String> userGroups;

    private final String conversationId;

    private final String parentMessageId;

    private final String clientToken;

    private ChatRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.userId = builder.userId;
        this.userGroups = builder.userGroups;
        this.conversationId = builder.conversationId;
        this.parentMessageId = builder.parentMessageId;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The identifier of the Amazon Q Business application linked to a streaming Amazon Q Business conversation.
     * </p>
     * 
     * @return The identifier of the Amazon Q Business application linked to a streaming Amazon Q Business conversation.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The identifier of the user attached to the chat input.
     * </p>
     * 
     * @return The identifier of the user attached to the chat input.
     */
    public final String userId() {
        return userId;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserGroups property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasUserGroups() {
        return userGroups != null && !(userGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The group names that a user associated with the chat input belongs to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserGroups} method.
     * </p>
     * 
     * @return The group names that a user associated with the chat input belongs to.
     */
    public final List<String> userGroups() {
        return userGroups;
    }

    /**
     * <p>
     * The identifier of the Amazon Q Business conversation.
     * </p>
     * 
     * @return The identifier of the Amazon Q Business conversation.
     */
    public final String conversationId() {
        return conversationId;
    }

    /**
     * <p>
     * The identifier used to associate a user message with a AI generated response.
     * </p>
     * 
     * @return The identifier used to associate a user message with a AI generated response.
     */
    public final String parentMessageId() {
        return parentMessageId;
    }

    /**
     * <p>
     * A token that you provide to identify the chat input.
     * </p>
     * 
     * @return A token that you provide to identify the chat input.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(hasUserGroups() ? userGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(conversationId());
        hashCode = 31 * hashCode + Objects.hashCode(parentMessageId());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChatRequest)) {
            return false;
        }
        ChatRequest other = (ChatRequest) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(userId(), other.userId())
                && hasUserGroups() == other.hasUserGroups() && Objects.equals(userGroups(), other.userGroups())
                && Objects.equals(conversationId(), other.conversationId())
                && Objects.equals(parentMessageId(), other.parentMessageId())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChatRequest").add("ApplicationId", applicationId()).add("UserId", userId())
                .add("UserGroups", hasUserGroups() ? userGroups() : null).add("ConversationId", conversationId())
                .add("ParentMessageId", parentMessageId()).add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "userId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "userGroups":
            return Optional.ofNullable(clazz.cast(userGroups()));
        case "conversationId":
            return Optional.ofNullable(clazz.cast(conversationId()));
        case "parentMessageId":
            return Optional.ofNullable(clazz.cast(parentMessageId()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("applicationId", APPLICATION_ID_FIELD);
        map.put("userId", USER_ID_FIELD);
        map.put("userGroups", USER_GROUPS_FIELD);
        map.put("conversationId", CONVERSATION_ID_FIELD);
        map.put("parentMessageId", PARENT_MESSAGE_ID_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChatRequest, T> g) {
        return obj -> g.apply((ChatRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QBusinessRequest.Builder, SdkPojo, CopyableBuilder<Builder, ChatRequest> {
        /**
         * <p>
         * The identifier of the Amazon Q Business application linked to a streaming Amazon Q Business conversation.
         * </p>
         * 
         * @param applicationId
         *        The identifier of the Amazon Q Business application linked to a streaming Amazon Q Business
         *        conversation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The identifier of the user attached to the chat input.
         * </p>
         * 
         * @param userId
         *        The identifier of the user attached to the chat input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * The group names that a user associated with the chat input belongs to.
         * </p>
         * 
         * @param userGroups
         *        The group names that a user associated with the chat input belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userGroups(Collection<String> userGroups);

        /**
         * <p>
         * The group names that a user associated with the chat input belongs to.
         * </p>
         * 
         * @param userGroups
         *        The group names that a user associated with the chat input belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userGroups(String... userGroups);

        /**
         * <p>
         * The identifier of the Amazon Q Business conversation.
         * </p>
         * 
         * @param conversationId
         *        The identifier of the Amazon Q Business conversation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conversationId(String conversationId);

        /**
         * <p>
         * The identifier used to associate a user message with a AI generated response.
         * </p>
         * 
         * @param parentMessageId
         *        The identifier used to associate a user message with a AI generated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentMessageId(String parentMessageId);

        /**
         * <p>
         * A token that you provide to identify the chat input.
         * </p>
         * 
         * @param clientToken
         *        A token that you provide to identify the chat input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QBusinessRequest.BuilderImpl implements Builder {
        private String applicationId;

        private String userId;

        private List<String> userGroups = DefaultSdkAutoConstructList.getInstance();

        private String conversationId;

        private String parentMessageId;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ChatRequest model) {
            super(model);
            applicationId(model.applicationId);
            userId(model.userId);
            userGroups(model.userGroups);
            conversationId(model.conversationId);
            parentMessageId(model.parentMessageId);
            clientToken(model.clientToken);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getUserId() {
            return userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final Collection<String> getUserGroups() {
            if (userGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return userGroups;
        }

        public final void setUserGroups(Collection<String> userGroups) {
            this.userGroups = UserGroupsCopier.copy(userGroups);
        }

        @Override
        public final Builder userGroups(Collection<String> userGroups) {
            this.userGroups = UserGroupsCopier.copy(userGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userGroups(String... userGroups) {
            userGroups(Arrays.asList(userGroups));
            return this;
        }

        public final String getConversationId() {
            return conversationId;
        }

        public final void setConversationId(String conversationId) {
            this.conversationId = conversationId;
        }

        @Override
        public final Builder conversationId(String conversationId) {
            this.conversationId = conversationId;
            return this;
        }

        public final String getParentMessageId() {
            return parentMessageId;
        }

        public final void setParentMessageId(String parentMessageId) {
            this.parentMessageId = parentMessageId;
        }

        @Override
        public final Builder parentMessageId(String parentMessageId) {
            this.parentMessageId = parentMessageId;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ChatRequest build() {
            return new ChatRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
