/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the source of content to search in.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContentSource implements SdkPojo, Serializable, ToCopyableBuilder<ContentSource.Builder, ContentSource> {
    private static final SdkField<RetrieverContentSource> RETRIEVER_FIELD = SdkField
            .<RetrieverContentSource> builder(MarshallingType.SDK_POJO).memberName("retriever")
            .getter(getter(ContentSource::retriever)).setter(setter(Builder::retriever))
            .constructor(RetrieverContentSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retriever").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RETRIEVER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final RetrieverContentSource retriever;

    private final Type type;

    private ContentSource(BuilderImpl builder) {
        this.retriever = builder.retriever;
        this.type = builder.type;
    }

    /**
     * <p>
     * The retriever to use as the content source.
     * </p>
     * 
     * @return The retriever to use as the content source.
     */
    public final RetrieverContentSource retriever() {
        return retriever;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(retriever());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContentSource)) {
            return false;
        }
        ContentSource other = (ContentSource) obj;
        return Objects.equals(retriever(), other.retriever());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContentSource").add("Retriever", retriever()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "retriever":
            return Optional.ofNullable(clazz.cast(retriever()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #retriever()} initialized to the given value.
     *
     * <p>
     * The retriever to use as the content source.
     * </p>
     * 
     * @param retriever
     *        The retriever to use as the content source.
     */
    public static ContentSource fromRetriever(RetrieverContentSource retriever) {
        return builder().retriever(retriever).build();
    }

    /**
     * Create an instance of this class with {@link #retriever()} initialized to the given value.
     *
     * <p>
     * The retriever to use as the content source.
     * </p>
     * 
     * @param retriever
     *        The retriever to use as the content source.
     */
    public static ContentSource fromRetriever(Consumer<RetrieverContentSource.Builder> retriever) {
        RetrieverContentSource.Builder builder = RetrieverContentSource.builder();
        retriever.accept(builder);
        return fromRetriever(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("retriever", RETRIEVER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContentSource, T> g) {
        return obj -> g.apply((ContentSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContentSource> {
        /**
         * <p>
         * The retriever to use as the content source.
         * </p>
         * 
         * @param retriever
         *        The retriever to use as the content source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retriever(RetrieverContentSource retriever);

        /**
         * <p>
         * The retriever to use as the content source.
         * </p>
         * This is a convenience method that creates an instance of the {@link RetrieverContentSource.Builder} avoiding
         * the need to create one manually via {@link RetrieverContentSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RetrieverContentSource.Builder#build()} is called immediately and
         * its result is passed to {@link #retriever(RetrieverContentSource)}.
         * 
         * @param retriever
         *        a consumer that will call methods on {@link RetrieverContentSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retriever(RetrieverContentSource)
         */
        default Builder retriever(Consumer<RetrieverContentSource.Builder> retriever) {
            return retriever(RetrieverContentSource.builder().applyMutation(retriever).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private RetrieverContentSource retriever;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ContentSource model) {
            retriever(model.retriever);
        }

        public final RetrieverContentSource.Builder getRetriever() {
            return retriever != null ? retriever.toBuilder() : null;
        }

        public final void setRetriever(RetrieverContentSource.BuilderImpl retriever) {
            Object oldValue = this.retriever;
            this.retriever = retriever != null ? retriever.build() : null;
            handleUnionValueChange(Type.RETRIEVER, oldValue, this.retriever);
        }

        @Override
        public final Builder retriever(RetrieverContentSource retriever) {
            Object oldValue = this.retriever;
            this.retriever = retriever;
            handleUnionValueChange(Type.RETRIEVER, oldValue, this.retriever);
            return this;
        }

        @Override
        public ContentSource build() {
            return new ContentSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ContentSource#type()
     */
    public enum Type {
        RETRIEVER,

        UNKNOWN_TO_SDK_VERSION
    }
}
