/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The source reference for an existing attachment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CopyFromSource implements SdkPojo, Serializable, ToCopyableBuilder<CopyFromSource.Builder, CopyFromSource> {
    private static final SdkField<ConversationSource> CONVERSATION_FIELD = SdkField
            .<ConversationSource> builder(MarshallingType.SDK_POJO).memberName("conversation")
            .getter(getter(CopyFromSource::conversation)).setter(setter(Builder::conversation))
            .constructor(ConversationSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conversation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONVERSATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ConversationSource conversation;

    private final Type type;

    private CopyFromSource(BuilderImpl builder) {
        this.conversation = builder.conversation;
        this.type = builder.type;
    }

    /**
     * <p>
     * A reference to an attachment in an existing conversation.
     * </p>
     * 
     * @return A reference to an attachment in an existing conversation.
     */
    public final ConversationSource conversation() {
        return conversation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(conversation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyFromSource)) {
            return false;
        }
        CopyFromSource other = (CopyFromSource) obj;
        return Objects.equals(conversation(), other.conversation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CopyFromSource").add("Conversation", conversation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "conversation":
            return Optional.ofNullable(clazz.cast(conversation()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #conversation()} initialized to the given value.
     *
     * <p>
     * A reference to an attachment in an existing conversation.
     * </p>
     * 
     * @param conversation
     *        A reference to an attachment in an existing conversation.
     */
    public static CopyFromSource fromConversation(ConversationSource conversation) {
        return builder().conversation(conversation).build();
    }

    /**
     * Create an instance of this class with {@link #conversation()} initialized to the given value.
     *
     * <p>
     * A reference to an attachment in an existing conversation.
     * </p>
     * 
     * @param conversation
     *        A reference to an attachment in an existing conversation.
     */
    public static CopyFromSource fromConversation(Consumer<ConversationSource.Builder> conversation) {
        ConversationSource.Builder builder = ConversationSource.builder();
        conversation.accept(builder);
        return fromConversation(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("conversation", CONVERSATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CopyFromSource, T> g) {
        return obj -> g.apply((CopyFromSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CopyFromSource> {
        /**
         * <p>
         * A reference to an attachment in an existing conversation.
         * </p>
         * 
         * @param conversation
         *        A reference to an attachment in an existing conversation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conversation(ConversationSource conversation);

        /**
         * <p>
         * A reference to an attachment in an existing conversation.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConversationSource.Builder} avoiding the
         * need to create one manually via {@link ConversationSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConversationSource.Builder#build()} is called immediately and its
         * result is passed to {@link #conversation(ConversationSource)}.
         * 
         * @param conversation
         *        a consumer that will call methods on {@link ConversationSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conversation(ConversationSource)
         */
        default Builder conversation(Consumer<ConversationSource.Builder> conversation) {
            return conversation(ConversationSource.builder().applyMutation(conversation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ConversationSource conversation;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(CopyFromSource model) {
            conversation(model.conversation);
        }

        public final ConversationSource.Builder getConversation() {
            return conversation != null ? conversation.toBuilder() : null;
        }

        public final void setConversation(ConversationSource.BuilderImpl conversation) {
            Object oldValue = this.conversation;
            this.conversation = conversation != null ? conversation.build() : null;
            handleUnionValueChange(Type.CONVERSATION, oldValue, this.conversation);
        }

        @Override
        public final Builder conversation(ConversationSource conversation) {
            Object oldValue = this.conversation;
            this.conversation = conversation;
            handleUnionValueChange(Type.CONVERSATION, oldValue, this.conversation);
            return this;
        }

        @Override
        public CopyFromSource build() {
            return new CopyFromSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see CopyFromSource#type()
     */
    public enum Type {
        CONVERSATION,

        UNKNOWN_TO_SDK_VERSION
    }
}
