/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateApplicationRequest extends QBusinessRequest implements
        ToCopyableBuilder<CreateApplicationRequest.Builder, CreateApplicationRequest> {
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(CreateApplicationRequest::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(CreateApplicationRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> IDENTITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identityType").getter(getter(CreateApplicationRequest::identityTypeAsString))
            .setter(setter(Builder::identityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identityType").build()).build();

    private static final SdkField<String> IAM_IDENTITY_PROVIDER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("iamIdentityProviderArn").getter(getter(CreateApplicationRequest::iamIdentityProviderArn))
            .setter(setter(Builder::iamIdentityProviderArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamIdentityProviderArn").build())
            .build();

    private static final SdkField<String> IDENTITY_CENTER_INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identityCenterInstanceArn").getter(getter(CreateApplicationRequest::identityCenterInstanceArn))
            .setter(setter(Builder::identityCenterInstanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identityCenterInstanceArn").build())
            .build();

    private static final SdkField<List<String>> CLIENT_IDS_FOR_OIDC_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("clientIdsForOIDC")
            .getter(getter(CreateApplicationRequest::clientIdsForOIDC))
            .setter(setter(Builder::clientIdsForOIDC))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientIdsForOIDC").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateApplicationRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<EncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField
            .<EncryptionConfiguration> builder(MarshallingType.SDK_POJO).memberName("encryptionConfiguration")
            .getter(getter(CreateApplicationRequest::encryptionConfiguration)).setter(setter(Builder::encryptionConfiguration))
            .constructor(EncryptionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionConfiguration").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateApplicationRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateApplicationRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<AttachmentsConfiguration> ATTACHMENTS_CONFIGURATION_FIELD = SdkField
            .<AttachmentsConfiguration> builder(MarshallingType.SDK_POJO).memberName("attachmentsConfiguration")
            .getter(getter(CreateApplicationRequest::attachmentsConfiguration)).setter(setter(Builder::attachmentsConfiguration))
            .constructor(AttachmentsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachmentsConfiguration").build())
            .build();

    private static final SdkField<QAppsConfiguration> Q_APPS_CONFIGURATION_FIELD = SdkField
            .<QAppsConfiguration> builder(MarshallingType.SDK_POJO).memberName("qAppsConfiguration")
            .getter(getter(CreateApplicationRequest::qAppsConfiguration)).setter(setter(Builder::qAppsConfiguration))
            .constructor(QAppsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qAppsConfiguration").build())
            .build();

    private static final SdkField<PersonalizationConfiguration> PERSONALIZATION_CONFIGURATION_FIELD = SdkField
            .<PersonalizationConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("personalizationConfiguration")
            .getter(getter(CreateApplicationRequest::personalizationConfiguration))
            .setter(setter(Builder::personalizationConfiguration))
            .constructor(PersonalizationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("personalizationConfiguration")
                    .build()).build();

    private static final SdkField<QuickSightConfiguration> QUICK_SIGHT_CONFIGURATION_FIELD = SdkField
            .<QuickSightConfiguration> builder(MarshallingType.SDK_POJO).memberName("quickSightConfiguration")
            .getter(getter(CreateApplicationRequest::quickSightConfiguration)).setter(setter(Builder::quickSightConfiguration))
            .constructor(QuickSightConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("quickSightConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISPLAY_NAME_FIELD,
            ROLE_ARN_FIELD, IDENTITY_TYPE_FIELD, IAM_IDENTITY_PROVIDER_ARN_FIELD, IDENTITY_CENTER_INSTANCE_ARN_FIELD,
            CLIENT_IDS_FOR_OIDC_FIELD, DESCRIPTION_FIELD, ENCRYPTION_CONFIGURATION_FIELD, TAGS_FIELD, CLIENT_TOKEN_FIELD,
            ATTACHMENTS_CONFIGURATION_FIELD, Q_APPS_CONFIGURATION_FIELD, PERSONALIZATION_CONFIGURATION_FIELD,
            QUICK_SIGHT_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String displayName;

    private final String roleArn;

    private final String identityType;

    private final String iamIdentityProviderArn;

    private final String identityCenterInstanceArn;

    private final List<String> clientIdsForOIDC;

    private final String description;

    private final EncryptionConfiguration encryptionConfiguration;

    private final List<Tag> tags;

    private final String clientToken;

    private final AttachmentsConfiguration attachmentsConfiguration;

    private final QAppsConfiguration qAppsConfiguration;

    private final PersonalizationConfiguration personalizationConfiguration;

    private final QuickSightConfiguration quickSightConfiguration;

    private CreateApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.displayName = builder.displayName;
        this.roleArn = builder.roleArn;
        this.identityType = builder.identityType;
        this.iamIdentityProviderArn = builder.iamIdentityProviderArn;
        this.identityCenterInstanceArn = builder.identityCenterInstanceArn;
        this.clientIdsForOIDC = builder.clientIdsForOIDC;
        this.description = builder.description;
        this.encryptionConfiguration = builder.encryptionConfiguration;
        this.tags = builder.tags;
        this.clientToken = builder.clientToken;
        this.attachmentsConfiguration = builder.attachmentsConfiguration;
        this.qAppsConfiguration = builder.qAppsConfiguration;
        this.personalizationConfiguration = builder.personalizationConfiguration;
        this.quickSightConfiguration = builder.quickSightConfiguration;
    }

    /**
     * <p>
     * A name for the Amazon Q Business application.
     * </p>
     * 
     * @return A name for the Amazon Q Business application.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM role with permissions to access your Amazon CloudWatch logs and metrics.
     * If this property is not specified, Amazon Q Business will create a <a
     * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/using-service-linked-roles.html#slr-permissions"
     * >service linked role (SLR)</a> and use it as the application's role.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM role with permissions to access your Amazon CloudWatch logs and
     *         metrics. If this property is not specified, Amazon Q Business will create a <a href=
     *         "https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/using-service-linked-roles.html#slr-permissions"
     *         >service linked role (SLR)</a> and use it as the application's role.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The authentication type being used by a Amazon Q Business application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #identityType} will
     * return {@link IdentityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #identityTypeAsString}.
     * </p>
     * 
     * @return The authentication type being used by a Amazon Q Business application.
     * @see IdentityType
     */
    public final IdentityType identityType() {
        return IdentityType.fromValue(identityType);
    }

    /**
     * <p>
     * The authentication type being used by a Amazon Q Business application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #identityType} will
     * return {@link IdentityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #identityTypeAsString}.
     * </p>
     * 
     * @return The authentication type being used by a Amazon Q Business application.
     * @see IdentityType
     */
    public final String identityTypeAsString() {
        return identityType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an identity provider being used by an Amazon Q Business application.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an identity provider being used by an Amazon Q Business application.
     */
    public final String iamIdentityProviderArn() {
        return iamIdentityProviderArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM Identity Center instance you are either creating for—or connecting
     * to—your Amazon Q Business application.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM Identity Center instance you are either creating for—or
     *         connecting to—your Amazon Q Business application.
     */
    public final String identityCenterInstanceArn() {
        return identityCenterInstanceArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the ClientIdsForOIDC property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasClientIdsForOIDC() {
        return clientIdsForOIDC != null && !(clientIdsForOIDC instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The OIDC client ID for a Amazon Q Business application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasClientIdsForOIDC} method.
     * </p>
     * 
     * @return The OIDC client ID for a Amazon Q Business application.
     */
    public final List<String> clientIdsForOIDC() {
        return clientIdsForOIDC;
    }

    /**
     * <p>
     * A description for the Amazon Q Business application.
     * </p>
     * 
     * @return A description for the Amazon Q Business application.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The identifier of the KMS key that is used to encrypt your data. Amazon Q Business doesn't support asymmetric
     * keys.
     * </p>
     * 
     * @return The identifier of the KMS key that is used to encrypt your data. Amazon Q Business doesn't support
     *         asymmetric keys.
     */
    public final EncryptionConfiguration encryptionConfiguration() {
        return encryptionConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of key-value pairs that identify or categorize your Amazon Q Business application. You can also use tags
     * to help control access to the application. Tag keys and values can consist of Unicode letters, digits, white
     * space, and any of the following symbols: _ . : / = + - @.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of key-value pairs that identify or categorize your Amazon Q Business application. You can also
     *         use tags to help control access to the application. Tag keys and values can consist of Unicode letters,
     *         digits, white space, and any of the following symbols: _ . : / = + - @.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * A token that you provide to identify the request to create your Amazon Q Business application.
     * </p>
     * 
     * @return A token that you provide to identify the request to create your Amazon Q Business application.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * An option to allow end users to upload files directly during chat.
     * </p>
     * 
     * @return An option to allow end users to upload files directly during chat.
     */
    public final AttachmentsConfiguration attachmentsConfiguration() {
        return attachmentsConfiguration;
    }

    /**
     * <p>
     * An option to allow end users to create and use Amazon Q Apps in the web experience.
     * </p>
     * 
     * @return An option to allow end users to create and use Amazon Q Apps in the web experience.
     */
    public final QAppsConfiguration qAppsConfiguration() {
        return qAppsConfiguration;
    }

    /**
     * <p>
     * Configuration information about chat response personalization. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/personalizing-chat-responses.html">Personalizing
     * chat responses</a>
     * </p>
     * 
     * @return Configuration information about chat response personalization. For more information, see <a
     *         href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/personalizing-chat-responses.html"
     *         >Personalizing chat responses</a>
     */
    public final PersonalizationConfiguration personalizationConfiguration() {
        return personalizationConfiguration;
    }

    /**
     * <p>
     * The Amazon QuickSight configuration for an Amazon Q Business application that uses QuickSight for authentication.
     * This configuration is required if your application uses QuickSight as the identity provider. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/create-quicksight-integrated-application.html"
     * >Creating an Amazon QuickSight integrated application</a>.
     * </p>
     * 
     * @return The Amazon QuickSight configuration for an Amazon Q Business application that uses QuickSight for
     *         authentication. This configuration is required if your application uses QuickSight as the identity
     *         provider. For more information, see <a href=
     *         "https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/create-quicksight-integrated-application.html"
     *         >Creating an Amazon QuickSight integrated application</a>.
     */
    public final QuickSightConfiguration quickSightConfiguration() {
        return quickSightConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(identityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(iamIdentityProviderArn());
        hashCode = 31 * hashCode + Objects.hashCode(identityCenterInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasClientIdsForOIDC() ? clientIdsForOIDC() : null);
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(attachmentsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(qAppsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(personalizationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(quickSightConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApplicationRequest)) {
            return false;
        }
        CreateApplicationRequest other = (CreateApplicationRequest) obj;
        return Objects.equals(displayName(), other.displayName()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(identityTypeAsString(), other.identityTypeAsString())
                && Objects.equals(iamIdentityProviderArn(), other.iamIdentityProviderArn())
                && Objects.equals(identityCenterInstanceArn(), other.identityCenterInstanceArn())
                && hasClientIdsForOIDC() == other.hasClientIdsForOIDC()
                && Objects.equals(clientIdsForOIDC(), other.clientIdsForOIDC())
                && Objects.equals(description(), other.description())
                && Objects.equals(encryptionConfiguration(), other.encryptionConfiguration()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(attachmentsConfiguration(), other.attachmentsConfiguration())
                && Objects.equals(qAppsConfiguration(), other.qAppsConfiguration())
                && Objects.equals(personalizationConfiguration(), other.personalizationConfiguration())
                && Objects.equals(quickSightConfiguration(), other.quickSightConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateApplicationRequest").add("DisplayName", displayName()).add("RoleArn", roleArn())
                .add("IdentityType", identityTypeAsString()).add("IamIdentityProviderArn", iamIdentityProviderArn())
                .add("IdentityCenterInstanceArn", identityCenterInstanceArn())
                .add("ClientIdsForOIDC", hasClientIdsForOIDC() ? clientIdsForOIDC() : null).add("Description", description())
                .add("EncryptionConfiguration", encryptionConfiguration()).add("Tags", hasTags() ? tags() : null)
                .add("ClientToken", clientToken()).add("AttachmentsConfiguration", attachmentsConfiguration())
                .add("QAppsConfiguration", qAppsConfiguration())
                .add("PersonalizationConfiguration", personalizationConfiguration())
                .add("QuickSightConfiguration", quickSightConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "identityType":
            return Optional.ofNullable(clazz.cast(identityTypeAsString()));
        case "iamIdentityProviderArn":
            return Optional.ofNullable(clazz.cast(iamIdentityProviderArn()));
        case "identityCenterInstanceArn":
            return Optional.ofNullable(clazz.cast(identityCenterInstanceArn()));
        case "clientIdsForOIDC":
            return Optional.ofNullable(clazz.cast(clientIdsForOIDC()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "encryptionConfiguration":
            return Optional.ofNullable(clazz.cast(encryptionConfiguration()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "attachmentsConfiguration":
            return Optional.ofNullable(clazz.cast(attachmentsConfiguration()));
        case "qAppsConfiguration":
            return Optional.ofNullable(clazz.cast(qAppsConfiguration()));
        case "personalizationConfiguration":
            return Optional.ofNullable(clazz.cast(personalizationConfiguration()));
        case "quickSightConfiguration":
            return Optional.ofNullable(clazz.cast(quickSightConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("identityType", IDENTITY_TYPE_FIELD);
        map.put("iamIdentityProviderArn", IAM_IDENTITY_PROVIDER_ARN_FIELD);
        map.put("identityCenterInstanceArn", IDENTITY_CENTER_INSTANCE_ARN_FIELD);
        map.put("clientIdsForOIDC", CLIENT_IDS_FOR_OIDC_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("encryptionConfiguration", ENCRYPTION_CONFIGURATION_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("attachmentsConfiguration", ATTACHMENTS_CONFIGURATION_FIELD);
        map.put("qAppsConfiguration", Q_APPS_CONFIGURATION_FIELD);
        map.put("personalizationConfiguration", PERSONALIZATION_CONFIGURATION_FIELD);
        map.put("quickSightConfiguration", QUICK_SIGHT_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateApplicationRequest, T> g) {
        return obj -> g.apply((CreateApplicationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QBusinessRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateApplicationRequest> {
        /**
         * <p>
         * A name for the Amazon Q Business application.
         * </p>
         * 
         * @param displayName
         *        A name for the Amazon Q Business application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM role with permissions to access your Amazon CloudWatch logs and
         * metrics. If this property is not specified, Amazon Q Business will create a <a href=
         * "https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/using-service-linked-roles.html#slr-permissions"
         * >service linked role (SLR)</a> and use it as the application's role.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of an IAM role with permissions to access your Amazon CloudWatch logs
         *        and metrics. If this property is not specified, Amazon Q Business will create a <a href=
         *        "https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/using-service-linked-roles.html#slr-permissions"
         *        >service linked role (SLR)</a> and use it as the application's role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The authentication type being used by a Amazon Q Business application.
         * </p>
         * 
         * @param identityType
         *        The authentication type being used by a Amazon Q Business application.
         * @see IdentityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityType
         */
        Builder identityType(String identityType);

        /**
         * <p>
         * The authentication type being used by a Amazon Q Business application.
         * </p>
         * 
         * @param identityType
         *        The authentication type being used by a Amazon Q Business application.
         * @see IdentityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityType
         */
        Builder identityType(IdentityType identityType);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an identity provider being used by an Amazon Q Business application.
         * </p>
         * 
         * @param iamIdentityProviderArn
         *        The Amazon Resource Name (ARN) of an identity provider being used by an Amazon Q Business application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamIdentityProviderArn(String iamIdentityProviderArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM Identity Center instance you are either creating for—or connecting
         * to—your Amazon Q Business application.
         * </p>
         * 
         * @param identityCenterInstanceArn
         *        The Amazon Resource Name (ARN) of the IAM Identity Center instance you are either creating for—or
         *        connecting to—your Amazon Q Business application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityCenterInstanceArn(String identityCenterInstanceArn);

        /**
         * <p>
         * The OIDC client ID for a Amazon Q Business application.
         * </p>
         * 
         * @param clientIdsForOIDC
         *        The OIDC client ID for a Amazon Q Business application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientIdsForOIDC(Collection<String> clientIdsForOIDC);

        /**
         * <p>
         * The OIDC client ID for a Amazon Q Business application.
         * </p>
         * 
         * @param clientIdsForOIDC
         *        The OIDC client ID for a Amazon Q Business application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientIdsForOIDC(String... clientIdsForOIDC);

        /**
         * <p>
         * A description for the Amazon Q Business application.
         * </p>
         * 
         * @param description
         *        A description for the Amazon Q Business application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The identifier of the KMS key that is used to encrypt your data. Amazon Q Business doesn't support asymmetric
         * keys.
         * </p>
         * 
         * @param encryptionConfiguration
         *        The identifier of the KMS key that is used to encrypt your data. Amazon Q Business doesn't support
         *        asymmetric keys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration);

        /**
         * <p>
         * The identifier of the KMS key that is used to encrypt your data. Amazon Q Business doesn't support asymmetric
         * keys.
         * </p>
         * This is a convenience method that creates an instance of the {@link EncryptionConfiguration.Builder} avoiding
         * the need to create one manually via {@link EncryptionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EncryptionConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #encryptionConfiguration(EncryptionConfiguration)}.
         * 
         * @param encryptionConfiguration
         *        a consumer that will call methods on {@link EncryptionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionConfiguration(EncryptionConfiguration)
         */
        default Builder encryptionConfiguration(Consumer<EncryptionConfiguration.Builder> encryptionConfiguration) {
            return encryptionConfiguration(EncryptionConfiguration.builder().applyMutation(encryptionConfiguration).build());
        }

        /**
         * <p>
         * A list of key-value pairs that identify or categorize your Amazon Q Business application. You can also use
         * tags to help control access to the application. Tag keys and values can consist of Unicode letters, digits,
         * white space, and any of the following symbols: _ . : / = + - @.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs that identify or categorize your Amazon Q Business application. You can also
         *        use tags to help control access to the application. Tag keys and values can consist of Unicode
         *        letters, digits, white space, and any of the following symbols: _ . : / = + - @.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of key-value pairs that identify or categorize your Amazon Q Business application. You can also use
         * tags to help control access to the application. Tag keys and values can consist of Unicode letters, digits,
         * white space, and any of the following symbols: _ . : / = + - @.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs that identify or categorize your Amazon Q Business application. You can also
         *        use tags to help control access to the application. Tag keys and values can consist of Unicode
         *        letters, digits, white space, and any of the following symbols: _ . : / = + - @.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of key-value pairs that identify or categorize your Amazon Q Business application. You can also use
         * tags to help control access to the application. Tag keys and values can consist of Unicode letters, digits,
         * white space, and any of the following symbols: _ . : / = + - @.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qbusiness.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.qbusiness.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qbusiness.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qbusiness.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * A token that you provide to identify the request to create your Amazon Q Business application.
         * </p>
         * 
         * @param clientToken
         *        A token that you provide to identify the request to create your Amazon Q Business application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * An option to allow end users to upload files directly during chat.
         * </p>
         * 
         * @param attachmentsConfiguration
         *        An option to allow end users to upload files directly during chat.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentsConfiguration(AttachmentsConfiguration attachmentsConfiguration);

        /**
         * <p>
         * An option to allow end users to upload files directly during chat.
         * </p>
         * This is a convenience method that creates an instance of the {@link AttachmentsConfiguration.Builder}
         * avoiding the need to create one manually via {@link AttachmentsConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttachmentsConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #attachmentsConfiguration(AttachmentsConfiguration)}.
         * 
         * @param attachmentsConfiguration
         *        a consumer that will call methods on {@link AttachmentsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachmentsConfiguration(AttachmentsConfiguration)
         */
        default Builder attachmentsConfiguration(Consumer<AttachmentsConfiguration.Builder> attachmentsConfiguration) {
            return attachmentsConfiguration(AttachmentsConfiguration.builder().applyMutation(attachmentsConfiguration).build());
        }

        /**
         * <p>
         * An option to allow end users to create and use Amazon Q Apps in the web experience.
         * </p>
         * 
         * @param qAppsConfiguration
         *        An option to allow end users to create and use Amazon Q Apps in the web experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qAppsConfiguration(QAppsConfiguration qAppsConfiguration);

        /**
         * <p>
         * An option to allow end users to create and use Amazon Q Apps in the web experience.
         * </p>
         * This is a convenience method that creates an instance of the {@link QAppsConfiguration.Builder} avoiding the
         * need to create one manually via {@link QAppsConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QAppsConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #qAppsConfiguration(QAppsConfiguration)}.
         * 
         * @param qAppsConfiguration
         *        a consumer that will call methods on {@link QAppsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #qAppsConfiguration(QAppsConfiguration)
         */
        default Builder qAppsConfiguration(Consumer<QAppsConfiguration.Builder> qAppsConfiguration) {
            return qAppsConfiguration(QAppsConfiguration.builder().applyMutation(qAppsConfiguration).build());
        }

        /**
         * <p>
         * Configuration information about chat response personalization. For more information, see <a
         * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/personalizing-chat-responses.html"
         * >Personalizing chat responses</a>
         * </p>
         * 
         * @param personalizationConfiguration
         *        Configuration information about chat response personalization. For more information, see <a
         *        href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/personalizing-chat-responses.html"
         *        >Personalizing chat responses</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder personalizationConfiguration(PersonalizationConfiguration personalizationConfiguration);

        /**
         * <p>
         * Configuration information about chat response personalization. For more information, see <a
         * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/personalizing-chat-responses.html"
         * >Personalizing chat responses</a>
         * </p>
         * This is a convenience method that creates an instance of the {@link PersonalizationConfiguration.Builder}
         * avoiding the need to create one manually via {@link PersonalizationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PersonalizationConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #personalizationConfiguration(PersonalizationConfiguration)}.
         * 
         * @param personalizationConfiguration
         *        a consumer that will call methods on {@link PersonalizationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #personalizationConfiguration(PersonalizationConfiguration)
         */
        default Builder personalizationConfiguration(Consumer<PersonalizationConfiguration.Builder> personalizationConfiguration) {
            return personalizationConfiguration(PersonalizationConfiguration.builder()
                    .applyMutation(personalizationConfiguration).build());
        }

        /**
         * <p>
         * The Amazon QuickSight configuration for an Amazon Q Business application that uses QuickSight for
         * authentication. This configuration is required if your application uses QuickSight as the identity provider.
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/create-quicksight-integrated-application.html"
         * >Creating an Amazon QuickSight integrated application</a>.
         * </p>
         * 
         * @param quickSightConfiguration
         *        The Amazon QuickSight configuration for an Amazon Q Business application that uses QuickSight for
         *        authentication. This configuration is required if your application uses QuickSight as the identity
         *        provider. For more information, see <a href=
         *        "https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/create-quicksight-integrated-application.html"
         *        >Creating an Amazon QuickSight integrated application</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quickSightConfiguration(QuickSightConfiguration quickSightConfiguration);

        /**
         * <p>
         * The Amazon QuickSight configuration for an Amazon Q Business application that uses QuickSight for
         * authentication. This configuration is required if your application uses QuickSight as the identity provider.
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/create-quicksight-integrated-application.html"
         * >Creating an Amazon QuickSight integrated application</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link QuickSightConfiguration.Builder} avoiding
         * the need to create one manually via {@link QuickSightConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QuickSightConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #quickSightConfiguration(QuickSightConfiguration)}.
         * 
         * @param quickSightConfiguration
         *        a consumer that will call methods on {@link QuickSightConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #quickSightConfiguration(QuickSightConfiguration)
         */
        default Builder quickSightConfiguration(Consumer<QuickSightConfiguration.Builder> quickSightConfiguration) {
            return quickSightConfiguration(QuickSightConfiguration.builder().applyMutation(quickSightConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QBusinessRequest.BuilderImpl implements Builder {
        private String displayName;

        private String roleArn;

        private String identityType;

        private String iamIdentityProviderArn;

        private String identityCenterInstanceArn;

        private List<String> clientIdsForOIDC = DefaultSdkAutoConstructList.getInstance();

        private String description;

        private EncryptionConfiguration encryptionConfiguration;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private AttachmentsConfiguration attachmentsConfiguration;

        private QAppsConfiguration qAppsConfiguration;

        private PersonalizationConfiguration personalizationConfiguration;

        private QuickSightConfiguration quickSightConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApplicationRequest model) {
            super(model);
            displayName(model.displayName);
            roleArn(model.roleArn);
            identityType(model.identityType);
            iamIdentityProviderArn(model.iamIdentityProviderArn);
            identityCenterInstanceArn(model.identityCenterInstanceArn);
            clientIdsForOIDC(model.clientIdsForOIDC);
            description(model.description);
            encryptionConfiguration(model.encryptionConfiguration);
            tags(model.tags);
            clientToken(model.clientToken);
            attachmentsConfiguration(model.attachmentsConfiguration);
            qAppsConfiguration(model.qAppsConfiguration);
            personalizationConfiguration(model.personalizationConfiguration);
            quickSightConfiguration(model.quickSightConfiguration);
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getIdentityType() {
            return identityType;
        }

        public final void setIdentityType(String identityType) {
            this.identityType = identityType;
        }

        @Override
        public final Builder identityType(String identityType) {
            this.identityType = identityType;
            return this;
        }

        @Override
        public final Builder identityType(IdentityType identityType) {
            this.identityType(identityType == null ? null : identityType.toString());
            return this;
        }

        public final String getIamIdentityProviderArn() {
            return iamIdentityProviderArn;
        }

        public final void setIamIdentityProviderArn(String iamIdentityProviderArn) {
            this.iamIdentityProviderArn = iamIdentityProviderArn;
        }

        @Override
        public final Builder iamIdentityProviderArn(String iamIdentityProviderArn) {
            this.iamIdentityProviderArn = iamIdentityProviderArn;
            return this;
        }

        public final String getIdentityCenterInstanceArn() {
            return identityCenterInstanceArn;
        }

        public final void setIdentityCenterInstanceArn(String identityCenterInstanceArn) {
            this.identityCenterInstanceArn = identityCenterInstanceArn;
        }

        @Override
        public final Builder identityCenterInstanceArn(String identityCenterInstanceArn) {
            this.identityCenterInstanceArn = identityCenterInstanceArn;
            return this;
        }

        public final Collection<String> getClientIdsForOIDC() {
            if (clientIdsForOIDC instanceof SdkAutoConstructList) {
                return null;
            }
            return clientIdsForOIDC;
        }

        public final void setClientIdsForOIDC(Collection<String> clientIdsForOIDC) {
            this.clientIdsForOIDC = ClientIdsForOIDCCopier.copy(clientIdsForOIDC);
        }

        @Override
        public final Builder clientIdsForOIDC(Collection<String> clientIdsForOIDC) {
            this.clientIdsForOIDC = ClientIdsForOIDCCopier.copy(clientIdsForOIDC);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clientIdsForOIDC(String... clientIdsForOIDC) {
            clientIdsForOIDC(Arrays.asList(clientIdsForOIDC));
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final EncryptionConfiguration.Builder getEncryptionConfiguration() {
            return encryptionConfiguration != null ? encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final AttachmentsConfiguration.Builder getAttachmentsConfiguration() {
            return attachmentsConfiguration != null ? attachmentsConfiguration.toBuilder() : null;
        }

        public final void setAttachmentsConfiguration(AttachmentsConfiguration.BuilderImpl attachmentsConfiguration) {
            this.attachmentsConfiguration = attachmentsConfiguration != null ? attachmentsConfiguration.build() : null;
        }

        @Override
        public final Builder attachmentsConfiguration(AttachmentsConfiguration attachmentsConfiguration) {
            this.attachmentsConfiguration = attachmentsConfiguration;
            return this;
        }

        public final QAppsConfiguration.Builder getQAppsConfiguration() {
            return qAppsConfiguration != null ? qAppsConfiguration.toBuilder() : null;
        }

        public final void setQAppsConfiguration(QAppsConfiguration.BuilderImpl qAppsConfiguration) {
            this.qAppsConfiguration = qAppsConfiguration != null ? qAppsConfiguration.build() : null;
        }

        @Override
        public final Builder qAppsConfiguration(QAppsConfiguration qAppsConfiguration) {
            this.qAppsConfiguration = qAppsConfiguration;
            return this;
        }

        public final PersonalizationConfiguration.Builder getPersonalizationConfiguration() {
            return personalizationConfiguration != null ? personalizationConfiguration.toBuilder() : null;
        }

        public final void setPersonalizationConfiguration(PersonalizationConfiguration.BuilderImpl personalizationConfiguration) {
            this.personalizationConfiguration = personalizationConfiguration != null ? personalizationConfiguration.build()
                    : null;
        }

        @Override
        public final Builder personalizationConfiguration(PersonalizationConfiguration personalizationConfiguration) {
            this.personalizationConfiguration = personalizationConfiguration;
            return this;
        }

        public final QuickSightConfiguration.Builder getQuickSightConfiguration() {
            return quickSightConfiguration != null ? quickSightConfiguration.toBuilder() : null;
        }

        public final void setQuickSightConfiguration(QuickSightConfiguration.BuilderImpl quickSightConfiguration) {
            this.quickSightConfiguration = quickSightConfiguration != null ? quickSightConfiguration.build() : null;
        }

        @Override
        public final Builder quickSightConfiguration(QuickSightConfiguration quickSightConfiguration) {
            this.quickSightConfiguration = quickSightConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateApplicationRequest build() {
            return new CreateApplicationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
