/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the configuration information to customize the logo, font, and color of an Amazon Q Business web experience
 * with individual files for each property or a CSS file for them all.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomizationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomizationConfiguration.Builder, CustomizationConfiguration> {
    private static final SdkField<String> CUSTOM_CSS_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customCSSUrl").getter(getter(CustomizationConfiguration::customCSSUrl))
            .setter(setter(Builder::customCSSUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customCSSUrl").build()).build();

    private static final SdkField<String> LOGO_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logoUrl").getter(getter(CustomizationConfiguration::logoUrl)).setter(setter(Builder::logoUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logoUrl").build()).build();

    private static final SdkField<String> FONT_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fontUrl").getter(getter(CustomizationConfiguration::fontUrl)).setter(setter(Builder::fontUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fontUrl").build()).build();

    private static final SdkField<String> FAVICON_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("faviconUrl").getter(getter(CustomizationConfiguration::faviconUrl)).setter(setter(Builder::faviconUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("faviconUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_CSS_URL_FIELD,
            LOGO_URL_FIELD, FONT_URL_FIELD, FAVICON_URL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String customCSSUrl;

    private final String logoUrl;

    private final String fontUrl;

    private final String faviconUrl;

    private CustomizationConfiguration(BuilderImpl builder) {
        this.customCSSUrl = builder.customCSSUrl;
        this.logoUrl = builder.logoUrl;
        this.fontUrl = builder.fontUrl;
        this.faviconUrl = builder.faviconUrl;
    }

    /**
     * <p>
     * Provides the URL where the custom CSS file is hosted for an Amazon Q web experience.
     * </p>
     * 
     * @return Provides the URL where the custom CSS file is hosted for an Amazon Q web experience.
     */
    public final String customCSSUrl() {
        return customCSSUrl;
    }

    /**
     * <p>
     * Provides the URL where the custom logo file is hosted for an Amazon Q web experience.
     * </p>
     * 
     * @return Provides the URL where the custom logo file is hosted for an Amazon Q web experience.
     */
    public final String logoUrl() {
        return logoUrl;
    }

    /**
     * <p>
     * Provides the URL where the custom font file is hosted for an Amazon Q web experience.
     * </p>
     * 
     * @return Provides the URL where the custom font file is hosted for an Amazon Q web experience.
     */
    public final String fontUrl() {
        return fontUrl;
    }

    /**
     * <p>
     * Provides the URL where the custom favicon file is hosted for an Amazon Q web experience.
     * </p>
     * 
     * @return Provides the URL where the custom favicon file is hosted for an Amazon Q web experience.
     */
    public final String faviconUrl() {
        return faviconUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(customCSSUrl());
        hashCode = 31 * hashCode + Objects.hashCode(logoUrl());
        hashCode = 31 * hashCode + Objects.hashCode(fontUrl());
        hashCode = 31 * hashCode + Objects.hashCode(faviconUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomizationConfiguration)) {
            return false;
        }
        CustomizationConfiguration other = (CustomizationConfiguration) obj;
        return Objects.equals(customCSSUrl(), other.customCSSUrl()) && Objects.equals(logoUrl(), other.logoUrl())
                && Objects.equals(fontUrl(), other.fontUrl()) && Objects.equals(faviconUrl(), other.faviconUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomizationConfiguration").add("CustomCSSUrl", customCSSUrl()).add("LogoUrl", logoUrl())
                .add("FontUrl", fontUrl()).add("FaviconUrl", faviconUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "customCSSUrl":
            return Optional.ofNullable(clazz.cast(customCSSUrl()));
        case "logoUrl":
            return Optional.ofNullable(clazz.cast(logoUrl()));
        case "fontUrl":
            return Optional.ofNullable(clazz.cast(fontUrl()));
        case "faviconUrl":
            return Optional.ofNullable(clazz.cast(faviconUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("customCSSUrl", CUSTOM_CSS_URL_FIELD);
        map.put("logoUrl", LOGO_URL_FIELD);
        map.put("fontUrl", FONT_URL_FIELD);
        map.put("faviconUrl", FAVICON_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomizationConfiguration, T> g) {
        return obj -> g.apply((CustomizationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomizationConfiguration> {
        /**
         * <p>
         * Provides the URL where the custom CSS file is hosted for an Amazon Q web experience.
         * </p>
         * 
         * @param customCSSUrl
         *        Provides the URL where the custom CSS file is hosted for an Amazon Q web experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customCSSUrl(String customCSSUrl);

        /**
         * <p>
         * Provides the URL where the custom logo file is hosted for an Amazon Q web experience.
         * </p>
         * 
         * @param logoUrl
         *        Provides the URL where the custom logo file is hosted for an Amazon Q web experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logoUrl(String logoUrl);

        /**
         * <p>
         * Provides the URL where the custom font file is hosted for an Amazon Q web experience.
         * </p>
         * 
         * @param fontUrl
         *        Provides the URL where the custom font file is hosted for an Amazon Q web experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fontUrl(String fontUrl);

        /**
         * <p>
         * Provides the URL where the custom favicon file is hosted for an Amazon Q web experience.
         * </p>
         * 
         * @param faviconUrl
         *        Provides the URL where the custom favicon file is hosted for an Amazon Q web experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faviconUrl(String faviconUrl);
    }

    static final class BuilderImpl implements Builder {
        private String customCSSUrl;

        private String logoUrl;

        private String fontUrl;

        private String faviconUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomizationConfiguration model) {
            customCSSUrl(model.customCSSUrl);
            logoUrl(model.logoUrl);
            fontUrl(model.fontUrl);
            faviconUrl(model.faviconUrl);
        }

        public final String getCustomCSSUrl() {
            return customCSSUrl;
        }

        public final void setCustomCSSUrl(String customCSSUrl) {
            this.customCSSUrl = customCSSUrl;
        }

        @Override
        public final Builder customCSSUrl(String customCSSUrl) {
            this.customCSSUrl = customCSSUrl;
            return this;
        }

        public final String getLogoUrl() {
            return logoUrl;
        }

        public final void setLogoUrl(String logoUrl) {
            this.logoUrl = logoUrl;
        }

        @Override
        public final Builder logoUrl(String logoUrl) {
            this.logoUrl = logoUrl;
            return this;
        }

        public final String getFontUrl() {
            return fontUrl;
        }

        public final void setFontUrl(String fontUrl) {
            this.fontUrl = fontUrl;
        }

        @Override
        public final Builder fontUrl(String fontUrl) {
            this.fontUrl = fontUrl;
            return this;
        }

        public final String getFaviconUrl() {
            return faviconUrl;
        }

        public final void setFaviconUrl(String faviconUrl) {
            this.faviconUrl = faviconUrl;
        }

        @Override
        public final Builder faviconUrl(String faviconUrl) {
            this.faviconUrl = faviconUrl;
            return this;
        }

        @Override
        public CustomizationConfiguration build() {
            return new CustomizationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
