/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the Access Control List (ACL) for a document, containing both allowlist and denylist conditions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DocumentAcl implements SdkPojo, Serializable, ToCopyableBuilder<DocumentAcl.Builder, DocumentAcl> {
    private static final SdkField<DocumentAclMembership> ALLOWLIST_FIELD = SdkField
            .<DocumentAclMembership> builder(MarshallingType.SDK_POJO).memberName("allowlist")
            .getter(getter(DocumentAcl::allowlist)).setter(setter(Builder::allowlist))
            .constructor(DocumentAclMembership::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowlist").build()).build();

    private static final SdkField<DocumentAclMembership> DENY_LIST_FIELD = SdkField
            .<DocumentAclMembership> builder(MarshallingType.SDK_POJO).memberName("denyList")
            .getter(getter(DocumentAcl::denyList)).setter(setter(Builder::denyList)).constructor(DocumentAclMembership::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("denyList").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOWLIST_FIELD,
            DENY_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DocumentAclMembership allowlist;

    private final DocumentAclMembership denyList;

    private DocumentAcl(BuilderImpl builder) {
        this.allowlist = builder.allowlist;
        this.denyList = builder.denyList;
    }

    /**
     * <p>
     * The allowlist conditions for the document. Users or groups matching these conditions are granted access to the
     * document.
     * </p>
     * 
     * @return The allowlist conditions for the document. Users or groups matching these conditions are granted access
     *         to the document.
     */
    public final DocumentAclMembership allowlist() {
        return allowlist;
    }

    /**
     * <p>
     * The denylist conditions for the document. Users or groups matching these conditions are denied access to the
     * document, overriding allowlist permissions.
     * </p>
     * 
     * @return The denylist conditions for the document. Users or groups matching these conditions are denied access to
     *         the document, overriding allowlist permissions.
     */
    public final DocumentAclMembership denyList() {
        return denyList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(allowlist());
        hashCode = 31 * hashCode + Objects.hashCode(denyList());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentAcl)) {
            return false;
        }
        DocumentAcl other = (DocumentAcl) obj;
        return Objects.equals(allowlist(), other.allowlist()) && Objects.equals(denyList(), other.denyList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DocumentAcl").add("Allowlist", allowlist()).add("DenyList", denyList()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "allowlist":
            return Optional.ofNullable(clazz.cast(allowlist()));
        case "denyList":
            return Optional.ofNullable(clazz.cast(denyList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("allowlist", ALLOWLIST_FIELD);
        map.put("denyList", DENY_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DocumentAcl, T> g) {
        return obj -> g.apply((DocumentAcl) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DocumentAcl> {
        /**
         * <p>
         * The allowlist conditions for the document. Users or groups matching these conditions are granted access to
         * the document.
         * </p>
         * 
         * @param allowlist
         *        The allowlist conditions for the document. Users or groups matching these conditions are granted
         *        access to the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowlist(DocumentAclMembership allowlist);

        /**
         * <p>
         * The allowlist conditions for the document. Users or groups matching these conditions are granted access to
         * the document.
         * </p>
         * This is a convenience method that creates an instance of the {@link DocumentAclMembership.Builder} avoiding
         * the need to create one manually via {@link DocumentAclMembership#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DocumentAclMembership.Builder#build()} is called immediately and
         * its result is passed to {@link #allowlist(DocumentAclMembership)}.
         * 
         * @param allowlist
         *        a consumer that will call methods on {@link DocumentAclMembership.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #allowlist(DocumentAclMembership)
         */
        default Builder allowlist(Consumer<DocumentAclMembership.Builder> allowlist) {
            return allowlist(DocumentAclMembership.builder().applyMutation(allowlist).build());
        }

        /**
         * <p>
         * The denylist conditions for the document. Users or groups matching these conditions are denied access to the
         * document, overriding allowlist permissions.
         * </p>
         * 
         * @param denyList
         *        The denylist conditions for the document. Users or groups matching these conditions are denied access
         *        to the document, overriding allowlist permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder denyList(DocumentAclMembership denyList);

        /**
         * <p>
         * The denylist conditions for the document. Users or groups matching these conditions are denied access to the
         * document, overriding allowlist permissions.
         * </p>
         * This is a convenience method that creates an instance of the {@link DocumentAclMembership.Builder} avoiding
         * the need to create one manually via {@link DocumentAclMembership#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DocumentAclMembership.Builder#build()} is called immediately and
         * its result is passed to {@link #denyList(DocumentAclMembership)}.
         * 
         * @param denyList
         *        a consumer that will call methods on {@link DocumentAclMembership.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #denyList(DocumentAclMembership)
         */
        default Builder denyList(Consumer<DocumentAclMembership.Builder> denyList) {
            return denyList(DocumentAclMembership.builder().applyMutation(denyList).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DocumentAclMembership allowlist;

        private DocumentAclMembership denyList;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentAcl model) {
            allowlist(model.allowlist);
            denyList(model.denyList);
        }

        public final DocumentAclMembership.Builder getAllowlist() {
            return allowlist != null ? allowlist.toBuilder() : null;
        }

        public final void setAllowlist(DocumentAclMembership.BuilderImpl allowlist) {
            this.allowlist = allowlist != null ? allowlist.build() : null;
        }

        @Override
        public final Builder allowlist(DocumentAclMembership allowlist) {
            this.allowlist = allowlist;
            return this;
        }

        public final DocumentAclMembership.Builder getDenyList() {
            return denyList != null ? denyList.toBuilder() : null;
        }

        public final void setDenyList(DocumentAclMembership.BuilderImpl denyList) {
            this.denyList = denyList != null ? denyList.build() : null;
        }

        @Override
        public final Builder denyList(DocumentAclMembership denyList) {
            this.denyList = denyList;
            return this;
        }

        @Override
        public DocumentAcl build() {
            return new DocumentAcl(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
