/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a condition in the document's ACL, specifying access rules for users and groups.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DocumentAclCondition implements SdkPojo, Serializable,
        ToCopyableBuilder<DocumentAclCondition.Builder, DocumentAclCondition> {
    private static final SdkField<String> MEMBER_RELATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("memberRelation").getter(getter(DocumentAclCondition::memberRelationAsString))
            .setter(setter(Builder::memberRelation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memberRelation").build()).build();

    private static final SdkField<List<DocumentAclUser>> USERS_FIELD = SdkField
            .<List<DocumentAclUser>> builder(MarshallingType.LIST)
            .memberName("users")
            .getter(getter(DocumentAclCondition::users))
            .setter(setter(Builder::users))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("users").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DocumentAclUser> builder(MarshallingType.SDK_POJO)
                                            .constructor(DocumentAclUser::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DocumentAclGroup>> GROUPS_FIELD = SdkField
            .<List<DocumentAclGroup>> builder(MarshallingType.LIST)
            .memberName("groups")
            .getter(getter(DocumentAclCondition::groups))
            .setter(setter(Builder::groups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DocumentAclGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(DocumentAclGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBER_RELATION_FIELD,
            USERS_FIELD, GROUPS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String memberRelation;

    private final List<DocumentAclUser> users;

    private final List<DocumentAclGroup> groups;

    private DocumentAclCondition(BuilderImpl builder) {
        this.memberRelation = builder.memberRelation;
        this.users = builder.users;
        this.groups = builder.groups;
    }

    /**
     * <p>
     * The logical relation between members in the condition, determining how multiple user or group conditions are
     * combined.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #memberRelation}
     * will return {@link MemberRelation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #memberRelationAsString}.
     * </p>
     * 
     * @return The logical relation between members in the condition, determining how multiple user or group conditions
     *         are combined.
     * @see MemberRelation
     */
    public final MemberRelation memberRelation() {
        return MemberRelation.fromValue(memberRelation);
    }

    /**
     * <p>
     * The logical relation between members in the condition, determining how multiple user or group conditions are
     * combined.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #memberRelation}
     * will return {@link MemberRelation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #memberRelationAsString}.
     * </p>
     * 
     * @return The logical relation between members in the condition, determining how multiple user or group conditions
     *         are combined.
     * @see MemberRelation
     */
    public final String memberRelationAsString() {
        return memberRelation;
    }

    /**
     * For responses, this returns true if the service returned a value for the Users property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasUsers() {
        return users != null && !(users instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of user identifiers that this condition applies to. Users listed here are subject to the access rule
     * defined by this condition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUsers} method.
     * </p>
     * 
     * @return An array of user identifiers that this condition applies to. Users listed here are subject to the access
     *         rule defined by this condition.
     */
    public final List<DocumentAclUser> users() {
        return users;
    }

    /**
     * For responses, this returns true if the service returned a value for the Groups property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasGroups() {
        return groups != null && !(groups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of group identifiers that this condition applies to. Groups listed here are subject to the access rule
     * defined by this condition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroups} method.
     * </p>
     * 
     * @return An array of group identifiers that this condition applies to. Groups listed here are subject to the
     *         access rule defined by this condition.
     */
    public final List<DocumentAclGroup> groups() {
        return groups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(memberRelationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasUsers() ? users() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasGroups() ? groups() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentAclCondition)) {
            return false;
        }
        DocumentAclCondition other = (DocumentAclCondition) obj;
        return Objects.equals(memberRelationAsString(), other.memberRelationAsString()) && hasUsers() == other.hasUsers()
                && Objects.equals(users(), other.users()) && hasGroups() == other.hasGroups()
                && Objects.equals(groups(), other.groups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DocumentAclCondition").add("MemberRelation", memberRelationAsString())
                .add("Users", hasUsers() ? users() : null).add("Groups", hasGroups() ? groups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "memberRelation":
            return Optional.ofNullable(clazz.cast(memberRelationAsString()));
        case "users":
            return Optional.ofNullable(clazz.cast(users()));
        case "groups":
            return Optional.ofNullable(clazz.cast(groups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("memberRelation", MEMBER_RELATION_FIELD);
        map.put("users", USERS_FIELD);
        map.put("groups", GROUPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DocumentAclCondition, T> g) {
        return obj -> g.apply((DocumentAclCondition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DocumentAclCondition> {
        /**
         * <p>
         * The logical relation between members in the condition, determining how multiple user or group conditions are
         * combined.
         * </p>
         * 
         * @param memberRelation
         *        The logical relation between members in the condition, determining how multiple user or group
         *        conditions are combined.
         * @see MemberRelation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MemberRelation
         */
        Builder memberRelation(String memberRelation);

        /**
         * <p>
         * The logical relation between members in the condition, determining how multiple user or group conditions are
         * combined.
         * </p>
         * 
         * @param memberRelation
         *        The logical relation between members in the condition, determining how multiple user or group
         *        conditions are combined.
         * @see MemberRelation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MemberRelation
         */
        Builder memberRelation(MemberRelation memberRelation);

        /**
         * <p>
         * An array of user identifiers that this condition applies to. Users listed here are subject to the access rule
         * defined by this condition.
         * </p>
         * 
         * @param users
         *        An array of user identifiers that this condition applies to. Users listed here are subject to the
         *        access rule defined by this condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder users(Collection<DocumentAclUser> users);

        /**
         * <p>
         * An array of user identifiers that this condition applies to. Users listed here are subject to the access rule
         * defined by this condition.
         * </p>
         * 
         * @param users
         *        An array of user identifiers that this condition applies to. Users listed here are subject to the
         *        access rule defined by this condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder users(DocumentAclUser... users);

        /**
         * <p>
         * An array of user identifiers that this condition applies to. Users listed here are subject to the access rule
         * defined by this condition.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qbusiness.model.DocumentAclUser.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.qbusiness.model.DocumentAclUser#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qbusiness.model.DocumentAclUser.Builder#build()} is called immediately
         * and its result is passed to {@link #users(List<DocumentAclUser>)}.
         * 
         * @param users
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qbusiness.model.DocumentAclUser.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #users(java.util.Collection<DocumentAclUser>)
         */
        Builder users(Consumer<DocumentAclUser.Builder>... users);

        /**
         * <p>
         * An array of group identifiers that this condition applies to. Groups listed here are subject to the access
         * rule defined by this condition.
         * </p>
         * 
         * @param groups
         *        An array of group identifiers that this condition applies to. Groups listed here are subject to the
         *        access rule defined by this condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(Collection<DocumentAclGroup> groups);

        /**
         * <p>
         * An array of group identifiers that this condition applies to. Groups listed here are subject to the access
         * rule defined by this condition.
         * </p>
         * 
         * @param groups
         *        An array of group identifiers that this condition applies to. Groups listed here are subject to the
         *        access rule defined by this condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(DocumentAclGroup... groups);

        /**
         * <p>
         * An array of group identifiers that this condition applies to. Groups listed here are subject to the access
         * rule defined by this condition.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qbusiness.model.DocumentAclGroup.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.qbusiness.model.DocumentAclGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qbusiness.model.DocumentAclGroup.Builder#build()} is called
         * immediately and its result is passed to {@link #groups(List<DocumentAclGroup>)}.
         * 
         * @param groups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qbusiness.model.DocumentAclGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groups(java.util.Collection<DocumentAclGroup>)
         */
        Builder groups(Consumer<DocumentAclGroup.Builder>... groups);
    }

    static final class BuilderImpl implements Builder {
        private String memberRelation;

        private List<DocumentAclUser> users = DefaultSdkAutoConstructList.getInstance();

        private List<DocumentAclGroup> groups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentAclCondition model) {
            memberRelation(model.memberRelation);
            users(model.users);
            groups(model.groups);
        }

        public final String getMemberRelation() {
            return memberRelation;
        }

        public final void setMemberRelation(String memberRelation) {
            this.memberRelation = memberRelation;
        }

        @Override
        public final Builder memberRelation(String memberRelation) {
            this.memberRelation = memberRelation;
            return this;
        }

        @Override
        public final Builder memberRelation(MemberRelation memberRelation) {
            this.memberRelation(memberRelation == null ? null : memberRelation.toString());
            return this;
        }

        public final List<DocumentAclUser.Builder> getUsers() {
            List<DocumentAclUser.Builder> result = DocumentAclUsersCopier.copyToBuilder(this.users);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUsers(Collection<DocumentAclUser.BuilderImpl> users) {
            this.users = DocumentAclUsersCopier.copyFromBuilder(users);
        }

        @Override
        public final Builder users(Collection<DocumentAclUser> users) {
            this.users = DocumentAclUsersCopier.copy(users);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(DocumentAclUser... users) {
            users(Arrays.asList(users));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(Consumer<DocumentAclUser.Builder>... users) {
            users(Stream.of(users).map(c -> DocumentAclUser.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DocumentAclGroup.Builder> getGroups() {
            List<DocumentAclGroup.Builder> result = DocumentAclGroupsCopier.copyToBuilder(this.groups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroups(Collection<DocumentAclGroup.BuilderImpl> groups) {
            this.groups = DocumentAclGroupsCopier.copyFromBuilder(groups);
        }

        @Override
        public final Builder groups(Collection<DocumentAclGroup> groups) {
            this.groups = DocumentAclGroupsCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(DocumentAclGroup... groups) {
            groups(Arrays.asList(groups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(Consumer<DocumentAclGroup.Builder>... groups) {
            groups(Stream.of(groups).map(c -> DocumentAclGroup.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DocumentAclCondition build() {
            return new DocumentAclCondition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
