/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The condition used for the target document attribute or metadata field when ingesting documents into Amazon Q
 * Business. You use this with <a
 * href="https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeTarget.html">
 * <code>DocumentAttributeTarget</code> </a> to apply the condition.
 * </p>
 * <p>
 * For example, you can create the 'Department' target field and have it prefill department names associated with the
 * documents based on information in the 'Source_URI' field. Set the condition that if the 'Source_URI' field contains
 * 'financial' in its URI value, then prefill the target field 'Department' with the target value 'Finance' for the
 * document.
 * </p>
 * <p>
 * Amazon Q Business can't create a target field if it has not already been created as an index field. After you create
 * your index field, you can create a document metadata field using <code>DocumentAttributeTarget</code>. Amazon Q
 * Business then will map your newly created metadata field to your index field.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DocumentAttributeCondition implements SdkPojo, Serializable,
        ToCopyableBuilder<DocumentAttributeCondition.Builder, DocumentAttributeCondition> {
    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("key")
            .getter(getter(DocumentAttributeCondition::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()).build();

    private static final SdkField<String> OPERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("operator").getter(getter(DocumentAttributeCondition::operatorAsString))
            .setter(setter(Builder::operator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operator").build()).build();

    private static final SdkField<DocumentAttributeValue> VALUE_FIELD = SdkField
            .<DocumentAttributeValue> builder(MarshallingType.SDK_POJO).memberName("value")
            .getter(getter(DocumentAttributeCondition::value)).setter(setter(Builder::value))
            .constructor(DocumentAttributeValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, OPERATOR_FIELD,
            VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String key;

    private final String operator;

    private final DocumentAttributeValue value;

    private DocumentAttributeCondition(BuilderImpl builder) {
        this.key = builder.key;
        this.operator = builder.operator;
        this.value = builder.value;
    }

    /**
     * <p>
     * The identifier of the document attribute used for the condition.
     * </p>
     * <p>
     * For example, 'Source_URI' could be an identifier for the attribute or metadata field that contains source URIs
     * associated with the documents.
     * </p>
     * <p>
     * Amazon Q Business currently doesn't support <code>_document_body</code> as an attribute key used for the
     * condition.
     * </p>
     * 
     * @return The identifier of the document attribute used for the condition.</p>
     *         <p>
     *         For example, 'Source_URI' could be an identifier for the attribute or metadata field that contains source
     *         URIs associated with the documents.
     *         </p>
     *         <p>
     *         Amazon Q Business currently doesn't support <code>_document_body</code> as an attribute key used for the
     *         condition.
     */
    public final String key() {
        return key;
    }

    /**
     * <p>
     * The identifier of the document attribute used for the condition.
     * </p>
     * <p>
     * For example, 'Source_URI' could be an identifier for the attribute or metadata field that contains source URIs
     * associated with the documents.
     * </p>
     * <p>
     * Amazon Q Business currently does not support <code>_document_body</code> as an attribute key used for the
     * condition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operator} will
     * return {@link DocumentEnrichmentConditionOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #operatorAsString}.
     * </p>
     * 
     * @return The identifier of the document attribute used for the condition.</p>
     *         <p>
     *         For example, 'Source_URI' could be an identifier for the attribute or metadata field that contains source
     *         URIs associated with the documents.
     *         </p>
     *         <p>
     *         Amazon Q Business currently does not support <code>_document_body</code> as an attribute key used for the
     *         condition.
     * @see DocumentEnrichmentConditionOperator
     */
    public final DocumentEnrichmentConditionOperator operator() {
        return DocumentEnrichmentConditionOperator.fromValue(operator);
    }

    /**
     * <p>
     * The identifier of the document attribute used for the condition.
     * </p>
     * <p>
     * For example, 'Source_URI' could be an identifier for the attribute or metadata field that contains source URIs
     * associated with the documents.
     * </p>
     * <p>
     * Amazon Q Business currently does not support <code>_document_body</code> as an attribute key used for the
     * condition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operator} will
     * return {@link DocumentEnrichmentConditionOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #operatorAsString}.
     * </p>
     * 
     * @return The identifier of the document attribute used for the condition.</p>
     *         <p>
     *         For example, 'Source_URI' could be an identifier for the attribute or metadata field that contains source
     *         URIs associated with the documents.
     *         </p>
     *         <p>
     *         Amazon Q Business currently does not support <code>_document_body</code> as an attribute key used for the
     *         condition.
     * @see DocumentEnrichmentConditionOperator
     */
    public final String operatorAsString() {
        return operator;
    }

    /**
     * Returns the value of the Value property for this object.
     * 
     * @return The value of the Value property for this object.
     */
    public final DocumentAttributeValue value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(operatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentAttributeCondition)) {
            return false;
        }
        DocumentAttributeCondition other = (DocumentAttributeCondition) obj;
        return Objects.equals(key(), other.key()) && Objects.equals(operatorAsString(), other.operatorAsString())
                && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DocumentAttributeCondition").add("Key", key()).add("Operator", operatorAsString())
                .add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "key":
            return Optional.ofNullable(clazz.cast(key()));
        case "operator":
            return Optional.ofNullable(clazz.cast(operatorAsString()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("key", KEY_FIELD);
        map.put("operator", OPERATOR_FIELD);
        map.put("value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DocumentAttributeCondition, T> g) {
        return obj -> g.apply((DocumentAttributeCondition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DocumentAttributeCondition> {
        /**
         * <p>
         * The identifier of the document attribute used for the condition.
         * </p>
         * <p>
         * For example, 'Source_URI' could be an identifier for the attribute or metadata field that contains source
         * URIs associated with the documents.
         * </p>
         * <p>
         * Amazon Q Business currently doesn't support <code>_document_body</code> as an attribute key used for the
         * condition.
         * </p>
         * 
         * @param key
         *        The identifier of the document attribute used for the condition.</p>
         *        <p>
         *        For example, 'Source_URI' could be an identifier for the attribute or metadata field that contains
         *        source URIs associated with the documents.
         *        </p>
         *        <p>
         *        Amazon Q Business currently doesn't support <code>_document_body</code> as an attribute key used for
         *        the condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * The identifier of the document attribute used for the condition.
         * </p>
         * <p>
         * For example, 'Source_URI' could be an identifier for the attribute or metadata field that contains source
         * URIs associated with the documents.
         * </p>
         * <p>
         * Amazon Q Business currently does not support <code>_document_body</code> as an attribute key used for the
         * condition.
         * </p>
         * 
         * @param operator
         *        The identifier of the document attribute used for the condition.</p>
         *        <p>
         *        For example, 'Source_URI' could be an identifier for the attribute or metadata field that contains
         *        source URIs associated with the documents.
         *        </p>
         *        <p>
         *        Amazon Q Business currently does not support <code>_document_body</code> as an attribute key used for
         *        the condition.
         * @see DocumentEnrichmentConditionOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentEnrichmentConditionOperator
         */
        Builder operator(String operator);

        /**
         * <p>
         * The identifier of the document attribute used for the condition.
         * </p>
         * <p>
         * For example, 'Source_URI' could be an identifier for the attribute or metadata field that contains source
         * URIs associated with the documents.
         * </p>
         * <p>
         * Amazon Q Business currently does not support <code>_document_body</code> as an attribute key used for the
         * condition.
         * </p>
         * 
         * @param operator
         *        The identifier of the document attribute used for the condition.</p>
         *        <p>
         *        For example, 'Source_URI' could be an identifier for the attribute or metadata field that contains
         *        source URIs associated with the documents.
         *        </p>
         *        <p>
         *        Amazon Q Business currently does not support <code>_document_body</code> as an attribute key used for
         *        the condition.
         * @see DocumentEnrichmentConditionOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentEnrichmentConditionOperator
         */
        Builder operator(DocumentEnrichmentConditionOperator operator);

        /**
         * Sets the value of the Value property for this object.
         *
         * @param value
         *        The new value for the Value property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(DocumentAttributeValue value);

        /**
         * Sets the value of the Value property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DocumentAttributeValue.Builder} avoiding
         * the need to create one manually via {@link DocumentAttributeValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DocumentAttributeValue.Builder#build()} is called immediately and
         * its result is passed to {@link #value(DocumentAttributeValue)}.
         * 
         * @param value
         *        a consumer that will call methods on {@link DocumentAttributeValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #value(DocumentAttributeValue)
         */
        default Builder value(Consumer<DocumentAttributeValue.Builder> value) {
            return value(DocumentAttributeValue.builder().applyMutation(value).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String key;

        private String operator;

        private DocumentAttributeValue value;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentAttributeCondition model) {
            key(model.key);
            operator(model.operator);
            value(model.value);
        }

        public final String getKey() {
            return key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final String getOperator() {
            return operator;
        }

        public final void setOperator(String operator) {
            this.operator = operator;
        }

        @Override
        public final Builder operator(String operator) {
            this.operator = operator;
            return this;
        }

        @Override
        public final Builder operator(DocumentEnrichmentConditionOperator operator) {
            this.operator(operator == null ? null : operator.toString());
            return this;
        }

        public final DocumentAttributeValue.Builder getValue() {
            return value != null ? value.toBuilder() : null;
        }

        public final void setValue(DocumentAttributeValue.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public final Builder value(DocumentAttributeValue value) {
            this.value = value;
            return this;
        }

        @Override
        public DocumentAttributeCondition build() {
            return new DocumentAttributeCondition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
