/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetChatControlsConfigurationResponse extends QBusinessResponse implements
        ToCopyableBuilder<GetChatControlsConfigurationResponse.Builder, GetChatControlsConfigurationResponse> {
    private static final SdkField<String> RESPONSE_SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("responseScope").getter(getter(GetChatControlsConfigurationResponse::responseScopeAsString))
            .setter(setter(Builder::responseScope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseScope").build()).build();

    private static final SdkField<AppliedOrchestrationConfiguration> ORCHESTRATION_CONFIGURATION_FIELD = SdkField
            .<AppliedOrchestrationConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("orchestrationConfiguration")
            .getter(getter(GetChatControlsConfigurationResponse::orchestrationConfiguration))
            .setter(setter(Builder::orchestrationConfiguration))
            .constructor(AppliedOrchestrationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orchestrationConfiguration").build())
            .build();

    private static final SdkField<BlockedPhrasesConfiguration> BLOCKED_PHRASES_FIELD = SdkField
            .<BlockedPhrasesConfiguration> builder(MarshallingType.SDK_POJO).memberName("blockedPhrases")
            .getter(getter(GetChatControlsConfigurationResponse::blockedPhrases)).setter(setter(Builder::blockedPhrases))
            .constructor(BlockedPhrasesConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockedPhrases").build()).build();

    private static final SdkField<List<TopicConfiguration>> TOPIC_CONFIGURATIONS_FIELD = SdkField
            .<List<TopicConfiguration>> builder(MarshallingType.LIST)
            .memberName("topicConfigurations")
            .getter(getter(GetChatControlsConfigurationResponse::topicConfigurations))
            .setter(setter(Builder::topicConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topicConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TopicConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(TopicConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AppliedCreatorModeConfiguration> CREATOR_MODE_CONFIGURATION_FIELD = SdkField
            .<AppliedCreatorModeConfiguration> builder(MarshallingType.SDK_POJO).memberName("creatorModeConfiguration")
            .getter(getter(GetChatControlsConfigurationResponse::creatorModeConfiguration))
            .setter(setter(Builder::creatorModeConfiguration)).constructor(AppliedCreatorModeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creatorModeConfiguration").build())
            .build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetChatControlsConfigurationResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<HallucinationReductionConfiguration> HALLUCINATION_REDUCTION_CONFIGURATION_FIELD = SdkField
            .<HallucinationReductionConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("hallucinationReductionConfiguration")
            .getter(getter(GetChatControlsConfigurationResponse::hallucinationReductionConfiguration))
            .setter(setter(Builder::hallucinationReductionConfiguration))
            .constructor(HallucinationReductionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("hallucinationReductionConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESPONSE_SCOPE_FIELD,
            ORCHESTRATION_CONFIGURATION_FIELD, BLOCKED_PHRASES_FIELD, TOPIC_CONFIGURATIONS_FIELD,
            CREATOR_MODE_CONFIGURATION_FIELD, NEXT_TOKEN_FIELD, HALLUCINATION_REDUCTION_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String responseScope;

    private final AppliedOrchestrationConfiguration orchestrationConfiguration;

    private final BlockedPhrasesConfiguration blockedPhrases;

    private final List<TopicConfiguration> topicConfigurations;

    private final AppliedCreatorModeConfiguration creatorModeConfiguration;

    private final String nextToken;

    private final HallucinationReductionConfiguration hallucinationReductionConfiguration;

    private GetChatControlsConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.responseScope = builder.responseScope;
        this.orchestrationConfiguration = builder.orchestrationConfiguration;
        this.blockedPhrases = builder.blockedPhrases;
        this.topicConfigurations = builder.topicConfigurations;
        this.creatorModeConfiguration = builder.creatorModeConfiguration;
        this.nextToken = builder.nextToken;
        this.hallucinationReductionConfiguration = builder.hallucinationReductionConfiguration;
    }

    /**
     * <p>
     * The response scope configured for a Amazon Q Business application. This determines whether your application uses
     * its retrieval augmented generation (RAG) system to generate answers only from your enterprise data, or also uses
     * the large language models (LLM) knowledge to respons to end user questions in chat.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #responseScope}
     * will return {@link ResponseScope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #responseScopeAsString}.
     * </p>
     * 
     * @return The response scope configured for a Amazon Q Business application. This determines whether your
     *         application uses its retrieval augmented generation (RAG) system to generate answers only from your
     *         enterprise data, or also uses the large language models (LLM) knowledge to respons to end user questions
     *         in chat.
     * @see ResponseScope
     */
    public final ResponseScope responseScope() {
        return ResponseScope.fromValue(responseScope);
    }

    /**
     * <p>
     * The response scope configured for a Amazon Q Business application. This determines whether your application uses
     * its retrieval augmented generation (RAG) system to generate answers only from your enterprise data, or also uses
     * the large language models (LLM) knowledge to respons to end user questions in chat.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #responseScope}
     * will return {@link ResponseScope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #responseScopeAsString}.
     * </p>
     * 
     * @return The response scope configured for a Amazon Q Business application. This determines whether your
     *         application uses its retrieval augmented generation (RAG) system to generate answers only from your
     *         enterprise data, or also uses the large language models (LLM) knowledge to respons to end user questions
     *         in chat.
     * @see ResponseScope
     */
    public final String responseScopeAsString() {
        return responseScope;
    }

    /**
     * <p>
     * The chat response orchestration settings for your application.
     * </p>
     * <note>
     * <p>
     * Chat orchestration is optimized to work for English language content. For more details on language support in
     * Amazon Q Business, see <a
     * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/supported-languages.html">Supported languages</a>.
     * </p>
     * </note>
     * 
     * @return The chat response orchestration settings for your application.</p> <note>
     *         <p>
     *         Chat orchestration is optimized to work for English language content. For more details on language
     *         support in Amazon Q Business, see <a
     *         href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/supported-languages.html">Supported
     *         languages</a>.
     *         </p>
     */
    public final AppliedOrchestrationConfiguration orchestrationConfiguration() {
        return orchestrationConfiguration;
    }

    /**
     * <p>
     * The phrases blocked from chat by your chat control configuration.
     * </p>
     * 
     * @return The phrases blocked from chat by your chat control configuration.
     */
    public final BlockedPhrasesConfiguration blockedPhrases() {
        return blockedPhrases;
    }

    /**
     * For responses, this returns true if the service returned a value for the TopicConfigurations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTopicConfigurations() {
        return topicConfigurations != null && !(topicConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The topic specific controls configured for a Amazon Q Business application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTopicConfigurations} method.
     * </p>
     * 
     * @return The topic specific controls configured for a Amazon Q Business application.
     */
    public final List<TopicConfiguration> topicConfigurations() {
        return topicConfigurations;
    }

    /**
     * <p>
     * The configuration details for <code>CREATOR_MODE</code>.
     * </p>
     * 
     * @return The configuration details for <code>CREATOR_MODE</code>.
     */
    public final AppliedCreatorModeConfiguration creatorModeConfiguration() {
        return creatorModeConfiguration;
    }

    /**
     * <p>
     * If the <code>maxResults</code> response was incomplete because there is more data to retrieve, Amazon Q Business
     * returns a pagination token in the response. You can use this pagination token to retrieve the next set of Amazon
     * Q Business chat controls configured.
     * </p>
     * 
     * @return If the <code>maxResults</code> response was incomplete because there is more data to retrieve, Amazon Q
     *         Business returns a pagination token in the response. You can use this pagination token to retrieve the
     *         next set of Amazon Q Business chat controls configured.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The hallucination reduction settings for your application.
     * </p>
     * 
     * @return The hallucination reduction settings for your application.
     */
    public final HallucinationReductionConfiguration hallucinationReductionConfiguration() {
        return hallucinationReductionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(responseScopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(orchestrationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(blockedPhrases());
        hashCode = 31 * hashCode + Objects.hashCode(hasTopicConfigurations() ? topicConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(creatorModeConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hallucinationReductionConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetChatControlsConfigurationResponse)) {
            return false;
        }
        GetChatControlsConfigurationResponse other = (GetChatControlsConfigurationResponse) obj;
        return Objects.equals(responseScopeAsString(), other.responseScopeAsString())
                && Objects.equals(orchestrationConfiguration(), other.orchestrationConfiguration())
                && Objects.equals(blockedPhrases(), other.blockedPhrases())
                && hasTopicConfigurations() == other.hasTopicConfigurations()
                && Objects.equals(topicConfigurations(), other.topicConfigurations())
                && Objects.equals(creatorModeConfiguration(), other.creatorModeConfiguration())
                && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(hallucinationReductionConfiguration(), other.hallucinationReductionConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetChatControlsConfigurationResponse").add("ResponseScope", responseScopeAsString())
                .add("OrchestrationConfiguration", orchestrationConfiguration()).add("BlockedPhrases", blockedPhrases())
                .add("TopicConfigurations", hasTopicConfigurations() ? topicConfigurations() : null)
                .add("CreatorModeConfiguration", creatorModeConfiguration()).add("NextToken", nextToken())
                .add("HallucinationReductionConfiguration", hallucinationReductionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "responseScope":
            return Optional.ofNullable(clazz.cast(responseScopeAsString()));
        case "orchestrationConfiguration":
            return Optional.ofNullable(clazz.cast(orchestrationConfiguration()));
        case "blockedPhrases":
            return Optional.ofNullable(clazz.cast(blockedPhrases()));
        case "topicConfigurations":
            return Optional.ofNullable(clazz.cast(topicConfigurations()));
        case "creatorModeConfiguration":
            return Optional.ofNullable(clazz.cast(creatorModeConfiguration()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "hallucinationReductionConfiguration":
            return Optional.ofNullable(clazz.cast(hallucinationReductionConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("responseScope", RESPONSE_SCOPE_FIELD);
        map.put("orchestrationConfiguration", ORCHESTRATION_CONFIGURATION_FIELD);
        map.put("blockedPhrases", BLOCKED_PHRASES_FIELD);
        map.put("topicConfigurations", TOPIC_CONFIGURATIONS_FIELD);
        map.put("creatorModeConfiguration", CREATOR_MODE_CONFIGURATION_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("hallucinationReductionConfiguration", HALLUCINATION_REDUCTION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetChatControlsConfigurationResponse, T> g) {
        return obj -> g.apply((GetChatControlsConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QBusinessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetChatControlsConfigurationResponse> {
        /**
         * <p>
         * The response scope configured for a Amazon Q Business application. This determines whether your application
         * uses its retrieval augmented generation (RAG) system to generate answers only from your enterprise data, or
         * also uses the large language models (LLM) knowledge to respons to end user questions in chat.
         * </p>
         * 
         * @param responseScope
         *        The response scope configured for a Amazon Q Business application. This determines whether your
         *        application uses its retrieval augmented generation (RAG) system to generate answers only from your
         *        enterprise data, or also uses the large language models (LLM) knowledge to respons to end user
         *        questions in chat.
         * @see ResponseScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResponseScope
         */
        Builder responseScope(String responseScope);

        /**
         * <p>
         * The response scope configured for a Amazon Q Business application. This determines whether your application
         * uses its retrieval augmented generation (RAG) system to generate answers only from your enterprise data, or
         * also uses the large language models (LLM) knowledge to respons to end user questions in chat.
         * </p>
         * 
         * @param responseScope
         *        The response scope configured for a Amazon Q Business application. This determines whether your
         *        application uses its retrieval augmented generation (RAG) system to generate answers only from your
         *        enterprise data, or also uses the large language models (LLM) knowledge to respons to end user
         *        questions in chat.
         * @see ResponseScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResponseScope
         */
        Builder responseScope(ResponseScope responseScope);

        /**
         * <p>
         * The chat response orchestration settings for your application.
         * </p>
         * <note>
         * <p>
         * Chat orchestration is optimized to work for English language content. For more details on language support in
         * Amazon Q Business, see <a
         * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/supported-languages.html">Supported
         * languages</a>.
         * </p>
         * </note>
         * 
         * @param orchestrationConfiguration
         *        The chat response orchestration settings for your application.</p> <note>
         *        <p>
         *        Chat orchestration is optimized to work for English language content. For more details on language
         *        support in Amazon Q Business, see <a
         *        href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/supported-languages.html">Supported
         *        languages</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orchestrationConfiguration(AppliedOrchestrationConfiguration orchestrationConfiguration);

        /**
         * <p>
         * The chat response orchestration settings for your application.
         * </p>
         * <note>
         * <p>
         * Chat orchestration is optimized to work for English language content. For more details on language support in
         * Amazon Q Business, see <a
         * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/supported-languages.html">Supported
         * languages</a>.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link AppliedOrchestrationConfiguration.Builder} avoiding the need to create one manually via
         * {@link AppliedOrchestrationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AppliedOrchestrationConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #orchestrationConfiguration(AppliedOrchestrationConfiguration)}.
         * 
         * @param orchestrationConfiguration
         *        a consumer that will call methods on {@link AppliedOrchestrationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #orchestrationConfiguration(AppliedOrchestrationConfiguration)
         */
        default Builder orchestrationConfiguration(Consumer<AppliedOrchestrationConfiguration.Builder> orchestrationConfiguration) {
            return orchestrationConfiguration(AppliedOrchestrationConfiguration.builder()
                    .applyMutation(orchestrationConfiguration).build());
        }

        /**
         * <p>
         * The phrases blocked from chat by your chat control configuration.
         * </p>
         * 
         * @param blockedPhrases
         *        The phrases blocked from chat by your chat control configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockedPhrases(BlockedPhrasesConfiguration blockedPhrases);

        /**
         * <p>
         * The phrases blocked from chat by your chat control configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link BlockedPhrasesConfiguration.Builder}
         * avoiding the need to create one manually via {@link BlockedPhrasesConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BlockedPhrasesConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #blockedPhrases(BlockedPhrasesConfiguration)}.
         * 
         * @param blockedPhrases
         *        a consumer that will call methods on {@link BlockedPhrasesConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blockedPhrases(BlockedPhrasesConfiguration)
         */
        default Builder blockedPhrases(Consumer<BlockedPhrasesConfiguration.Builder> blockedPhrases) {
            return blockedPhrases(BlockedPhrasesConfiguration.builder().applyMutation(blockedPhrases).build());
        }

        /**
         * <p>
         * The topic specific controls configured for a Amazon Q Business application.
         * </p>
         * 
         * @param topicConfigurations
         *        The topic specific controls configured for a Amazon Q Business application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicConfigurations(Collection<TopicConfiguration> topicConfigurations);

        /**
         * <p>
         * The topic specific controls configured for a Amazon Q Business application.
         * </p>
         * 
         * @param topicConfigurations
         *        The topic specific controls configured for a Amazon Q Business application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicConfigurations(TopicConfiguration... topicConfigurations);

        /**
         * <p>
         * The topic specific controls configured for a Amazon Q Business application.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qbusiness.model.TopicConfiguration.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.qbusiness.model.TopicConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qbusiness.model.TopicConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #topicConfigurations(List<TopicConfiguration>)}.
         * 
         * @param topicConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qbusiness.model.TopicConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #topicConfigurations(java.util.Collection<TopicConfiguration>)
         */
        Builder topicConfigurations(Consumer<TopicConfiguration.Builder>... topicConfigurations);

        /**
         * <p>
         * The configuration details for <code>CREATOR_MODE</code>.
         * </p>
         * 
         * @param creatorModeConfiguration
         *        The configuration details for <code>CREATOR_MODE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creatorModeConfiguration(AppliedCreatorModeConfiguration creatorModeConfiguration);

        /**
         * <p>
         * The configuration details for <code>CREATOR_MODE</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link AppliedCreatorModeConfiguration.Builder}
         * avoiding the need to create one manually via {@link AppliedCreatorModeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AppliedCreatorModeConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #creatorModeConfiguration(AppliedCreatorModeConfiguration)}.
         * 
         * @param creatorModeConfiguration
         *        a consumer that will call methods on {@link AppliedCreatorModeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #creatorModeConfiguration(AppliedCreatorModeConfiguration)
         */
        default Builder creatorModeConfiguration(Consumer<AppliedCreatorModeConfiguration.Builder> creatorModeConfiguration) {
            return creatorModeConfiguration(AppliedCreatorModeConfiguration.builder().applyMutation(creatorModeConfiguration)
                    .build());
        }

        /**
         * <p>
         * If the <code>maxResults</code> response was incomplete because there is more data to retrieve, Amazon Q
         * Business returns a pagination token in the response. You can use this pagination token to retrieve the next
         * set of Amazon Q Business chat controls configured.
         * </p>
         * 
         * @param nextToken
         *        If the <code>maxResults</code> response was incomplete because there is more data to retrieve, Amazon
         *        Q Business returns a pagination token in the response. You can use this pagination token to retrieve
         *        the next set of Amazon Q Business chat controls configured.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The hallucination reduction settings for your application.
         * </p>
         * 
         * @param hallucinationReductionConfiguration
         *        The hallucination reduction settings for your application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hallucinationReductionConfiguration(HallucinationReductionConfiguration hallucinationReductionConfiguration);

        /**
         * <p>
         * The hallucination reduction settings for your application.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link HallucinationReductionConfiguration.Builder} avoiding the need to create one manually via
         * {@link HallucinationReductionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HallucinationReductionConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #hallucinationReductionConfiguration(HallucinationReductionConfiguration)}.
         * 
         * @param hallucinationReductionConfiguration
         *        a consumer that will call methods on {@link HallucinationReductionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hallucinationReductionConfiguration(HallucinationReductionConfiguration)
         */
        default Builder hallucinationReductionConfiguration(
                Consumer<HallucinationReductionConfiguration.Builder> hallucinationReductionConfiguration) {
            return hallucinationReductionConfiguration(HallucinationReductionConfiguration.builder()
                    .applyMutation(hallucinationReductionConfiguration).build());
        }
    }

    static final class BuilderImpl extends QBusinessResponse.BuilderImpl implements Builder {
        private String responseScope;

        private AppliedOrchestrationConfiguration orchestrationConfiguration;

        private BlockedPhrasesConfiguration blockedPhrases;

        private List<TopicConfiguration> topicConfigurations = DefaultSdkAutoConstructList.getInstance();

        private AppliedCreatorModeConfiguration creatorModeConfiguration;

        private String nextToken;

        private HallucinationReductionConfiguration hallucinationReductionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetChatControlsConfigurationResponse model) {
            super(model);
            responseScope(model.responseScope);
            orchestrationConfiguration(model.orchestrationConfiguration);
            blockedPhrases(model.blockedPhrases);
            topicConfigurations(model.topicConfigurations);
            creatorModeConfiguration(model.creatorModeConfiguration);
            nextToken(model.nextToken);
            hallucinationReductionConfiguration(model.hallucinationReductionConfiguration);
        }

        public final String getResponseScope() {
            return responseScope;
        }

        public final void setResponseScope(String responseScope) {
            this.responseScope = responseScope;
        }

        @Override
        public final Builder responseScope(String responseScope) {
            this.responseScope = responseScope;
            return this;
        }

        @Override
        public final Builder responseScope(ResponseScope responseScope) {
            this.responseScope(responseScope == null ? null : responseScope.toString());
            return this;
        }

        public final AppliedOrchestrationConfiguration.Builder getOrchestrationConfiguration() {
            return orchestrationConfiguration != null ? orchestrationConfiguration.toBuilder() : null;
        }

        public final void setOrchestrationConfiguration(AppliedOrchestrationConfiguration.BuilderImpl orchestrationConfiguration) {
            this.orchestrationConfiguration = orchestrationConfiguration != null ? orchestrationConfiguration.build() : null;
        }

        @Override
        public final Builder orchestrationConfiguration(AppliedOrchestrationConfiguration orchestrationConfiguration) {
            this.orchestrationConfiguration = orchestrationConfiguration;
            return this;
        }

        public final BlockedPhrasesConfiguration.Builder getBlockedPhrases() {
            return blockedPhrases != null ? blockedPhrases.toBuilder() : null;
        }

        public final void setBlockedPhrases(BlockedPhrasesConfiguration.BuilderImpl blockedPhrases) {
            this.blockedPhrases = blockedPhrases != null ? blockedPhrases.build() : null;
        }

        @Override
        public final Builder blockedPhrases(BlockedPhrasesConfiguration blockedPhrases) {
            this.blockedPhrases = blockedPhrases;
            return this;
        }

        public final List<TopicConfiguration.Builder> getTopicConfigurations() {
            List<TopicConfiguration.Builder> result = TopicConfigurationsCopier.copyToBuilder(this.topicConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTopicConfigurations(Collection<TopicConfiguration.BuilderImpl> topicConfigurations) {
            this.topicConfigurations = TopicConfigurationsCopier.copyFromBuilder(topicConfigurations);
        }

        @Override
        public final Builder topicConfigurations(Collection<TopicConfiguration> topicConfigurations) {
            this.topicConfigurations = TopicConfigurationsCopier.copy(topicConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topicConfigurations(TopicConfiguration... topicConfigurations) {
            topicConfigurations(Arrays.asList(topicConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topicConfigurations(Consumer<TopicConfiguration.Builder>... topicConfigurations) {
            topicConfigurations(Stream.of(topicConfigurations).map(c -> TopicConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final AppliedCreatorModeConfiguration.Builder getCreatorModeConfiguration() {
            return creatorModeConfiguration != null ? creatorModeConfiguration.toBuilder() : null;
        }

        public final void setCreatorModeConfiguration(AppliedCreatorModeConfiguration.BuilderImpl creatorModeConfiguration) {
            this.creatorModeConfiguration = creatorModeConfiguration != null ? creatorModeConfiguration.build() : null;
        }

        @Override
        public final Builder creatorModeConfiguration(AppliedCreatorModeConfiguration creatorModeConfiguration) {
            this.creatorModeConfiguration = creatorModeConfiguration;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final HallucinationReductionConfiguration.Builder getHallucinationReductionConfiguration() {
            return hallucinationReductionConfiguration != null ? hallucinationReductionConfiguration.toBuilder() : null;
        }

        public final void setHallucinationReductionConfiguration(
                HallucinationReductionConfiguration.BuilderImpl hallucinationReductionConfiguration) {
            this.hallucinationReductionConfiguration = hallucinationReductionConfiguration != null ? hallucinationReductionConfiguration
                    .build() : null;
        }

        @Override
        public final Builder hallucinationReductionConfiguration(
                HallucinationReductionConfiguration hallucinationReductionConfiguration) {
            this.hallucinationReductionConfiguration = hallucinationReductionConfiguration;
            return this;
        }

        @Override
        public GetChatControlsConfigurationResponse build() {
            return new GetChatControlsConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
