/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the configuration information for invoking a Lambda function in Lambda to alter document metadata and
 * content when ingesting documents into Amazon Q Business.
 * </p>
 * <p>
 * You can configure your Lambda function using the <code>PreExtractionHookConfiguration</code> parameter if you want to
 * apply advanced alterations on the original or raw documents.
 * </p>
 * <p>
 * If you want to apply advanced alterations on the Amazon Q Business structured documents, you must configure your
 * Lambda function using <code>PostExtractionHookConfiguration</code>.
 * </p>
 * <p>
 * You can only invoke one Lambda function. However, this function can invoke other functions it requires.
 * </p>
 * <p>
 * For more information, see <a
 * href="https://docs.aws.amazon.com/amazonq/latest/business-use-dg/custom-document-enrichment.html">Custom document
 * enrichment</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HookConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<HookConfiguration.Builder, HookConfiguration> {
    private static final SdkField<DocumentAttributeCondition> INVOCATION_CONDITION_FIELD = SdkField
            .<DocumentAttributeCondition> builder(MarshallingType.SDK_POJO).memberName("invocationCondition")
            .getter(getter(HookConfiguration::invocationCondition)).setter(setter(Builder::invocationCondition))
            .constructor(DocumentAttributeCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invocationCondition").build())
            .build();

    private static final SdkField<String> LAMBDA_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lambdaArn").getter(getter(HookConfiguration::lambdaArn)).setter(setter(Builder::lambdaArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaArn").build()).build();

    private static final SdkField<String> S3_BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("s3BucketName").getter(getter(HookConfiguration::s3BucketName)).setter(setter(Builder::s3BucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3BucketName").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(HookConfiguration::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVOCATION_CONDITION_FIELD,
            LAMBDA_ARN_FIELD, S3_BUCKET_NAME_FIELD, ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DocumentAttributeCondition invocationCondition;

    private final String lambdaArn;

    private final String s3BucketName;

    private final String roleArn;

    private HookConfiguration(BuilderImpl builder) {
        this.invocationCondition = builder.invocationCondition;
        this.lambdaArn = builder.lambdaArn;
        this.s3BucketName = builder.s3BucketName;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * The condition used for when a Lambda function should be invoked.
     * </p>
     * <p>
     * For example, you can specify a condition that if there are empty date-time values, then Amazon Q Business should
     * invoke a function that inserts the current date-time.
     * </p>
     * 
     * @return The condition used for when a Lambda function should be invoked.</p>
     *         <p>
     *         For example, you can specify a condition that if there are empty date-time values, then Amazon Q Business
     *         should invoke a function that inserts the current date-time.
     */
    public final DocumentAttributeCondition invocationCondition() {
        return invocationCondition;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Lambda function during ingestion. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/cde-lambda-operations.html">Using Lambda functions
     * for Amazon Q Business document enrichment</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Lambda function during ingestion. For more information, see <a
     *         href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/cde-lambda-operations.html">Using Lambda
     *         functions for Amazon Q Business document enrichment</a>.
     */
    public final String lambdaArn() {
        return lambdaArn;
    }

    /**
     * <p>
     * Stores the original, raw documents or the structured, parsed documents before and after altering them. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/amazonq/latest/business-use-dg/cde-lambda-operations.html#cde-lambda-operations-data-contracts"
     * >Data contracts for Lambda functions</a>.
     * </p>
     * 
     * @return Stores the original, raw documents or the structured, parsed documents before and after altering them.
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/amazonq/latest/business-use-dg/cde-lambda-operations.html#cde-lambda-operations-data-contracts"
     *         >Data contracts for Lambda functions</a>.
     */
    public final String s3BucketName() {
        return s3BucketName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a role with permission to run <code>PreExtractionHookConfiguration</code> and
     * <code>PostExtractionHookConfiguration</code> for altering document metadata and content during the document
     * ingestion process.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a role with permission to run
     *         <code>PreExtractionHookConfiguration</code> and <code>PostExtractionHookConfiguration</code> for altering
     *         document metadata and content during the document ingestion process.
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(invocationCondition());
        hashCode = 31 * hashCode + Objects.hashCode(lambdaArn());
        hashCode = 31 * hashCode + Objects.hashCode(s3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HookConfiguration)) {
            return false;
        }
        HookConfiguration other = (HookConfiguration) obj;
        return Objects.equals(invocationCondition(), other.invocationCondition())
                && Objects.equals(lambdaArn(), other.lambdaArn()) && Objects.equals(s3BucketName(), other.s3BucketName())
                && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HookConfiguration").add("InvocationCondition", invocationCondition())
                .add("LambdaArn", lambdaArn()).add("S3BucketName", s3BucketName()).add("RoleArn", roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "invocationCondition":
            return Optional.ofNullable(clazz.cast(invocationCondition()));
        case "lambdaArn":
            return Optional.ofNullable(clazz.cast(lambdaArn()));
        case "s3BucketName":
            return Optional.ofNullable(clazz.cast(s3BucketName()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("invocationCondition", INVOCATION_CONDITION_FIELD);
        map.put("lambdaArn", LAMBDA_ARN_FIELD);
        map.put("s3BucketName", S3_BUCKET_NAME_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HookConfiguration, T> g) {
        return obj -> g.apply((HookConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HookConfiguration> {
        /**
         * <p>
         * The condition used for when a Lambda function should be invoked.
         * </p>
         * <p>
         * For example, you can specify a condition that if there are empty date-time values, then Amazon Q Business
         * should invoke a function that inserts the current date-time.
         * </p>
         * 
         * @param invocationCondition
         *        The condition used for when a Lambda function should be invoked.</p>
         *        <p>
         *        For example, you can specify a condition that if there are empty date-time values, then Amazon Q
         *        Business should invoke a function that inserts the current date-time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invocationCondition(DocumentAttributeCondition invocationCondition);

        /**
         * <p>
         * The condition used for when a Lambda function should be invoked.
         * </p>
         * <p>
         * For example, you can specify a condition that if there are empty date-time values, then Amazon Q Business
         * should invoke a function that inserts the current date-time.
         * </p>
         * This is a convenience method that creates an instance of the {@link DocumentAttributeCondition.Builder}
         * avoiding the need to create one manually via {@link DocumentAttributeCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DocumentAttributeCondition.Builder#build()} is called immediately
         * and its result is passed to {@link #invocationCondition(DocumentAttributeCondition)}.
         * 
         * @param invocationCondition
         *        a consumer that will call methods on {@link DocumentAttributeCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #invocationCondition(DocumentAttributeCondition)
         */
        default Builder invocationCondition(Consumer<DocumentAttributeCondition.Builder> invocationCondition) {
            return invocationCondition(DocumentAttributeCondition.builder().applyMutation(invocationCondition).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Lambda function during ingestion. For more information, see <a
         * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/cde-lambda-operations.html">Using Lambda
         * functions for Amazon Q Business document enrichment</a>.
         * </p>
         * 
         * @param lambdaArn
         *        The Amazon Resource Name (ARN) of the Lambda function during ingestion. For more information, see <a
         *        href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/cde-lambda-operations.html">Using Lambda
         *        functions for Amazon Q Business document enrichment</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaArn(String lambdaArn);

        /**
         * <p>
         * Stores the original, raw documents or the structured, parsed documents before and after altering them. For
         * more information, see <a href=
         * "https://docs.aws.amazon.com/amazonq/latest/business-use-dg/cde-lambda-operations.html#cde-lambda-operations-data-contracts"
         * >Data contracts for Lambda functions</a>.
         * </p>
         * 
         * @param s3BucketName
         *        Stores the original, raw documents or the structured, parsed documents before and after altering them.
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/amazonq/latest/business-use-dg/cde-lambda-operations.html#cde-lambda-operations-data-contracts"
         *        >Data contracts for Lambda functions</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketName(String s3BucketName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a role with permission to run <code>PreExtractionHookConfiguration</code>
         * and <code>PostExtractionHookConfiguration</code> for altering document metadata and content during the
         * document ingestion process.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of a role with permission to run
         *        <code>PreExtractionHookConfiguration</code> and <code>PostExtractionHookConfiguration</code> for
         *        altering document metadata and content during the document ingestion process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);
    }

    static final class BuilderImpl implements Builder {
        private DocumentAttributeCondition invocationCondition;

        private String lambdaArn;

        private String s3BucketName;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(HookConfiguration model) {
            invocationCondition(model.invocationCondition);
            lambdaArn(model.lambdaArn);
            s3BucketName(model.s3BucketName);
            roleArn(model.roleArn);
        }

        public final DocumentAttributeCondition.Builder getInvocationCondition() {
            return invocationCondition != null ? invocationCondition.toBuilder() : null;
        }

        public final void setInvocationCondition(DocumentAttributeCondition.BuilderImpl invocationCondition) {
            this.invocationCondition = invocationCondition != null ? invocationCondition.build() : null;
        }

        @Override
        public final Builder invocationCondition(DocumentAttributeCondition invocationCondition) {
            this.invocationCondition = invocationCondition;
            return this;
        }

        public final String getLambdaArn() {
            return lambdaArn;
        }

        public final void setLambdaArn(String lambdaArn) {
            this.lambdaArn = lambdaArn;
        }

        @Override
        public final Builder lambdaArn(String lambdaArn) {
            this.lambdaArn = lambdaArn;
            return this;
        }

        public final String getS3BucketName() {
            return s3BucketName;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        @Override
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public HookConfiguration build() {
            return new HookConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
