/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration information required to enable chat orchestration for your Amazon Q Business application.
 * </p>
 * <note>
 * <p>
 * Chat orchestration is optimized to work for English language content. For more details on language support in Amazon
 * Q Business, see <a href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/supported-languages.html">Supported
 * languages</a>.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OrchestrationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<OrchestrationConfiguration.Builder, OrchestrationConfiguration> {
    private static final SdkField<String> CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("control")
            .getter(getter(OrchestrationConfiguration::controlAsString)).setter(setter(Builder::control))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("control").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTROL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String control;

    private OrchestrationConfiguration(BuilderImpl builder) {
        this.control = builder.control;
    }

    /**
     * <p>
     * Status information about whether chat orchestration is activated or deactivated for your Amazon Q Business
     * application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #control} will
     * return {@link OrchestrationControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #controlAsString}.
     * </p>
     * 
     * @return Status information about whether chat orchestration is activated or deactivated for your Amazon Q
     *         Business application.
     * @see OrchestrationControl
     */
    public final OrchestrationControl control() {
        return OrchestrationControl.fromValue(control);
    }

    /**
     * <p>
     * Status information about whether chat orchestration is activated or deactivated for your Amazon Q Business
     * application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #control} will
     * return {@link OrchestrationControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #controlAsString}.
     * </p>
     * 
     * @return Status information about whether chat orchestration is activated or deactivated for your Amazon Q
     *         Business application.
     * @see OrchestrationControl
     */
    public final String controlAsString() {
        return control;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(controlAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrchestrationConfiguration)) {
            return false;
        }
        OrchestrationConfiguration other = (OrchestrationConfiguration) obj;
        return Objects.equals(controlAsString(), other.controlAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OrchestrationConfiguration").add("Control", controlAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "control":
            return Optional.ofNullable(clazz.cast(controlAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("control", CONTROL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OrchestrationConfiguration, T> g) {
        return obj -> g.apply((OrchestrationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OrchestrationConfiguration> {
        /**
         * <p>
         * Status information about whether chat orchestration is activated or deactivated for your Amazon Q Business
         * application.
         * </p>
         * 
         * @param control
         *        Status information about whether chat orchestration is activated or deactivated for your Amazon Q
         *        Business application.
         * @see OrchestrationControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrchestrationControl
         */
        Builder control(String control);

        /**
         * <p>
         * Status information about whether chat orchestration is activated or deactivated for your Amazon Q Business
         * application.
         * </p>
         * 
         * @param control
         *        Status information about whether chat orchestration is activated or deactivated for your Amazon Q
         *        Business application.
         * @see OrchestrationControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrchestrationControl
         */
        Builder control(OrchestrationControl control);
    }

    static final class BuilderImpl implements Builder {
        private String control;

        private BuilderImpl() {
        }

        private BuilderImpl(OrchestrationConfiguration model) {
            control(model.control);
        }

        public final String getControl() {
            return control;
        }

        public final void setControl(String control) {
            this.control = control;
        }

        @Override
        public final Builder control(String control) {
            this.control = control;
            return this;
        }

        @Override
        public final Builder control(OrchestrationControl control) {
            this.control(control == null ? null : control.toString());
            return this;
        }

        @Override
        public OrchestrationConfiguration build() {
            return new OrchestrationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
