/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines a condition that restricts when a permission is effective. Conditions allow you to control access based on
 * specific attributes of the request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PermissionCondition implements SdkPojo, Serializable,
        ToCopyableBuilder<PermissionCondition.Builder, PermissionCondition> {
    private static final SdkField<String> CONDITION_OPERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("conditionOperator").getter(getter(PermissionCondition::conditionOperatorAsString))
            .setter(setter(Builder::conditionOperator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conditionOperator").build()).build();

    private static final SdkField<String> CONDITION_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("conditionKey").getter(getter(PermissionCondition::conditionKey)).setter(setter(Builder::conditionKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conditionKey").build()).build();

    private static final SdkField<List<String>> CONDITION_VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("conditionValues")
            .getter(getter(PermissionCondition::conditionValues))
            .setter(setter(Builder::conditionValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conditionValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONDITION_OPERATOR_FIELD,
            CONDITION_KEY_FIELD, CONDITION_VALUES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String conditionOperator;

    private final String conditionKey;

    private final List<String> conditionValues;

    private PermissionCondition(BuilderImpl builder) {
        this.conditionOperator = builder.conditionOperator;
        this.conditionKey = builder.conditionKey;
        this.conditionValues = builder.conditionValues;
    }

    /**
     * <p>
     * The operator to use for the condition evaluation. This determines how the condition values are compared.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #conditionOperator}
     * will return {@link PermissionConditionOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #conditionOperatorAsString}.
     * </p>
     * 
     * @return The operator to use for the condition evaluation. This determines how the condition values are compared.
     * @see PermissionConditionOperator
     */
    public final PermissionConditionOperator conditionOperator() {
        return PermissionConditionOperator.fromValue(conditionOperator);
    }

    /**
     * <p>
     * The operator to use for the condition evaluation. This determines how the condition values are compared.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #conditionOperator}
     * will return {@link PermissionConditionOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #conditionOperatorAsString}.
     * </p>
     * 
     * @return The operator to use for the condition evaluation. This determines how the condition values are compared.
     * @see PermissionConditionOperator
     */
    public final String conditionOperatorAsString() {
        return conditionOperator;
    }

    /**
     * <p>
     * The key for the condition. This identifies the attribute that the condition applies to.
     * </p>
     * 
     * @return The key for the condition. This identifies the attribute that the condition applies to.
     */
    public final String conditionKey() {
        return conditionKey;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConditionValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasConditionValues() {
        return conditionValues != null && !(conditionValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The values to compare against using the specified condition operator.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConditionValues} method.
     * </p>
     * 
     * @return The values to compare against using the specified condition operator.
     */
    public final List<String> conditionValues() {
        return conditionValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(conditionOperatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(conditionKey());
        hashCode = 31 * hashCode + Objects.hashCode(hasConditionValues() ? conditionValues() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PermissionCondition)) {
            return false;
        }
        PermissionCondition other = (PermissionCondition) obj;
        return Objects.equals(conditionOperatorAsString(), other.conditionOperatorAsString())
                && Objects.equals(conditionKey(), other.conditionKey()) && hasConditionValues() == other.hasConditionValues()
                && Objects.equals(conditionValues(), other.conditionValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PermissionCondition").add("ConditionOperator", conditionOperatorAsString())
                .add("ConditionKey", conditionKey()).add("ConditionValues", hasConditionValues() ? conditionValues() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "conditionOperator":
            return Optional.ofNullable(clazz.cast(conditionOperatorAsString()));
        case "conditionKey":
            return Optional.ofNullable(clazz.cast(conditionKey()));
        case "conditionValues":
            return Optional.ofNullable(clazz.cast(conditionValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("conditionOperator", CONDITION_OPERATOR_FIELD);
        map.put("conditionKey", CONDITION_KEY_FIELD);
        map.put("conditionValues", CONDITION_VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PermissionCondition, T> g) {
        return obj -> g.apply((PermissionCondition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PermissionCondition> {
        /**
         * <p>
         * The operator to use for the condition evaluation. This determines how the condition values are compared.
         * </p>
         * 
         * @param conditionOperator
         *        The operator to use for the condition evaluation. This determines how the condition values are
         *        compared.
         * @see PermissionConditionOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PermissionConditionOperator
         */
        Builder conditionOperator(String conditionOperator);

        /**
         * <p>
         * The operator to use for the condition evaluation. This determines how the condition values are compared.
         * </p>
         * 
         * @param conditionOperator
         *        The operator to use for the condition evaluation. This determines how the condition values are
         *        compared.
         * @see PermissionConditionOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PermissionConditionOperator
         */
        Builder conditionOperator(PermissionConditionOperator conditionOperator);

        /**
         * <p>
         * The key for the condition. This identifies the attribute that the condition applies to.
         * </p>
         * 
         * @param conditionKey
         *        The key for the condition. This identifies the attribute that the condition applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditionKey(String conditionKey);

        /**
         * <p>
         * The values to compare against using the specified condition operator.
         * </p>
         * 
         * @param conditionValues
         *        The values to compare against using the specified condition operator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditionValues(Collection<String> conditionValues);

        /**
         * <p>
         * The values to compare against using the specified condition operator.
         * </p>
         * 
         * @param conditionValues
         *        The values to compare against using the specified condition operator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditionValues(String... conditionValues);
    }

    static final class BuilderImpl implements Builder {
        private String conditionOperator;

        private String conditionKey;

        private List<String> conditionValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PermissionCondition model) {
            conditionOperator(model.conditionOperator);
            conditionKey(model.conditionKey);
            conditionValues(model.conditionValues);
        }

        public final String getConditionOperator() {
            return conditionOperator;
        }

        public final void setConditionOperator(String conditionOperator) {
            this.conditionOperator = conditionOperator;
        }

        @Override
        public final Builder conditionOperator(String conditionOperator) {
            this.conditionOperator = conditionOperator;
            return this;
        }

        @Override
        public final Builder conditionOperator(PermissionConditionOperator conditionOperator) {
            this.conditionOperator(conditionOperator == null ? null : conditionOperator.toString());
            return this;
        }

        public final String getConditionKey() {
            return conditionKey;
        }

        public final void setConditionKey(String conditionKey) {
            this.conditionKey = conditionKey;
        }

        @Override
        public final Builder conditionKey(String conditionKey) {
            this.conditionKey = conditionKey;
            return this;
        }

        public final Collection<String> getConditionValues() {
            if (conditionValues instanceof SdkAutoConstructList) {
                return null;
            }
            return conditionValues;
        }

        public final void setConditionValues(Collection<String> conditionValues) {
            this.conditionValues = PermissionConditionValuesCopier.copy(conditionValues);
        }

        @Override
        public final Builder conditionValues(Collection<String> conditionValues) {
            this.conditionValues = PermissionConditionValuesCopier.copy(conditionValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditionValues(String... conditionValues) {
            conditionValues(Arrays.asList(conditionValues));
            return this;
        }

        @Override
        public PermissionCondition build() {
            return new PermissionCondition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
