/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about a group associated with the principal.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PrincipalGroup implements SdkPojo, Serializable, ToCopyableBuilder<PrincipalGroup.Builder, PrincipalGroup> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(PrincipalGroup::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ACCESS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("access")
            .getter(getter(PrincipalGroup::accessAsString)).setter(setter(Builder::access))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("access").build()).build();

    private static final SdkField<String> MEMBERSHIP_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipType").getter(getter(PrincipalGroup::membershipTypeAsString))
            .setter(setter(Builder::membershipType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ACCESS_FIELD,
            MEMBERSHIP_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String access;

    private final String membershipType;

    private PrincipalGroup(BuilderImpl builder) {
        this.name = builder.name;
        this.access = builder.access;
        this.membershipType = builder.membershipType;
    }

    /**
     * <p>
     * The name of the group.
     * </p>
     * 
     * @return The name of the group.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Provides information about whether to allow or deny access to the principal.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #access} will
     * return {@link ReadAccessType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #accessAsString}.
     * </p>
     * 
     * @return Provides information about whether to allow or deny access to the principal.
     * @see ReadAccessType
     */
    public final ReadAccessType access() {
        return ReadAccessType.fromValue(access);
    }

    /**
     * <p>
     * Provides information about whether to allow or deny access to the principal.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #access} will
     * return {@link ReadAccessType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #accessAsString}.
     * </p>
     * 
     * @return Provides information about whether to allow or deny access to the principal.
     * @see ReadAccessType
     */
    public final String accessAsString() {
        return access;
    }

    /**
     * <p>
     * The type of group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #membershipType}
     * will return {@link MembershipType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #membershipTypeAsString}.
     * </p>
     * 
     * @return The type of group.
     * @see MembershipType
     */
    public final MembershipType membershipType() {
        return MembershipType.fromValue(membershipType);
    }

    /**
     * <p>
     * The type of group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #membershipType}
     * will return {@link MembershipType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #membershipTypeAsString}.
     * </p>
     * 
     * @return The type of group.
     * @see MembershipType
     */
    public final String membershipTypeAsString() {
        return membershipType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(accessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(membershipTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrincipalGroup)) {
            return false;
        }
        PrincipalGroup other = (PrincipalGroup) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(accessAsString(), other.accessAsString())
                && Objects.equals(membershipTypeAsString(), other.membershipTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PrincipalGroup").add("Name", name()).add("Access", accessAsString())
                .add("MembershipType", membershipTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "access":
            return Optional.ofNullable(clazz.cast(accessAsString()));
        case "membershipType":
            return Optional.ofNullable(clazz.cast(membershipTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("access", ACCESS_FIELD);
        map.put("membershipType", MEMBERSHIP_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PrincipalGroup, T> g) {
        return obj -> g.apply((PrincipalGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PrincipalGroup> {
        /**
         * <p>
         * The name of the group.
         * </p>
         * 
         * @param name
         *        The name of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Provides information about whether to allow or deny access to the principal.
         * </p>
         * 
         * @param access
         *        Provides information about whether to allow or deny access to the principal.
         * @see ReadAccessType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReadAccessType
         */
        Builder access(String access);

        /**
         * <p>
         * Provides information about whether to allow or deny access to the principal.
         * </p>
         * 
         * @param access
         *        Provides information about whether to allow or deny access to the principal.
         * @see ReadAccessType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReadAccessType
         */
        Builder access(ReadAccessType access);

        /**
         * <p>
         * The type of group.
         * </p>
         * 
         * @param membershipType
         *        The type of group.
         * @see MembershipType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MembershipType
         */
        Builder membershipType(String membershipType);

        /**
         * <p>
         * The type of group.
         * </p>
         * 
         * @param membershipType
         *        The type of group.
         * @see MembershipType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MembershipType
         */
        Builder membershipType(MembershipType membershipType);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String access;

        private String membershipType;

        private BuilderImpl() {
        }

        private BuilderImpl(PrincipalGroup model) {
            name(model.name);
            access(model.access);
            membershipType(model.membershipType);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getAccess() {
            return access;
        }

        public final void setAccess(String access) {
            this.access = access;
        }

        @Override
        public final Builder access(String access) {
            this.access = access;
            return this;
        }

        @Override
        public final Builder access(ReadAccessType access) {
            this.access(access == null ? null : access.toString());
            return this;
        }

        public final String getMembershipType() {
            return membershipType;
        }

        public final void setMembershipType(String membershipType) {
            this.membershipType = membershipType;
        }

        @Override
        public final Builder membershipType(String membershipType) {
            this.membershipType = membershipType;
            return this;
        }

        @Override
        public final Builder membershipType(MembershipType membershipType) {
            this.membershipType(membershipType == null ? null : membershipType.toString());
            return this;
        }

        @Override
        public PrincipalGroup build() {
            return new PrincipalGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
