/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon QuickSight configuration for an Amazon Q Business application that uses QuickSight as the identity
 * provider. For more information, see <a
 * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/create-quicksight-integrated-application.html">Creating
 * an Amazon QuickSight integrated application</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QuickSightConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<QuickSightConfiguration.Builder, QuickSightConfiguration> {
    private static final SdkField<String> CLIENT_NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientNamespace").getter(getter(QuickSightConfiguration::clientNamespace))
            .setter(setter(Builder::clientNamespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientNamespace").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_NAMESPACE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String clientNamespace;

    private QuickSightConfiguration(BuilderImpl builder) {
        this.clientNamespace = builder.clientNamespace;
    }

    /**
     * <p>
     * The Amazon QuickSight namespace that is used as the identity provider. For more information about QuickSight
     * namespaces, see <a
     * href="https://docs.aws.amazon.com/quicksight/latest/developerguide/namespace-operations.html">Namespace
     * operations</a>.
     * </p>
     * 
     * @return The Amazon QuickSight namespace that is used as the identity provider. For more information about
     *         QuickSight namespaces, see <a
     *         href="https://docs.aws.amazon.com/quicksight/latest/developerguide/namespace-operations.html">Namespace
     *         operations</a>.
     */
    public final String clientNamespace() {
        return clientNamespace;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clientNamespace());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QuickSightConfiguration)) {
            return false;
        }
        QuickSightConfiguration other = (QuickSightConfiguration) obj;
        return Objects.equals(clientNamespace(), other.clientNamespace());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QuickSightConfiguration").add("ClientNamespace", clientNamespace()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientNamespace":
            return Optional.ofNullable(clazz.cast(clientNamespace()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clientNamespace", CLIENT_NAMESPACE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QuickSightConfiguration, T> g) {
        return obj -> g.apply((QuickSightConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QuickSightConfiguration> {
        /**
         * <p>
         * The Amazon QuickSight namespace that is used as the identity provider. For more information about QuickSight
         * namespaces, see <a
         * href="https://docs.aws.amazon.com/quicksight/latest/developerguide/namespace-operations.html">Namespace
         * operations</a>.
         * </p>
         * 
         * @param clientNamespace
         *        The Amazon QuickSight namespace that is used as the identity provider. For more information about
         *        QuickSight namespaces, see <a
         *        href="https://docs.aws.amazon.com/quicksight/latest/developerguide/namespace-operations.html"
         *        >Namespace operations</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientNamespace(String clientNamespace);
    }

    static final class BuilderImpl implements Builder {
        private String clientNamespace;

        private BuilderImpl() {
        }

        private BuilderImpl(QuickSightConfiguration model) {
            clientNamespace(model.clientNamespace);
        }

        public final String getClientNamespace() {
            return clientNamespace;
        }

        public final void setClientNamespace(String clientNamespace) {
            this.clientNamespace = clientNamespace;
        }

        @Override
        public final Builder clientNamespace(String clientNamespace) {
            this.clientNamespace = clientNamespace;
            return this;
        }

        @Override
        public QuickSightConfiguration build() {
            return new QuickSightConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
