/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateChatResponseConfigurationRequest extends QBusinessRequest implements
        ToCopyableBuilder<UpdateChatResponseConfigurationRequest.Builder, UpdateChatResponseConfigurationRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationId").getter(getter(UpdateChatResponseConfigurationRequest::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()).build();

    private static final SdkField<String> CHAT_RESPONSE_CONFIGURATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING).memberName("chatResponseConfigurationId")
            .getter(getter(UpdateChatResponseConfigurationRequest::chatResponseConfigurationId))
            .setter(setter(Builder::chatResponseConfigurationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("chatResponseConfigurationId").build())
            .build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(UpdateChatResponseConfigurationRequest::displayName))
            .setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<Map<String, ResponseConfiguration>> RESPONSE_CONFIGURATIONS_FIELD = SdkField
            .<Map<String, ResponseConfiguration>> builder(MarshallingType.MAP)
            .memberName("responseConfigurations")
            .getter(getter(UpdateChatResponseConfigurationRequest::responseConfigurationsAsStrings))
            .setter(setter(Builder::responseConfigurationsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseConfigurations").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ResponseConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResponseConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateChatResponseConfigurationRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            CHAT_RESPONSE_CONFIGURATION_ID_FIELD, DISPLAY_NAME_FIELD, RESPONSE_CONFIGURATIONS_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String applicationId;

    private final String chatResponseConfigurationId;

    private final String displayName;

    private final Map<String, ResponseConfiguration> responseConfigurations;

    private final String clientToken;

    private UpdateChatResponseConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.chatResponseConfigurationId = builder.chatResponseConfigurationId;
        this.displayName = builder.displayName;
        this.responseConfigurations = builder.responseConfigurations;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The unique identifier of the Amazon Q Business application containing the chat response configuration to update.
     * </p>
     * 
     * @return The unique identifier of the Amazon Q Business application containing the chat response configuration to
     *         update.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The unique identifier of the chat response configuration to update within the specified application.
     * </p>
     * 
     * @return The unique identifier of the chat response configuration to update within the specified application.
     */
    public final String chatResponseConfigurationId() {
        return chatResponseConfigurationId;
    }

    /**
     * <p>
     * The new human-readable name to assign to the chat response configuration, making it easier to identify among
     * multiple configurations.
     * </p>
     * 
     * @return The new human-readable name to assign to the chat response configuration, making it easier to identify
     *         among multiple configurations.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The updated collection of response configuration settings that define how Amazon Q Business generates and formats
     * responses to user queries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResponseConfigurations} method.
     * </p>
     * 
     * @return The updated collection of response configuration settings that define how Amazon Q Business generates and
     *         formats responses to user queries.
     */
    public final Map<ResponseConfigurationType, ResponseConfiguration> responseConfigurations() {
        return ResponseConfigurationsCopier.copyStringToEnum(responseConfigurations);
    }

    /**
     * For responses, this returns true if the service returned a value for the ResponseConfigurations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasResponseConfigurations() {
        return responseConfigurations != null && !(responseConfigurations instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The updated collection of response configuration settings that define how Amazon Q Business generates and formats
     * responses to user queries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResponseConfigurations} method.
     * </p>
     * 
     * @return The updated collection of response configuration settings that define how Amazon Q Business generates and
     *         formats responses to user queries.
     */
    public final Map<String, ResponseConfiguration> responseConfigurationsAsStrings() {
        return responseConfigurations;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier to ensure idempotency of the request. This helps prevent the same update from
     * being processed multiple times if retries occur.
     * </p>
     * 
     * @return A unique, case-sensitive identifier to ensure idempotency of the request. This helps prevent the same
     *         update from being processed multiple times if retries occur.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(chatResponseConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(hasResponseConfigurations() ? responseConfigurationsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateChatResponseConfigurationRequest)) {
            return false;
        }
        UpdateChatResponseConfigurationRequest other = (UpdateChatResponseConfigurationRequest) obj;
        return Objects.equals(applicationId(), other.applicationId())
                && Objects.equals(chatResponseConfigurationId(), other.chatResponseConfigurationId())
                && Objects.equals(displayName(), other.displayName())
                && hasResponseConfigurations() == other.hasResponseConfigurations()
                && Objects.equals(responseConfigurationsAsStrings(), other.responseConfigurationsAsStrings())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateChatResponseConfigurationRequest").add("ApplicationId", applicationId())
                .add("ChatResponseConfigurationId", chatResponseConfigurationId()).add("DisplayName", displayName())
                .add("ResponseConfigurations", hasResponseConfigurations() ? responseConfigurationsAsStrings() : null)
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "chatResponseConfigurationId":
            return Optional.ofNullable(clazz.cast(chatResponseConfigurationId()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "responseConfigurations":
            return Optional.ofNullable(clazz.cast(responseConfigurationsAsStrings()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("applicationId", APPLICATION_ID_FIELD);
        map.put("chatResponseConfigurationId", CHAT_RESPONSE_CONFIGURATION_ID_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("responseConfigurations", RESPONSE_CONFIGURATIONS_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateChatResponseConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateChatResponseConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QBusinessRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateChatResponseConfigurationRequest> {
        /**
         * <p>
         * The unique identifier of the Amazon Q Business application containing the chat response configuration to
         * update.
         * </p>
         * 
         * @param applicationId
         *        The unique identifier of the Amazon Q Business application containing the chat response configuration
         *        to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The unique identifier of the chat response configuration to update within the specified application.
         * </p>
         * 
         * @param chatResponseConfigurationId
         *        The unique identifier of the chat response configuration to update within the specified application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chatResponseConfigurationId(String chatResponseConfigurationId);

        /**
         * <p>
         * The new human-readable name to assign to the chat response configuration, making it easier to identify among
         * multiple configurations.
         * </p>
         * 
         * @param displayName
         *        The new human-readable name to assign to the chat response configuration, making it easier to identify
         *        among multiple configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The updated collection of response configuration settings that define how Amazon Q Business generates and
         * formats responses to user queries.
         * </p>
         * 
         * @param responseConfigurations
         *        The updated collection of response configuration settings that define how Amazon Q Business generates
         *        and formats responses to user queries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseConfigurationsWithStrings(Map<String, ResponseConfiguration> responseConfigurations);

        /**
         * <p>
         * The updated collection of response configuration settings that define how Amazon Q Business generates and
         * formats responses to user queries.
         * </p>
         * 
         * @param responseConfigurations
         *        The updated collection of response configuration settings that define how Amazon Q Business generates
         *        and formats responses to user queries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseConfigurations(Map<ResponseConfigurationType, ResponseConfiguration> responseConfigurations);

        /**
         * <p>
         * A unique, case-sensitive identifier to ensure idempotency of the request. This helps prevent the same update
         * from being processed multiple times if retries occur.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier to ensure idempotency of the request. This helps prevent the same
         *        update from being processed multiple times if retries occur.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QBusinessRequest.BuilderImpl implements Builder {
        private String applicationId;

        private String chatResponseConfigurationId;

        private String displayName;

        private Map<String, ResponseConfiguration> responseConfigurations = DefaultSdkAutoConstructMap.getInstance();

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateChatResponseConfigurationRequest model) {
            super(model);
            applicationId(model.applicationId);
            chatResponseConfigurationId(model.chatResponseConfigurationId);
            displayName(model.displayName);
            responseConfigurationsWithStrings(model.responseConfigurations);
            clientToken(model.clientToken);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getChatResponseConfigurationId() {
            return chatResponseConfigurationId;
        }

        public final void setChatResponseConfigurationId(String chatResponseConfigurationId) {
            this.chatResponseConfigurationId = chatResponseConfigurationId;
        }

        @Override
        public final Builder chatResponseConfigurationId(String chatResponseConfigurationId) {
            this.chatResponseConfigurationId = chatResponseConfigurationId;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final Map<String, ResponseConfiguration.Builder> getResponseConfigurations() {
            Map<String, ResponseConfiguration.Builder> result = ResponseConfigurationsCopier
                    .copyToBuilder(this.responseConfigurations);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setResponseConfigurations(Map<String, ResponseConfiguration.BuilderImpl> responseConfigurations) {
            this.responseConfigurations = ResponseConfigurationsCopier.copyFromBuilder(responseConfigurations);
        }

        @Override
        public final Builder responseConfigurationsWithStrings(Map<String, ResponseConfiguration> responseConfigurations) {
            this.responseConfigurations = ResponseConfigurationsCopier.copy(responseConfigurations);
            return this;
        }

        @Override
        public final Builder responseConfigurations(Map<ResponseConfigurationType, ResponseConfiguration> responseConfigurations) {
            this.responseConfigurations = ResponseConfigurationsCopier.copyEnumToString(responseConfigurations);
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateChatResponseConfigurationRequest build() {
            return new UpdateChatResponseConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
