/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qbusiness.model.AppliedCreatorModeConfiguration;
import software.amazon.awssdk.services.qbusiness.model.AppliedOrchestrationConfiguration;
import software.amazon.awssdk.services.qbusiness.model.BlockedPhrasesConfiguration;
import software.amazon.awssdk.services.qbusiness.model.HallucinationReductionConfiguration;
import software.amazon.awssdk.services.qbusiness.model.QBusinessResponse;
import software.amazon.awssdk.services.qbusiness.model.ResponseScope;
import software.amazon.awssdk.services.qbusiness.model.TopicConfiguration;
import software.amazon.awssdk.services.qbusiness.model.TopicConfigurationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetChatControlsConfigurationResponse
extends QBusinessResponse
implements ToCopyableBuilder<Builder, GetChatControlsConfigurationResponse> {
    private static final SdkField<String> RESPONSE_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("responseScope").getter(GetChatControlsConfigurationResponse.getter(GetChatControlsConfigurationResponse::responseScopeAsString)).setter(GetChatControlsConfigurationResponse.setter(Builder::responseScope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseScope").build()}).build();
    private static final SdkField<AppliedOrchestrationConfiguration> ORCHESTRATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("orchestrationConfiguration").getter(GetChatControlsConfigurationResponse.getter(GetChatControlsConfigurationResponse::orchestrationConfiguration)).setter(GetChatControlsConfigurationResponse.setter(Builder::orchestrationConfiguration)).constructor(AppliedOrchestrationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orchestrationConfiguration").build()}).build();
    private static final SdkField<BlockedPhrasesConfiguration> BLOCKED_PHRASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("blockedPhrases").getter(GetChatControlsConfigurationResponse.getter(GetChatControlsConfigurationResponse::blockedPhrases)).setter(GetChatControlsConfigurationResponse.setter(Builder::blockedPhrases)).constructor(BlockedPhrasesConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockedPhrases").build()}).build();
    private static final SdkField<List<TopicConfiguration>> TOPIC_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("topicConfigurations").getter(GetChatControlsConfigurationResponse.getter(GetChatControlsConfigurationResponse::topicConfigurations)).setter(GetChatControlsConfigurationResponse.setter(Builder::topicConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topicConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TopicConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AppliedCreatorModeConfiguration> CREATOR_MODE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("creatorModeConfiguration").getter(GetChatControlsConfigurationResponse.getter(GetChatControlsConfigurationResponse::creatorModeConfiguration)).setter(GetChatControlsConfigurationResponse.setter(Builder::creatorModeConfiguration)).constructor(AppliedCreatorModeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creatorModeConfiguration").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetChatControlsConfigurationResponse.getter(GetChatControlsConfigurationResponse::nextToken)).setter(GetChatControlsConfigurationResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<HallucinationReductionConfiguration> HALLUCINATION_REDUCTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("hallucinationReductionConfiguration").getter(GetChatControlsConfigurationResponse.getter(GetChatControlsConfigurationResponse::hallucinationReductionConfiguration)).setter(GetChatControlsConfigurationResponse.setter(Builder::hallucinationReductionConfiguration)).constructor(HallucinationReductionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hallucinationReductionConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESPONSE_SCOPE_FIELD, ORCHESTRATION_CONFIGURATION_FIELD, BLOCKED_PHRASES_FIELD, TOPIC_CONFIGURATIONS_FIELD, CREATOR_MODE_CONFIGURATION_FIELD, NEXT_TOKEN_FIELD, HALLUCINATION_REDUCTION_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetChatControlsConfigurationResponse.memberNameToFieldInitializer();
    private final String responseScope;
    private final AppliedOrchestrationConfiguration orchestrationConfiguration;
    private final BlockedPhrasesConfiguration blockedPhrases;
    private final List<TopicConfiguration> topicConfigurations;
    private final AppliedCreatorModeConfiguration creatorModeConfiguration;
    private final String nextToken;
    private final HallucinationReductionConfiguration hallucinationReductionConfiguration;

    private GetChatControlsConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.responseScope = builder.responseScope;
        this.orchestrationConfiguration = builder.orchestrationConfiguration;
        this.blockedPhrases = builder.blockedPhrases;
        this.topicConfigurations = builder.topicConfigurations;
        this.creatorModeConfiguration = builder.creatorModeConfiguration;
        this.nextToken = builder.nextToken;
        this.hallucinationReductionConfiguration = builder.hallucinationReductionConfiguration;
    }

    public final ResponseScope responseScope() {
        return ResponseScope.fromValue(this.responseScope);
    }

    public final String responseScopeAsString() {
        return this.responseScope;
    }

    public final AppliedOrchestrationConfiguration orchestrationConfiguration() {
        return this.orchestrationConfiguration;
    }

    public final BlockedPhrasesConfiguration blockedPhrases() {
        return this.blockedPhrases;
    }

    public final boolean hasTopicConfigurations() {
        return this.topicConfigurations != null && !(this.topicConfigurations instanceof SdkAutoConstructList);
    }

    public final List<TopicConfiguration> topicConfigurations() {
        return this.topicConfigurations;
    }

    public final AppliedCreatorModeConfiguration creatorModeConfiguration() {
        return this.creatorModeConfiguration;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final HallucinationReductionConfiguration hallucinationReductionConfiguration() {
        return this.hallucinationReductionConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.responseScopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.orchestrationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.blockedPhrases());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTopicConfigurations() ? this.topicConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.creatorModeConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hallucinationReductionConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetChatControlsConfigurationResponse)) {
            return false;
        }
        GetChatControlsConfigurationResponse other = (GetChatControlsConfigurationResponse)((Object)obj);
        return Objects.equals(this.responseScopeAsString(), other.responseScopeAsString()) && Objects.equals(this.orchestrationConfiguration(), other.orchestrationConfiguration()) && Objects.equals(this.blockedPhrases(), other.blockedPhrases()) && this.hasTopicConfigurations() == other.hasTopicConfigurations() && Objects.equals(this.topicConfigurations(), other.topicConfigurations()) && Objects.equals(this.creatorModeConfiguration(), other.creatorModeConfiguration()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.hallucinationReductionConfiguration(), other.hallucinationReductionConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"GetChatControlsConfigurationResponse").add("ResponseScope", (Object)this.responseScopeAsString()).add("OrchestrationConfiguration", (Object)this.orchestrationConfiguration()).add("BlockedPhrases", (Object)this.blockedPhrases()).add("TopicConfigurations", this.hasTopicConfigurations() ? this.topicConfigurations() : null).add("CreatorModeConfiguration", (Object)this.creatorModeConfiguration()).add("NextToken", (Object)this.nextToken()).add("HallucinationReductionConfiguration", (Object)this.hallucinationReductionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "responseScope": {
                return Optional.ofNullable(clazz.cast(this.responseScopeAsString()));
            }
            case "orchestrationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.orchestrationConfiguration()));
            }
            case "blockedPhrases": {
                return Optional.ofNullable(clazz.cast(this.blockedPhrases()));
            }
            case "topicConfigurations": {
                return Optional.ofNullable(clazz.cast(this.topicConfigurations()));
            }
            case "creatorModeConfiguration": {
                return Optional.ofNullable(clazz.cast(this.creatorModeConfiguration()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "hallucinationReductionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.hallucinationReductionConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("responseScope", RESPONSE_SCOPE_FIELD);
        map.put("orchestrationConfiguration", ORCHESTRATION_CONFIGURATION_FIELD);
        map.put("blockedPhrases", BLOCKED_PHRASES_FIELD);
        map.put("topicConfigurations", TOPIC_CONFIGURATIONS_FIELD);
        map.put("creatorModeConfiguration", CREATOR_MODE_CONFIGURATION_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("hallucinationReductionConfiguration", HALLUCINATION_REDUCTION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetChatControlsConfigurationResponse, T> g) {
        return obj -> g.apply((GetChatControlsConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QBusinessResponse.BuilderImpl
    implements Builder {
        private String responseScope;
        private AppliedOrchestrationConfiguration orchestrationConfiguration;
        private BlockedPhrasesConfiguration blockedPhrases;
        private List<TopicConfiguration> topicConfigurations = DefaultSdkAutoConstructList.getInstance();
        private AppliedCreatorModeConfiguration creatorModeConfiguration;
        private String nextToken;
        private HallucinationReductionConfiguration hallucinationReductionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetChatControlsConfigurationResponse model) {
            super(model);
            this.responseScope(model.responseScope);
            this.orchestrationConfiguration(model.orchestrationConfiguration);
            this.blockedPhrases(model.blockedPhrases);
            this.topicConfigurations(model.topicConfigurations);
            this.creatorModeConfiguration(model.creatorModeConfiguration);
            this.nextToken(model.nextToken);
            this.hallucinationReductionConfiguration(model.hallucinationReductionConfiguration);
        }

        public final String getResponseScope() {
            return this.responseScope;
        }

        public final void setResponseScope(String responseScope) {
            this.responseScope = responseScope;
        }

        @Override
        public final Builder responseScope(String responseScope) {
            this.responseScope = responseScope;
            return this;
        }

        @Override
        public final Builder responseScope(ResponseScope responseScope) {
            this.responseScope(responseScope == null ? null : responseScope.toString());
            return this;
        }

        public final AppliedOrchestrationConfiguration.Builder getOrchestrationConfiguration() {
            return this.orchestrationConfiguration != null ? this.orchestrationConfiguration.toBuilder() : null;
        }

        public final void setOrchestrationConfiguration(AppliedOrchestrationConfiguration.BuilderImpl orchestrationConfiguration) {
            this.orchestrationConfiguration = orchestrationConfiguration != null ? orchestrationConfiguration.build() : null;
        }

        @Override
        public final Builder orchestrationConfiguration(AppliedOrchestrationConfiguration orchestrationConfiguration) {
            this.orchestrationConfiguration = orchestrationConfiguration;
            return this;
        }

        public final BlockedPhrasesConfiguration.Builder getBlockedPhrases() {
            return this.blockedPhrases != null ? this.blockedPhrases.toBuilder() : null;
        }

        public final void setBlockedPhrases(BlockedPhrasesConfiguration.BuilderImpl blockedPhrases) {
            this.blockedPhrases = blockedPhrases != null ? blockedPhrases.build() : null;
        }

        @Override
        public final Builder blockedPhrases(BlockedPhrasesConfiguration blockedPhrases) {
            this.blockedPhrases = blockedPhrases;
            return this;
        }

        public final List<TopicConfiguration.Builder> getTopicConfigurations() {
            List<TopicConfiguration.Builder> result = TopicConfigurationsCopier.copyToBuilder(this.topicConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTopicConfigurations(Collection<TopicConfiguration.BuilderImpl> topicConfigurations) {
            this.topicConfigurations = TopicConfigurationsCopier.copyFromBuilder(topicConfigurations);
        }

        @Override
        public final Builder topicConfigurations(Collection<TopicConfiguration> topicConfigurations) {
            this.topicConfigurations = TopicConfigurationsCopier.copy(topicConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topicConfigurations(TopicConfiguration ... topicConfigurations) {
            this.topicConfigurations(Arrays.asList(topicConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topicConfigurations(Consumer<TopicConfiguration.Builder> ... topicConfigurations) {
            this.topicConfigurations(Stream.of(topicConfigurations).map(c -> (TopicConfiguration)((TopicConfiguration.Builder)TopicConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final AppliedCreatorModeConfiguration.Builder getCreatorModeConfiguration() {
            return this.creatorModeConfiguration != null ? this.creatorModeConfiguration.toBuilder() : null;
        }

        public final void setCreatorModeConfiguration(AppliedCreatorModeConfiguration.BuilderImpl creatorModeConfiguration) {
            this.creatorModeConfiguration = creatorModeConfiguration != null ? creatorModeConfiguration.build() : null;
        }

        @Override
        public final Builder creatorModeConfiguration(AppliedCreatorModeConfiguration creatorModeConfiguration) {
            this.creatorModeConfiguration = creatorModeConfiguration;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final HallucinationReductionConfiguration.Builder getHallucinationReductionConfiguration() {
            return this.hallucinationReductionConfiguration != null ? this.hallucinationReductionConfiguration.toBuilder() : null;
        }

        public final void setHallucinationReductionConfiguration(HallucinationReductionConfiguration.BuilderImpl hallucinationReductionConfiguration) {
            this.hallucinationReductionConfiguration = hallucinationReductionConfiguration != null ? hallucinationReductionConfiguration.build() : null;
        }

        @Override
        public final Builder hallucinationReductionConfiguration(HallucinationReductionConfiguration hallucinationReductionConfiguration) {
            this.hallucinationReductionConfiguration = hallucinationReductionConfiguration;
            return this;
        }

        @Override
        public GetChatControlsConfigurationResponse build() {
            return new GetChatControlsConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends QBusinessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetChatControlsConfigurationResponse> {
        public Builder responseScope(String var1);

        public Builder responseScope(ResponseScope var1);

        public Builder orchestrationConfiguration(AppliedOrchestrationConfiguration var1);

        default public Builder orchestrationConfiguration(Consumer<AppliedOrchestrationConfiguration.Builder> orchestrationConfiguration) {
            return this.orchestrationConfiguration((AppliedOrchestrationConfiguration)((AppliedOrchestrationConfiguration.Builder)AppliedOrchestrationConfiguration.builder().applyMutation(orchestrationConfiguration)).build());
        }

        public Builder blockedPhrases(BlockedPhrasesConfiguration var1);

        default public Builder blockedPhrases(Consumer<BlockedPhrasesConfiguration.Builder> blockedPhrases) {
            return this.blockedPhrases((BlockedPhrasesConfiguration)((BlockedPhrasesConfiguration.Builder)BlockedPhrasesConfiguration.builder().applyMutation(blockedPhrases)).build());
        }

        public Builder topicConfigurations(Collection<TopicConfiguration> var1);

        public Builder topicConfigurations(TopicConfiguration ... var1);

        public Builder topicConfigurations(Consumer<TopicConfiguration.Builder> ... var1);

        public Builder creatorModeConfiguration(AppliedCreatorModeConfiguration var1);

        default public Builder creatorModeConfiguration(Consumer<AppliedCreatorModeConfiguration.Builder> creatorModeConfiguration) {
            return this.creatorModeConfiguration((AppliedCreatorModeConfiguration)((AppliedCreatorModeConfiguration.Builder)AppliedCreatorModeConfiguration.builder().applyMutation(creatorModeConfiguration)).build());
        }

        public Builder nextToken(String var1);

        public Builder hallucinationReductionConfiguration(HallucinationReductionConfiguration var1);

        default public Builder hallucinationReductionConfiguration(Consumer<HallucinationReductionConfiguration.Builder> hallucinationReductionConfiguration) {
            return this.hallucinationReductionConfiguration((HallucinationReductionConfiguration)((HallucinationReductionConfiguration.Builder)HallucinationReductionConfiguration.builder().applyMutation(hallucinationReductionConfiguration)).build());
        }
    }
}

