/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qbusiness.model.DataAccessor;
import software.amazon.awssdk.services.qbusiness.model.DataAccessorsCopier;
import software.amazon.awssdk.services.qbusiness.model.QBusinessResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDataAccessorsResponse
extends QBusinessResponse
implements ToCopyableBuilder<Builder, ListDataAccessorsResponse> {
    private static final SdkField<List<DataAccessor>> DATA_ACCESSORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dataAccessors").getter(ListDataAccessorsResponse.getter(ListDataAccessorsResponse::dataAccessors)).setter(ListDataAccessorsResponse.setter(Builder::dataAccessors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataAccessors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataAccessor::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListDataAccessorsResponse.getter(ListDataAccessorsResponse::nextToken)).setter(ListDataAccessorsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_ACCESSORS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListDataAccessorsResponse.memberNameToFieldInitializer();
    private final List<DataAccessor> dataAccessors;
    private final String nextToken;

    private ListDataAccessorsResponse(BuilderImpl builder) {
        super(builder);
        this.dataAccessors = builder.dataAccessors;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDataAccessors() {
        return this.dataAccessors != null && !(this.dataAccessors instanceof SdkAutoConstructList);
    }

    public final List<DataAccessor> dataAccessors() {
        return this.dataAccessors;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataAccessors() ? this.dataAccessors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDataAccessorsResponse)) {
            return false;
        }
        ListDataAccessorsResponse other = (ListDataAccessorsResponse)((Object)obj);
        return this.hasDataAccessors() == other.hasDataAccessors() && Objects.equals(this.dataAccessors(), other.dataAccessors()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListDataAccessorsResponse").add("DataAccessors", this.hasDataAccessors() ? this.dataAccessors() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dataAccessors": {
                return Optional.ofNullable(clazz.cast(this.dataAccessors()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataAccessors", DATA_ACCESSORS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDataAccessorsResponse, T> g) {
        return obj -> g.apply((ListDataAccessorsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QBusinessResponse.BuilderImpl
    implements Builder {
        private List<DataAccessor> dataAccessors = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDataAccessorsResponse model) {
            super(model);
            this.dataAccessors(model.dataAccessors);
            this.nextToken(model.nextToken);
        }

        public final List<DataAccessor.Builder> getDataAccessors() {
            List<DataAccessor.Builder> result = DataAccessorsCopier.copyToBuilder(this.dataAccessors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataAccessors(Collection<DataAccessor.BuilderImpl> dataAccessors) {
            this.dataAccessors = DataAccessorsCopier.copyFromBuilder(dataAccessors);
        }

        @Override
        public final Builder dataAccessors(Collection<DataAccessor> dataAccessors) {
            this.dataAccessors = DataAccessorsCopier.copy(dataAccessors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataAccessors(DataAccessor ... dataAccessors) {
            this.dataAccessors(Arrays.asList(dataAccessors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataAccessors(Consumer<DataAccessor.Builder> ... dataAccessors) {
            this.dataAccessors(Stream.of(dataAccessors).map(c -> (DataAccessor)((DataAccessor.Builder)DataAccessor.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDataAccessorsResponse build() {
            return new ListDataAccessorsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends QBusinessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDataAccessorsResponse> {
        public Builder dataAccessors(Collection<DataAccessor> var1);

        public Builder dataAccessors(DataAccessor ... var1);

        public Builder dataAccessors(Consumer<DataAccessor.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

