/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.qbusiness.QBusinessAsyncClient;
import software.amazon.awssdk.services.qbusiness.internal.UserAgentUtils;
import software.amazon.awssdk.services.qbusiness.model.ChatResponseConfiguration;
import software.amazon.awssdk.services.qbusiness.model.ListChatResponseConfigurationsRequest;
import software.amazon.awssdk.services.qbusiness.model.ListChatResponseConfigurationsResponse;

public class ListChatResponseConfigurationsPublisher
implements SdkPublisher<ListChatResponseConfigurationsResponse> {
    private final QBusinessAsyncClient client;
    private final ListChatResponseConfigurationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListChatResponseConfigurationsPublisher(QBusinessAsyncClient client, ListChatResponseConfigurationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListChatResponseConfigurationsPublisher(QBusinessAsyncClient client, ListChatResponseConfigurationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListChatResponseConfigurationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListChatResponseConfigurationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ChatResponseConfiguration> chatResponseConfigurations() {
        Function<ListChatResponseConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.chatResponseConfigurations() != null) {
                return response.chatResponseConfigurations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListChatResponseConfigurationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListChatResponseConfigurationsResponseFetcher
    implements AsyncPageFetcher<ListChatResponseConfigurationsResponse> {
        private ListChatResponseConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListChatResponseConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListChatResponseConfigurationsResponse> nextPage(ListChatResponseConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListChatResponseConfigurationsPublisher.this.client.listChatResponseConfigurations(ListChatResponseConfigurationsPublisher.this.firstRequest);
            }
            return ListChatResponseConfigurationsPublisher.this.client.listChatResponseConfigurations((ListChatResponseConfigurationsRequest)((Object)ListChatResponseConfigurationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

