/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qbusiness.model.QBusinessRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteChatResponseConfigurationRequest
extends QBusinessRequest
implements ToCopyableBuilder<Builder, DeleteChatResponseConfigurationRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationId").getter(DeleteChatResponseConfigurationRequest.getter(DeleteChatResponseConfigurationRequest::applicationId)).setter(DeleteChatResponseConfigurationRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()}).build();
    private static final SdkField<String> CHAT_RESPONSE_CONFIGURATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("chatResponseConfigurationId").getter(DeleteChatResponseConfigurationRequest.getter(DeleteChatResponseConfigurationRequest::chatResponseConfigurationId)).setter(DeleteChatResponseConfigurationRequest.setter(Builder::chatResponseConfigurationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("chatResponseConfigurationId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, CHAT_RESPONSE_CONFIGURATION_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteChatResponseConfigurationRequest.memberNameToFieldInitializer();
    private final String applicationId;
    private final String chatResponseConfigurationId;

    private DeleteChatResponseConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.chatResponseConfigurationId = builder.chatResponseConfigurationId;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String chatResponseConfigurationId() {
        return this.chatResponseConfigurationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.chatResponseConfigurationId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteChatResponseConfigurationRequest)) {
            return false;
        }
        DeleteChatResponseConfigurationRequest other = (DeleteChatResponseConfigurationRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.chatResponseConfigurationId(), other.chatResponseConfigurationId());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteChatResponseConfigurationRequest").add("ApplicationId", (Object)this.applicationId()).add("ChatResponseConfigurationId", (Object)this.chatResponseConfigurationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "chatResponseConfigurationId": {
                return Optional.ofNullable(clazz.cast(this.chatResponseConfigurationId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("applicationId", APPLICATION_ID_FIELD);
        map.put("chatResponseConfigurationId", CHAT_RESPONSE_CONFIGURATION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteChatResponseConfigurationRequest, T> g) {
        return obj -> g.apply((DeleteChatResponseConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QBusinessRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private String chatResponseConfigurationId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteChatResponseConfigurationRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.chatResponseConfigurationId(model.chatResponseConfigurationId);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getChatResponseConfigurationId() {
            return this.chatResponseConfigurationId;
        }

        public final void setChatResponseConfigurationId(String chatResponseConfigurationId) {
            this.chatResponseConfigurationId = chatResponseConfigurationId;
        }

        @Override
        public final Builder chatResponseConfigurationId(String chatResponseConfigurationId) {
            this.chatResponseConfigurationId = chatResponseConfigurationId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteChatResponseConfigurationRequest build() {
            return new DeleteChatResponseConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends QBusinessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteChatResponseConfigurationRequest> {
        public Builder applicationId(String var1);

        public Builder chatResponseConfigurationId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

