/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qbusiness.model.PermissionConditionOperator;
import software.amazon.awssdk.services.qbusiness.model.PermissionConditionValuesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PermissionCondition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PermissionCondition> {
    private static final SdkField<String> CONDITION_OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("conditionOperator").getter(PermissionCondition.getter(PermissionCondition::conditionOperatorAsString)).setter(PermissionCondition.setter(Builder::conditionOperator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conditionOperator").build()}).build();
    private static final SdkField<String> CONDITION_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("conditionKey").getter(PermissionCondition.getter(PermissionCondition::conditionKey)).setter(PermissionCondition.setter(Builder::conditionKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conditionKey").build()}).build();
    private static final SdkField<List<String>> CONDITION_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("conditionValues").getter(PermissionCondition.getter(PermissionCondition::conditionValues)).setter(PermissionCondition.setter(Builder::conditionValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conditionValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONDITION_OPERATOR_FIELD, CONDITION_KEY_FIELD, CONDITION_VALUES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PermissionCondition.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String conditionOperator;
    private final String conditionKey;
    private final List<String> conditionValues;

    private PermissionCondition(BuilderImpl builder) {
        this.conditionOperator = builder.conditionOperator;
        this.conditionKey = builder.conditionKey;
        this.conditionValues = builder.conditionValues;
    }

    public final PermissionConditionOperator conditionOperator() {
        return PermissionConditionOperator.fromValue(this.conditionOperator);
    }

    public final String conditionOperatorAsString() {
        return this.conditionOperator;
    }

    public final String conditionKey() {
        return this.conditionKey;
    }

    public final boolean hasConditionValues() {
        return this.conditionValues != null && !(this.conditionValues instanceof SdkAutoConstructList);
    }

    public final List<String> conditionValues() {
        return this.conditionValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.conditionOperatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.conditionKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConditionValues() ? this.conditionValues() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PermissionCondition)) {
            return false;
        }
        PermissionCondition other = (PermissionCondition)obj;
        return Objects.equals(this.conditionOperatorAsString(), other.conditionOperatorAsString()) && Objects.equals(this.conditionKey(), other.conditionKey()) && this.hasConditionValues() == other.hasConditionValues() && Objects.equals(this.conditionValues(), other.conditionValues());
    }

    public final String toString() {
        return ToString.builder((String)"PermissionCondition").add("ConditionOperator", (Object)this.conditionOperatorAsString()).add("ConditionKey", (Object)this.conditionKey()).add("ConditionValues", this.hasConditionValues() ? this.conditionValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "conditionOperator": {
                return Optional.ofNullable(clazz.cast(this.conditionOperatorAsString()));
            }
            case "conditionKey": {
                return Optional.ofNullable(clazz.cast(this.conditionKey()));
            }
            case "conditionValues": {
                return Optional.ofNullable(clazz.cast(this.conditionValues()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("conditionOperator", CONDITION_OPERATOR_FIELD);
        map.put("conditionKey", CONDITION_KEY_FIELD);
        map.put("conditionValues", CONDITION_VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PermissionCondition, T> g) {
        return obj -> g.apply((PermissionCondition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String conditionOperator;
        private String conditionKey;
        private List<String> conditionValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PermissionCondition model) {
            this.conditionOperator(model.conditionOperator);
            this.conditionKey(model.conditionKey);
            this.conditionValues(model.conditionValues);
        }

        public final String getConditionOperator() {
            return this.conditionOperator;
        }

        public final void setConditionOperator(String conditionOperator) {
            this.conditionOperator = conditionOperator;
        }

        @Override
        public final Builder conditionOperator(String conditionOperator) {
            this.conditionOperator = conditionOperator;
            return this;
        }

        @Override
        public final Builder conditionOperator(PermissionConditionOperator conditionOperator) {
            this.conditionOperator(conditionOperator == null ? null : conditionOperator.toString());
            return this;
        }

        public final String getConditionKey() {
            return this.conditionKey;
        }

        public final void setConditionKey(String conditionKey) {
            this.conditionKey = conditionKey;
        }

        @Override
        public final Builder conditionKey(String conditionKey) {
            this.conditionKey = conditionKey;
            return this;
        }

        public final Collection<String> getConditionValues() {
            if (this.conditionValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.conditionValues;
        }

        public final void setConditionValues(Collection<String> conditionValues) {
            this.conditionValues = PermissionConditionValuesCopier.copy(conditionValues);
        }

        @Override
        public final Builder conditionValues(Collection<String> conditionValues) {
            this.conditionValues = PermissionConditionValuesCopier.copy(conditionValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditionValues(String ... conditionValues) {
            this.conditionValues(Arrays.asList(conditionValues));
            return this;
        }

        public PermissionCondition build() {
            return new PermissionCondition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PermissionCondition> {
        public Builder conditionOperator(String var1);

        public Builder conditionOperator(PermissionConditionOperator var1);

        public Builder conditionKey(String var1);

        public Builder conditionValues(Collection<String> var1);

        public Builder conditionValues(String ... var1);
    }
}

