/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.qbusiness.internal.QBusinessServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.qbusiness.internal.ServiceVersionInfo;
import software.amazon.awssdk.services.qbusiness.model.AccessDeniedException;
import software.amazon.awssdk.services.qbusiness.model.AssociatePermissionRequest;
import software.amazon.awssdk.services.qbusiness.model.AssociatePermissionResponse;
import software.amazon.awssdk.services.qbusiness.model.BatchDeleteDocumentRequest;
import software.amazon.awssdk.services.qbusiness.model.BatchDeleteDocumentResponse;
import software.amazon.awssdk.services.qbusiness.model.BatchPutDocumentRequest;
import software.amazon.awssdk.services.qbusiness.model.BatchPutDocumentResponse;
import software.amazon.awssdk.services.qbusiness.model.CancelSubscriptionRequest;
import software.amazon.awssdk.services.qbusiness.model.CancelSubscriptionResponse;
import software.amazon.awssdk.services.qbusiness.model.ChatSyncRequest;
import software.amazon.awssdk.services.qbusiness.model.ChatSyncResponse;
import software.amazon.awssdk.services.qbusiness.model.CheckDocumentAccessRequest;
import software.amazon.awssdk.services.qbusiness.model.CheckDocumentAccessResponse;
import software.amazon.awssdk.services.qbusiness.model.ConflictException;
import software.amazon.awssdk.services.qbusiness.model.CreateAnonymousWebExperienceUrlRequest;
import software.amazon.awssdk.services.qbusiness.model.CreateAnonymousWebExperienceUrlResponse;
import software.amazon.awssdk.services.qbusiness.model.CreateApplicationRequest;
import software.amazon.awssdk.services.qbusiness.model.CreateApplicationResponse;
import software.amazon.awssdk.services.qbusiness.model.CreateChatResponseConfigurationRequest;
import software.amazon.awssdk.services.qbusiness.model.CreateChatResponseConfigurationResponse;
import software.amazon.awssdk.services.qbusiness.model.CreateDataAccessorRequest;
import software.amazon.awssdk.services.qbusiness.model.CreateDataAccessorResponse;
import software.amazon.awssdk.services.qbusiness.model.CreateDataSourceRequest;
import software.amazon.awssdk.services.qbusiness.model.CreateDataSourceResponse;
import software.amazon.awssdk.services.qbusiness.model.CreateIndexRequest;
import software.amazon.awssdk.services.qbusiness.model.CreateIndexResponse;
import software.amazon.awssdk.services.qbusiness.model.CreatePluginRequest;
import software.amazon.awssdk.services.qbusiness.model.CreatePluginResponse;
import software.amazon.awssdk.services.qbusiness.model.CreateRetrieverRequest;
import software.amazon.awssdk.services.qbusiness.model.CreateRetrieverResponse;
import software.amazon.awssdk.services.qbusiness.model.CreateSubscriptionRequest;
import software.amazon.awssdk.services.qbusiness.model.CreateSubscriptionResponse;
import software.amazon.awssdk.services.qbusiness.model.CreateUserRequest;
import software.amazon.awssdk.services.qbusiness.model.CreateUserResponse;
import software.amazon.awssdk.services.qbusiness.model.CreateWebExperienceRequest;
import software.amazon.awssdk.services.qbusiness.model.CreateWebExperienceResponse;
import software.amazon.awssdk.services.qbusiness.model.DeleteApplicationRequest;
import software.amazon.awssdk.services.qbusiness.model.DeleteApplicationResponse;
import software.amazon.awssdk.services.qbusiness.model.DeleteAttachmentRequest;
import software.amazon.awssdk.services.qbusiness.model.DeleteAttachmentResponse;
import software.amazon.awssdk.services.qbusiness.model.DeleteChatControlsConfigurationRequest;
import software.amazon.awssdk.services.qbusiness.model.DeleteChatControlsConfigurationResponse;
import software.amazon.awssdk.services.qbusiness.model.DeleteChatResponseConfigurationRequest;
import software.amazon.awssdk.services.qbusiness.model.DeleteChatResponseConfigurationResponse;
import software.amazon.awssdk.services.qbusiness.model.DeleteConversationRequest;
import software.amazon.awssdk.services.qbusiness.model.DeleteConversationResponse;
import software.amazon.awssdk.services.qbusiness.model.DeleteDataAccessorRequest;
import software.amazon.awssdk.services.qbusiness.model.DeleteDataAccessorResponse;
import software.amazon.awssdk.services.qbusiness.model.DeleteDataSourceRequest;
import software.amazon.awssdk.services.qbusiness.model.DeleteDataSourceResponse;
import software.amazon.awssdk.services.qbusiness.model.DeleteGroupRequest;
import software.amazon.awssdk.services.qbusiness.model.DeleteGroupResponse;
import software.amazon.awssdk.services.qbusiness.model.DeleteIndexRequest;
import software.amazon.awssdk.services.qbusiness.model.DeleteIndexResponse;
import software.amazon.awssdk.services.qbusiness.model.DeletePluginRequest;
import software.amazon.awssdk.services.qbusiness.model.DeletePluginResponse;
import software.amazon.awssdk.services.qbusiness.model.DeleteRetrieverRequest;
import software.amazon.awssdk.services.qbusiness.model.DeleteRetrieverResponse;
import software.amazon.awssdk.services.qbusiness.model.DeleteUserRequest;
import software.amazon.awssdk.services.qbusiness.model.DeleteUserResponse;
import software.amazon.awssdk.services.qbusiness.model.DeleteWebExperienceRequest;
import software.amazon.awssdk.services.qbusiness.model.DeleteWebExperienceResponse;
import software.amazon.awssdk.services.qbusiness.model.DisassociatePermissionRequest;
import software.amazon.awssdk.services.qbusiness.model.DisassociatePermissionResponse;
import software.amazon.awssdk.services.qbusiness.model.ExternalResourceException;
import software.amazon.awssdk.services.qbusiness.model.GetApplicationRequest;
import software.amazon.awssdk.services.qbusiness.model.GetApplicationResponse;
import software.amazon.awssdk.services.qbusiness.model.GetChatControlsConfigurationRequest;
import software.amazon.awssdk.services.qbusiness.model.GetChatControlsConfigurationResponse;
import software.amazon.awssdk.services.qbusiness.model.GetChatResponseConfigurationRequest;
import software.amazon.awssdk.services.qbusiness.model.GetChatResponseConfigurationResponse;
import software.amazon.awssdk.services.qbusiness.model.GetDataAccessorRequest;
import software.amazon.awssdk.services.qbusiness.model.GetDataAccessorResponse;
import software.amazon.awssdk.services.qbusiness.model.GetDataSourceRequest;
import software.amazon.awssdk.services.qbusiness.model.GetDataSourceResponse;
import software.amazon.awssdk.services.qbusiness.model.GetDocumentContentRequest;
import software.amazon.awssdk.services.qbusiness.model.GetDocumentContentResponse;
import software.amazon.awssdk.services.qbusiness.model.GetGroupRequest;
import software.amazon.awssdk.services.qbusiness.model.GetGroupResponse;
import software.amazon.awssdk.services.qbusiness.model.GetIndexRequest;
import software.amazon.awssdk.services.qbusiness.model.GetIndexResponse;
import software.amazon.awssdk.services.qbusiness.model.GetMediaRequest;
import software.amazon.awssdk.services.qbusiness.model.GetMediaResponse;
import software.amazon.awssdk.services.qbusiness.model.GetPluginRequest;
import software.amazon.awssdk.services.qbusiness.model.GetPluginResponse;
import software.amazon.awssdk.services.qbusiness.model.GetPolicyRequest;
import software.amazon.awssdk.services.qbusiness.model.GetPolicyResponse;
import software.amazon.awssdk.services.qbusiness.model.GetRetrieverRequest;
import software.amazon.awssdk.services.qbusiness.model.GetRetrieverResponse;
import software.amazon.awssdk.services.qbusiness.model.GetUserRequest;
import software.amazon.awssdk.services.qbusiness.model.GetUserResponse;
import software.amazon.awssdk.services.qbusiness.model.GetWebExperienceRequest;
import software.amazon.awssdk.services.qbusiness.model.GetWebExperienceResponse;
import software.amazon.awssdk.services.qbusiness.model.InternalServerException;
import software.amazon.awssdk.services.qbusiness.model.LicenseNotFoundException;
import software.amazon.awssdk.services.qbusiness.model.ListApplicationsRequest;
import software.amazon.awssdk.services.qbusiness.model.ListApplicationsResponse;
import software.amazon.awssdk.services.qbusiness.model.ListAttachmentsRequest;
import software.amazon.awssdk.services.qbusiness.model.ListAttachmentsResponse;
import software.amazon.awssdk.services.qbusiness.model.ListChatResponseConfigurationsRequest;
import software.amazon.awssdk.services.qbusiness.model.ListChatResponseConfigurationsResponse;
import software.amazon.awssdk.services.qbusiness.model.ListConversationsRequest;
import software.amazon.awssdk.services.qbusiness.model.ListConversationsResponse;
import software.amazon.awssdk.services.qbusiness.model.ListDataAccessorsRequest;
import software.amazon.awssdk.services.qbusiness.model.ListDataAccessorsResponse;
import software.amazon.awssdk.services.qbusiness.model.ListDataSourceSyncJobsRequest;
import software.amazon.awssdk.services.qbusiness.model.ListDataSourceSyncJobsResponse;
import software.amazon.awssdk.services.qbusiness.model.ListDataSourcesRequest;
import software.amazon.awssdk.services.qbusiness.model.ListDataSourcesResponse;
import software.amazon.awssdk.services.qbusiness.model.ListDocumentsRequest;
import software.amazon.awssdk.services.qbusiness.model.ListDocumentsResponse;
import software.amazon.awssdk.services.qbusiness.model.ListGroupsRequest;
import software.amazon.awssdk.services.qbusiness.model.ListGroupsResponse;
import software.amazon.awssdk.services.qbusiness.model.ListIndicesRequest;
import software.amazon.awssdk.services.qbusiness.model.ListIndicesResponse;
import software.amazon.awssdk.services.qbusiness.model.ListMessagesRequest;
import software.amazon.awssdk.services.qbusiness.model.ListMessagesResponse;
import software.amazon.awssdk.services.qbusiness.model.ListPluginActionsRequest;
import software.amazon.awssdk.services.qbusiness.model.ListPluginActionsResponse;
import software.amazon.awssdk.services.qbusiness.model.ListPluginTypeActionsRequest;
import software.amazon.awssdk.services.qbusiness.model.ListPluginTypeActionsResponse;
import software.amazon.awssdk.services.qbusiness.model.ListPluginTypeMetadataRequest;
import software.amazon.awssdk.services.qbusiness.model.ListPluginTypeMetadataResponse;
import software.amazon.awssdk.services.qbusiness.model.ListPluginsRequest;
import software.amazon.awssdk.services.qbusiness.model.ListPluginsResponse;
import software.amazon.awssdk.services.qbusiness.model.ListRetrieversRequest;
import software.amazon.awssdk.services.qbusiness.model.ListRetrieversResponse;
import software.amazon.awssdk.services.qbusiness.model.ListSubscriptionsRequest;
import software.amazon.awssdk.services.qbusiness.model.ListSubscriptionsResponse;
import software.amazon.awssdk.services.qbusiness.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.qbusiness.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.qbusiness.model.ListWebExperiencesRequest;
import software.amazon.awssdk.services.qbusiness.model.ListWebExperiencesResponse;
import software.amazon.awssdk.services.qbusiness.model.MediaTooLargeException;
import software.amazon.awssdk.services.qbusiness.model.PutFeedbackRequest;
import software.amazon.awssdk.services.qbusiness.model.PutFeedbackResponse;
import software.amazon.awssdk.services.qbusiness.model.PutGroupRequest;
import software.amazon.awssdk.services.qbusiness.model.PutGroupResponse;
import software.amazon.awssdk.services.qbusiness.model.QBusinessException;
import software.amazon.awssdk.services.qbusiness.model.ResourceNotFoundException;
import software.amazon.awssdk.services.qbusiness.model.SearchRelevantContentRequest;
import software.amazon.awssdk.services.qbusiness.model.SearchRelevantContentResponse;
import software.amazon.awssdk.services.qbusiness.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.qbusiness.model.StartDataSourceSyncJobRequest;
import software.amazon.awssdk.services.qbusiness.model.StartDataSourceSyncJobResponse;
import software.amazon.awssdk.services.qbusiness.model.StopDataSourceSyncJobRequest;
import software.amazon.awssdk.services.qbusiness.model.StopDataSourceSyncJobResponse;
import software.amazon.awssdk.services.qbusiness.model.TagResourceRequest;
import software.amazon.awssdk.services.qbusiness.model.TagResourceResponse;
import software.amazon.awssdk.services.qbusiness.model.ThrottlingException;
import software.amazon.awssdk.services.qbusiness.model.UntagResourceRequest;
import software.amazon.awssdk.services.qbusiness.model.UntagResourceResponse;
import software.amazon.awssdk.services.qbusiness.model.UpdateApplicationRequest;
import software.amazon.awssdk.services.qbusiness.model.UpdateApplicationResponse;
import software.amazon.awssdk.services.qbusiness.model.UpdateChatControlsConfigurationRequest;
import software.amazon.awssdk.services.qbusiness.model.UpdateChatControlsConfigurationResponse;
import software.amazon.awssdk.services.qbusiness.model.UpdateChatResponseConfigurationRequest;
import software.amazon.awssdk.services.qbusiness.model.UpdateChatResponseConfigurationResponse;
import software.amazon.awssdk.services.qbusiness.model.UpdateDataAccessorRequest;
import software.amazon.awssdk.services.qbusiness.model.UpdateDataAccessorResponse;
import software.amazon.awssdk.services.qbusiness.model.UpdateDataSourceRequest;
import software.amazon.awssdk.services.qbusiness.model.UpdateDataSourceResponse;
import software.amazon.awssdk.services.qbusiness.model.UpdateIndexRequest;
import software.amazon.awssdk.services.qbusiness.model.UpdateIndexResponse;
import software.amazon.awssdk.services.qbusiness.model.UpdatePluginRequest;
import software.amazon.awssdk.services.qbusiness.model.UpdatePluginResponse;
import software.amazon.awssdk.services.qbusiness.model.UpdateRetrieverRequest;
import software.amazon.awssdk.services.qbusiness.model.UpdateRetrieverResponse;
import software.amazon.awssdk.services.qbusiness.model.UpdateSubscriptionRequest;
import software.amazon.awssdk.services.qbusiness.model.UpdateSubscriptionResponse;
import software.amazon.awssdk.services.qbusiness.model.UpdateUserRequest;
import software.amazon.awssdk.services.qbusiness.model.UpdateUserResponse;
import software.amazon.awssdk.services.qbusiness.model.UpdateWebExperienceRequest;
import software.amazon.awssdk.services.qbusiness.model.UpdateWebExperienceResponse;
import software.amazon.awssdk.services.qbusiness.model.ValidationException;
import software.amazon.awssdk.services.qbusiness.transform.AssociatePermissionRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.BatchDeleteDocumentRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.BatchPutDocumentRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.CancelSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.ChatSyncRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.CheckDocumentAccessRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.CreateAnonymousWebExperienceUrlRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.CreateApplicationRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.CreateChatResponseConfigurationRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.CreateDataAccessorRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.CreateDataSourceRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.CreateIndexRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.CreatePluginRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.CreateRetrieverRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.CreateSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.CreateUserRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.CreateWebExperienceRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.DeleteApplicationRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.DeleteAttachmentRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.DeleteChatControlsConfigurationRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.DeleteChatResponseConfigurationRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.DeleteConversationRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.DeleteDataAccessorRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.DeleteDataSourceRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.DeleteGroupRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.DeleteIndexRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.DeletePluginRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.DeleteRetrieverRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.DeleteUserRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.DeleteWebExperienceRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.DisassociatePermissionRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.GetApplicationRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.GetChatControlsConfigurationRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.GetChatResponseConfigurationRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.GetDataAccessorRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.GetDataSourceRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.GetDocumentContentRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.GetGroupRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.GetIndexRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.GetMediaRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.GetPluginRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.GetPolicyRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.GetRetrieverRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.GetUserRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.GetWebExperienceRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.ListApplicationsRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.ListAttachmentsRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.ListChatResponseConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.ListConversationsRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.ListDataAccessorsRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.ListDataSourceSyncJobsRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.ListDataSourcesRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.ListDocumentsRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.ListGroupsRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.ListIndicesRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.ListMessagesRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.ListPluginActionsRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.ListPluginTypeActionsRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.ListPluginTypeMetadataRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.ListPluginsRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.ListRetrieversRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.ListSubscriptionsRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.ListWebExperiencesRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.PutFeedbackRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.PutGroupRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.SearchRelevantContentRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.StartDataSourceSyncJobRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.StopDataSourceSyncJobRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.UpdateApplicationRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.UpdateChatControlsConfigurationRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.UpdateChatResponseConfigurationRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.UpdateDataAccessorRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.UpdateDataSourceRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.UpdateIndexRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.UpdatePluginRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.UpdateRetrieverRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.UpdateSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.UpdateUserRequestMarshaller;
import software.amazon.awssdk.services.qbusiness.transform.UpdateWebExperienceRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link QBusinessClient}.
 *
 * @see QBusinessClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultQBusinessClient implements QBusinessClient {
    private static final Logger log = Logger.loggerFor(DefaultQBusinessClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.REST_JSON).build();

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultQBusinessClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this)
                .option(SdkClientOption.API_METADATA, "QBusiness" + "#" + ServiceVersionInfo.VERSION).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Adds or updates a permission policy for a Amazon Q Business application, allowing cross-account access for an
     * ISV. This operation creates a new policy statement for the specified Amazon Q Business application. The policy
     * statement defines the IAM actions that the ISV is allowed to perform on the Amazon Q Business application's
     * resources.
     * </p>
     *
     * @param associatePermissionRequest
     * @return Result of the AssociatePermission operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistencies with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the set limits for your Amazon Q Business service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.AssociatePermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/AssociatePermission" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public AssociatePermissionResponse associatePermission(AssociatePermissionRequest associatePermissionRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociatePermissionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociatePermissionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associatePermissionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associatePermissionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociatePermission");

            return clientHandler.execute(new ClientExecutionParams<AssociatePermissionRequest, AssociatePermissionResponse>()
                    .withOperationName("AssociatePermission").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(associatePermissionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AssociatePermissionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Asynchronously deletes one or more documents added using the <code>BatchPutDocument</code> API from an Amazon Q
     * Business index.
     * </p>
     * <p>
     * You can see the progress of the deletion, and any error messages related to the process, by using CloudWatch.
     * </p>
     *
     * @param batchDeleteDocumentRequest
     * @return Result of the BatchDeleteDocument operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistencies with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.BatchDeleteDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/BatchDeleteDocument" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public BatchDeleteDocumentResponse batchDeleteDocument(BatchDeleteDocumentRequest batchDeleteDocumentRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchDeleteDocumentResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchDeleteDocumentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchDeleteDocumentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchDeleteDocumentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchDeleteDocument");

            return clientHandler.execute(new ClientExecutionParams<BatchDeleteDocumentRequest, BatchDeleteDocumentResponse>()
                    .withOperationName("BatchDeleteDocument").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(batchDeleteDocumentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new BatchDeleteDocumentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds one or more documents to an Amazon Q Business index.
     * </p>
     * <p>
     * You use this API to:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ingest your structured and unstructured documents and documents stored in an Amazon S3 bucket into an Amazon Q
     * Business index.
     * </p>
     * </li>
     * <li>
     * <p>
     * add custom attributes to documents in an Amazon Q Business index.
     * </p>
     * </li>
     * <li>
     * <p>
     * attach an access control list to the documents added to an Amazon Q Business index.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can see the progress of the deletion, and any error messages related to the process, by using CloudWatch.
     * </p>
     *
     * @param batchPutDocumentRequest
     * @return Result of the BatchPutDocument operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistencies with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the set limits for your Amazon Q Business service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.BatchPutDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/BatchPutDocument" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public BatchPutDocumentResponse batchPutDocument(BatchPutDocumentRequest batchPutDocumentRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchPutDocumentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                BatchPutDocumentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchPutDocumentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchPutDocumentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchPutDocument");

            return clientHandler.execute(new ClientExecutionParams<BatchPutDocumentRequest, BatchPutDocumentResponse>()
                    .withOperationName("BatchPutDocument").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(batchPutDocumentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new BatchPutDocumentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Unsubscribes a user or a group from their pricing tier in an Amazon Q Business application. An unsubscribed user
     * or group loses all Amazon Q Business feature access at the start of next month.
     * </p>
     *
     * @param cancelSubscriptionRequest
     * @return Result of the CancelSubscription operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.CancelSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CancelSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CancelSubscriptionResponse cancelSubscription(CancelSubscriptionRequest cancelSubscriptionRequest)
            throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CancelSubscriptionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CancelSubscriptionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelSubscriptionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelSubscriptionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelSubscription");

            return clientHandler.execute(new ClientExecutionParams<CancelSubscriptionRequest, CancelSubscriptionResponse>()
                    .withOperationName("CancelSubscription").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(cancelSubscriptionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CancelSubscriptionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Starts or continues a non-streaming Amazon Q Business conversation.
     * </p>
     *
     * @param chatSyncRequest
     * @return Result of the ChatSync operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistencies with your resources and try again.
     * @throws LicenseNotFoundException
     *         You don't have permissions to perform the action because your license is inactive. Ask your admin to
     *         activate your license and try again after your licence is active.
     * @throws ExternalResourceException
     *         An external resource that you configured with your application is returning errors and preventing this
     *         operation from succeeding. Fix those errors and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ChatSync
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ChatSync" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ChatSyncResponse chatSync(ChatSyncRequest chatSyncRequest) throws InternalServerException, ResourceNotFoundException,
            ConflictException, LicenseNotFoundException, ExternalResourceException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ChatSyncResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ChatSyncResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(chatSyncRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, chatSyncRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ChatSync");

            return clientHandler.execute(new ClientExecutionParams<ChatSyncRequest, ChatSyncResponse>()
                    .withOperationName("ChatSync").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(chatSyncRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ChatSyncRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Verifies if a user has access permissions for a specified document and returns the actual ACL attached to the
     * document. Resolves user access on the document via user aliases and groups when verifying user access.
     * </p>
     *
     * @param checkDocumentAccessRequest
     * @return Result of the CheckDocumentAccess operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.CheckDocumentAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CheckDocumentAccess" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CheckDocumentAccessResponse checkDocumentAccess(CheckDocumentAccessRequest checkDocumentAccessRequest)
            throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CheckDocumentAccessResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CheckDocumentAccessResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(checkDocumentAccessRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, checkDocumentAccessRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CheckDocumentAccess");

            return clientHandler.execute(new ClientExecutionParams<CheckDocumentAccessRequest, CheckDocumentAccessResponse>()
                    .withOperationName("CheckDocumentAccess").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(checkDocumentAccessRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CheckDocumentAccessRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a unique URL for anonymous Amazon Q Business web experience. This URL can only be used once and must be
     * used within 5 minutes after it's generated.
     * </p>
     *
     * @param createAnonymousWebExperienceUrlRequest
     * @return Result of the CreateAnonymousWebExperienceUrl operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the set limits for your Amazon Q Business service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.CreateAnonymousWebExperienceUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CreateAnonymousWebExperienceUrl"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateAnonymousWebExperienceUrlResponse createAnonymousWebExperienceUrl(
            CreateAnonymousWebExperienceUrlRequest createAnonymousWebExperienceUrlRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateAnonymousWebExperienceUrlResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateAnonymousWebExperienceUrlResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAnonymousWebExperienceUrlRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createAnonymousWebExperienceUrlRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAnonymousWebExperienceUrl");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateAnonymousWebExperienceUrlRequest, CreateAnonymousWebExperienceUrlResponse>()
                            .withOperationName("CreateAnonymousWebExperienceUrl").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createAnonymousWebExperienceUrlRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateAnonymousWebExperienceUrlRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an Amazon Q Business application.
     * </p>
     * <note>
     * <p>
     * There are new tiers for Amazon Q Business. Not all features in Amazon Q Business Pro are also available in Amazon
     * Q Business Lite. For information on what's included in Amazon Q Business Lite and what's included in Amazon Q
     * Business Pro, see <a
     * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/tiers.html#user-sub-tiers">Amazon Q Business
     * tiers</a>. You must use the Amazon Q Business console to assign subscription tiers to users.
     * </p>
     * <p>
     * An Amazon Q Apps service linked role will be created if it's absent in the Amazon Web Services account when
     * <code>QAppsConfiguration</code> is enabled in the request. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/using-service-linked-roles-qapps.html"> Using
     * service-linked roles for Q Apps</a>.
     * </p>
     * <p>
     * When you create an application, Amazon Q Business may securely transmit data for processing from your selected
     * Amazon Web Services region, but within your geography. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/cross-region-inference.html">Cross region inference
     * in Amazon Q Business</a>.
     * </p>
     * </note>
     *
     * @param createApplicationRequest
     * @return Result of the CreateApplication operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistencies with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the set limits for your Amazon Q Business service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.CreateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CreateApplication" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateApplicationResponse createApplication(CreateApplicationRequest createApplicationRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateApplicationResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateApplicationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createApplicationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createApplicationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateApplication");

            return clientHandler.execute(new ClientExecutionParams<CreateApplicationRequest, CreateApplicationResponse>()
                    .withOperationName("CreateApplication").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createApplicationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateApplicationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new chat response configuration for an Amazon Q Business application. This operation establishes a set
     * of parameters that define how the system generates and formats responses to user queries in chat interactions.
     * </p>
     *
     * @param createChatResponseConfigurationRequest
     * @return Result of the CreateChatResponseConfiguration operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistencies with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the set limits for your Amazon Q Business service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.CreateChatResponseConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CreateChatResponseConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateChatResponseConfigurationResponse createChatResponseConfiguration(
            CreateChatResponseConfigurationRequest createChatResponseConfigurationRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateChatResponseConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateChatResponseConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createChatResponseConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createChatResponseConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateChatResponseConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateChatResponseConfigurationRequest, CreateChatResponseConfigurationResponse>()
                            .withOperationName("CreateChatResponseConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createChatResponseConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateChatResponseConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new data accessor for an ISV to access data from a Amazon Q Business application. The data accessor is
     * an entity that represents the ISV's access to the Amazon Q Business application's data. It includes the IAM role
     * ARN for the ISV, a friendly name, and a set of action configurations that define the specific actions the ISV is
     * allowed to perform and any associated data filters. When the data accessor is created, an IAM Identity Center
     * application is also created to manage the ISV's identity and authentication for accessing the Amazon Q Business
     * application.
     * </p>
     *
     * @param createDataAccessorRequest
     * @return Result of the CreateDataAccessor operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistencies with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the set limits for your Amazon Q Business service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.CreateDataAccessor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CreateDataAccessor" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateDataAccessorResponse createDataAccessor(CreateDataAccessorRequest createDataAccessorRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateDataAccessorResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateDataAccessorResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDataAccessorRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDataAccessorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDataAccessor");

            return clientHandler.execute(new ClientExecutionParams<CreateDataAccessorRequest, CreateDataAccessorResponse>()
                    .withOperationName("CreateDataAccessor").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createDataAccessorRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateDataAccessorRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a data source connector for an Amazon Q Business application.
     * </p>
     * <p>
     * <code>CreateDataSource</code> is a synchronous operation. The operation returns 200 if the data source was
     * successfully created. Otherwise, an exception is raised.
     * </p>
     *
     * @param createDataSourceRequest
     * @return Result of the CreateDataSource operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistencies with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the set limits for your Amazon Q Business service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.CreateDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CreateDataSource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateDataSourceResponse createDataSource(CreateDataSourceRequest createDataSourceRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateDataSourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateDataSourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDataSourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDataSourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDataSource");

            return clientHandler.execute(new ClientExecutionParams<CreateDataSourceRequest, CreateDataSourceResponse>()
                    .withOperationName("CreateDataSource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createDataSourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateDataSourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an Amazon Q Business index.
     * </p>
     * <p>
     * To determine if index creation has completed, check the <code>Status</code> field returned from a call to
     * <code>DescribeIndex</code>. The <code>Status</code> field is set to <code>ACTIVE</code> when the index is ready
     * to use.
     * </p>
     * <p>
     * Once the index is active, you can index your documents using the <a
     * href="https://docs.aws.amazon.com/amazonq/latest/api-reference/API_BatchPutDocument.html">
     * <code>BatchPutDocument</code> </a> API or the <a
     * href="https://docs.aws.amazon.com/amazonq/latest/api-reference/API_CreateDataSource.html">
     * <code>CreateDataSource</code> </a> API.
     * </p>
     *
     * @param createIndexRequest
     * @return Result of the CreateIndex operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistencies with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the set limits for your Amazon Q Business service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.CreateIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CreateIndex" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateIndexResponse createIndex(CreateIndexRequest createIndexRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateIndexResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateIndexResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createIndexRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createIndexRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateIndex");

            return clientHandler.execute(new ClientExecutionParams<CreateIndexRequest, CreateIndexResponse>()
                    .withOperationName("CreateIndex").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createIndexRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateIndexRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an Amazon Q Business plugin.
     * </p>
     *
     * @param createPluginRequest
     * @return Result of the CreatePlugin operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistencies with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the set limits for your Amazon Q Business service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.CreatePlugin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CreatePlugin" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreatePluginResponse createPlugin(CreatePluginRequest createPluginRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreatePluginResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreatePluginResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createPluginRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPluginRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePlugin");

            return clientHandler.execute(new ClientExecutionParams<CreatePluginRequest, CreatePluginResponse>()
                    .withOperationName("CreatePlugin").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createPluginRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreatePluginRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds a retriever to your Amazon Q Business application.
     * </p>
     *
     * @param createRetrieverRequest
     * @return Result of the CreateRetriever operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistencies with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the set limits for your Amazon Q Business service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.CreateRetriever
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CreateRetriever" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateRetrieverResponse createRetriever(CreateRetrieverRequest createRetrieverRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateRetrieverResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateRetrieverResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createRetrieverRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createRetrieverRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRetriever");

            return clientHandler.execute(new ClientExecutionParams<CreateRetrieverRequest, CreateRetrieverResponse>()
                    .withOperationName("CreateRetriever").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createRetrieverRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateRetrieverRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Subscribes an IAM Identity Center user or a group to a pricing tier for an Amazon Q Business application.
     * </p>
     * <p>
     * Amazon Q Business offers two subscription tiers: <code>Q_LITE</code> and <code>Q_BUSINESS</code>. Subscription
     * tier determines feature access for the user. For more information on subscriptions and pricing tiers, see <a
     * href="https://aws.amazon.com/q/business/pricing/">Amazon Q Business pricing</a>.
     * </p>
     * <note>
     * <p>
     * For an example IAM role policy for assigning subscriptions, see <a
     * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/setting-up.html#permissions">Set up required
     * permissions</a> in the Amazon Q Business User Guide.
     * </p>
     * </note>
     *
     * @param createSubscriptionRequest
     * @return Result of the CreateSubscription operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistencies with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.CreateSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CreateSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateSubscriptionResponse createSubscription(CreateSubscriptionRequest createSubscriptionRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateSubscriptionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateSubscriptionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createSubscriptionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSubscriptionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSubscription");

            return clientHandler.execute(new ClientExecutionParams<CreateSubscriptionRequest, CreateSubscriptionResponse>()
                    .withOperationName("CreateSubscription").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createSubscriptionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateSubscriptionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a universally unique identifier (UUID) mapped to a list of local user ids within an application.
     * </p>
     *
     * @param createUserRequest
     * @return Result of the CreateUser operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistencies with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the set limits for your Amazon Q Business service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.CreateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CreateUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateUserResponse createUser(CreateUserRequest createUserRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateUserResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateUserResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateUser");

            return clientHandler.execute(new ClientExecutionParams<CreateUserRequest, CreateUserResponse>()
                    .withOperationName("CreateUser").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createUserRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateUserRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an Amazon Q Business web experience.
     * </p>
     *
     * @param createWebExperienceRequest
     * @return Result of the CreateWebExperience operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistencies with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the set limits for your Amazon Q Business service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.CreateWebExperience
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CreateWebExperience" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateWebExperienceResponse createWebExperience(CreateWebExperienceRequest createWebExperienceRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateWebExperienceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateWebExperienceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createWebExperienceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createWebExperienceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateWebExperience");

            return clientHandler.execute(new ClientExecutionParams<CreateWebExperienceRequest, CreateWebExperienceResponse>()
                    .withOperationName("CreateWebExperience").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createWebExperienceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateWebExperienceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an Amazon Q Business application.
     * </p>
     *
     * @param deleteApplicationRequest
     * @return Result of the DeleteApplication operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistencies with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.DeleteApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteApplication" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteApplicationResponse deleteApplication(DeleteApplicationRequest deleteApplicationRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteApplicationResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteApplicationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteApplicationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteApplicationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteApplication");

            return clientHandler.execute(new ClientExecutionParams<DeleteApplicationRequest, DeleteApplicationResponse>()
                    .withOperationName("DeleteApplication").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteApplicationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteApplicationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an attachment associated with a specific Amazon Q Business conversation.
     * </p>
     *
     * @param deleteAttachmentRequest
     * @return Result of the DeleteAttachment operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws LicenseNotFoundException
     *         You don't have permissions to perform the action because your license is inactive. Ask your admin to
     *         activate your license and try again after your licence is active.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.DeleteAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteAttachment" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteAttachmentResponse deleteAttachment(DeleteAttachmentRequest deleteAttachmentRequest)
            throws InternalServerException, ResourceNotFoundException, LicenseNotFoundException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAttachmentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteAttachmentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAttachmentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAttachmentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAttachment");

            return clientHandler.execute(new ClientExecutionParams<DeleteAttachmentRequest, DeleteAttachmentResponse>()
                    .withOperationName("DeleteAttachment").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteAttachmentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteAttachmentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes chat controls configured for an existing Amazon Q Business application.
     * </p>
     *
     * @param deleteChatControlsConfigurationRequest
     * @return Result of the DeleteChatControlsConfiguration operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.DeleteChatControlsConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteChatControlsConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteChatControlsConfigurationResponse deleteChatControlsConfiguration(
            DeleteChatControlsConfigurationRequest deleteChatControlsConfigurationRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteChatControlsConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteChatControlsConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteChatControlsConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteChatControlsConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteChatControlsConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteChatControlsConfigurationRequest, DeleteChatControlsConfigurationResponse>()
                            .withOperationName("DeleteChatControlsConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteChatControlsConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteChatControlsConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a specified chat response configuration from an Amazon Q Business application.
     * </p>
     *
     * @param deleteChatResponseConfigurationRequest
     * @return Result of the DeleteChatResponseConfiguration operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistencies with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.DeleteChatResponseConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteChatResponseConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteChatResponseConfigurationResponse deleteChatResponseConfiguration(
            DeleteChatResponseConfigurationRequest deleteChatResponseConfigurationRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteChatResponseConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteChatResponseConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteChatResponseConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteChatResponseConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteChatResponseConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteChatResponseConfigurationRequest, DeleteChatResponseConfigurationResponse>()
                            .withOperationName("DeleteChatResponseConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteChatResponseConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteChatResponseConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an Amazon Q Business web experience conversation.
     * </p>
     *
     * @param deleteConversationRequest
     * @return Result of the DeleteConversation operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistencies with your resources and try again.
     * @throws LicenseNotFoundException
     *         You don't have permissions to perform the action because your license is inactive. Ask your admin to
     *         activate your license and try again after your licence is active.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.DeleteConversation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteConversation" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteConversationResponse deleteConversation(DeleteConversationRequest deleteConversationRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, LicenseNotFoundException,
            ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteConversationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteConversationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteConversationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteConversationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteConversation");

            return clientHandler.execute(new ClientExecutionParams<DeleteConversationRequest, DeleteConversationResponse>()
                    .withOperationName("DeleteConversation").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteConversationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteConversationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a specified data accessor. This operation permanently removes the data accessor and its associated IAM
     * Identity Center application. Any access granted to the ISV through this data accessor will be revoked.
     * </p>
     *
     * @param deleteDataAccessorRequest
     * @return Result of the DeleteDataAccessor operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistencies with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.DeleteDataAccessor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteDataAccessor" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteDataAccessorResponse deleteDataAccessor(DeleteDataAccessorRequest deleteDataAccessorRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteDataAccessorResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteDataAccessorResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDataAccessorRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDataAccessorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDataAccessor");

            return clientHandler.execute(new ClientExecutionParams<DeleteDataAccessorRequest, DeleteDataAccessorResponse>()
                    .withOperationName("DeleteDataAccessor").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteDataAccessorRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteDataAccessorRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an Amazon Q Business data source connector. While the data source is being deleted, the
     * <code>Status</code> field returned by a call to the <code>DescribeDataSource</code> API is set to
     * <code>DELETING</code>.
     * </p>
     *
     * @param deleteDataSourceRequest
     * @return Result of the DeleteDataSource operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistencies with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.DeleteDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteDataSource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteDataSourceResponse deleteDataSource(DeleteDataSourceRequest deleteDataSourceRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteDataSourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteDataSourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDataSourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDataSourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDataSource");

            return clientHandler.execute(new ClientExecutionParams<DeleteDataSourceRequest, DeleteDataSourceResponse>()
                    .withOperationName("DeleteDataSource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteDataSourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteDataSourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a group so that all users and sub groups that belong to the group can no longer access documents only
     * available to that group. For example, after deleting the group "Summer Interns", all interns who belonged to that
     * group no longer see intern-only documents in their chat results.
     * </p>
     * <p>
     * If you want to delete, update, or replace users or sub groups of a group, you need to use the
     * <code>PutGroup</code> operation. For example, if a user in the group "Engineering" leaves the engineering team
     * and another user takes their place, you provide an updated list of users or sub groups that belong to the
     * "Engineering" group when calling <code>PutGroup</code>.
     * </p>
     *
     * @param deleteGroupRequest
     * @return Result of the DeleteGroup operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistencies with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.DeleteGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteGroupResponse deleteGroup(DeleteGroupRequest deleteGroupRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteGroup");

            return clientHandler.execute(new ClientExecutionParams<DeleteGroupRequest, DeleteGroupResponse>()
                    .withOperationName("DeleteGroup").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteGroupRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an Amazon Q Business index.
     * </p>
     *
     * @param deleteIndexRequest
     * @return Result of the DeleteIndex operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistencies with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.DeleteIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteIndex" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteIndexResponse deleteIndex(DeleteIndexRequest deleteIndexRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteIndexResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteIndexResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteIndexRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteIndexRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteIndex");

            return clientHandler.execute(new ClientExecutionParams<DeleteIndexRequest, DeleteIndexResponse>()
                    .withOperationName("DeleteIndex").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteIndexRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteIndexRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an Amazon Q Business plugin.
     * </p>
     *
     * @param deletePluginRequest
     * @return Result of the DeletePlugin operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistencies with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.DeletePlugin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeletePlugin" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeletePluginResponse deletePlugin(DeletePluginRequest deletePluginRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeletePluginResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeletePluginResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deletePluginRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deletePluginRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePlugin");

            return clientHandler.execute(new ClientExecutionParams<DeletePluginRequest, DeletePluginResponse>()
                    .withOperationName("DeletePlugin").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deletePluginRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeletePluginRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the retriever used by an Amazon Q Business application.
     * </p>
     *
     * @param deleteRetrieverRequest
     * @return Result of the DeleteRetriever operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistencies with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.DeleteRetriever
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteRetriever" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteRetrieverResponse deleteRetriever(DeleteRetrieverRequest deleteRetrieverRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteRetrieverResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteRetrieverResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteRetrieverRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRetrieverRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRetriever");

            return clientHandler.execute(new ClientExecutionParams<DeleteRetrieverRequest, DeleteRetrieverResponse>()
                    .withOperationName("DeleteRetriever").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteRetrieverRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteRetrieverRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a user by email id.
     * </p>
     *
     * @param deleteUserRequest
     * @return Result of the DeleteUser operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistencies with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.DeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteUserResponse deleteUser(DeleteUserRequest deleteUserRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteUserResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteUserResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteUser");

            return clientHandler.execute(new ClientExecutionParams<DeleteUserRequest, DeleteUserResponse>()
                    .withOperationName("DeleteUser").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteUserRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteUserRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an Amazon Q Business web experience.
     * </p>
     *
     * @param deleteWebExperienceRequest
     * @return Result of the DeleteWebExperience operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistencies with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.DeleteWebExperience
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteWebExperience" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteWebExperienceResponse deleteWebExperience(DeleteWebExperienceRequest deleteWebExperienceRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteWebExperienceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteWebExperienceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteWebExperienceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteWebExperienceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteWebExperience");

            return clientHandler.execute(new ClientExecutionParams<DeleteWebExperienceRequest, DeleteWebExperienceResponse>()
                    .withOperationName("DeleteWebExperience").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteWebExperienceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteWebExperienceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes a permission policy from a Amazon Q Business application, revoking the cross-account access that was
     * previously granted to an ISV. This operation deletes the specified policy statement from the application's
     * permission policy.
     * </p>
     *
     * @param disassociatePermissionRequest
     * @return Result of the DisassociatePermission operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistencies with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.DisassociatePermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DisassociatePermission"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociatePermissionResponse disassociatePermission(DisassociatePermissionRequest disassociatePermissionRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociatePermissionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DisassociatePermissionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociatePermissionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disassociatePermissionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociatePermission");

            return clientHandler
                    .execute(new ClientExecutionParams<DisassociatePermissionRequest, DisassociatePermissionResponse>()
                            .withOperationName("DisassociatePermission").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(disassociatePermissionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DisassociatePermissionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about an existing Amazon Q Business application.
     * </p>
     *
     * @param getApplicationRequest
     * @return Result of the GetApplication operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.GetApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetApplication" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetApplicationResponse getApplication(GetApplicationRequest getApplicationRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetApplicationResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetApplicationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getApplicationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getApplicationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetApplication");

            return clientHandler.execute(new ClientExecutionParams<GetApplicationRequest, GetApplicationResponse>()
                    .withOperationName("GetApplication").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getApplicationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetApplicationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about chat controls configured for an existing Amazon Q Business application.
     * </p>
     *
     * @param getChatControlsConfigurationRequest
     * @return Result of the GetChatControlsConfiguration operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.GetChatControlsConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetChatControlsConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetChatControlsConfigurationResponse getChatControlsConfiguration(
            GetChatControlsConfigurationRequest getChatControlsConfigurationRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetChatControlsConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetChatControlsConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getChatControlsConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getChatControlsConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetChatControlsConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<GetChatControlsConfigurationRequest, GetChatControlsConfigurationResponse>()
                            .withOperationName("GetChatControlsConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getChatControlsConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetChatControlsConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves detailed information about a specific chat response configuration from an Amazon Q Business
     * application. This operation returns the complete configuration settings and metadata.
     * </p>
     *
     * @param getChatResponseConfigurationRequest
     * @return Result of the GetChatResponseConfiguration operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.GetChatResponseConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetChatResponseConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetChatResponseConfigurationResponse getChatResponseConfiguration(
            GetChatResponseConfigurationRequest getChatResponseConfigurationRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetChatResponseConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetChatResponseConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getChatResponseConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getChatResponseConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetChatResponseConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<GetChatResponseConfigurationRequest, GetChatResponseConfigurationResponse>()
                            .withOperationName("GetChatResponseConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getChatResponseConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetChatResponseConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about a specified data accessor. This operation returns details about the data accessor,
     * including its display name, unique identifier, Amazon Resource Name (ARN), the associated Amazon Q Business
     * application and IAM Identity Center application, the IAM role for the ISV, the action configurations, and the
     * timestamps for when the data accessor was created and last updated.
     * </p>
     *
     * @param getDataAccessorRequest
     * @return Result of the GetDataAccessor operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.GetDataAccessor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetDataAccessor" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetDataAccessorResponse getDataAccessor(GetDataAccessorRequest getDataAccessorRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDataAccessorResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetDataAccessorResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDataAccessorRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDataAccessorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDataAccessor");

            return clientHandler.execute(new ClientExecutionParams<GetDataAccessorRequest, GetDataAccessorResponse>()
                    .withOperationName("GetDataAccessor").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getDataAccessorRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetDataAccessorRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about an existing Amazon Q Business data source connector.
     * </p>
     *
     * @param getDataSourceRequest
     * @return Result of the GetDataSource operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.GetDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetDataSourceResponse getDataSource(GetDataSourceRequest getDataSourceRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDataSourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetDataSourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDataSourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDataSourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDataSource");

            return clientHandler.execute(new ClientExecutionParams<GetDataSourceRequest, GetDataSourceResponse>()
                    .withOperationName("GetDataSource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getDataSourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetDataSourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the content of a document that was ingested into Amazon Q Business. This API validates user
     * authorization against document ACLs before returning a pre-signed URL for secure document access. You can
     * download or view source documents referenced in chat responses through the URL.
     * </p>
     *
     * @param getDocumentContentRequest
     * @return Result of the GetDocumentContent operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.GetDocumentContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetDocumentContent" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetDocumentContentResponse getDocumentContent(GetDocumentContentRequest getDocumentContentRequest)
            throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDocumentContentResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetDocumentContentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDocumentContentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDocumentContentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDocumentContent");

            return clientHandler.execute(new ClientExecutionParams<GetDocumentContentRequest, GetDocumentContentResponse>()
                    .withOperationName("GetDocumentContent").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getDocumentContentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetDocumentContentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes a group by group name.
     * </p>
     *
     * @param getGroupRequest
     * @return Result of the GetGroup operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistencies with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.GetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetGroupResponse getGroup(GetGroupRequest getGroupRequest) throws InternalServerException, ResourceNotFoundException,
            ConflictException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetGroup");

            return clientHandler.execute(new ClientExecutionParams<GetGroupRequest, GetGroupResponse>()
                    .withOperationName("GetGroup").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getGroupRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about an existing Amazon Q Business index.
     * </p>
     *
     * @param getIndexRequest
     * @return Result of the GetIndex operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.GetIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetIndex" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetIndexResponse getIndex(GetIndexRequest getIndexRequest) throws InternalServerException, ResourceNotFoundException,
            ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetIndexResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetIndexResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getIndexRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getIndexRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetIndex");

            return clientHandler.execute(new ClientExecutionParams<GetIndexRequest, GetIndexResponse>()
                    .withOperationName("GetIndex").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getIndexRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetIndexRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the image bytes corresponding to a media object. If you have implemented your own application with the
     * Chat and ChatSync APIs, and have enabled content extraction from visual data in Amazon Q Business, you use the
     * GetMedia API operation to download the images so you can show them in your UI with responses.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/extracting-meaning-from-images.html">Extracting
     * semantic meaning from images and visuals</a>.
     * </p>
     *
     * @param getMediaRequest
     * @return Result of the GetMedia operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws LicenseNotFoundException
     *         You don't have permissions to perform the action because your license is inactive. Ask your admin to
     *         activate your license and try again after your licence is active.
     * @throws MediaTooLargeException
     *         The requested media object is too large to be returned.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.GetMedia
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetMedia" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetMediaResponse getMedia(GetMediaRequest getMediaRequest) throws InternalServerException, ResourceNotFoundException,
            LicenseNotFoundException, MediaTooLargeException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetMediaResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetMediaResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getMediaRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMediaRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMedia");

            return clientHandler.execute(new ClientExecutionParams<GetMediaRequest, GetMediaResponse>()
                    .withOperationName("GetMedia").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getMediaRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetMediaRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about an existing Amazon Q Business plugin.
     * </p>
     *
     * @param getPluginRequest
     * @return Result of the GetPlugin operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.GetPlugin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetPlugin" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetPluginResponse getPlugin(GetPluginRequest getPluginRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetPluginResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetPluginResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getPluginRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getPluginRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPlugin");

            return clientHandler.execute(new ClientExecutionParams<GetPluginRequest, GetPluginResponse>()
                    .withOperationName("GetPlugin").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getPluginRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetPluginRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the current permission policy for a Amazon Q Business application. The policy is returned as a
     * JSON-formatted string and defines the IAM actions that are allowed or denied for the application's resources.
     * </p>
     *
     * @param getPolicyRequest
     * @return Result of the GetPolicy operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.GetPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetPolicyResponse getPolicy(GetPolicyRequest getPolicyRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetPolicyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetPolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPolicy");

            return clientHandler.execute(new ClientExecutionParams<GetPolicyRequest, GetPolicyResponse>()
                    .withOperationName("GetPolicy").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getPolicyRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about an existing retriever used by an Amazon Q Business application.
     * </p>
     *
     * @param getRetrieverRequest
     * @return Result of the GetRetriever operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.GetRetriever
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetRetriever" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetRetrieverResponse getRetriever(GetRetrieverRequest getRetrieverRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetRetrieverResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetRetrieverResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getRetrieverRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRetrieverRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRetriever");

            return clientHandler.execute(new ClientExecutionParams<GetRetrieverRequest, GetRetrieverResponse>()
                    .withOperationName("GetRetriever").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getRetrieverRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetRetrieverRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the universally unique identifier (UUID) associated with a local user in a data source.
     * </p>
     *
     * @param getUserRequest
     * @return Result of the GetUser operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistencies with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.GetUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetUserResponse getUser(GetUserRequest getUserRequest) throws InternalServerException, ResourceNotFoundException,
            ConflictException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetUserResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetUserResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetUser");

            return clientHandler.execute(new ClientExecutionParams<GetUserRequest, GetUserResponse>()
                    .withOperationName("GetUser").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getUserRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetUserRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about an existing Amazon Q Business web experience.
     * </p>
     *
     * @param getWebExperienceRequest
     * @return Result of the GetWebExperience operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.GetWebExperience
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetWebExperience" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetWebExperienceResponse getWebExperience(GetWebExperienceRequest getWebExperienceRequest)
            throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetWebExperienceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetWebExperienceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getWebExperienceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getWebExperienceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetWebExperience");

            return clientHandler.execute(new ClientExecutionParams<GetWebExperienceRequest, GetWebExperienceResponse>()
                    .withOperationName("GetWebExperience").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getWebExperienceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetWebExperienceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists Amazon Q Business applications.
     * </p>
     * <note>
     * <p>
     * Amazon Q Business applications may securely transmit data for processing across Amazon Web Services Regions
     * within your geography. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/cross-region-inference.html">Cross region inference
     * in Amazon Q Business</a>.
     * </p>
     * </note>
     *
     * @param listApplicationsRequest
     * @return Result of the ListApplications operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListApplications" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListApplicationsResponse listApplications(ListApplicationsRequest listApplicationsRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListApplicationsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListApplicationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listApplicationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listApplicationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListApplications");

            return clientHandler.execute(new ClientExecutionParams<ListApplicationsRequest, ListApplicationsResponse>()
                    .withOperationName("ListApplications").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listApplicationsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListApplicationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a list of attachments associated with an Amazon Q Business web experience or a list of attachements
     * associated with a specific Amazon Q Business conversation.
     * </p>
     *
     * @param listAttachmentsRequest
     * @return Result of the ListAttachments operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws LicenseNotFoundException
     *         You don't have permissions to perform the action because your license is inactive. Ask your admin to
     *         activate your license and try again after your licence is active.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ListAttachments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListAttachments" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListAttachmentsResponse listAttachments(ListAttachmentsRequest listAttachmentsRequest) throws InternalServerException,
            ResourceNotFoundException, LicenseNotFoundException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAttachmentsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListAttachmentsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAttachmentsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAttachmentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAttachments");

            return clientHandler.execute(new ClientExecutionParams<ListAttachmentsRequest, ListAttachmentsResponse>()
                    .withOperationName("ListAttachments").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listAttachmentsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListAttachmentsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of all chat response configurations available in a specified Amazon Q Business application. This
     * operation returns summary information about each configuration to help administrators manage and select
     * appropriate response settings.
     * </p>
     *
     * @param listChatResponseConfigurationsRequest
     * @return Result of the ListChatResponseConfigurations operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ListChatResponseConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListChatResponseConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListChatResponseConfigurationsResponse listChatResponseConfigurations(
            ListChatResponseConfigurationsRequest listChatResponseConfigurationsRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListChatResponseConfigurationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListChatResponseConfigurationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listChatResponseConfigurationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listChatResponseConfigurationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListChatResponseConfigurations");

            return clientHandler
                    .execute(new ClientExecutionParams<ListChatResponseConfigurationsRequest, ListChatResponseConfigurationsResponse>()
                            .withOperationName("ListChatResponseConfigurations").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listChatResponseConfigurationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListChatResponseConfigurationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists one or more Amazon Q Business conversations.
     * </p>
     *
     * @param listConversationsRequest
     * @return Result of the ListConversations operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws LicenseNotFoundException
     *         You don't have permissions to perform the action because your license is inactive. Ask your admin to
     *         activate your license and try again after your licence is active.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ListConversations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListConversations" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListConversationsResponse listConversations(ListConversationsRequest listConversationsRequest)
            throws InternalServerException, ResourceNotFoundException, LicenseNotFoundException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListConversationsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListConversationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listConversationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listConversationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListConversations");

            return clientHandler.execute(new ClientExecutionParams<ListConversationsRequest, ListConversationsResponse>()
                    .withOperationName("ListConversations").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listConversationsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListConversationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the data accessors for a Amazon Q Business application. This operation returns a paginated list of data
     * accessor summaries, including the friendly name, unique identifier, ARN, associated IAM role, and creation/update
     * timestamps for each data accessor.
     * </p>
     *
     * @param listDataAccessorsRequest
     * @return Result of the ListDataAccessors operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ListDataAccessors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListDataAccessors" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListDataAccessorsResponse listDataAccessors(ListDataAccessorsRequest listDataAccessorsRequest)
            throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListDataAccessorsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListDataAccessorsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDataAccessorsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDataAccessorsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDataAccessors");

            return clientHandler.execute(new ClientExecutionParams<ListDataAccessorsRequest, ListDataAccessorsResponse>()
                    .withOperationName("ListDataAccessors").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listDataAccessorsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListDataAccessorsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get information about an Amazon Q Business data source connector synchronization.
     * </p>
     *
     * @param listDataSourceSyncJobsRequest
     * @return Result of the ListDataSourceSyncJobs operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistencies with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ListDataSourceSyncJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListDataSourceSyncJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListDataSourceSyncJobsResponse listDataSourceSyncJobs(ListDataSourceSyncJobsRequest listDataSourceSyncJobsRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListDataSourceSyncJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListDataSourceSyncJobsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDataSourceSyncJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDataSourceSyncJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDataSourceSyncJobs");

            return clientHandler
                    .execute(new ClientExecutionParams<ListDataSourceSyncJobsRequest, ListDataSourceSyncJobsResponse>()
                            .withOperationName("ListDataSourceSyncJobs").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listDataSourceSyncJobsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListDataSourceSyncJobsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the Amazon Q Business data source connectors that you have created.
     * </p>
     *
     * @param listDataSourcesRequest
     * @return Result of the ListDataSources operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ListDataSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListDataSources" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListDataSourcesResponse listDataSources(ListDataSourcesRequest listDataSourcesRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListDataSourcesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListDataSourcesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDataSourcesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDataSourcesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDataSources");

            return clientHandler.execute(new ClientExecutionParams<ListDataSourcesRequest, ListDataSourcesResponse>()
                    .withOperationName("ListDataSources").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listDataSourcesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListDataSourcesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * A list of documents attached to an index.
     * </p>
     *
     * @param listDocumentsRequest
     * @return Result of the ListDocuments operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ListDocuments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListDocuments" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListDocumentsResponse listDocuments(ListDocumentsRequest listDocumentsRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListDocumentsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListDocumentsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDocumentsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDocumentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDocuments");

            return clientHandler.execute(new ClientExecutionParams<ListDocumentsRequest, ListDocumentsResponse>()
                    .withOperationName("ListDocuments").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listDocumentsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListDocumentsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Provides a list of groups that are mapped to users.
     * </p>
     *
     * @param listGroupsRequest
     * @return Result of the ListGroups operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistencies with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ListGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListGroupsResponse listGroups(ListGroupsRequest listGroupsRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListGroupsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListGroupsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listGroupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListGroups");

            return clientHandler.execute(new ClientExecutionParams<ListGroupsRequest, ListGroupsResponse>()
                    .withOperationName("ListGroups").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(listGroupsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListGroupsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the Amazon Q Business indices you have created.
     * </p>
     *
     * @param listIndicesRequest
     * @return Result of the ListIndices operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ListIndices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListIndices" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListIndicesResponse listIndices(ListIndicesRequest listIndicesRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListIndicesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListIndicesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listIndicesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listIndicesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListIndices");

            return clientHandler.execute(new ClientExecutionParams<ListIndicesRequest, ListIndicesResponse>()
                    .withOperationName("ListIndices").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(listIndicesRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListIndicesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a list of messages associated with an Amazon Q Business web experience.
     * </p>
     *
     * @param listMessagesRequest
     * @return Result of the ListMessages operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws LicenseNotFoundException
     *         You don't have permissions to perform the action because your license is inactive. Ask your admin to
     *         activate your license and try again after your licence is active.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ListMessages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListMessages" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListMessagesResponse listMessages(ListMessagesRequest listMessagesRequest) throws InternalServerException,
            ResourceNotFoundException, LicenseNotFoundException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListMessagesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListMessagesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listMessagesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMessagesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMessages");

            return clientHandler.execute(new ClientExecutionParams<ListMessagesRequest, ListMessagesResponse>()
                    .withOperationName("ListMessages").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listMessagesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListMessagesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists configured Amazon Q Business actions for a specific plugin in an Amazon Q Business application.
     * </p>
     *
     * @param listPluginActionsRequest
     * @return Result of the ListPluginActions operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ListPluginActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListPluginActions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListPluginActionsResponse listPluginActions(ListPluginActionsRequest listPluginActionsRequest)
            throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListPluginActionsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListPluginActionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listPluginActionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listPluginActionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPluginActions");

            return clientHandler.execute(new ClientExecutionParams<ListPluginActionsRequest, ListPluginActionsResponse>()
                    .withOperationName("ListPluginActions").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listPluginActionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListPluginActionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists configured Amazon Q Business actions for any plugin type—both built-in and custom.
     * </p>
     *
     * @param listPluginTypeActionsRequest
     * @return Result of the ListPluginTypeActions operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ListPluginTypeActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListPluginTypeActions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListPluginTypeActionsResponse listPluginTypeActions(ListPluginTypeActionsRequest listPluginTypeActionsRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListPluginTypeActionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListPluginTypeActionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listPluginTypeActionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listPluginTypeActionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPluginTypeActions");

            return clientHandler.execute(new ClientExecutionParams<ListPluginTypeActionsRequest, ListPluginTypeActionsResponse>()
                    .withOperationName("ListPluginTypeActions").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listPluginTypeActionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListPluginTypeActionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists metadata for all Amazon Q Business plugin types.
     * </p>
     *
     * @param listPluginTypeMetadataRequest
     * @return Result of the ListPluginTypeMetadata operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ListPluginTypeMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListPluginTypeMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListPluginTypeMetadataResponse listPluginTypeMetadata(ListPluginTypeMetadataRequest listPluginTypeMetadataRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListPluginTypeMetadataResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListPluginTypeMetadataResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listPluginTypeMetadataRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listPluginTypeMetadataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPluginTypeMetadata");

            return clientHandler
                    .execute(new ClientExecutionParams<ListPluginTypeMetadataRequest, ListPluginTypeMetadataResponse>()
                            .withOperationName("ListPluginTypeMetadata").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listPluginTypeMetadataRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListPluginTypeMetadataRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists configured Amazon Q Business plugins.
     * </p>
     *
     * @param listPluginsRequest
     * @return Result of the ListPlugins operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ListPlugins
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListPlugins" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListPluginsResponse listPlugins(ListPluginsRequest listPluginsRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListPluginsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListPluginsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listPluginsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listPluginsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPlugins");

            return clientHandler.execute(new ClientExecutionParams<ListPluginsRequest, ListPluginsResponse>()
                    .withOperationName("ListPlugins").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(listPluginsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListPluginsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the retriever used by an Amazon Q Business application.
     * </p>
     *
     * @param listRetrieversRequest
     * @return Result of the ListRetrievers operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ListRetrievers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListRetrievers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListRetrieversResponse listRetrievers(ListRetrieversRequest listRetrieversRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListRetrieversResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListRetrieversResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listRetrieversRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listRetrieversRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRetrievers");

            return clientHandler.execute(new ClientExecutionParams<ListRetrieversRequest, ListRetrieversResponse>()
                    .withOperationName("ListRetrievers").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listRetrieversRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListRetrieversRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all subscriptions created in an Amazon Q Business application.
     * </p>
     *
     * @param listSubscriptionsRequest
     * @return Result of the ListSubscriptions operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistencies with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ListSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListSubscriptions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListSubscriptionsResponse listSubscriptions(ListSubscriptionsRequest listSubscriptionsRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListSubscriptionsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListSubscriptionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listSubscriptionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSubscriptionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSubscriptions");

            return clientHandler.execute(new ClientExecutionParams<ListSubscriptionsRequest, ListSubscriptionsResponse>()
                    .withOperationName("ListSubscriptions").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listSubscriptionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListSubscriptionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a list of tags associated with a specified resource. Amazon Q Business applications and data sources can
     * have tags associated with them.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTagsForResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                    .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listTagsForResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists one or more Amazon Q Business Web Experiences.
     * </p>
     *
     * @param listWebExperiencesRequest
     * @return Result of the ListWebExperiences operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.ListWebExperiences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListWebExperiences" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListWebExperiencesResponse listWebExperiences(ListWebExperiencesRequest listWebExperiencesRequest)
            throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListWebExperiencesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListWebExperiencesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listWebExperiencesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listWebExperiencesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListWebExperiences");

            return clientHandler.execute(new ClientExecutionParams<ListWebExperiencesRequest, ListWebExperiencesResponse>()
                    .withOperationName("ListWebExperiences").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listWebExperiencesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListWebExperiencesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Enables your end user to provide feedback on their Amazon Q Business generated chat responses.
     * </p>
     *
     * @param putFeedbackRequest
     * @return Result of the PutFeedback operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.PutFeedback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/PutFeedback" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public PutFeedbackResponse putFeedback(PutFeedbackRequest putFeedbackRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutFeedbackResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                PutFeedbackResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putFeedbackRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putFeedbackRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutFeedback");

            return clientHandler.execute(new ClientExecutionParams<PutFeedbackRequest, PutFeedbackResponse>()
                    .withOperationName("PutFeedback").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(putFeedbackRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PutFeedbackRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Create, or updates, a mapping of users—who have access to a document—to groups.
     * </p>
     * <p>
     * You can also map sub groups to groups. For example, the group "Company Intellectual Property Teams" includes sub
     * groups "Research" and "Engineering". These sub groups include their own list of users or people who work in these
     * teams. Only users who work in research and engineering, and therefore belong in the intellectual property group,
     * can see top-secret company documents in their Amazon Q Business chat results.
     * </p>
     * <p>
     * There are two options for creating groups, either passing group members inline or using an S3 file via the
     * S3PathForGroupMembers field. For inline groups, there is a limit of 1000 members per group and for provided S3
     * files there is a limit of 100 thousand members. When creating a group using an S3 file, you provide both an S3
     * file and a <code>RoleArn</code> for Amazon Q Buisness to access the file.
     * </p>
     *
     * @param putGroupRequest
     * @return Result of the PutGroup operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistencies with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the set limits for your Amazon Q Business service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.PutGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/PutGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public PutGroupResponse putGroup(PutGroupRequest putGroupRequest) throws InternalServerException, ResourceNotFoundException,
            ConflictException, ThrottlingException, ValidationException, AccessDeniedException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                PutGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutGroup");

            return clientHandler.execute(new ClientExecutionParams<PutGroupRequest, PutGroupResponse>()
                    .withOperationName("PutGroup").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(putGroupRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PutGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Searches for relevant content in a Amazon Q Business application based on a query. This operation takes a search
     * query text, the Amazon Q Business application identifier, and optional filters (such as content source and
     * maximum results) as input. It returns a list of relevant content items, where each item includes the content
     * text, the unique document identifier, the document title, the document URI, any relevant document attributes, and
     * score attributes indicating the confidence level of the relevance.
     * </p>
     *
     * @param searchRelevantContentRequest
     * @return Result of the SearchRelevantContent operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws LicenseNotFoundException
     *         You don't have permissions to perform the action because your license is inactive. Ask your admin to
     *         activate your license and try again after your licence is active.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.SearchRelevantContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/SearchRelevantContent"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public SearchRelevantContentResponse searchRelevantContent(SearchRelevantContentRequest searchRelevantContentRequest)
            throws InternalServerException, ResourceNotFoundException, LicenseNotFoundException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SearchRelevantContentResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, SearchRelevantContentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(searchRelevantContentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, searchRelevantContentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SearchRelevantContent");

            return clientHandler.execute(new ClientExecutionParams<SearchRelevantContentRequest, SearchRelevantContentResponse>()
                    .withOperationName("SearchRelevantContent").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(searchRelevantContentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new SearchRelevantContentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Starts a data source connector synchronization job. If a synchronization job is already in progress, Amazon Q
     * Business returns a <code>ConflictException</code>.
     * </p>
     *
     * @param startDataSourceSyncJobRequest
     * @return Result of the StartDataSourceSyncJob operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistencies with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the set limits for your Amazon Q Business service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.StartDataSourceSyncJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/StartDataSourceSyncJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StartDataSourceSyncJobResponse startDataSourceSyncJob(StartDataSourceSyncJobRequest startDataSourceSyncJobRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartDataSourceSyncJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartDataSourceSyncJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startDataSourceSyncJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startDataSourceSyncJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartDataSourceSyncJob");

            return clientHandler
                    .execute(new ClientExecutionParams<StartDataSourceSyncJobRequest, StartDataSourceSyncJobResponse>()
                            .withOperationName("StartDataSourceSyncJob").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(startDataSourceSyncJobRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new StartDataSourceSyncJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Stops an Amazon Q Business data source connector synchronization job already in progress.
     * </p>
     *
     * @param stopDataSourceSyncJobRequest
     * @return Result of the StopDataSourceSyncJob operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistencies with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.StopDataSourceSyncJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/StopDataSourceSyncJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StopDataSourceSyncJobResponse stopDataSourceSyncJob(StopDataSourceSyncJobRequest stopDataSourceSyncJobRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StopDataSourceSyncJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StopDataSourceSyncJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopDataSourceSyncJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopDataSourceSyncJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopDataSourceSyncJob");

            return clientHandler.execute(new ClientExecutionParams<StopDataSourceSyncJobRequest, StopDataSourceSyncJobResponse>()
                    .withOperationName("StopDataSourceSyncJob").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(stopDataSourceSyncJobRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StopDataSourceSyncJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds the specified tag to the specified Amazon Q Business application or data source resource. If the tag already
     * exists, the existing value is replaced with the new value.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistencies with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");

            return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                    .withOperationName("TagResource").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(tagResourceRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes a tag from an Amazon Q Business application or a data source.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");

            return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                    .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(untagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an existing Amazon Q Business application.
     * </p>
     * <note>
     * <p>
     * Amazon Q Business applications may securely transmit data for processing across Amazon Web Services Regions
     * within your geography. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/cross-region-inference.html">Cross region inference
     * in Amazon Q Business</a>.
     * </p>
     * </note> <note>
     * <p>
     * An Amazon Q Apps service-linked role will be created if it's absent in the Amazon Web Services account when
     * <code>QAppsConfiguration</code> is enabled in the request. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/using-service-linked-roles-qapps.html">Using
     * service-linked roles for Q Apps</a>.
     * </p>
     * </note>
     *
     * @param updateApplicationRequest
     * @return Result of the UpdateApplication operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistencies with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.UpdateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdateApplication" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateApplicationResponse updateApplication(UpdateApplicationRequest updateApplicationRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateApplicationResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateApplicationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateApplicationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateApplicationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateApplication");

            return clientHandler.execute(new ClientExecutionParams<UpdateApplicationRequest, UpdateApplicationResponse>()
                    .withOperationName("UpdateApplication").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateApplicationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateApplicationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a set of chat controls configured for an existing Amazon Q Business application.
     * </p>
     *
     * @param updateChatControlsConfigurationRequest
     * @return Result of the UpdateChatControlsConfiguration operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistencies with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the set limits for your Amazon Q Business service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.UpdateChatControlsConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdateChatControlsConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateChatControlsConfigurationResponse updateChatControlsConfiguration(
            UpdateChatControlsConfigurationRequest updateChatControlsConfigurationRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateChatControlsConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateChatControlsConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateChatControlsConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateChatControlsConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateChatControlsConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateChatControlsConfigurationRequest, UpdateChatControlsConfigurationResponse>()
                            .withOperationName("UpdateChatControlsConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateChatControlsConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateChatControlsConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an existing chat response configuration in an Amazon Q Business application. This operation allows
     * administrators to modify configuration settings, display name, and response parameters to refine how the system
     * generates responses.
     * </p>
     *
     * @param updateChatResponseConfigurationRequest
     * @return Result of the UpdateChatResponseConfiguration operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistencies with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.UpdateChatResponseConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdateChatResponseConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateChatResponseConfigurationResponse updateChatResponseConfiguration(
            UpdateChatResponseConfigurationRequest updateChatResponseConfigurationRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateChatResponseConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateChatResponseConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateChatResponseConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateChatResponseConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateChatResponseConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateChatResponseConfigurationRequest, UpdateChatResponseConfigurationResponse>()
                            .withOperationName("UpdateChatResponseConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateChatResponseConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateChatResponseConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an existing data accessor. This operation allows modifying the action configurations (the allowed actions
     * and associated filters) and the display name of the data accessor. It does not allow changing the IAM role
     * associated with the data accessor or other core properties of the data accessor.
     * </p>
     *
     * @param updateDataAccessorRequest
     * @return Result of the UpdateDataAccessor operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistencies with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.UpdateDataAccessor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdateDataAccessor" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateDataAccessorResponse updateDataAccessor(UpdateDataAccessorRequest updateDataAccessorRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateDataAccessorResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateDataAccessorResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateDataAccessorRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDataAccessorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDataAccessor");

            return clientHandler.execute(new ClientExecutionParams<UpdateDataAccessorRequest, UpdateDataAccessorResponse>()
                    .withOperationName("UpdateDataAccessor").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateDataAccessorRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateDataAccessorRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an existing Amazon Q Business data source connector.
     * </p>
     *
     * @param updateDataSourceRequest
     * @return Result of the UpdateDataSource operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistencies with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.UpdateDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdateDataSource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateDataSourceResponse updateDataSource(UpdateDataSourceRequest updateDataSourceRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateDataSourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateDataSourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateDataSourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDataSourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDataSource");

            return clientHandler.execute(new ClientExecutionParams<UpdateDataSourceRequest, UpdateDataSourceResponse>()
                    .withOperationName("UpdateDataSource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateDataSourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateDataSourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an Amazon Q Business index.
     * </p>
     *
     * @param updateIndexRequest
     * @return Result of the UpdateIndex operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistencies with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the set limits for your Amazon Q Business service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.UpdateIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdateIndex" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateIndexResponse updateIndex(UpdateIndexRequest updateIndexRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateIndexResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateIndexResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateIndexRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateIndexRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateIndex");

            return clientHandler.execute(new ClientExecutionParams<UpdateIndexRequest, UpdateIndexResponse>()
                    .withOperationName("UpdateIndex").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(updateIndexRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateIndexRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an Amazon Q Business plugin.
     * </p>
     *
     * @param updatePluginRequest
     * @return Result of the UpdatePlugin operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistencies with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the set limits for your Amazon Q Business service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.UpdatePlugin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdatePlugin" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdatePluginResponse updatePlugin(UpdatePluginRequest updatePluginRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdatePluginResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdatePluginResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updatePluginRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updatePluginRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdatePlugin");

            return clientHandler.execute(new ClientExecutionParams<UpdatePluginRequest, UpdatePluginResponse>()
                    .withOperationName("UpdatePlugin").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updatePluginRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdatePluginRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the retriever used for your Amazon Q Business application.
     * </p>
     *
     * @param updateRetrieverRequest
     * @return Result of the UpdateRetriever operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistencies with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the set limits for your Amazon Q Business service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.UpdateRetriever
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdateRetriever" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateRetrieverResponse updateRetriever(UpdateRetrieverRequest updateRetrieverRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateRetrieverResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateRetrieverResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateRetrieverRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateRetrieverRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateRetriever");

            return clientHandler.execute(new ClientExecutionParams<UpdateRetrieverRequest, UpdateRetrieverResponse>()
                    .withOperationName("UpdateRetriever").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateRetrieverRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateRetrieverRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the pricing tier for an Amazon Q Business subscription. Upgrades are instant. Downgrades apply at the
     * start of the next month. Subscription tier determines feature access for the user. For more information on
     * subscriptions and pricing tiers, see <a href="https://aws.amazon.com/q/business/pricing/">Amazon Q Business
     * pricing</a>.
     * </p>
     *
     * @param updateSubscriptionRequest
     * @return Result of the UpdateSubscription operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistencies with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.UpdateSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdateSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateSubscriptionResponse updateSubscription(UpdateSubscriptionRequest updateSubscriptionRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateSubscriptionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateSubscriptionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateSubscriptionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateSubscriptionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateSubscription");

            return clientHandler.execute(new ClientExecutionParams<UpdateSubscriptionRequest, UpdateSubscriptionResponse>()
                    .withOperationName("UpdateSubscription").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateSubscriptionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateSubscriptionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a information associated with a user id.
     * </p>
     *
     * @param updateUserRequest
     * @return Result of the UpdateUser operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistencies with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the set limits for your Amazon Q Business service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.UpdateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdateUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateUserResponse updateUser(UpdateUserRequest updateUserRequest) throws InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateUserResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateUserResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateUser");

            return clientHandler.execute(new ClientExecutionParams<UpdateUserRequest, UpdateUserResponse>()
                    .withOperationName("UpdateUser").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(updateUserRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateUserRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an Amazon Q Business web experience.
     * </p>
     *
     * @param updateWebExperienceRequest
     * @return Result of the UpdateWebExperience operation returned by the service.
     * @throws InternalServerException
     *         An issue occurred with the internal server used for your Amazon Q Business service. Wait some minutes and
     *         try again, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> for help.
     * @throws ResourceNotFoundException
     *         The application or plugin resource you want to use doesn’t exist. Make sure you have provided the correct
     *         resource and try again.
     * @throws ConflictException
     *         You are trying to perform an action that conflicts with the current status of your resource. Fix any
     *         inconsistencies with your resources and try again.
     * @throws ThrottlingException
     *         The request was denied due to throttling. Reduce the number of requests and try again.
     * @throws ValidationException
     *         The input doesn't meet the constraints set by the Amazon Q Business service. Provide the correct input
     *         and try again.
     * @throws AccessDeniedException
     *         You don't have access to perform this action. Make sure you have the required permission policies and
     *         user accounts and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QBusinessClient.UpdateWebExperience
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdateWebExperience" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateWebExperienceResponse updateWebExperience(UpdateWebExperienceRequest updateWebExperienceRequest)
            throws InternalServerException, ResourceNotFoundException, ConflictException, ThrottlingException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, QBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateWebExperienceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateWebExperienceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ExternalResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ExternalResourceException").httpStatusCode(424)
                        .exceptionBuilderSupplier(ExternalResourceException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "MediaTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MediaTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MediaTooLargeException::builder).build());
            case "LicenseNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LicenseNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LicenseNotFoundException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateWebExperienceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateWebExperienceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QBusiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateWebExperience");

            return clientHandler.execute(new ClientExecutionParams<UpdateWebExperienceRequest, UpdateWebExperienceResponse>()
                    .withOperationName("UpdateWebExperience").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateWebExperienceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateWebExperienceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        QBusinessServiceClientConfigurationBuilder serviceConfigBuilder = new QBusinessServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder.clientConfiguration(clientConfiguration).defaultServiceExceptionSupplier(QBusinessException::builder)
                .protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1");
    }

    @Override
    public final QBusinessServiceClientConfiguration serviceClientConfiguration() {
        return new QBusinessServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
