/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.qbusiness.model.AssociatePermissionRequest;
import software.amazon.awssdk.services.qbusiness.model.AssociatePermissionResponse;
import software.amazon.awssdk.services.qbusiness.model.BatchDeleteDocumentRequest;
import software.amazon.awssdk.services.qbusiness.model.BatchDeleteDocumentResponse;
import software.amazon.awssdk.services.qbusiness.model.BatchPutDocumentRequest;
import software.amazon.awssdk.services.qbusiness.model.BatchPutDocumentResponse;
import software.amazon.awssdk.services.qbusiness.model.CancelSubscriptionRequest;
import software.amazon.awssdk.services.qbusiness.model.CancelSubscriptionResponse;
import software.amazon.awssdk.services.qbusiness.model.ChatInputStream;
import software.amazon.awssdk.services.qbusiness.model.ChatRequest;
import software.amazon.awssdk.services.qbusiness.model.ChatResponseHandler;
import software.amazon.awssdk.services.qbusiness.model.ChatSyncRequest;
import software.amazon.awssdk.services.qbusiness.model.ChatSyncResponse;
import software.amazon.awssdk.services.qbusiness.model.CheckDocumentAccessRequest;
import software.amazon.awssdk.services.qbusiness.model.CheckDocumentAccessResponse;
import software.amazon.awssdk.services.qbusiness.model.CreateAnonymousWebExperienceUrlRequest;
import software.amazon.awssdk.services.qbusiness.model.CreateAnonymousWebExperienceUrlResponse;
import software.amazon.awssdk.services.qbusiness.model.CreateApplicationRequest;
import software.amazon.awssdk.services.qbusiness.model.CreateApplicationResponse;
import software.amazon.awssdk.services.qbusiness.model.CreateChatResponseConfigurationRequest;
import software.amazon.awssdk.services.qbusiness.model.CreateChatResponseConfigurationResponse;
import software.amazon.awssdk.services.qbusiness.model.CreateDataAccessorRequest;
import software.amazon.awssdk.services.qbusiness.model.CreateDataAccessorResponse;
import software.amazon.awssdk.services.qbusiness.model.CreateDataSourceRequest;
import software.amazon.awssdk.services.qbusiness.model.CreateDataSourceResponse;
import software.amazon.awssdk.services.qbusiness.model.CreateIndexRequest;
import software.amazon.awssdk.services.qbusiness.model.CreateIndexResponse;
import software.amazon.awssdk.services.qbusiness.model.CreatePluginRequest;
import software.amazon.awssdk.services.qbusiness.model.CreatePluginResponse;
import software.amazon.awssdk.services.qbusiness.model.CreateRetrieverRequest;
import software.amazon.awssdk.services.qbusiness.model.CreateRetrieverResponse;
import software.amazon.awssdk.services.qbusiness.model.CreateSubscriptionRequest;
import software.amazon.awssdk.services.qbusiness.model.CreateSubscriptionResponse;
import software.amazon.awssdk.services.qbusiness.model.CreateUserRequest;
import software.amazon.awssdk.services.qbusiness.model.CreateUserResponse;
import software.amazon.awssdk.services.qbusiness.model.CreateWebExperienceRequest;
import software.amazon.awssdk.services.qbusiness.model.CreateWebExperienceResponse;
import software.amazon.awssdk.services.qbusiness.model.DeleteApplicationRequest;
import software.amazon.awssdk.services.qbusiness.model.DeleteApplicationResponse;
import software.amazon.awssdk.services.qbusiness.model.DeleteAttachmentRequest;
import software.amazon.awssdk.services.qbusiness.model.DeleteAttachmentResponse;
import software.amazon.awssdk.services.qbusiness.model.DeleteChatControlsConfigurationRequest;
import software.amazon.awssdk.services.qbusiness.model.DeleteChatControlsConfigurationResponse;
import software.amazon.awssdk.services.qbusiness.model.DeleteChatResponseConfigurationRequest;
import software.amazon.awssdk.services.qbusiness.model.DeleteChatResponseConfigurationResponse;
import software.amazon.awssdk.services.qbusiness.model.DeleteConversationRequest;
import software.amazon.awssdk.services.qbusiness.model.DeleteConversationResponse;
import software.amazon.awssdk.services.qbusiness.model.DeleteDataAccessorRequest;
import software.amazon.awssdk.services.qbusiness.model.DeleteDataAccessorResponse;
import software.amazon.awssdk.services.qbusiness.model.DeleteDataSourceRequest;
import software.amazon.awssdk.services.qbusiness.model.DeleteDataSourceResponse;
import software.amazon.awssdk.services.qbusiness.model.DeleteGroupRequest;
import software.amazon.awssdk.services.qbusiness.model.DeleteGroupResponse;
import software.amazon.awssdk.services.qbusiness.model.DeleteIndexRequest;
import software.amazon.awssdk.services.qbusiness.model.DeleteIndexResponse;
import software.amazon.awssdk.services.qbusiness.model.DeletePluginRequest;
import software.amazon.awssdk.services.qbusiness.model.DeletePluginResponse;
import software.amazon.awssdk.services.qbusiness.model.DeleteRetrieverRequest;
import software.amazon.awssdk.services.qbusiness.model.DeleteRetrieverResponse;
import software.amazon.awssdk.services.qbusiness.model.DeleteUserRequest;
import software.amazon.awssdk.services.qbusiness.model.DeleteUserResponse;
import software.amazon.awssdk.services.qbusiness.model.DeleteWebExperienceRequest;
import software.amazon.awssdk.services.qbusiness.model.DeleteWebExperienceResponse;
import software.amazon.awssdk.services.qbusiness.model.DisassociatePermissionRequest;
import software.amazon.awssdk.services.qbusiness.model.DisassociatePermissionResponse;
import software.amazon.awssdk.services.qbusiness.model.GetApplicationRequest;
import software.amazon.awssdk.services.qbusiness.model.GetApplicationResponse;
import software.amazon.awssdk.services.qbusiness.model.GetChatControlsConfigurationRequest;
import software.amazon.awssdk.services.qbusiness.model.GetChatControlsConfigurationResponse;
import software.amazon.awssdk.services.qbusiness.model.GetChatResponseConfigurationRequest;
import software.amazon.awssdk.services.qbusiness.model.GetChatResponseConfigurationResponse;
import software.amazon.awssdk.services.qbusiness.model.GetDataAccessorRequest;
import software.amazon.awssdk.services.qbusiness.model.GetDataAccessorResponse;
import software.amazon.awssdk.services.qbusiness.model.GetDataSourceRequest;
import software.amazon.awssdk.services.qbusiness.model.GetDataSourceResponse;
import software.amazon.awssdk.services.qbusiness.model.GetDocumentContentRequest;
import software.amazon.awssdk.services.qbusiness.model.GetDocumentContentResponse;
import software.amazon.awssdk.services.qbusiness.model.GetGroupRequest;
import software.amazon.awssdk.services.qbusiness.model.GetGroupResponse;
import software.amazon.awssdk.services.qbusiness.model.GetIndexRequest;
import software.amazon.awssdk.services.qbusiness.model.GetIndexResponse;
import software.amazon.awssdk.services.qbusiness.model.GetMediaRequest;
import software.amazon.awssdk.services.qbusiness.model.GetMediaResponse;
import software.amazon.awssdk.services.qbusiness.model.GetPluginRequest;
import software.amazon.awssdk.services.qbusiness.model.GetPluginResponse;
import software.amazon.awssdk.services.qbusiness.model.GetPolicyRequest;
import software.amazon.awssdk.services.qbusiness.model.GetPolicyResponse;
import software.amazon.awssdk.services.qbusiness.model.GetRetrieverRequest;
import software.amazon.awssdk.services.qbusiness.model.GetRetrieverResponse;
import software.amazon.awssdk.services.qbusiness.model.GetUserRequest;
import software.amazon.awssdk.services.qbusiness.model.GetUserResponse;
import software.amazon.awssdk.services.qbusiness.model.GetWebExperienceRequest;
import software.amazon.awssdk.services.qbusiness.model.GetWebExperienceResponse;
import software.amazon.awssdk.services.qbusiness.model.ListApplicationsRequest;
import software.amazon.awssdk.services.qbusiness.model.ListApplicationsResponse;
import software.amazon.awssdk.services.qbusiness.model.ListAttachmentsRequest;
import software.amazon.awssdk.services.qbusiness.model.ListAttachmentsResponse;
import software.amazon.awssdk.services.qbusiness.model.ListChatResponseConfigurationsRequest;
import software.amazon.awssdk.services.qbusiness.model.ListChatResponseConfigurationsResponse;
import software.amazon.awssdk.services.qbusiness.model.ListConversationsRequest;
import software.amazon.awssdk.services.qbusiness.model.ListConversationsResponse;
import software.amazon.awssdk.services.qbusiness.model.ListDataAccessorsRequest;
import software.amazon.awssdk.services.qbusiness.model.ListDataAccessorsResponse;
import software.amazon.awssdk.services.qbusiness.model.ListDataSourceSyncJobsRequest;
import software.amazon.awssdk.services.qbusiness.model.ListDataSourceSyncJobsResponse;
import software.amazon.awssdk.services.qbusiness.model.ListDataSourcesRequest;
import software.amazon.awssdk.services.qbusiness.model.ListDataSourcesResponse;
import software.amazon.awssdk.services.qbusiness.model.ListDocumentsRequest;
import software.amazon.awssdk.services.qbusiness.model.ListDocumentsResponse;
import software.amazon.awssdk.services.qbusiness.model.ListGroupsRequest;
import software.amazon.awssdk.services.qbusiness.model.ListGroupsResponse;
import software.amazon.awssdk.services.qbusiness.model.ListIndicesRequest;
import software.amazon.awssdk.services.qbusiness.model.ListIndicesResponse;
import software.amazon.awssdk.services.qbusiness.model.ListMessagesRequest;
import software.amazon.awssdk.services.qbusiness.model.ListMessagesResponse;
import software.amazon.awssdk.services.qbusiness.model.ListPluginActionsRequest;
import software.amazon.awssdk.services.qbusiness.model.ListPluginActionsResponse;
import software.amazon.awssdk.services.qbusiness.model.ListPluginTypeActionsRequest;
import software.amazon.awssdk.services.qbusiness.model.ListPluginTypeActionsResponse;
import software.amazon.awssdk.services.qbusiness.model.ListPluginTypeMetadataRequest;
import software.amazon.awssdk.services.qbusiness.model.ListPluginTypeMetadataResponse;
import software.amazon.awssdk.services.qbusiness.model.ListPluginsRequest;
import software.amazon.awssdk.services.qbusiness.model.ListPluginsResponse;
import software.amazon.awssdk.services.qbusiness.model.ListRetrieversRequest;
import software.amazon.awssdk.services.qbusiness.model.ListRetrieversResponse;
import software.amazon.awssdk.services.qbusiness.model.ListSubscriptionsRequest;
import software.amazon.awssdk.services.qbusiness.model.ListSubscriptionsResponse;
import software.amazon.awssdk.services.qbusiness.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.qbusiness.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.qbusiness.model.ListWebExperiencesRequest;
import software.amazon.awssdk.services.qbusiness.model.ListWebExperiencesResponse;
import software.amazon.awssdk.services.qbusiness.model.PutFeedbackRequest;
import software.amazon.awssdk.services.qbusiness.model.PutFeedbackResponse;
import software.amazon.awssdk.services.qbusiness.model.PutGroupRequest;
import software.amazon.awssdk.services.qbusiness.model.PutGroupResponse;
import software.amazon.awssdk.services.qbusiness.model.SearchRelevantContentRequest;
import software.amazon.awssdk.services.qbusiness.model.SearchRelevantContentResponse;
import software.amazon.awssdk.services.qbusiness.model.StartDataSourceSyncJobRequest;
import software.amazon.awssdk.services.qbusiness.model.StartDataSourceSyncJobResponse;
import software.amazon.awssdk.services.qbusiness.model.StopDataSourceSyncJobRequest;
import software.amazon.awssdk.services.qbusiness.model.StopDataSourceSyncJobResponse;
import software.amazon.awssdk.services.qbusiness.model.TagResourceRequest;
import software.amazon.awssdk.services.qbusiness.model.TagResourceResponse;
import software.amazon.awssdk.services.qbusiness.model.UntagResourceRequest;
import software.amazon.awssdk.services.qbusiness.model.UntagResourceResponse;
import software.amazon.awssdk.services.qbusiness.model.UpdateApplicationRequest;
import software.amazon.awssdk.services.qbusiness.model.UpdateApplicationResponse;
import software.amazon.awssdk.services.qbusiness.model.UpdateChatControlsConfigurationRequest;
import software.amazon.awssdk.services.qbusiness.model.UpdateChatControlsConfigurationResponse;
import software.amazon.awssdk.services.qbusiness.model.UpdateChatResponseConfigurationRequest;
import software.amazon.awssdk.services.qbusiness.model.UpdateChatResponseConfigurationResponse;
import software.amazon.awssdk.services.qbusiness.model.UpdateDataAccessorRequest;
import software.amazon.awssdk.services.qbusiness.model.UpdateDataAccessorResponse;
import software.amazon.awssdk.services.qbusiness.model.UpdateDataSourceRequest;
import software.amazon.awssdk.services.qbusiness.model.UpdateDataSourceResponse;
import software.amazon.awssdk.services.qbusiness.model.UpdateIndexRequest;
import software.amazon.awssdk.services.qbusiness.model.UpdateIndexResponse;
import software.amazon.awssdk.services.qbusiness.model.UpdatePluginRequest;
import software.amazon.awssdk.services.qbusiness.model.UpdatePluginResponse;
import software.amazon.awssdk.services.qbusiness.model.UpdateRetrieverRequest;
import software.amazon.awssdk.services.qbusiness.model.UpdateRetrieverResponse;
import software.amazon.awssdk.services.qbusiness.model.UpdateSubscriptionRequest;
import software.amazon.awssdk.services.qbusiness.model.UpdateSubscriptionResponse;
import software.amazon.awssdk.services.qbusiness.model.UpdateUserRequest;
import software.amazon.awssdk.services.qbusiness.model.UpdateUserResponse;
import software.amazon.awssdk.services.qbusiness.model.UpdateWebExperienceRequest;
import software.amazon.awssdk.services.qbusiness.model.UpdateWebExperienceResponse;
import software.amazon.awssdk.services.qbusiness.paginators.GetChatControlsConfigurationPublisher;
import software.amazon.awssdk.services.qbusiness.paginators.ListApplicationsPublisher;
import software.amazon.awssdk.services.qbusiness.paginators.ListAttachmentsPublisher;
import software.amazon.awssdk.services.qbusiness.paginators.ListChatResponseConfigurationsPublisher;
import software.amazon.awssdk.services.qbusiness.paginators.ListConversationsPublisher;
import software.amazon.awssdk.services.qbusiness.paginators.ListDataAccessorsPublisher;
import software.amazon.awssdk.services.qbusiness.paginators.ListDataSourceSyncJobsPublisher;
import software.amazon.awssdk.services.qbusiness.paginators.ListDataSourcesPublisher;
import software.amazon.awssdk.services.qbusiness.paginators.ListDocumentsPublisher;
import software.amazon.awssdk.services.qbusiness.paginators.ListGroupsPublisher;
import software.amazon.awssdk.services.qbusiness.paginators.ListIndicesPublisher;
import software.amazon.awssdk.services.qbusiness.paginators.ListMessagesPublisher;
import software.amazon.awssdk.services.qbusiness.paginators.ListPluginActionsPublisher;
import software.amazon.awssdk.services.qbusiness.paginators.ListPluginTypeActionsPublisher;
import software.amazon.awssdk.services.qbusiness.paginators.ListPluginTypeMetadataPublisher;
import software.amazon.awssdk.services.qbusiness.paginators.ListPluginsPublisher;
import software.amazon.awssdk.services.qbusiness.paginators.ListRetrieversPublisher;
import software.amazon.awssdk.services.qbusiness.paginators.ListSubscriptionsPublisher;
import software.amazon.awssdk.services.qbusiness.paginators.ListWebExperiencesPublisher;
import software.amazon.awssdk.services.qbusiness.paginators.SearchRelevantContentPublisher;

/**
 * Service client for accessing QBusiness asynchronously. This can be created using the static {@link #builder()}
 * method.The asynchronous client performs non-blocking I/O when configured with any {@code SdkAsyncHttpClient}
 * supported in the SDK. However, full non-blocking is not guaranteed as the async client may perform blocking calls in
 * some cases such as credentials retrieval and endpoint discovery as part of the async API call.
 *
 * <p>
 * This is the <i>Amazon Q Business</i> API Reference. Amazon Q Business is a fully managed, generative-AI powered
 * enterprise chat assistant that you can deploy within your organization. Amazon Q Business enhances employee
 * productivity by supporting key tasks such as question-answering, knowledge discovery, writing email messages,
 * summarizing text, drafting document outlines, and brainstorming ideas. Users ask questions of Amazon Q Business and
 * get answers that are presented in a conversational manner. For an introduction to the service, see the <a
 * href="https://docs.aws.amazon.com/amazonq/latest/business-use-dg/what-is.html"> <i>Amazon Q Business User Guide</i>
 * </a>.
 * </p>
 * <p>
 * For an overview of the Amazon Q Business APIs, see <a
 * href="https://docs.aws.amazon.com/amazonq/latest/business-use-dg/api-ref.html#api-overview">Overview of Amazon Q
 * Business API operations</a>.
 * </p>
 * <p>
 * For information about the IAM access control permissions you need to use this API, see <a
 * href="https://docs.aws.amazon.com/amazonq/latest/business-use-dg/iam-roles.html">IAM roles for Amazon Q Business</a>
 * in the <i>Amazon Q Business User Guide</i>.
 * </p>
 * <p>
 * The following resources provide additional information about using the Amazon Q Business API:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <i> <a href="https://docs.aws.amazon.com/amazonq/latest/business-use-dg/setting-up.html">Setting up for Amazon Q
 * Business</a> </i>
 * </p>
 * </li>
 * <li>
 * <p>
 * <i> <a href="https://awscli.amazonaws.com/v2/documentation/api/latest/reference/qbusiness/index.html">Amazon Q
 * Business CLI Reference</a> </i>
 * </p>
 * </li>
 * <li>
 * <p>
 * <i> <a href="https://docs.aws.amazon.com/general/latest/gr/amazonq.html">Amazon Web Services General Reference</a>
 * </i>
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface QBusinessAsyncClient extends AwsClient {
    String SERVICE_NAME = "qbusiness";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "qbusiness";

    /**
     * <p>
     * Adds or updates a permission policy for a Amazon Q Business application, allowing cross-account access for an
     * ISV. This operation creates a new policy statement for the specified Amazon Q Business application. The policy
     * statement defines the IAM actions that the ISV is allowed to perform on the Amazon Q Business application's
     * resources.
     * </p>
     *
     * @param associatePermissionRequest
     * @return A Java Future containing the result of the AssociatePermission operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Q Business service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.AssociatePermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/AssociatePermission" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AssociatePermissionResponse> associatePermission(
            AssociatePermissionRequest associatePermissionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or updates a permission policy for a Amazon Q Business application, allowing cross-account access for an
     * ISV. This operation creates a new policy statement for the specified Amazon Q Business application. The policy
     * statement defines the IAM actions that the ISV is allowed to perform on the Amazon Q Business application's
     * resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociatePermissionRequest.Builder} avoiding the
     * need to create one manually via {@link AssociatePermissionRequest#builder()}
     * </p>
     *
     * @param associatePermissionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.AssociatePermissionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AssociatePermission operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Q Business service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.AssociatePermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/AssociatePermission" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AssociatePermissionResponse> associatePermission(
            Consumer<AssociatePermissionRequest.Builder> associatePermissionRequest) {
        return associatePermission(AssociatePermissionRequest.builder().applyMutation(associatePermissionRequest).build());
    }

    /**
     * <p>
     * Asynchronously deletes one or more documents added using the <code>BatchPutDocument</code> API from an Amazon Q
     * Business index.
     * </p>
     * <p>
     * You can see the progress of the deletion, and any error messages related to the process, by using CloudWatch.
     * </p>
     *
     * @param batchDeleteDocumentRequest
     * @return A Java Future containing the result of the BatchDeleteDocument operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.BatchDeleteDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/BatchDeleteDocument" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BatchDeleteDocumentResponse> batchDeleteDocument(
            BatchDeleteDocumentRequest batchDeleteDocumentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Asynchronously deletes one or more documents added using the <code>BatchPutDocument</code> API from an Amazon Q
     * Business index.
     * </p>
     * <p>
     * You can see the progress of the deletion, and any error messages related to the process, by using CloudWatch.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDeleteDocumentRequest.Builder} avoiding the
     * need to create one manually via {@link BatchDeleteDocumentRequest#builder()}
     * </p>
     *
     * @param batchDeleteDocumentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.BatchDeleteDocumentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchDeleteDocument operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.BatchDeleteDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/BatchDeleteDocument" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BatchDeleteDocumentResponse> batchDeleteDocument(
            Consumer<BatchDeleteDocumentRequest.Builder> batchDeleteDocumentRequest) {
        return batchDeleteDocument(BatchDeleteDocumentRequest.builder().applyMutation(batchDeleteDocumentRequest).build());
    }

    /**
     * <p>
     * Adds one or more documents to an Amazon Q Business index.
     * </p>
     * <p>
     * You use this API to:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ingest your structured and unstructured documents and documents stored in an Amazon S3 bucket into an Amazon Q
     * Business index.
     * </p>
     * </li>
     * <li>
     * <p>
     * add custom attributes to documents in an Amazon Q Business index.
     * </p>
     * </li>
     * <li>
     * <p>
     * attach an access control list to the documents added to an Amazon Q Business index.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can see the progress of the deletion, and any error messages related to the process, by using CloudWatch.
     * </p>
     *
     * @param batchPutDocumentRequest
     * @return A Java Future containing the result of the BatchPutDocument operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Q Business service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.BatchPutDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/BatchPutDocument" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BatchPutDocumentResponse> batchPutDocument(BatchPutDocumentRequest batchPutDocumentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds one or more documents to an Amazon Q Business index.
     * </p>
     * <p>
     * You use this API to:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ingest your structured and unstructured documents and documents stored in an Amazon S3 bucket into an Amazon Q
     * Business index.
     * </p>
     * </li>
     * <li>
     * <p>
     * add custom attributes to documents in an Amazon Q Business index.
     * </p>
     * </li>
     * <li>
     * <p>
     * attach an access control list to the documents added to an Amazon Q Business index.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can see the progress of the deletion, and any error messages related to the process, by using CloudWatch.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchPutDocumentRequest.Builder} avoiding the need
     * to create one manually via {@link BatchPutDocumentRequest#builder()}
     * </p>
     *
     * @param batchPutDocumentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.BatchPutDocumentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchPutDocument operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Q Business service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.BatchPutDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/BatchPutDocument" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BatchPutDocumentResponse> batchPutDocument(
            Consumer<BatchPutDocumentRequest.Builder> batchPutDocumentRequest) {
        return batchPutDocument(BatchPutDocumentRequest.builder().applyMutation(batchPutDocumentRequest).build());
    }

    /**
     * <p>
     * Unsubscribes a user or a group from their pricing tier in an Amazon Q Business application. An unsubscribed user
     * or group loses all Amazon Q Business feature access at the start of next month.
     * </p>
     *
     * @param cancelSubscriptionRequest
     * @return A Java Future containing the result of the CancelSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.CancelSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CancelSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CancelSubscriptionResponse> cancelSubscription(CancelSubscriptionRequest cancelSubscriptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Unsubscribes a user or a group from their pricing tier in an Amazon Q Business application. An unsubscribed user
     * or group loses all Amazon Q Business feature access at the start of next month.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelSubscriptionRequest.Builder} avoiding the
     * need to create one manually via {@link CancelSubscriptionRequest#builder()}
     * </p>
     *
     * @param cancelSubscriptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.CancelSubscriptionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CancelSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.CancelSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CancelSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CancelSubscriptionResponse> cancelSubscription(
            Consumer<CancelSubscriptionRequest.Builder> cancelSubscriptionRequest) {
        return cancelSubscription(CancelSubscriptionRequest.builder().applyMutation(cancelSubscriptionRequest).build());
    }

    /**
     * <p>
     * Starts or continues a streaming Amazon Q Business conversation.
     * </p>
     *
     * @param chatRequest
     * @return A Java Future containing the result of the Chat operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>LicenseNotFoundException You don't have permissions to perform the action because your license is
     *         inactive. Ask your admin to activate your license and try again after your licence is active.</li>
     *         <li>ExternalResourceException An external resource that you configured with your application is returning
     *         errors and preventing this operation from succeeding. Fix those errors and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.Chat
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/Chat" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<Void> chat(ChatRequest chatRequest, Publisher<ChatInputStream> requestStream,
            ChatResponseHandler asyncResponseHandler) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts or continues a streaming Amazon Q Business conversation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ChatRequest.Builder} avoiding the need to create
     * one manually via {@link ChatRequest#builder()}
     * </p>
     *
     * @param chatRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.ChatRequest.Builder} to create a request.
     * @return A Java Future containing the result of the Chat operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>LicenseNotFoundException You don't have permissions to perform the action because your license is
     *         inactive. Ask your admin to activate your license and try again after your licence is active.</li>
     *         <li>ExternalResourceException An external resource that you configured with your application is returning
     *         errors and preventing this operation from succeeding. Fix those errors and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.Chat
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/Chat" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<Void> chat(Consumer<ChatRequest.Builder> chatRequest, Publisher<ChatInputStream> requestStream,
            ChatResponseHandler asyncResponseHandler) {
        return chat(ChatRequest.builder().applyMutation(chatRequest).build(), requestStream, asyncResponseHandler);
    }

    /**
     * <p>
     * Starts or continues a non-streaming Amazon Q Business conversation.
     * </p>
     *
     * @param chatSyncRequest
     * @return A Java Future containing the result of the ChatSync operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>LicenseNotFoundException You don't have permissions to perform the action because your license is
     *         inactive. Ask your admin to activate your license and try again after your licence is active.</li>
     *         <li>ExternalResourceException An external resource that you configured with your application is returning
     *         errors and preventing this operation from succeeding. Fix those errors and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ChatSync
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ChatSync" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ChatSyncResponse> chatSync(ChatSyncRequest chatSyncRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts or continues a non-streaming Amazon Q Business conversation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ChatSyncRequest.Builder} avoiding the need to
     * create one manually via {@link ChatSyncRequest#builder()}
     * </p>
     *
     * @param chatSyncRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.ChatSyncRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ChatSync operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>LicenseNotFoundException You don't have permissions to perform the action because your license is
     *         inactive. Ask your admin to activate your license and try again after your licence is active.</li>
     *         <li>ExternalResourceException An external resource that you configured with your application is returning
     *         errors and preventing this operation from succeeding. Fix those errors and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ChatSync
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ChatSync" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ChatSyncResponse> chatSync(Consumer<ChatSyncRequest.Builder> chatSyncRequest) {
        return chatSync(ChatSyncRequest.builder().applyMutation(chatSyncRequest).build());
    }

    /**
     * <p>
     * Verifies if a user has access permissions for a specified document and returns the actual ACL attached to the
     * document. Resolves user access on the document via user aliases and groups when verifying user access.
     * </p>
     *
     * @param checkDocumentAccessRequest
     * @return A Java Future containing the result of the CheckDocumentAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.CheckDocumentAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CheckDocumentAccess" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CheckDocumentAccessResponse> checkDocumentAccess(
            CheckDocumentAccessRequest checkDocumentAccessRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Verifies if a user has access permissions for a specified document and returns the actual ACL attached to the
     * document. Resolves user access on the document via user aliases and groups when verifying user access.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CheckDocumentAccessRequest.Builder} avoiding the
     * need to create one manually via {@link CheckDocumentAccessRequest#builder()}
     * </p>
     *
     * @param checkDocumentAccessRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.CheckDocumentAccessRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CheckDocumentAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.CheckDocumentAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CheckDocumentAccess" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CheckDocumentAccessResponse> checkDocumentAccess(
            Consumer<CheckDocumentAccessRequest.Builder> checkDocumentAccessRequest) {
        return checkDocumentAccess(CheckDocumentAccessRequest.builder().applyMutation(checkDocumentAccessRequest).build());
    }

    /**
     * <p>
     * Creates a unique URL for anonymous Amazon Q Business web experience. This URL can only be used once and must be
     * used within 5 minutes after it's generated.
     * </p>
     *
     * @param createAnonymousWebExperienceUrlRequest
     * @return A Java Future containing the result of the CreateAnonymousWebExperienceUrl operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Q Business service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.CreateAnonymousWebExperienceUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CreateAnonymousWebExperienceUrl"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAnonymousWebExperienceUrlResponse> createAnonymousWebExperienceUrl(
            CreateAnonymousWebExperienceUrlRequest createAnonymousWebExperienceUrlRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a unique URL for anonymous Amazon Q Business web experience. This URL can only be used once and must be
     * used within 5 minutes after it's generated.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAnonymousWebExperienceUrlRequest.Builder}
     * avoiding the need to create one manually via {@link CreateAnonymousWebExperienceUrlRequest#builder()}
     * </p>
     *
     * @param createAnonymousWebExperienceUrlRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.CreateAnonymousWebExperienceUrlRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateAnonymousWebExperienceUrl operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Q Business service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.CreateAnonymousWebExperienceUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CreateAnonymousWebExperienceUrl"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAnonymousWebExperienceUrlResponse> createAnonymousWebExperienceUrl(
            Consumer<CreateAnonymousWebExperienceUrlRequest.Builder> createAnonymousWebExperienceUrlRequest) {
        return createAnonymousWebExperienceUrl(CreateAnonymousWebExperienceUrlRequest.builder()
                .applyMutation(createAnonymousWebExperienceUrlRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon Q Business application.
     * </p>
     * <note>
     * <p>
     * There are new tiers for Amazon Q Business. Not all features in Amazon Q Business Pro are also available in Amazon
     * Q Business Lite. For information on what's included in Amazon Q Business Lite and what's included in Amazon Q
     * Business Pro, see <a
     * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/tiers.html#user-sub-tiers">Amazon Q Business
     * tiers</a>. You must use the Amazon Q Business console to assign subscription tiers to users.
     * </p>
     * <p>
     * An Amazon Q Apps service linked role will be created if it's absent in the Amazon Web Services account when
     * <code>QAppsConfiguration</code> is enabled in the request. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/using-service-linked-roles-qapps.html"> Using
     * service-linked roles for Q Apps</a>.
     * </p>
     * <p>
     * When you create an application, Amazon Q Business may securely transmit data for processing from your selected
     * Amazon Web Services region, but within your geography. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/cross-region-inference.html">Cross region inference
     * in Amazon Q Business</a>.
     * </p>
     * </note>
     *
     * @param createApplicationRequest
     * @return A Java Future containing the result of the CreateApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Q Business service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.CreateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CreateApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateApplicationResponse> createApplication(CreateApplicationRequest createApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Q Business application.
     * </p>
     * <note>
     * <p>
     * There are new tiers for Amazon Q Business. Not all features in Amazon Q Business Pro are also available in Amazon
     * Q Business Lite. For information on what's included in Amazon Q Business Lite and what's included in Amazon Q
     * Business Pro, see <a
     * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/tiers.html#user-sub-tiers">Amazon Q Business
     * tiers</a>. You must use the Amazon Q Business console to assign subscription tiers to users.
     * </p>
     * <p>
     * An Amazon Q Apps service linked role will be created if it's absent in the Amazon Web Services account when
     * <code>QAppsConfiguration</code> is enabled in the request. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/using-service-linked-roles-qapps.html"> Using
     * service-linked roles for Q Apps</a>.
     * </p>
     * <p>
     * When you create an application, Amazon Q Business may securely transmit data for processing from your selected
     * Amazon Web Services region, but within your geography. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/cross-region-inference.html">Cross region inference
     * in Amazon Q Business</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link CreateApplicationRequest#builder()}
     * </p>
     *
     * @param createApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.CreateApplicationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Q Business service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.CreateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CreateApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateApplicationResponse> createApplication(
            Consumer<CreateApplicationRequest.Builder> createApplicationRequest) {
        return createApplication(CreateApplicationRequest.builder().applyMutation(createApplicationRequest).build());
    }

    /**
     * <p>
     * Creates a new chat response configuration for an Amazon Q Business application. This operation establishes a set
     * of parameters that define how the system generates and formats responses to user queries in chat interactions.
     * </p>
     *
     * @param createChatResponseConfigurationRequest
     * @return A Java Future containing the result of the CreateChatResponseConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Q Business service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.CreateChatResponseConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CreateChatResponseConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateChatResponseConfigurationResponse> createChatResponseConfiguration(
            CreateChatResponseConfigurationRequest createChatResponseConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new chat response configuration for an Amazon Q Business application. This operation establishes a set
     * of parameters that define how the system generates and formats responses to user queries in chat interactions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateChatResponseConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link CreateChatResponseConfigurationRequest#builder()}
     * </p>
     *
     * @param createChatResponseConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.CreateChatResponseConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateChatResponseConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Q Business service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.CreateChatResponseConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CreateChatResponseConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateChatResponseConfigurationResponse> createChatResponseConfiguration(
            Consumer<CreateChatResponseConfigurationRequest.Builder> createChatResponseConfigurationRequest) {
        return createChatResponseConfiguration(CreateChatResponseConfigurationRequest.builder()
                .applyMutation(createChatResponseConfigurationRequest).build());
    }

    /**
     * <p>
     * Creates a new data accessor for an ISV to access data from a Amazon Q Business application. The data accessor is
     * an entity that represents the ISV's access to the Amazon Q Business application's data. It includes the IAM role
     * ARN for the ISV, a friendly name, and a set of action configurations that define the specific actions the ISV is
     * allowed to perform and any associated data filters. When the data accessor is created, an IAM Identity Center
     * application is also created to manage the ISV's identity and authentication for accessing the Amazon Q Business
     * application.
     * </p>
     *
     * @param createDataAccessorRequest
     * @return A Java Future containing the result of the CreateDataAccessor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Q Business service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.CreateDataAccessor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CreateDataAccessor" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDataAccessorResponse> createDataAccessor(CreateDataAccessorRequest createDataAccessorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new data accessor for an ISV to access data from a Amazon Q Business application. The data accessor is
     * an entity that represents the ISV's access to the Amazon Q Business application's data. It includes the IAM role
     * ARN for the ISV, a friendly name, and a set of action configurations that define the specific actions the ISV is
     * allowed to perform and any associated data filters. When the data accessor is created, an IAM Identity Center
     * application is also created to manage the ISV's identity and authentication for accessing the Amazon Q Business
     * application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDataAccessorRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDataAccessorRequest#builder()}
     * </p>
     *
     * @param createDataAccessorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.CreateDataAccessorRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateDataAccessor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Q Business service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.CreateDataAccessor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CreateDataAccessor" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDataAccessorResponse> createDataAccessor(
            Consumer<CreateDataAccessorRequest.Builder> createDataAccessorRequest) {
        return createDataAccessor(CreateDataAccessorRequest.builder().applyMutation(createDataAccessorRequest).build());
    }

    /**
     * <p>
     * Creates a data source connector for an Amazon Q Business application.
     * </p>
     * <p>
     * <code>CreateDataSource</code> is a synchronous operation. The operation returns 200 if the data source was
     * successfully created. Otherwise, an exception is raised.
     * </p>
     *
     * @param createDataSourceRequest
     * @return A Java Future containing the result of the CreateDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Q Business service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.CreateDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CreateDataSource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDataSourceResponse> createDataSource(CreateDataSourceRequest createDataSourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a data source connector for an Amazon Q Business application.
     * </p>
     * <p>
     * <code>CreateDataSource</code> is a synchronous operation. The operation returns 200 if the data source was
     * successfully created. Otherwise, an exception is raised.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDataSourceRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDataSourceRequest#builder()}
     * </p>
     *
     * @param createDataSourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.CreateDataSourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Q Business service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.CreateDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CreateDataSource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDataSourceResponse> createDataSource(
            Consumer<CreateDataSourceRequest.Builder> createDataSourceRequest) {
        return createDataSource(CreateDataSourceRequest.builder().applyMutation(createDataSourceRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon Q Business index.
     * </p>
     * <p>
     * To determine if index creation has completed, check the <code>Status</code> field returned from a call to
     * <code>DescribeIndex</code>. The <code>Status</code> field is set to <code>ACTIVE</code> when the index is ready
     * to use.
     * </p>
     * <p>
     * Once the index is active, you can index your documents using the <a
     * href="https://docs.aws.amazon.com/amazonq/latest/api-reference/API_BatchPutDocument.html">
     * <code>BatchPutDocument</code> </a> API or the <a
     * href="https://docs.aws.amazon.com/amazonq/latest/api-reference/API_CreateDataSource.html">
     * <code>CreateDataSource</code> </a> API.
     * </p>
     *
     * @param createIndexRequest
     * @return A Java Future containing the result of the CreateIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Q Business service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.CreateIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CreateIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateIndexResponse> createIndex(CreateIndexRequest createIndexRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Q Business index.
     * </p>
     * <p>
     * To determine if index creation has completed, check the <code>Status</code> field returned from a call to
     * <code>DescribeIndex</code>. The <code>Status</code> field is set to <code>ACTIVE</code> when the index is ready
     * to use.
     * </p>
     * <p>
     * Once the index is active, you can index your documents using the <a
     * href="https://docs.aws.amazon.com/amazonq/latest/api-reference/API_BatchPutDocument.html">
     * <code>BatchPutDocument</code> </a> API or the <a
     * href="https://docs.aws.amazon.com/amazonq/latest/api-reference/API_CreateDataSource.html">
     * <code>CreateDataSource</code> </a> API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateIndexRequest.Builder} avoiding the need to
     * create one manually via {@link CreateIndexRequest#builder()}
     * </p>
     *
     * @param createIndexRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.CreateIndexRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Q Business service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.CreateIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CreateIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateIndexResponse> createIndex(Consumer<CreateIndexRequest.Builder> createIndexRequest) {
        return createIndex(CreateIndexRequest.builder().applyMutation(createIndexRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon Q Business plugin.
     * </p>
     *
     * @param createPluginRequest
     * @return A Java Future containing the result of the CreatePlugin operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Q Business service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.CreatePlugin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CreatePlugin" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreatePluginResponse> createPlugin(CreatePluginRequest createPluginRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Q Business plugin.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePluginRequest.Builder} avoiding the need to
     * create one manually via {@link CreatePluginRequest#builder()}
     * </p>
     *
     * @param createPluginRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.CreatePluginRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreatePlugin operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Q Business service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.CreatePlugin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CreatePlugin" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreatePluginResponse> createPlugin(Consumer<CreatePluginRequest.Builder> createPluginRequest) {
        return createPlugin(CreatePluginRequest.builder().applyMutation(createPluginRequest).build());
    }

    /**
     * <p>
     * Adds a retriever to your Amazon Q Business application.
     * </p>
     *
     * @param createRetrieverRequest
     * @return A Java Future containing the result of the CreateRetriever operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Q Business service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.CreateRetriever
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CreateRetriever" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateRetrieverResponse> createRetriever(CreateRetrieverRequest createRetrieverRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a retriever to your Amazon Q Business application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRetrieverRequest.Builder} avoiding the need
     * to create one manually via {@link CreateRetrieverRequest#builder()}
     * </p>
     *
     * @param createRetrieverRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.CreateRetrieverRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateRetriever operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Q Business service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.CreateRetriever
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CreateRetriever" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateRetrieverResponse> createRetriever(
            Consumer<CreateRetrieverRequest.Builder> createRetrieverRequest) {
        return createRetriever(CreateRetrieverRequest.builder().applyMutation(createRetrieverRequest).build());
    }

    /**
     * <p>
     * Subscribes an IAM Identity Center user or a group to a pricing tier for an Amazon Q Business application.
     * </p>
     * <p>
     * Amazon Q Business offers two subscription tiers: <code>Q_LITE</code> and <code>Q_BUSINESS</code>. Subscription
     * tier determines feature access for the user. For more information on subscriptions and pricing tiers, see <a
     * href="https://aws.amazon.com/q/business/pricing/">Amazon Q Business pricing</a>.
     * </p>
     * <note>
     * <p>
     * For an example IAM role policy for assigning subscriptions, see <a
     * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/setting-up.html#permissions">Set up required
     * permissions</a> in the Amazon Q Business User Guide.
     * </p>
     * </note>
     *
     * @param createSubscriptionRequest
     * @return A Java Future containing the result of the CreateSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.CreateSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CreateSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateSubscriptionResponse> createSubscription(CreateSubscriptionRequest createSubscriptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Subscribes an IAM Identity Center user or a group to a pricing tier for an Amazon Q Business application.
     * </p>
     * <p>
     * Amazon Q Business offers two subscription tiers: <code>Q_LITE</code> and <code>Q_BUSINESS</code>. Subscription
     * tier determines feature access for the user. For more information on subscriptions and pricing tiers, see <a
     * href="https://aws.amazon.com/q/business/pricing/">Amazon Q Business pricing</a>.
     * </p>
     * <note>
     * <p>
     * For an example IAM role policy for assigning subscriptions, see <a
     * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/setting-up.html#permissions">Set up required
     * permissions</a> in the Amazon Q Business User Guide.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSubscriptionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateSubscriptionRequest#builder()}
     * </p>
     *
     * @param createSubscriptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.CreateSubscriptionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.CreateSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CreateSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateSubscriptionResponse> createSubscription(
            Consumer<CreateSubscriptionRequest.Builder> createSubscriptionRequest) {
        return createSubscription(CreateSubscriptionRequest.builder().applyMutation(createSubscriptionRequest).build());
    }

    /**
     * <p>
     * Creates a universally unique identifier (UUID) mapped to a list of local user ids within an application.
     * </p>
     *
     * @param createUserRequest
     * @return A Java Future containing the result of the CreateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Q Business service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.CreateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CreateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateUserResponse> createUser(CreateUserRequest createUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a universally unique identifier (UUID) mapped to a list of local user ids within an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUserRequest.Builder} avoiding the need to
     * create one manually via {@link CreateUserRequest#builder()}
     * </p>
     *
     * @param createUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.CreateUserRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Q Business service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.CreateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CreateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateUserResponse> createUser(Consumer<CreateUserRequest.Builder> createUserRequest) {
        return createUser(CreateUserRequest.builder().applyMutation(createUserRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon Q Business web experience.
     * </p>
     *
     * @param createWebExperienceRequest
     * @return A Java Future containing the result of the CreateWebExperience operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Q Business service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.CreateWebExperience
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CreateWebExperience" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateWebExperienceResponse> createWebExperience(
            CreateWebExperienceRequest createWebExperienceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Q Business web experience.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWebExperienceRequest.Builder} avoiding the
     * need to create one manually via {@link CreateWebExperienceRequest#builder()}
     * </p>
     *
     * @param createWebExperienceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.CreateWebExperienceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateWebExperience operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Q Business service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.CreateWebExperience
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CreateWebExperience" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateWebExperienceResponse> createWebExperience(
            Consumer<CreateWebExperienceRequest.Builder> createWebExperienceRequest) {
        return createWebExperience(CreateWebExperienceRequest.builder().applyMutation(createWebExperienceRequest).build());
    }

    /**
     * <p>
     * Deletes an Amazon Q Business application.
     * </p>
     *
     * @param deleteApplicationRequest
     * @return A Java Future containing the result of the DeleteApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.DeleteApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteApplicationResponse> deleteApplication(DeleteApplicationRequest deleteApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Amazon Q Business application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteApplicationRequest#builder()}
     * </p>
     *
     * @param deleteApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.DeleteApplicationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.DeleteApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteApplicationResponse> deleteApplication(
            Consumer<DeleteApplicationRequest.Builder> deleteApplicationRequest) {
        return deleteApplication(DeleteApplicationRequest.builder().applyMutation(deleteApplicationRequest).build());
    }

    /**
     * <p>
     * Deletes an attachment associated with a specific Amazon Q Business conversation.
     * </p>
     *
     * @param deleteAttachmentRequest
     * @return A Java Future containing the result of the DeleteAttachment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>LicenseNotFoundException You don't have permissions to perform the action because your license is
     *         inactive. Ask your admin to activate your license and try again after your licence is active.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.DeleteAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteAttachment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteAttachmentResponse> deleteAttachment(DeleteAttachmentRequest deleteAttachmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an attachment associated with a specific Amazon Q Business conversation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAttachmentRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteAttachmentRequest#builder()}
     * </p>
     *
     * @param deleteAttachmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.DeleteAttachmentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteAttachment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>LicenseNotFoundException You don't have permissions to perform the action because your license is
     *         inactive. Ask your admin to activate your license and try again after your licence is active.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.DeleteAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteAttachment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteAttachmentResponse> deleteAttachment(
            Consumer<DeleteAttachmentRequest.Builder> deleteAttachmentRequest) {
        return deleteAttachment(DeleteAttachmentRequest.builder().applyMutation(deleteAttachmentRequest).build());
    }

    /**
     * <p>
     * Deletes chat controls configured for an existing Amazon Q Business application.
     * </p>
     *
     * @param deleteChatControlsConfigurationRequest
     * @return A Java Future containing the result of the DeleteChatControlsConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.DeleteChatControlsConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteChatControlsConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteChatControlsConfigurationResponse> deleteChatControlsConfiguration(
            DeleteChatControlsConfigurationRequest deleteChatControlsConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes chat controls configured for an existing Amazon Q Business application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteChatControlsConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteChatControlsConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteChatControlsConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.DeleteChatControlsConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteChatControlsConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.DeleteChatControlsConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteChatControlsConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteChatControlsConfigurationResponse> deleteChatControlsConfiguration(
            Consumer<DeleteChatControlsConfigurationRequest.Builder> deleteChatControlsConfigurationRequest) {
        return deleteChatControlsConfiguration(DeleteChatControlsConfigurationRequest.builder()
                .applyMutation(deleteChatControlsConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes a specified chat response configuration from an Amazon Q Business application.
     * </p>
     *
     * @param deleteChatResponseConfigurationRequest
     * @return A Java Future containing the result of the DeleteChatResponseConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.DeleteChatResponseConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteChatResponseConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteChatResponseConfigurationResponse> deleteChatResponseConfiguration(
            DeleteChatResponseConfigurationRequest deleteChatResponseConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specified chat response configuration from an Amazon Q Business application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteChatResponseConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteChatResponseConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteChatResponseConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.DeleteChatResponseConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteChatResponseConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.DeleteChatResponseConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteChatResponseConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteChatResponseConfigurationResponse> deleteChatResponseConfiguration(
            Consumer<DeleteChatResponseConfigurationRequest.Builder> deleteChatResponseConfigurationRequest) {
        return deleteChatResponseConfiguration(DeleteChatResponseConfigurationRequest.builder()
                .applyMutation(deleteChatResponseConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes an Amazon Q Business web experience conversation.
     * </p>
     *
     * @param deleteConversationRequest
     * @return A Java Future containing the result of the DeleteConversation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>LicenseNotFoundException You don't have permissions to perform the action because your license is
     *         inactive. Ask your admin to activate your license and try again after your licence is active.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.DeleteConversation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteConversation" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteConversationResponse> deleteConversation(DeleteConversationRequest deleteConversationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Amazon Q Business web experience conversation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConversationRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteConversationRequest#builder()}
     * </p>
     *
     * @param deleteConversationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.DeleteConversationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteConversation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>LicenseNotFoundException You don't have permissions to perform the action because your license is
     *         inactive. Ask your admin to activate your license and try again after your licence is active.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.DeleteConversation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteConversation" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteConversationResponse> deleteConversation(
            Consumer<DeleteConversationRequest.Builder> deleteConversationRequest) {
        return deleteConversation(DeleteConversationRequest.builder().applyMutation(deleteConversationRequest).build());
    }

    /**
     * <p>
     * Deletes a specified data accessor. This operation permanently removes the data accessor and its associated IAM
     * Identity Center application. Any access granted to the ISV through this data accessor will be revoked.
     * </p>
     *
     * @param deleteDataAccessorRequest
     * @return A Java Future containing the result of the DeleteDataAccessor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.DeleteDataAccessor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteDataAccessor" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDataAccessorResponse> deleteDataAccessor(DeleteDataAccessorRequest deleteDataAccessorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specified data accessor. This operation permanently removes the data accessor and its associated IAM
     * Identity Center application. Any access granted to the ISV through this data accessor will be revoked.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDataAccessorRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDataAccessorRequest#builder()}
     * </p>
     *
     * @param deleteDataAccessorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.DeleteDataAccessorRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteDataAccessor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.DeleteDataAccessor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteDataAccessor" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDataAccessorResponse> deleteDataAccessor(
            Consumer<DeleteDataAccessorRequest.Builder> deleteDataAccessorRequest) {
        return deleteDataAccessor(DeleteDataAccessorRequest.builder().applyMutation(deleteDataAccessorRequest).build());
    }

    /**
     * <p>
     * Deletes an Amazon Q Business data source connector. While the data source is being deleted, the
     * <code>Status</code> field returned by a call to the <code>DescribeDataSource</code> API is set to
     * <code>DELETING</code>.
     * </p>
     *
     * @param deleteDataSourceRequest
     * @return A Java Future containing the result of the DeleteDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.DeleteDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteDataSource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDataSourceResponse> deleteDataSource(DeleteDataSourceRequest deleteDataSourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Amazon Q Business data source connector. While the data source is being deleted, the
     * <code>Status</code> field returned by a call to the <code>DescribeDataSource</code> API is set to
     * <code>DELETING</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDataSourceRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDataSourceRequest#builder()}
     * </p>
     *
     * @param deleteDataSourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.DeleteDataSourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.DeleteDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteDataSource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDataSourceResponse> deleteDataSource(
            Consumer<DeleteDataSourceRequest.Builder> deleteDataSourceRequest) {
        return deleteDataSource(DeleteDataSourceRequest.builder().applyMutation(deleteDataSourceRequest).build());
    }

    /**
     * <p>
     * Deletes a group so that all users and sub groups that belong to the group can no longer access documents only
     * available to that group. For example, after deleting the group "Summer Interns", all interns who belonged to that
     * group no longer see intern-only documents in their chat results.
     * </p>
     * <p>
     * If you want to delete, update, or replace users or sub groups of a group, you need to use the
     * <code>PutGroup</code> operation. For example, if a user in the group "Engineering" leaves the engineering team
     * and another user takes their place, you provide an updated list of users or sub groups that belong to the
     * "Engineering" group when calling <code>PutGroup</code>.
     * </p>
     *
     * @param deleteGroupRequest
     * @return A Java Future containing the result of the DeleteGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.DeleteGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteGroupResponse> deleteGroup(DeleteGroupRequest deleteGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a group so that all users and sub groups that belong to the group can no longer access documents only
     * available to that group. For example, after deleting the group "Summer Interns", all interns who belonged to that
     * group no longer see intern-only documents in their chat results.
     * </p>
     * <p>
     * If you want to delete, update, or replace users or sub groups of a group, you need to use the
     * <code>PutGroup</code> operation. For example, if a user in the group "Engineering" leaves the engineering team
     * and another user takes their place, you provide an updated list of users or sub groups that belong to the
     * "Engineering" group when calling <code>PutGroup</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGroupRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteGroupRequest#builder()}
     * </p>
     *
     * @param deleteGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.DeleteGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.DeleteGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteGroupResponse> deleteGroup(Consumer<DeleteGroupRequest.Builder> deleteGroupRequest) {
        return deleteGroup(DeleteGroupRequest.builder().applyMutation(deleteGroupRequest).build());
    }

    /**
     * <p>
     * Deletes an Amazon Q Business index.
     * </p>
     *
     * @param deleteIndexRequest
     * @return A Java Future containing the result of the DeleteIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.DeleteIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteIndexResponse> deleteIndex(DeleteIndexRequest deleteIndexRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Amazon Q Business index.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIndexRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteIndexRequest#builder()}
     * </p>
     *
     * @param deleteIndexRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.DeleteIndexRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.DeleteIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteIndexResponse> deleteIndex(Consumer<DeleteIndexRequest.Builder> deleteIndexRequest) {
        return deleteIndex(DeleteIndexRequest.builder().applyMutation(deleteIndexRequest).build());
    }

    /**
     * <p>
     * Deletes an Amazon Q Business plugin.
     * </p>
     *
     * @param deletePluginRequest
     * @return A Java Future containing the result of the DeletePlugin operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.DeletePlugin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeletePlugin" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeletePluginResponse> deletePlugin(DeletePluginRequest deletePluginRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Amazon Q Business plugin.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePluginRequest.Builder} avoiding the need to
     * create one manually via {@link DeletePluginRequest#builder()}
     * </p>
     *
     * @param deletePluginRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.DeletePluginRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeletePlugin operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.DeletePlugin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeletePlugin" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeletePluginResponse> deletePlugin(Consumer<DeletePluginRequest.Builder> deletePluginRequest) {
        return deletePlugin(DeletePluginRequest.builder().applyMutation(deletePluginRequest).build());
    }

    /**
     * <p>
     * Deletes the retriever used by an Amazon Q Business application.
     * </p>
     *
     * @param deleteRetrieverRequest
     * @return A Java Future containing the result of the DeleteRetriever operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.DeleteRetriever
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteRetriever" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteRetrieverResponse> deleteRetriever(DeleteRetrieverRequest deleteRetrieverRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the retriever used by an Amazon Q Business application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRetrieverRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteRetrieverRequest#builder()}
     * </p>
     *
     * @param deleteRetrieverRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.DeleteRetrieverRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteRetriever operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.DeleteRetriever
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteRetriever" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteRetrieverResponse> deleteRetriever(
            Consumer<DeleteRetrieverRequest.Builder> deleteRetrieverRequest) {
        return deleteRetriever(DeleteRetrieverRequest.builder().applyMutation(deleteRetrieverRequest).build());
    }

    /**
     * <p>
     * Deletes a user by email id.
     * </p>
     *
     * @param deleteUserRequest
     * @return A Java Future containing the result of the DeleteUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.DeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteUserResponse> deleteUser(DeleteUserRequest deleteUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a user by email id.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUserRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteUserRequest#builder()}
     * </p>
     *
     * @param deleteUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.DeleteUserRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.DeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteUserResponse> deleteUser(Consumer<DeleteUserRequest.Builder> deleteUserRequest) {
        return deleteUser(DeleteUserRequest.builder().applyMutation(deleteUserRequest).build());
    }

    /**
     * <p>
     * Deletes an Amazon Q Business web experience.
     * </p>
     *
     * @param deleteWebExperienceRequest
     * @return A Java Future containing the result of the DeleteWebExperience operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.DeleteWebExperience
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteWebExperience" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteWebExperienceResponse> deleteWebExperience(
            DeleteWebExperienceRequest deleteWebExperienceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Amazon Q Business web experience.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWebExperienceRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteWebExperienceRequest#builder()}
     * </p>
     *
     * @param deleteWebExperienceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.DeleteWebExperienceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteWebExperience operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.DeleteWebExperience
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteWebExperience" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteWebExperienceResponse> deleteWebExperience(
            Consumer<DeleteWebExperienceRequest.Builder> deleteWebExperienceRequest) {
        return deleteWebExperience(DeleteWebExperienceRequest.builder().applyMutation(deleteWebExperienceRequest).build());
    }

    /**
     * <p>
     * Removes a permission policy from a Amazon Q Business application, revoking the cross-account access that was
     * previously granted to an ISV. This operation deletes the specified policy statement from the application's
     * permission policy.
     * </p>
     *
     * @param disassociatePermissionRequest
     * @return A Java Future containing the result of the DisassociatePermission operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.DisassociatePermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DisassociatePermission"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociatePermissionResponse> disassociatePermission(
            DisassociatePermissionRequest disassociatePermissionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a permission policy from a Amazon Q Business application, revoking the cross-account access that was
     * previously granted to an ISV. This operation deletes the specified policy statement from the application's
     * permission policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociatePermissionRequest.Builder} avoiding the
     * need to create one manually via {@link DisassociatePermissionRequest#builder()}
     * </p>
     *
     * @param disassociatePermissionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.DisassociatePermissionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DisassociatePermission operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.DisassociatePermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DisassociatePermission"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociatePermissionResponse> disassociatePermission(
            Consumer<DisassociatePermissionRequest.Builder> disassociatePermissionRequest) {
        return disassociatePermission(DisassociatePermissionRequest.builder().applyMutation(disassociatePermissionRequest)
                .build());
    }

    /**
     * <p>
     * Gets information about an existing Amazon Q Business application.
     * </p>
     *
     * @param getApplicationRequest
     * @return A Java Future containing the result of the GetApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.GetApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetApplication" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetApplicationResponse> getApplication(GetApplicationRequest getApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about an existing Amazon Q Business application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetApplicationRequest.Builder} avoiding the need to
     * create one manually via {@link GetApplicationRequest#builder()}
     * </p>
     *
     * @param getApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.GetApplicationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.GetApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetApplication" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetApplicationResponse> getApplication(Consumer<GetApplicationRequest.Builder> getApplicationRequest) {
        return getApplication(GetApplicationRequest.builder().applyMutation(getApplicationRequest).build());
    }

    /**
     * <p>
     * Gets information about chat controls configured for an existing Amazon Q Business application.
     * </p>
     *
     * @param getChatControlsConfigurationRequest
     * @return A Java Future containing the result of the GetChatControlsConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.GetChatControlsConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetChatControlsConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetChatControlsConfigurationResponse> getChatControlsConfiguration(
            GetChatControlsConfigurationRequest getChatControlsConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about chat controls configured for an existing Amazon Q Business application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetChatControlsConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link GetChatControlsConfigurationRequest#builder()}
     * </p>
     *
     * @param getChatControlsConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.GetChatControlsConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetChatControlsConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.GetChatControlsConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetChatControlsConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetChatControlsConfigurationResponse> getChatControlsConfiguration(
            Consumer<GetChatControlsConfigurationRequest.Builder> getChatControlsConfigurationRequest) {
        return getChatControlsConfiguration(GetChatControlsConfigurationRequest.builder()
                .applyMutation(getChatControlsConfigurationRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getChatControlsConfiguration(software.amazon.awssdk.services.qbusiness.model.GetChatControlsConfigurationRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.GetChatControlsConfigurationPublisher publisher = client.getChatControlsConfigurationPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.GetChatControlsConfigurationPublisher publisher = client.getChatControlsConfigurationPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qbusiness.model.GetChatControlsConfigurationResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qbusiness.model.GetChatControlsConfigurationResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getChatControlsConfiguration(software.amazon.awssdk.services.qbusiness.model.GetChatControlsConfigurationRequest)}
     * operation.</b>
     * </p>
     *
     * @param getChatControlsConfigurationRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.GetChatControlsConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetChatControlsConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetChatControlsConfigurationPublisher getChatControlsConfigurationPaginator(
            GetChatControlsConfigurationRequest getChatControlsConfigurationRequest) {
        return new GetChatControlsConfigurationPublisher(this, getChatControlsConfigurationRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getChatControlsConfiguration(software.amazon.awssdk.services.qbusiness.model.GetChatControlsConfigurationRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.GetChatControlsConfigurationPublisher publisher = client.getChatControlsConfigurationPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.GetChatControlsConfigurationPublisher publisher = client.getChatControlsConfigurationPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qbusiness.model.GetChatControlsConfigurationResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qbusiness.model.GetChatControlsConfigurationResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getChatControlsConfiguration(software.amazon.awssdk.services.qbusiness.model.GetChatControlsConfigurationRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetChatControlsConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link GetChatControlsConfigurationRequest#builder()}
     * </p>
     *
     * @param getChatControlsConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.GetChatControlsConfigurationRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.GetChatControlsConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetChatControlsConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetChatControlsConfigurationPublisher getChatControlsConfigurationPaginator(
            Consumer<GetChatControlsConfigurationRequest.Builder> getChatControlsConfigurationRequest) {
        return getChatControlsConfigurationPaginator(GetChatControlsConfigurationRequest.builder()
                .applyMutation(getChatControlsConfigurationRequest).build());
    }

    /**
     * <p>
     * Retrieves detailed information about a specific chat response configuration from an Amazon Q Business
     * application. This operation returns the complete configuration settings and metadata.
     * </p>
     *
     * @param getChatResponseConfigurationRequest
     * @return A Java Future containing the result of the GetChatResponseConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.GetChatResponseConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetChatResponseConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetChatResponseConfigurationResponse> getChatResponseConfiguration(
            GetChatResponseConfigurationRequest getChatResponseConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves detailed information about a specific chat response configuration from an Amazon Q Business
     * application. This operation returns the complete configuration settings and metadata.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetChatResponseConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link GetChatResponseConfigurationRequest#builder()}
     * </p>
     *
     * @param getChatResponseConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.GetChatResponseConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetChatResponseConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.GetChatResponseConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetChatResponseConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetChatResponseConfigurationResponse> getChatResponseConfiguration(
            Consumer<GetChatResponseConfigurationRequest.Builder> getChatResponseConfigurationRequest) {
        return getChatResponseConfiguration(GetChatResponseConfigurationRequest.builder()
                .applyMutation(getChatResponseConfigurationRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a specified data accessor. This operation returns details about the data accessor,
     * including its display name, unique identifier, Amazon Resource Name (ARN), the associated Amazon Q Business
     * application and IAM Identity Center application, the IAM role for the ISV, the action configurations, and the
     * timestamps for when the data accessor was created and last updated.
     * </p>
     *
     * @param getDataAccessorRequest
     * @return A Java Future containing the result of the GetDataAccessor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.GetDataAccessor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetDataAccessor" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDataAccessorResponse> getDataAccessor(GetDataAccessorRequest getDataAccessorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a specified data accessor. This operation returns details about the data accessor,
     * including its display name, unique identifier, Amazon Resource Name (ARN), the associated Amazon Q Business
     * application and IAM Identity Center application, the IAM role for the ISV, the action configurations, and the
     * timestamps for when the data accessor was created and last updated.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDataAccessorRequest.Builder} avoiding the need
     * to create one manually via {@link GetDataAccessorRequest#builder()}
     * </p>
     *
     * @param getDataAccessorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.GetDataAccessorRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetDataAccessor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.GetDataAccessor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetDataAccessor" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDataAccessorResponse> getDataAccessor(
            Consumer<GetDataAccessorRequest.Builder> getDataAccessorRequest) {
        return getDataAccessor(GetDataAccessorRequest.builder().applyMutation(getDataAccessorRequest).build());
    }

    /**
     * <p>
     * Gets information about an existing Amazon Q Business data source connector.
     * </p>
     *
     * @param getDataSourceRequest
     * @return A Java Future containing the result of the GetDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.GetDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDataSourceResponse> getDataSource(GetDataSourceRequest getDataSourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about an existing Amazon Q Business data source connector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDataSourceRequest.Builder} avoiding the need to
     * create one manually via {@link GetDataSourceRequest#builder()}
     * </p>
     *
     * @param getDataSourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.GetDataSourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.GetDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDataSourceResponse> getDataSource(Consumer<GetDataSourceRequest.Builder> getDataSourceRequest) {
        return getDataSource(GetDataSourceRequest.builder().applyMutation(getDataSourceRequest).build());
    }

    /**
     * <p>
     * Retrieves the content of a document that was ingested into Amazon Q Business. This API validates user
     * authorization against document ACLs before returning a pre-signed URL for secure document access. You can
     * download or view source documents referenced in chat responses through the URL.
     * </p>
     *
     * @param getDocumentContentRequest
     * @return A Java Future containing the result of the GetDocumentContent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.GetDocumentContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetDocumentContent" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetDocumentContentResponse> getDocumentContent(GetDocumentContentRequest getDocumentContentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the content of a document that was ingested into Amazon Q Business. This API validates user
     * authorization against document ACLs before returning a pre-signed URL for secure document access. You can
     * download or view source documents referenced in chat responses through the URL.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDocumentContentRequest.Builder} avoiding the
     * need to create one manually via {@link GetDocumentContentRequest#builder()}
     * </p>
     *
     * @param getDocumentContentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.GetDocumentContentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetDocumentContent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.GetDocumentContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetDocumentContent" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetDocumentContentResponse> getDocumentContent(
            Consumer<GetDocumentContentRequest.Builder> getDocumentContentRequest) {
        return getDocumentContent(GetDocumentContentRequest.builder().applyMutation(getDocumentContentRequest).build());
    }

    /**
     * <p>
     * Describes a group by group name.
     * </p>
     *
     * @param getGroupRequest
     * @return A Java Future containing the result of the GetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.GetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetGroupResponse> getGroup(GetGroupRequest getGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a group by group name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGroupRequest.Builder} avoiding the need to
     * create one manually via {@link GetGroupRequest#builder()}
     * </p>
     *
     * @param getGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.GetGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.GetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetGroupResponse> getGroup(Consumer<GetGroupRequest.Builder> getGroupRequest) {
        return getGroup(GetGroupRequest.builder().applyMutation(getGroupRequest).build());
    }

    /**
     * <p>
     * Gets information about an existing Amazon Q Business index.
     * </p>
     *
     * @param getIndexRequest
     * @return A Java Future containing the result of the GetIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.GetIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetIndexResponse> getIndex(GetIndexRequest getIndexRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about an existing Amazon Q Business index.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIndexRequest.Builder} avoiding the need to
     * create one manually via {@link GetIndexRequest#builder()}
     * </p>
     *
     * @param getIndexRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.GetIndexRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.GetIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetIndexResponse> getIndex(Consumer<GetIndexRequest.Builder> getIndexRequest) {
        return getIndex(GetIndexRequest.builder().applyMutation(getIndexRequest).build());
    }

    /**
     * <p>
     * Returns the image bytes corresponding to a media object. If you have implemented your own application with the
     * Chat and ChatSync APIs, and have enabled content extraction from visual data in Amazon Q Business, you use the
     * GetMedia API operation to download the images so you can show them in your UI with responses.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/extracting-meaning-from-images.html">Extracting
     * semantic meaning from images and visuals</a>.
     * </p>
     *
     * @param getMediaRequest
     * @return A Java Future containing the result of the GetMedia operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>LicenseNotFoundException You don't have permissions to perform the action because your license is
     *         inactive. Ask your admin to activate your license and try again after your licence is active.</li>
     *         <li>MediaTooLargeException The requested media object is too large to be returned.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.GetMedia
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetMedia" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetMediaResponse> getMedia(GetMediaRequest getMediaRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the image bytes corresponding to a media object. If you have implemented your own application with the
     * Chat and ChatSync APIs, and have enabled content extraction from visual data in Amazon Q Business, you use the
     * GetMedia API operation to download the images so you can show them in your UI with responses.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/extracting-meaning-from-images.html">Extracting
     * semantic meaning from images and visuals</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMediaRequest.Builder} avoiding the need to
     * create one manually via {@link GetMediaRequest#builder()}
     * </p>
     *
     * @param getMediaRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.GetMediaRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetMedia operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>LicenseNotFoundException You don't have permissions to perform the action because your license is
     *         inactive. Ask your admin to activate your license and try again after your licence is active.</li>
     *         <li>MediaTooLargeException The requested media object is too large to be returned.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.GetMedia
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetMedia" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetMediaResponse> getMedia(Consumer<GetMediaRequest.Builder> getMediaRequest) {
        return getMedia(GetMediaRequest.builder().applyMutation(getMediaRequest).build());
    }

    /**
     * <p>
     * Gets information about an existing Amazon Q Business plugin.
     * </p>
     *
     * @param getPluginRequest
     * @return A Java Future containing the result of the GetPlugin operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.GetPlugin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetPlugin" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetPluginResponse> getPlugin(GetPluginRequest getPluginRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about an existing Amazon Q Business plugin.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPluginRequest.Builder} avoiding the need to
     * create one manually via {@link GetPluginRequest#builder()}
     * </p>
     *
     * @param getPluginRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.GetPluginRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetPlugin operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.GetPlugin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetPlugin" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetPluginResponse> getPlugin(Consumer<GetPluginRequest.Builder> getPluginRequest) {
        return getPlugin(GetPluginRequest.builder().applyMutation(getPluginRequest).build());
    }

    /**
     * <p>
     * Retrieves the current permission policy for a Amazon Q Business application. The policy is returned as a
     * JSON-formatted string and defines the IAM actions that are allowed or denied for the application's resources.
     * </p>
     *
     * @param getPolicyRequest
     * @return A Java Future containing the result of the GetPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.GetPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetPolicyResponse> getPolicy(GetPolicyRequest getPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the current permission policy for a Amazon Q Business application. The policy is returned as a
     * JSON-formatted string and defines the IAM actions that are allowed or denied for the application's resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPolicyRequest.Builder} avoiding the need to
     * create one manually via {@link GetPolicyRequest#builder()}
     * </p>
     *
     * @param getPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.GetPolicyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.GetPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetPolicyResponse> getPolicy(Consumer<GetPolicyRequest.Builder> getPolicyRequest) {
        return getPolicy(GetPolicyRequest.builder().applyMutation(getPolicyRequest).build());
    }

    /**
     * <p>
     * Gets information about an existing retriever used by an Amazon Q Business application.
     * </p>
     *
     * @param getRetrieverRequest
     * @return A Java Future containing the result of the GetRetriever operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.GetRetriever
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetRetriever" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetRetrieverResponse> getRetriever(GetRetrieverRequest getRetrieverRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about an existing retriever used by an Amazon Q Business application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRetrieverRequest.Builder} avoiding the need to
     * create one manually via {@link GetRetrieverRequest#builder()}
     * </p>
     *
     * @param getRetrieverRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.GetRetrieverRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetRetriever operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.GetRetriever
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetRetriever" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetRetrieverResponse> getRetriever(Consumer<GetRetrieverRequest.Builder> getRetrieverRequest) {
        return getRetriever(GetRetrieverRequest.builder().applyMutation(getRetrieverRequest).build());
    }

    /**
     * <p>
     * Describes the universally unique identifier (UUID) associated with a local user in a data source.
     * </p>
     *
     * @param getUserRequest
     * @return A Java Future containing the result of the GetUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.GetUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetUserResponse> getUser(GetUserRequest getUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the universally unique identifier (UUID) associated with a local user in a data source.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUserRequest.Builder} avoiding the need to create
     * one manually via {@link GetUserRequest#builder()}
     * </p>
     *
     * @param getUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.GetUserRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.GetUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetUserResponse> getUser(Consumer<GetUserRequest.Builder> getUserRequest) {
        return getUser(GetUserRequest.builder().applyMutation(getUserRequest).build());
    }

    /**
     * <p>
     * Gets information about an existing Amazon Q Business web experience.
     * </p>
     *
     * @param getWebExperienceRequest
     * @return A Java Future containing the result of the GetWebExperience operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.GetWebExperience
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetWebExperience" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetWebExperienceResponse> getWebExperience(GetWebExperienceRequest getWebExperienceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about an existing Amazon Q Business web experience.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWebExperienceRequest.Builder} avoiding the need
     * to create one manually via {@link GetWebExperienceRequest#builder()}
     * </p>
     *
     * @param getWebExperienceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.GetWebExperienceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetWebExperience operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.GetWebExperience
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetWebExperience" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetWebExperienceResponse> getWebExperience(
            Consumer<GetWebExperienceRequest.Builder> getWebExperienceRequest) {
        return getWebExperience(GetWebExperienceRequest.builder().applyMutation(getWebExperienceRequest).build());
    }

    /**
     * <p>
     * Lists Amazon Q Business applications.
     * </p>
     * <note>
     * <p>
     * Amazon Q Business applications may securely transmit data for processing across Amazon Web Services Regions
     * within your geography. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/cross-region-inference.html">Cross region inference
     * in Amazon Q Business</a>.
     * </p>
     * </note>
     *
     * @param listApplicationsRequest
     * @return A Java Future containing the result of the ListApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListApplications" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListApplicationsResponse> listApplications(ListApplicationsRequest listApplicationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists Amazon Q Business applications.
     * </p>
     * <note>
     * <p>
     * Amazon Q Business applications may securely transmit data for processing across Amazon Web Services Regions
     * within your geography. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/cross-region-inference.html">Cross region inference
     * in Amazon Q Business</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListApplicationsRequest#builder()}
     * </p>
     *
     * @param listApplicationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.ListApplicationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListApplications" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListApplicationsResponse> listApplications(
            Consumer<ListApplicationsRequest.Builder> listApplicationsRequest) {
        return listApplications(ListApplicationsRequest.builder().applyMutation(listApplicationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listApplications(software.amazon.awssdk.services.qbusiness.model.ListApplicationsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListApplicationsPublisher publisher = client.listApplicationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListApplicationsPublisher publisher = client.listApplicationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qbusiness.model.ListApplicationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qbusiness.model.ListApplicationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplications(software.amazon.awssdk.services.qbusiness.model.ListApplicationsRequest)} operation.</b>
     * </p>
     *
     * @param listApplicationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListApplications" target="_top">AWS
     *      API Documentation</a>
     */
    default ListApplicationsPublisher listApplicationsPaginator(ListApplicationsRequest listApplicationsRequest) {
        return new ListApplicationsPublisher(this, listApplicationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listApplications(software.amazon.awssdk.services.qbusiness.model.ListApplicationsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListApplicationsPublisher publisher = client.listApplicationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListApplicationsPublisher publisher = client.listApplicationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qbusiness.model.ListApplicationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qbusiness.model.ListApplicationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplications(software.amazon.awssdk.services.qbusiness.model.ListApplicationsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListApplicationsRequest#builder()}
     * </p>
     *
     * @param listApplicationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.ListApplicationsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListApplications" target="_top">AWS
     *      API Documentation</a>
     */
    default ListApplicationsPublisher listApplicationsPaginator(Consumer<ListApplicationsRequest.Builder> listApplicationsRequest) {
        return listApplicationsPaginator(ListApplicationsRequest.builder().applyMutation(listApplicationsRequest).build());
    }

    /**
     * <p>
     * Gets a list of attachments associated with an Amazon Q Business web experience or a list of attachements
     * associated with a specific Amazon Q Business conversation.
     * </p>
     *
     * @param listAttachmentsRequest
     * @return A Java Future containing the result of the ListAttachments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>LicenseNotFoundException You don't have permissions to perform the action because your license is
     *         inactive. Ask your admin to activate your license and try again after your licence is active.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListAttachments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListAttachments" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAttachmentsResponse> listAttachments(ListAttachmentsRequest listAttachmentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of attachments associated with an Amazon Q Business web experience or a list of attachements
     * associated with a specific Amazon Q Business conversation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAttachmentsRequest.Builder} avoiding the need
     * to create one manually via {@link ListAttachmentsRequest#builder()}
     * </p>
     *
     * @param listAttachmentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.ListAttachmentsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListAttachments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>LicenseNotFoundException You don't have permissions to perform the action because your license is
     *         inactive. Ask your admin to activate your license and try again after your licence is active.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListAttachments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListAttachments" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAttachmentsResponse> listAttachments(
            Consumer<ListAttachmentsRequest.Builder> listAttachmentsRequest) {
        return listAttachments(ListAttachmentsRequest.builder().applyMutation(listAttachmentsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAttachments(software.amazon.awssdk.services.qbusiness.model.ListAttachmentsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListAttachmentsPublisher publisher = client.listAttachmentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListAttachmentsPublisher publisher = client.listAttachmentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qbusiness.model.ListAttachmentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qbusiness.model.ListAttachmentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAttachments(software.amazon.awssdk.services.qbusiness.model.ListAttachmentsRequest)} operation.</b>
     * </p>
     *
     * @param listAttachmentsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>LicenseNotFoundException You don't have permissions to perform the action because your license is
     *         inactive. Ask your admin to activate your license and try again after your licence is active.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListAttachments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListAttachments" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAttachmentsPublisher listAttachmentsPaginator(ListAttachmentsRequest listAttachmentsRequest) {
        return new ListAttachmentsPublisher(this, listAttachmentsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAttachments(software.amazon.awssdk.services.qbusiness.model.ListAttachmentsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListAttachmentsPublisher publisher = client.listAttachmentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListAttachmentsPublisher publisher = client.listAttachmentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qbusiness.model.ListAttachmentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qbusiness.model.ListAttachmentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAttachments(software.amazon.awssdk.services.qbusiness.model.ListAttachmentsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAttachmentsRequest.Builder} avoiding the need
     * to create one manually via {@link ListAttachmentsRequest#builder()}
     * </p>
     *
     * @param listAttachmentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.ListAttachmentsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>LicenseNotFoundException You don't have permissions to perform the action because your license is
     *         inactive. Ask your admin to activate your license and try again after your licence is active.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListAttachments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListAttachments" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAttachmentsPublisher listAttachmentsPaginator(Consumer<ListAttachmentsRequest.Builder> listAttachmentsRequest) {
        return listAttachmentsPaginator(ListAttachmentsRequest.builder().applyMutation(listAttachmentsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of all chat response configurations available in a specified Amazon Q Business application. This
     * operation returns summary information about each configuration to help administrators manage and select
     * appropriate response settings.
     * </p>
     *
     * @param listChatResponseConfigurationsRequest
     * @return A Java Future containing the result of the ListChatResponseConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListChatResponseConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListChatResponseConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListChatResponseConfigurationsResponse> listChatResponseConfigurations(
            ListChatResponseConfigurationsRequest listChatResponseConfigurationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of all chat response configurations available in a specified Amazon Q Business application. This
     * operation returns summary information about each configuration to help administrators manage and select
     * appropriate response settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListChatResponseConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListChatResponseConfigurationsRequest#builder()}
     * </p>
     *
     * @param listChatResponseConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.ListChatResponseConfigurationsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListChatResponseConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListChatResponseConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListChatResponseConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListChatResponseConfigurationsResponse> listChatResponseConfigurations(
            Consumer<ListChatResponseConfigurationsRequest.Builder> listChatResponseConfigurationsRequest) {
        return listChatResponseConfigurations(ListChatResponseConfigurationsRequest.builder()
                .applyMutation(listChatResponseConfigurationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listChatResponseConfigurations(software.amazon.awssdk.services.qbusiness.model.ListChatResponseConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListChatResponseConfigurationsPublisher publisher = client.listChatResponseConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListChatResponseConfigurationsPublisher publisher = client.listChatResponseConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qbusiness.model.ListChatResponseConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qbusiness.model.ListChatResponseConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listChatResponseConfigurations(software.amazon.awssdk.services.qbusiness.model.ListChatResponseConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listChatResponseConfigurationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListChatResponseConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListChatResponseConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListChatResponseConfigurationsPublisher listChatResponseConfigurationsPaginator(
            ListChatResponseConfigurationsRequest listChatResponseConfigurationsRequest) {
        return new ListChatResponseConfigurationsPublisher(this, listChatResponseConfigurationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listChatResponseConfigurations(software.amazon.awssdk.services.qbusiness.model.ListChatResponseConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListChatResponseConfigurationsPublisher publisher = client.listChatResponseConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListChatResponseConfigurationsPublisher publisher = client.listChatResponseConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qbusiness.model.ListChatResponseConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qbusiness.model.ListChatResponseConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listChatResponseConfigurations(software.amazon.awssdk.services.qbusiness.model.ListChatResponseConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListChatResponseConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListChatResponseConfigurationsRequest#builder()}
     * </p>
     *
     * @param listChatResponseConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.ListChatResponseConfigurationsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListChatResponseConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListChatResponseConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListChatResponseConfigurationsPublisher listChatResponseConfigurationsPaginator(
            Consumer<ListChatResponseConfigurationsRequest.Builder> listChatResponseConfigurationsRequest) {
        return listChatResponseConfigurationsPaginator(ListChatResponseConfigurationsRequest.builder()
                .applyMutation(listChatResponseConfigurationsRequest).build());
    }

    /**
     * <p>
     * Lists one or more Amazon Q Business conversations.
     * </p>
     *
     * @param listConversationsRequest
     * @return A Java Future containing the result of the ListConversations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>LicenseNotFoundException You don't have permissions to perform the action because your license is
     *         inactive. Ask your admin to activate your license and try again after your licence is active.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListConversations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListConversations" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListConversationsResponse> listConversations(ListConversationsRequest listConversationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists one or more Amazon Q Business conversations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConversationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListConversationsRequest#builder()}
     * </p>
     *
     * @param listConversationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.ListConversationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListConversations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>LicenseNotFoundException You don't have permissions to perform the action because your license is
     *         inactive. Ask your admin to activate your license and try again after your licence is active.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListConversations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListConversations" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListConversationsResponse> listConversations(
            Consumer<ListConversationsRequest.Builder> listConversationsRequest) {
        return listConversations(ListConversationsRequest.builder().applyMutation(listConversationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listConversations(software.amazon.awssdk.services.qbusiness.model.ListConversationsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListConversationsPublisher publisher = client.listConversationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListConversationsPublisher publisher = client.listConversationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qbusiness.model.ListConversationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qbusiness.model.ListConversationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConversations(software.amazon.awssdk.services.qbusiness.model.ListConversationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listConversationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>LicenseNotFoundException You don't have permissions to perform the action because your license is
     *         inactive. Ask your admin to activate your license and try again after your licence is active.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListConversations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListConversations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListConversationsPublisher listConversationsPaginator(ListConversationsRequest listConversationsRequest) {
        return new ListConversationsPublisher(this, listConversationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listConversations(software.amazon.awssdk.services.qbusiness.model.ListConversationsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListConversationsPublisher publisher = client.listConversationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListConversationsPublisher publisher = client.listConversationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qbusiness.model.ListConversationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qbusiness.model.ListConversationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConversations(software.amazon.awssdk.services.qbusiness.model.ListConversationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConversationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListConversationsRequest#builder()}
     * </p>
     *
     * @param listConversationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.ListConversationsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>LicenseNotFoundException You don't have permissions to perform the action because your license is
     *         inactive. Ask your admin to activate your license and try again after your licence is active.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListConversations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListConversations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListConversationsPublisher listConversationsPaginator(
            Consumer<ListConversationsRequest.Builder> listConversationsRequest) {
        return listConversationsPaginator(ListConversationsRequest.builder().applyMutation(listConversationsRequest).build());
    }

    /**
     * <p>
     * Lists the data accessors for a Amazon Q Business application. This operation returns a paginated list of data
     * accessor summaries, including the friendly name, unique identifier, ARN, associated IAM role, and creation/update
     * timestamps for each data accessor.
     * </p>
     *
     * @param listDataAccessorsRequest
     * @return A Java Future containing the result of the ListDataAccessors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListDataAccessors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListDataAccessors" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListDataAccessorsResponse> listDataAccessors(ListDataAccessorsRequest listDataAccessorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the data accessors for a Amazon Q Business application. This operation returns a paginated list of data
     * accessor summaries, including the friendly name, unique identifier, ARN, associated IAM role, and creation/update
     * timestamps for each data accessor.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataAccessorsRequest.Builder} avoiding the need
     * to create one manually via {@link ListDataAccessorsRequest#builder()}
     * </p>
     *
     * @param listDataAccessorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.ListDataAccessorsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListDataAccessors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListDataAccessors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListDataAccessors" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListDataAccessorsResponse> listDataAccessors(
            Consumer<ListDataAccessorsRequest.Builder> listDataAccessorsRequest) {
        return listDataAccessors(ListDataAccessorsRequest.builder().applyMutation(listDataAccessorsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataAccessors(software.amazon.awssdk.services.qbusiness.model.ListDataAccessorsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListDataAccessorsPublisher publisher = client.listDataAccessorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListDataAccessorsPublisher publisher = client.listDataAccessorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qbusiness.model.ListDataAccessorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qbusiness.model.ListDataAccessorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataAccessors(software.amazon.awssdk.services.qbusiness.model.ListDataAccessorsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDataAccessorsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListDataAccessors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListDataAccessors" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDataAccessorsPublisher listDataAccessorsPaginator(ListDataAccessorsRequest listDataAccessorsRequest) {
        return new ListDataAccessorsPublisher(this, listDataAccessorsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataAccessors(software.amazon.awssdk.services.qbusiness.model.ListDataAccessorsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListDataAccessorsPublisher publisher = client.listDataAccessorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListDataAccessorsPublisher publisher = client.listDataAccessorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qbusiness.model.ListDataAccessorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qbusiness.model.ListDataAccessorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataAccessors(software.amazon.awssdk.services.qbusiness.model.ListDataAccessorsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataAccessorsRequest.Builder} avoiding the need
     * to create one manually via {@link ListDataAccessorsRequest#builder()}
     * </p>
     *
     * @param listDataAccessorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.ListDataAccessorsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListDataAccessors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListDataAccessors" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDataAccessorsPublisher listDataAccessorsPaginator(
            Consumer<ListDataAccessorsRequest.Builder> listDataAccessorsRequest) {
        return listDataAccessorsPaginator(ListDataAccessorsRequest.builder().applyMutation(listDataAccessorsRequest).build());
    }

    /**
     * <p>
     * Get information about an Amazon Q Business data source connector synchronization.
     * </p>
     *
     * @param listDataSourceSyncJobsRequest
     * @return A Java Future containing the result of the ListDataSourceSyncJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListDataSourceSyncJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListDataSourceSyncJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDataSourceSyncJobsResponse> listDataSourceSyncJobs(
            ListDataSourceSyncJobsRequest listDataSourceSyncJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get information about an Amazon Q Business data source connector synchronization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataSourceSyncJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDataSourceSyncJobsRequest#builder()}
     * </p>
     *
     * @param listDataSourceSyncJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.ListDataSourceSyncJobsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListDataSourceSyncJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListDataSourceSyncJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListDataSourceSyncJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDataSourceSyncJobsResponse> listDataSourceSyncJobs(
            Consumer<ListDataSourceSyncJobsRequest.Builder> listDataSourceSyncJobsRequest) {
        return listDataSourceSyncJobs(ListDataSourceSyncJobsRequest.builder().applyMutation(listDataSourceSyncJobsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataSourceSyncJobs(software.amazon.awssdk.services.qbusiness.model.ListDataSourceSyncJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListDataSourceSyncJobsPublisher publisher = client.listDataSourceSyncJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListDataSourceSyncJobsPublisher publisher = client.listDataSourceSyncJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qbusiness.model.ListDataSourceSyncJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qbusiness.model.ListDataSourceSyncJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataSourceSyncJobs(software.amazon.awssdk.services.qbusiness.model.ListDataSourceSyncJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDataSourceSyncJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListDataSourceSyncJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListDataSourceSyncJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataSourceSyncJobsPublisher listDataSourceSyncJobsPaginator(
            ListDataSourceSyncJobsRequest listDataSourceSyncJobsRequest) {
        return new ListDataSourceSyncJobsPublisher(this, listDataSourceSyncJobsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataSourceSyncJobs(software.amazon.awssdk.services.qbusiness.model.ListDataSourceSyncJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListDataSourceSyncJobsPublisher publisher = client.listDataSourceSyncJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListDataSourceSyncJobsPublisher publisher = client.listDataSourceSyncJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qbusiness.model.ListDataSourceSyncJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qbusiness.model.ListDataSourceSyncJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataSourceSyncJobs(software.amazon.awssdk.services.qbusiness.model.ListDataSourceSyncJobsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataSourceSyncJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDataSourceSyncJobsRequest#builder()}
     * </p>
     *
     * @param listDataSourceSyncJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.ListDataSourceSyncJobsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListDataSourceSyncJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListDataSourceSyncJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataSourceSyncJobsPublisher listDataSourceSyncJobsPaginator(
            Consumer<ListDataSourceSyncJobsRequest.Builder> listDataSourceSyncJobsRequest) {
        return listDataSourceSyncJobsPaginator(ListDataSourceSyncJobsRequest.builder()
                .applyMutation(listDataSourceSyncJobsRequest).build());
    }

    /**
     * <p>
     * Lists the Amazon Q Business data source connectors that you have created.
     * </p>
     *
     * @param listDataSourcesRequest
     * @return A Java Future containing the result of the ListDataSources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListDataSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListDataSources" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDataSourcesResponse> listDataSources(ListDataSourcesRequest listDataSourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Amazon Q Business data source connectors that you have created.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataSourcesRequest.Builder} avoiding the need
     * to create one manually via {@link ListDataSourcesRequest#builder()}
     * </p>
     *
     * @param listDataSourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.ListDataSourcesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListDataSources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListDataSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListDataSources" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDataSourcesResponse> listDataSources(
            Consumer<ListDataSourcesRequest.Builder> listDataSourcesRequest) {
        return listDataSources(ListDataSourcesRequest.builder().applyMutation(listDataSourcesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataSources(software.amazon.awssdk.services.qbusiness.model.ListDataSourcesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListDataSourcesPublisher publisher = client.listDataSourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListDataSourcesPublisher publisher = client.listDataSourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qbusiness.model.ListDataSourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qbusiness.model.ListDataSourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataSources(software.amazon.awssdk.services.qbusiness.model.ListDataSourcesRequest)} operation.</b>
     * </p>
     *
     * @param listDataSourcesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListDataSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListDataSources" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDataSourcesPublisher listDataSourcesPaginator(ListDataSourcesRequest listDataSourcesRequest) {
        return new ListDataSourcesPublisher(this, listDataSourcesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataSources(software.amazon.awssdk.services.qbusiness.model.ListDataSourcesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListDataSourcesPublisher publisher = client.listDataSourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListDataSourcesPublisher publisher = client.listDataSourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qbusiness.model.ListDataSourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qbusiness.model.ListDataSourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataSources(software.amazon.awssdk.services.qbusiness.model.ListDataSourcesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataSourcesRequest.Builder} avoiding the need
     * to create one manually via {@link ListDataSourcesRequest#builder()}
     * </p>
     *
     * @param listDataSourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.ListDataSourcesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListDataSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListDataSources" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDataSourcesPublisher listDataSourcesPaginator(Consumer<ListDataSourcesRequest.Builder> listDataSourcesRequest) {
        return listDataSourcesPaginator(ListDataSourcesRequest.builder().applyMutation(listDataSourcesRequest).build());
    }

    /**
     * <p>
     * A list of documents attached to an index.
     * </p>
     *
     * @param listDocumentsRequest
     * @return A Java Future containing the result of the ListDocuments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListDocuments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListDocuments" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDocumentsResponse> listDocuments(ListDocumentsRequest listDocumentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A list of documents attached to an index.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDocumentsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDocumentsRequest#builder()}
     * </p>
     *
     * @param listDocumentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.ListDocumentsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListDocuments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListDocuments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListDocuments" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDocumentsResponse> listDocuments(Consumer<ListDocumentsRequest.Builder> listDocumentsRequest) {
        return listDocuments(ListDocumentsRequest.builder().applyMutation(listDocumentsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listDocuments(software.amazon.awssdk.services.qbusiness.model.ListDocumentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListDocumentsPublisher publisher = client.listDocumentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListDocumentsPublisher publisher = client.listDocumentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qbusiness.model.ListDocumentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qbusiness.model.ListDocumentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDocuments(software.amazon.awssdk.services.qbusiness.model.ListDocumentsRequest)} operation.</b>
     * </p>
     *
     * @param listDocumentsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListDocuments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListDocuments" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDocumentsPublisher listDocumentsPaginator(ListDocumentsRequest listDocumentsRequest) {
        return new ListDocumentsPublisher(this, listDocumentsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listDocuments(software.amazon.awssdk.services.qbusiness.model.ListDocumentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListDocumentsPublisher publisher = client.listDocumentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListDocumentsPublisher publisher = client.listDocumentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qbusiness.model.ListDocumentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qbusiness.model.ListDocumentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDocuments(software.amazon.awssdk.services.qbusiness.model.ListDocumentsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDocumentsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDocumentsRequest#builder()}
     * </p>
     *
     * @param listDocumentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.ListDocumentsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListDocuments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListDocuments" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDocumentsPublisher listDocumentsPaginator(Consumer<ListDocumentsRequest.Builder> listDocumentsRequest) {
        return listDocumentsPaginator(ListDocumentsRequest.builder().applyMutation(listDocumentsRequest).build());
    }

    /**
     * <p>
     * Provides a list of groups that are mapped to users.
     * </p>
     *
     * @param listGroupsRequest
     * @return A Java Future containing the result of the ListGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListGroupsResponse> listGroups(ListGroupsRequest listGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of groups that are mapped to users.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroupsRequest.Builder} avoiding the need to
     * create one manually via {@link ListGroupsRequest#builder()}
     * </p>
     *
     * @param listGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.ListGroupsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListGroupsResponse> listGroups(Consumer<ListGroupsRequest.Builder> listGroupsRequest) {
        return listGroups(ListGroupsRequest.builder().applyMutation(listGroupsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listGroups(software.amazon.awssdk.services.qbusiness.model.ListGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListGroupsPublisher publisher = client.listGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListGroupsPublisher publisher = client.listGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qbusiness.model.ListGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qbusiness.model.ListGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGroups(software.amazon.awssdk.services.qbusiness.model.ListGroupsRequest)} operation.</b>
     * </p>
     *
     * @param listGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGroupsPublisher listGroupsPaginator(ListGroupsRequest listGroupsRequest) {
        return new ListGroupsPublisher(this, listGroupsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listGroups(software.amazon.awssdk.services.qbusiness.model.ListGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListGroupsPublisher publisher = client.listGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListGroupsPublisher publisher = client.listGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qbusiness.model.ListGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qbusiness.model.ListGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGroups(software.amazon.awssdk.services.qbusiness.model.ListGroupsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroupsRequest.Builder} avoiding the need to
     * create one manually via {@link ListGroupsRequest#builder()}
     * </p>
     *
     * @param listGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.ListGroupsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGroupsPublisher listGroupsPaginator(Consumer<ListGroupsRequest.Builder> listGroupsRequest) {
        return listGroupsPaginator(ListGroupsRequest.builder().applyMutation(listGroupsRequest).build());
    }

    /**
     * <p>
     * Lists the Amazon Q Business indices you have created.
     * </p>
     *
     * @param listIndicesRequest
     * @return A Java Future containing the result of the ListIndices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListIndices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListIndices" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListIndicesResponse> listIndices(ListIndicesRequest listIndicesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Amazon Q Business indices you have created.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIndicesRequest.Builder} avoiding the need to
     * create one manually via {@link ListIndicesRequest#builder()}
     * </p>
     *
     * @param listIndicesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.ListIndicesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListIndices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListIndices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListIndices" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListIndicesResponse> listIndices(Consumer<ListIndicesRequest.Builder> listIndicesRequest) {
        return listIndices(ListIndicesRequest.builder().applyMutation(listIndicesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listIndices(software.amazon.awssdk.services.qbusiness.model.ListIndicesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListIndicesPublisher publisher = client.listIndicesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListIndicesPublisher publisher = client.listIndicesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qbusiness.model.ListIndicesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qbusiness.model.ListIndicesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIndices(software.amazon.awssdk.services.qbusiness.model.ListIndicesRequest)} operation.</b>
     * </p>
     *
     * @param listIndicesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListIndices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListIndices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListIndicesPublisher listIndicesPaginator(ListIndicesRequest listIndicesRequest) {
        return new ListIndicesPublisher(this, listIndicesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listIndices(software.amazon.awssdk.services.qbusiness.model.ListIndicesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListIndicesPublisher publisher = client.listIndicesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListIndicesPublisher publisher = client.listIndicesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qbusiness.model.ListIndicesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qbusiness.model.ListIndicesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIndices(software.amazon.awssdk.services.qbusiness.model.ListIndicesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIndicesRequest.Builder} avoiding the need to
     * create one manually via {@link ListIndicesRequest#builder()}
     * </p>
     *
     * @param listIndicesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.ListIndicesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListIndices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListIndices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListIndicesPublisher listIndicesPaginator(Consumer<ListIndicesRequest.Builder> listIndicesRequest) {
        return listIndicesPaginator(ListIndicesRequest.builder().applyMutation(listIndicesRequest).build());
    }

    /**
     * <p>
     * Gets a list of messages associated with an Amazon Q Business web experience.
     * </p>
     *
     * @param listMessagesRequest
     * @return A Java Future containing the result of the ListMessages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>LicenseNotFoundException You don't have permissions to perform the action because your license is
     *         inactive. Ask your admin to activate your license and try again after your licence is active.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListMessages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListMessages" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListMessagesResponse> listMessages(ListMessagesRequest listMessagesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of messages associated with an Amazon Q Business web experience.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMessagesRequest.Builder} avoiding the need to
     * create one manually via {@link ListMessagesRequest#builder()}
     * </p>
     *
     * @param listMessagesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.ListMessagesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListMessages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>LicenseNotFoundException You don't have permissions to perform the action because your license is
     *         inactive. Ask your admin to activate your license and try again after your licence is active.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListMessages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListMessages" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListMessagesResponse> listMessages(Consumer<ListMessagesRequest.Builder> listMessagesRequest) {
        return listMessages(ListMessagesRequest.builder().applyMutation(listMessagesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listMessages(software.amazon.awssdk.services.qbusiness.model.ListMessagesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListMessagesPublisher publisher = client.listMessagesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListMessagesPublisher publisher = client.listMessagesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qbusiness.model.ListMessagesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qbusiness.model.ListMessagesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMessages(software.amazon.awssdk.services.qbusiness.model.ListMessagesRequest)} operation.</b>
     * </p>
     *
     * @param listMessagesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>LicenseNotFoundException You don't have permissions to perform the action because your license is
     *         inactive. Ask your admin to activate your license and try again after your licence is active.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListMessages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListMessages" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMessagesPublisher listMessagesPaginator(ListMessagesRequest listMessagesRequest) {
        return new ListMessagesPublisher(this, listMessagesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listMessages(software.amazon.awssdk.services.qbusiness.model.ListMessagesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListMessagesPublisher publisher = client.listMessagesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListMessagesPublisher publisher = client.listMessagesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qbusiness.model.ListMessagesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qbusiness.model.ListMessagesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMessages(software.amazon.awssdk.services.qbusiness.model.ListMessagesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMessagesRequest.Builder} avoiding the need to
     * create one manually via {@link ListMessagesRequest#builder()}
     * </p>
     *
     * @param listMessagesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.ListMessagesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>LicenseNotFoundException You don't have permissions to perform the action because your license is
     *         inactive. Ask your admin to activate your license and try again after your licence is active.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListMessages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListMessages" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMessagesPublisher listMessagesPaginator(Consumer<ListMessagesRequest.Builder> listMessagesRequest) {
        return listMessagesPaginator(ListMessagesRequest.builder().applyMutation(listMessagesRequest).build());
    }

    /**
     * <p>
     * Lists configured Amazon Q Business actions for a specific plugin in an Amazon Q Business application.
     * </p>
     *
     * @param listPluginActionsRequest
     * @return A Java Future containing the result of the ListPluginActions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListPluginActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListPluginActions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListPluginActionsResponse> listPluginActions(ListPluginActionsRequest listPluginActionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists configured Amazon Q Business actions for a specific plugin in an Amazon Q Business application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPluginActionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListPluginActionsRequest#builder()}
     * </p>
     *
     * @param listPluginActionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.ListPluginActionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListPluginActions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListPluginActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListPluginActions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListPluginActionsResponse> listPluginActions(
            Consumer<ListPluginActionsRequest.Builder> listPluginActionsRequest) {
        return listPluginActions(ListPluginActionsRequest.builder().applyMutation(listPluginActionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPluginActions(software.amazon.awssdk.services.qbusiness.model.ListPluginActionsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListPluginActionsPublisher publisher = client.listPluginActionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListPluginActionsPublisher publisher = client.listPluginActionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qbusiness.model.ListPluginActionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qbusiness.model.ListPluginActionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPluginActions(software.amazon.awssdk.services.qbusiness.model.ListPluginActionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPluginActionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListPluginActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListPluginActions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPluginActionsPublisher listPluginActionsPaginator(ListPluginActionsRequest listPluginActionsRequest) {
        return new ListPluginActionsPublisher(this, listPluginActionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPluginActions(software.amazon.awssdk.services.qbusiness.model.ListPluginActionsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListPluginActionsPublisher publisher = client.listPluginActionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListPluginActionsPublisher publisher = client.listPluginActionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qbusiness.model.ListPluginActionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qbusiness.model.ListPluginActionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPluginActions(software.amazon.awssdk.services.qbusiness.model.ListPluginActionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPluginActionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListPluginActionsRequest#builder()}
     * </p>
     *
     * @param listPluginActionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.ListPluginActionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListPluginActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListPluginActions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPluginActionsPublisher listPluginActionsPaginator(
            Consumer<ListPluginActionsRequest.Builder> listPluginActionsRequest) {
        return listPluginActionsPaginator(ListPluginActionsRequest.builder().applyMutation(listPluginActionsRequest).build());
    }

    /**
     * <p>
     * Lists configured Amazon Q Business actions for any plugin type—both built-in and custom.
     * </p>
     *
     * @param listPluginTypeActionsRequest
     * @return A Java Future containing the result of the ListPluginTypeActions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListPluginTypeActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListPluginTypeActions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPluginTypeActionsResponse> listPluginTypeActions(
            ListPluginTypeActionsRequest listPluginTypeActionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists configured Amazon Q Business actions for any plugin type—both built-in and custom.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPluginTypeActionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListPluginTypeActionsRequest#builder()}
     * </p>
     *
     * @param listPluginTypeActionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.ListPluginTypeActionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListPluginTypeActions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListPluginTypeActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListPluginTypeActions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPluginTypeActionsResponse> listPluginTypeActions(
            Consumer<ListPluginTypeActionsRequest.Builder> listPluginTypeActionsRequest) {
        return listPluginTypeActions(ListPluginTypeActionsRequest.builder().applyMutation(listPluginTypeActionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPluginTypeActions(software.amazon.awssdk.services.qbusiness.model.ListPluginTypeActionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListPluginTypeActionsPublisher publisher = client.listPluginTypeActionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListPluginTypeActionsPublisher publisher = client.listPluginTypeActionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qbusiness.model.ListPluginTypeActionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qbusiness.model.ListPluginTypeActionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPluginTypeActions(software.amazon.awssdk.services.qbusiness.model.ListPluginTypeActionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPluginTypeActionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListPluginTypeActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListPluginTypeActions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPluginTypeActionsPublisher listPluginTypeActionsPaginator(
            ListPluginTypeActionsRequest listPluginTypeActionsRequest) {
        return new ListPluginTypeActionsPublisher(this, listPluginTypeActionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPluginTypeActions(software.amazon.awssdk.services.qbusiness.model.ListPluginTypeActionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListPluginTypeActionsPublisher publisher = client.listPluginTypeActionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListPluginTypeActionsPublisher publisher = client.listPluginTypeActionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qbusiness.model.ListPluginTypeActionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qbusiness.model.ListPluginTypeActionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPluginTypeActions(software.amazon.awssdk.services.qbusiness.model.ListPluginTypeActionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPluginTypeActionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListPluginTypeActionsRequest#builder()}
     * </p>
     *
     * @param listPluginTypeActionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.ListPluginTypeActionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListPluginTypeActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListPluginTypeActions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPluginTypeActionsPublisher listPluginTypeActionsPaginator(
            Consumer<ListPluginTypeActionsRequest.Builder> listPluginTypeActionsRequest) {
        return listPluginTypeActionsPaginator(ListPluginTypeActionsRequest.builder().applyMutation(listPluginTypeActionsRequest)
                .build());
    }

    /**
     * <p>
     * Lists metadata for all Amazon Q Business plugin types.
     * </p>
     *
     * @param listPluginTypeMetadataRequest
     * @return A Java Future containing the result of the ListPluginTypeMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListPluginTypeMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListPluginTypeMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPluginTypeMetadataResponse> listPluginTypeMetadata(
            ListPluginTypeMetadataRequest listPluginTypeMetadataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists metadata for all Amazon Q Business plugin types.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPluginTypeMetadataRequest.Builder} avoiding the
     * need to create one manually via {@link ListPluginTypeMetadataRequest#builder()}
     * </p>
     *
     * @param listPluginTypeMetadataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.ListPluginTypeMetadataRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListPluginTypeMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListPluginTypeMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListPluginTypeMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPluginTypeMetadataResponse> listPluginTypeMetadata(
            Consumer<ListPluginTypeMetadataRequest.Builder> listPluginTypeMetadataRequest) {
        return listPluginTypeMetadata(ListPluginTypeMetadataRequest.builder().applyMutation(listPluginTypeMetadataRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPluginTypeMetadata(software.amazon.awssdk.services.qbusiness.model.ListPluginTypeMetadataRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListPluginTypeMetadataPublisher publisher = client.listPluginTypeMetadataPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListPluginTypeMetadataPublisher publisher = client.listPluginTypeMetadataPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qbusiness.model.ListPluginTypeMetadataResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qbusiness.model.ListPluginTypeMetadataResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPluginTypeMetadata(software.amazon.awssdk.services.qbusiness.model.ListPluginTypeMetadataRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPluginTypeMetadataRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListPluginTypeMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListPluginTypeMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPluginTypeMetadataPublisher listPluginTypeMetadataPaginator(
            ListPluginTypeMetadataRequest listPluginTypeMetadataRequest) {
        return new ListPluginTypeMetadataPublisher(this, listPluginTypeMetadataRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPluginTypeMetadata(software.amazon.awssdk.services.qbusiness.model.ListPluginTypeMetadataRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListPluginTypeMetadataPublisher publisher = client.listPluginTypeMetadataPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListPluginTypeMetadataPublisher publisher = client.listPluginTypeMetadataPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qbusiness.model.ListPluginTypeMetadataResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qbusiness.model.ListPluginTypeMetadataResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPluginTypeMetadata(software.amazon.awssdk.services.qbusiness.model.ListPluginTypeMetadataRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPluginTypeMetadataRequest.Builder} avoiding the
     * need to create one manually via {@link ListPluginTypeMetadataRequest#builder()}
     * </p>
     *
     * @param listPluginTypeMetadataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.ListPluginTypeMetadataRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListPluginTypeMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListPluginTypeMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPluginTypeMetadataPublisher listPluginTypeMetadataPaginator(
            Consumer<ListPluginTypeMetadataRequest.Builder> listPluginTypeMetadataRequest) {
        return listPluginTypeMetadataPaginator(ListPluginTypeMetadataRequest.builder()
                .applyMutation(listPluginTypeMetadataRequest).build());
    }

    /**
     * <p>
     * Lists configured Amazon Q Business plugins.
     * </p>
     *
     * @param listPluginsRequest
     * @return A Java Future containing the result of the ListPlugins operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListPlugins
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListPlugins" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListPluginsResponse> listPlugins(ListPluginsRequest listPluginsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists configured Amazon Q Business plugins.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPluginsRequest.Builder} avoiding the need to
     * create one manually via {@link ListPluginsRequest#builder()}
     * </p>
     *
     * @param listPluginsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.ListPluginsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListPlugins operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListPlugins
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListPlugins" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListPluginsResponse> listPlugins(Consumer<ListPluginsRequest.Builder> listPluginsRequest) {
        return listPlugins(ListPluginsRequest.builder().applyMutation(listPluginsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listPlugins(software.amazon.awssdk.services.qbusiness.model.ListPluginsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListPluginsPublisher publisher = client.listPluginsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListPluginsPublisher publisher = client.listPluginsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qbusiness.model.ListPluginsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qbusiness.model.ListPluginsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPlugins(software.amazon.awssdk.services.qbusiness.model.ListPluginsRequest)} operation.</b>
     * </p>
     *
     * @param listPluginsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListPlugins
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListPlugins" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPluginsPublisher listPluginsPaginator(ListPluginsRequest listPluginsRequest) {
        return new ListPluginsPublisher(this, listPluginsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listPlugins(software.amazon.awssdk.services.qbusiness.model.ListPluginsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListPluginsPublisher publisher = client.listPluginsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListPluginsPublisher publisher = client.listPluginsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qbusiness.model.ListPluginsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qbusiness.model.ListPluginsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPlugins(software.amazon.awssdk.services.qbusiness.model.ListPluginsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPluginsRequest.Builder} avoiding the need to
     * create one manually via {@link ListPluginsRequest#builder()}
     * </p>
     *
     * @param listPluginsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.ListPluginsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListPlugins
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListPlugins" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPluginsPublisher listPluginsPaginator(Consumer<ListPluginsRequest.Builder> listPluginsRequest) {
        return listPluginsPaginator(ListPluginsRequest.builder().applyMutation(listPluginsRequest).build());
    }

    /**
     * <p>
     * Lists the retriever used by an Amazon Q Business application.
     * </p>
     *
     * @param listRetrieversRequest
     * @return A Java Future containing the result of the ListRetrievers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListRetrievers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListRetrievers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListRetrieversResponse> listRetrievers(ListRetrieversRequest listRetrieversRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the retriever used by an Amazon Q Business application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRetrieversRequest.Builder} avoiding the need to
     * create one manually via {@link ListRetrieversRequest#builder()}
     * </p>
     *
     * @param listRetrieversRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.ListRetrieversRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListRetrievers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListRetrievers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListRetrievers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListRetrieversResponse> listRetrievers(Consumer<ListRetrieversRequest.Builder> listRetrieversRequest) {
        return listRetrievers(ListRetrieversRequest.builder().applyMutation(listRetrieversRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRetrievers(software.amazon.awssdk.services.qbusiness.model.ListRetrieversRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListRetrieversPublisher publisher = client.listRetrieversPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListRetrieversPublisher publisher = client.listRetrieversPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qbusiness.model.ListRetrieversResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qbusiness.model.ListRetrieversResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRetrievers(software.amazon.awssdk.services.qbusiness.model.ListRetrieversRequest)} operation.</b>
     * </p>
     *
     * @param listRetrieversRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListRetrievers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListRetrievers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRetrieversPublisher listRetrieversPaginator(ListRetrieversRequest listRetrieversRequest) {
        return new ListRetrieversPublisher(this, listRetrieversRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRetrievers(software.amazon.awssdk.services.qbusiness.model.ListRetrieversRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListRetrieversPublisher publisher = client.listRetrieversPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListRetrieversPublisher publisher = client.listRetrieversPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qbusiness.model.ListRetrieversResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qbusiness.model.ListRetrieversResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRetrievers(software.amazon.awssdk.services.qbusiness.model.ListRetrieversRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRetrieversRequest.Builder} avoiding the need to
     * create one manually via {@link ListRetrieversRequest#builder()}
     * </p>
     *
     * @param listRetrieversRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.ListRetrieversRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListRetrievers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListRetrievers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRetrieversPublisher listRetrieversPaginator(Consumer<ListRetrieversRequest.Builder> listRetrieversRequest) {
        return listRetrieversPaginator(ListRetrieversRequest.builder().applyMutation(listRetrieversRequest).build());
    }

    /**
     * <p>
     * Lists all subscriptions created in an Amazon Q Business application.
     * </p>
     *
     * @param listSubscriptionsRequest
     * @return A Java Future containing the result of the ListSubscriptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListSubscriptions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListSubscriptionsResponse> listSubscriptions(ListSubscriptionsRequest listSubscriptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all subscriptions created in an Amazon Q Business application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSubscriptionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListSubscriptionsRequest#builder()}
     * </p>
     *
     * @param listSubscriptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.ListSubscriptionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListSubscriptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListSubscriptions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListSubscriptionsResponse> listSubscriptions(
            Consumer<ListSubscriptionsRequest.Builder> listSubscriptionsRequest) {
        return listSubscriptions(ListSubscriptionsRequest.builder().applyMutation(listSubscriptionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSubscriptions(software.amazon.awssdk.services.qbusiness.model.ListSubscriptionsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListSubscriptionsPublisher publisher = client.listSubscriptionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListSubscriptionsPublisher publisher = client.listSubscriptionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qbusiness.model.ListSubscriptionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qbusiness.model.ListSubscriptionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSubscriptions(software.amazon.awssdk.services.qbusiness.model.ListSubscriptionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSubscriptionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListSubscriptions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSubscriptionsPublisher listSubscriptionsPaginator(ListSubscriptionsRequest listSubscriptionsRequest) {
        return new ListSubscriptionsPublisher(this, listSubscriptionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSubscriptions(software.amazon.awssdk.services.qbusiness.model.ListSubscriptionsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListSubscriptionsPublisher publisher = client.listSubscriptionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListSubscriptionsPublisher publisher = client.listSubscriptionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qbusiness.model.ListSubscriptionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qbusiness.model.ListSubscriptionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSubscriptions(software.amazon.awssdk.services.qbusiness.model.ListSubscriptionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSubscriptionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListSubscriptionsRequest#builder()}
     * </p>
     *
     * @param listSubscriptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.ListSubscriptionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListSubscriptions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSubscriptionsPublisher listSubscriptionsPaginator(
            Consumer<ListSubscriptionsRequest.Builder> listSubscriptionsRequest) {
        return listSubscriptionsPaginator(ListSubscriptionsRequest.builder().applyMutation(listSubscriptionsRequest).build());
    }

    /**
     * <p>
     * Gets a list of tags associated with a specified resource. Amazon Q Business applications and data sources can
     * have tags associated with them.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of tags associated with a specified resource. Amazon Q Business applications and data sources can
     * have tags associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists one or more Amazon Q Business Web Experiences.
     * </p>
     *
     * @param listWebExperiencesRequest
     * @return A Java Future containing the result of the ListWebExperiences operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListWebExperiences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListWebExperiences" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListWebExperiencesResponse> listWebExperiences(ListWebExperiencesRequest listWebExperiencesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists one or more Amazon Q Business Web Experiences.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWebExperiencesRequest.Builder} avoiding the
     * need to create one manually via {@link ListWebExperiencesRequest#builder()}
     * </p>
     *
     * @param listWebExperiencesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.ListWebExperiencesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListWebExperiences operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListWebExperiences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListWebExperiences" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListWebExperiencesResponse> listWebExperiences(
            Consumer<ListWebExperiencesRequest.Builder> listWebExperiencesRequest) {
        return listWebExperiences(ListWebExperiencesRequest.builder().applyMutation(listWebExperiencesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listWebExperiences(software.amazon.awssdk.services.qbusiness.model.ListWebExperiencesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListWebExperiencesPublisher publisher = client.listWebExperiencesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListWebExperiencesPublisher publisher = client.listWebExperiencesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qbusiness.model.ListWebExperiencesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qbusiness.model.ListWebExperiencesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWebExperiences(software.amazon.awssdk.services.qbusiness.model.ListWebExperiencesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listWebExperiencesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListWebExperiences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListWebExperiences" target="_top">AWS
     *      API Documentation</a>
     */
    default ListWebExperiencesPublisher listWebExperiencesPaginator(ListWebExperiencesRequest listWebExperiencesRequest) {
        return new ListWebExperiencesPublisher(this, listWebExperiencesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listWebExperiences(software.amazon.awssdk.services.qbusiness.model.ListWebExperiencesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListWebExperiencesPublisher publisher = client.listWebExperiencesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.ListWebExperiencesPublisher publisher = client.listWebExperiencesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qbusiness.model.ListWebExperiencesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qbusiness.model.ListWebExperiencesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWebExperiences(software.amazon.awssdk.services.qbusiness.model.ListWebExperiencesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWebExperiencesRequest.Builder} avoiding the
     * need to create one manually via {@link ListWebExperiencesRequest#builder()}
     * </p>
     *
     * @param listWebExperiencesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.ListWebExperiencesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.ListWebExperiences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListWebExperiences" target="_top">AWS
     *      API Documentation</a>
     */
    default ListWebExperiencesPublisher listWebExperiencesPaginator(
            Consumer<ListWebExperiencesRequest.Builder> listWebExperiencesRequest) {
        return listWebExperiencesPaginator(ListWebExperiencesRequest.builder().applyMutation(listWebExperiencesRequest).build());
    }

    /**
     * <p>
     * Enables your end user to provide feedback on their Amazon Q Business generated chat responses.
     * </p>
     *
     * @param putFeedbackRequest
     * @return A Java Future containing the result of the PutFeedback operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.PutFeedback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/PutFeedback" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutFeedbackResponse> putFeedback(PutFeedbackRequest putFeedbackRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables your end user to provide feedback on their Amazon Q Business generated chat responses.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutFeedbackRequest.Builder} avoiding the need to
     * create one manually via {@link PutFeedbackRequest#builder()}
     * </p>
     *
     * @param putFeedbackRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.PutFeedbackRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PutFeedback operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.PutFeedback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/PutFeedback" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutFeedbackResponse> putFeedback(Consumer<PutFeedbackRequest.Builder> putFeedbackRequest) {
        return putFeedback(PutFeedbackRequest.builder().applyMutation(putFeedbackRequest).build());
    }

    /**
     * <p>
     * Create, or updates, a mapping of users—who have access to a document—to groups.
     * </p>
     * <p>
     * You can also map sub groups to groups. For example, the group "Company Intellectual Property Teams" includes sub
     * groups "Research" and "Engineering". These sub groups include their own list of users or people who work in these
     * teams. Only users who work in research and engineering, and therefore belong in the intellectual property group,
     * can see top-secret company documents in their Amazon Q Business chat results.
     * </p>
     * <p>
     * There are two options for creating groups, either passing group members inline or using an S3 file via the
     * S3PathForGroupMembers field. For inline groups, there is a limit of 1000 members per group and for provided S3
     * files there is a limit of 100 thousand members. When creating a group using an S3 file, you provide both an S3
     * file and a <code>RoleArn</code> for Amazon Q Buisness to access the file.
     * </p>
     *
     * @param putGroupRequest
     * @return A Java Future containing the result of the PutGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Q Business service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.PutGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/PutGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutGroupResponse> putGroup(PutGroupRequest putGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create, or updates, a mapping of users—who have access to a document—to groups.
     * </p>
     * <p>
     * You can also map sub groups to groups. For example, the group "Company Intellectual Property Teams" includes sub
     * groups "Research" and "Engineering". These sub groups include their own list of users or people who work in these
     * teams. Only users who work in research and engineering, and therefore belong in the intellectual property group,
     * can see top-secret company documents in their Amazon Q Business chat results.
     * </p>
     * <p>
     * There are two options for creating groups, either passing group members inline or using an S3 file via the
     * S3PathForGroupMembers field. For inline groups, there is a limit of 1000 members per group and for provided S3
     * files there is a limit of 100 thousand members. When creating a group using an S3 file, you provide both an S3
     * file and a <code>RoleArn</code> for Amazon Q Buisness to access the file.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutGroupRequest.Builder} avoiding the need to
     * create one manually via {@link PutGroupRequest#builder()}
     * </p>
     *
     * @param putGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.PutGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PutGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Q Business service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.PutGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/PutGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutGroupResponse> putGroup(Consumer<PutGroupRequest.Builder> putGroupRequest) {
        return putGroup(PutGroupRequest.builder().applyMutation(putGroupRequest).build());
    }

    /**
     * <p>
     * Searches for relevant content in a Amazon Q Business application based on a query. This operation takes a search
     * query text, the Amazon Q Business application identifier, and optional filters (such as content source and
     * maximum results) as input. It returns a list of relevant content items, where each item includes the content
     * text, the unique document identifier, the document title, the document URI, any relevant document attributes, and
     * score attributes indicating the confidence level of the relevance.
     * </p>
     *
     * @param searchRelevantContentRequest
     * @return A Java Future containing the result of the SearchRelevantContent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>LicenseNotFoundException You don't have permissions to perform the action because your license is
     *         inactive. Ask your admin to activate your license and try again after your licence is active.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.SearchRelevantContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/SearchRelevantContent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SearchRelevantContentResponse> searchRelevantContent(
            SearchRelevantContentRequest searchRelevantContentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches for relevant content in a Amazon Q Business application based on a query. This operation takes a search
     * query text, the Amazon Q Business application identifier, and optional filters (such as content source and
     * maximum results) as input. It returns a list of relevant content items, where each item includes the content
     * text, the unique document identifier, the document title, the document URI, any relevant document attributes, and
     * score attributes indicating the confidence level of the relevance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchRelevantContentRequest.Builder} avoiding the
     * need to create one manually via {@link SearchRelevantContentRequest#builder()}
     * </p>
     *
     * @param searchRelevantContentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.SearchRelevantContentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the SearchRelevantContent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>LicenseNotFoundException You don't have permissions to perform the action because your license is
     *         inactive. Ask your admin to activate your license and try again after your licence is active.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.SearchRelevantContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/SearchRelevantContent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SearchRelevantContentResponse> searchRelevantContent(
            Consumer<SearchRelevantContentRequest.Builder> searchRelevantContentRequest) {
        return searchRelevantContent(SearchRelevantContentRequest.builder().applyMutation(searchRelevantContentRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #searchRelevantContent(software.amazon.awssdk.services.qbusiness.model.SearchRelevantContentRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.SearchRelevantContentPublisher publisher = client.searchRelevantContentPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.SearchRelevantContentPublisher publisher = client.searchRelevantContentPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qbusiness.model.SearchRelevantContentResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qbusiness.model.SearchRelevantContentResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchRelevantContent(software.amazon.awssdk.services.qbusiness.model.SearchRelevantContentRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchRelevantContentRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>LicenseNotFoundException You don't have permissions to perform the action because your license is
     *         inactive. Ask your admin to activate your license and try again after your licence is active.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.SearchRelevantContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/SearchRelevantContent"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchRelevantContentPublisher searchRelevantContentPaginator(
            SearchRelevantContentRequest searchRelevantContentRequest) {
        return new SearchRelevantContentPublisher(this, searchRelevantContentRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #searchRelevantContent(software.amazon.awssdk.services.qbusiness.model.SearchRelevantContentRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.SearchRelevantContentPublisher publisher = client.searchRelevantContentPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qbusiness.paginators.SearchRelevantContentPublisher publisher = client.searchRelevantContentPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qbusiness.model.SearchRelevantContentResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qbusiness.model.SearchRelevantContentResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchRelevantContent(software.amazon.awssdk.services.qbusiness.model.SearchRelevantContentRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchRelevantContentRequest.Builder} avoiding the
     * need to create one manually via {@link SearchRelevantContentRequest#builder()}
     * </p>
     *
     * @param searchRelevantContentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.SearchRelevantContentRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>LicenseNotFoundException You don't have permissions to perform the action because your license is
     *         inactive. Ask your admin to activate your license and try again after your licence is active.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.SearchRelevantContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/SearchRelevantContent"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchRelevantContentPublisher searchRelevantContentPaginator(
            Consumer<SearchRelevantContentRequest.Builder> searchRelevantContentRequest) {
        return searchRelevantContentPaginator(SearchRelevantContentRequest.builder().applyMutation(searchRelevantContentRequest)
                .build());
    }

    /**
     * <p>
     * Starts a data source connector synchronization job. If a synchronization job is already in progress, Amazon Q
     * Business returns a <code>ConflictException</code>.
     * </p>
     *
     * @param startDataSourceSyncJobRequest
     * @return A Java Future containing the result of the StartDataSourceSyncJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Q Business service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.StartDataSourceSyncJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/StartDataSourceSyncJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartDataSourceSyncJobResponse> startDataSourceSyncJob(
            StartDataSourceSyncJobRequest startDataSourceSyncJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a data source connector synchronization job. If a synchronization job is already in progress, Amazon Q
     * Business returns a <code>ConflictException</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartDataSourceSyncJobRequest.Builder} avoiding the
     * need to create one manually via {@link StartDataSourceSyncJobRequest#builder()}
     * </p>
     *
     * @param startDataSourceSyncJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.StartDataSourceSyncJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartDataSourceSyncJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Q Business service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.StartDataSourceSyncJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/StartDataSourceSyncJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartDataSourceSyncJobResponse> startDataSourceSyncJob(
            Consumer<StartDataSourceSyncJobRequest.Builder> startDataSourceSyncJobRequest) {
        return startDataSourceSyncJob(StartDataSourceSyncJobRequest.builder().applyMutation(startDataSourceSyncJobRequest)
                .build());
    }

    /**
     * <p>
     * Stops an Amazon Q Business data source connector synchronization job already in progress.
     * </p>
     *
     * @param stopDataSourceSyncJobRequest
     * @return A Java Future containing the result of the StopDataSourceSyncJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.StopDataSourceSyncJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/StopDataSourceSyncJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopDataSourceSyncJobResponse> stopDataSourceSyncJob(
            StopDataSourceSyncJobRequest stopDataSourceSyncJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops an Amazon Q Business data source connector synchronization job already in progress.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopDataSourceSyncJobRequest.Builder} avoiding the
     * need to create one manually via {@link StopDataSourceSyncJobRequest#builder()}
     * </p>
     *
     * @param stopDataSourceSyncJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.StopDataSourceSyncJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StopDataSourceSyncJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.StopDataSourceSyncJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/StopDataSourceSyncJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopDataSourceSyncJobResponse> stopDataSourceSyncJob(
            Consumer<StopDataSourceSyncJobRequest.Builder> stopDataSourceSyncJobRequest) {
        return stopDataSourceSyncJob(StopDataSourceSyncJobRequest.builder().applyMutation(stopDataSourceSyncJobRequest).build());
    }

    /**
     * <p>
     * Adds the specified tag to the specified Amazon Q Business application or data source resource. If the tag already
     * exists, the existing value is replaced with the new value.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds the specified tag to the specified Amazon Q Business application or data source resource. If the tag already
     * exists, the existing value is replaced with the new value.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes a tag from an Amazon Q Business application or a data source.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a tag from an Amazon Q Business application or a data source.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an existing Amazon Q Business application.
     * </p>
     * <note>
     * <p>
     * Amazon Q Business applications may securely transmit data for processing across Amazon Web Services Regions
     * within your geography. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/cross-region-inference.html">Cross region inference
     * in Amazon Q Business</a>.
     * </p>
     * </note> <note>
     * <p>
     * An Amazon Q Apps service-linked role will be created if it's absent in the Amazon Web Services account when
     * <code>QAppsConfiguration</code> is enabled in the request. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/using-service-linked-roles-qapps.html">Using
     * service-linked roles for Q Apps</a>.
     * </p>
     * </note>
     *
     * @param updateApplicationRequest
     * @return A Java Future containing the result of the UpdateApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.UpdateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdateApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateApplicationResponse> updateApplication(UpdateApplicationRequest updateApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing Amazon Q Business application.
     * </p>
     * <note>
     * <p>
     * Amazon Q Business applications may securely transmit data for processing across Amazon Web Services Regions
     * within your geography. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/cross-region-inference.html">Cross region inference
     * in Amazon Q Business</a>.
     * </p>
     * </note> <note>
     * <p>
     * An Amazon Q Apps service-linked role will be created if it's absent in the Amazon Web Services account when
     * <code>QAppsConfiguration</code> is enabled in the request. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/using-service-linked-roles-qapps.html">Using
     * service-linked roles for Q Apps</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateApplicationRequest#builder()}
     * </p>
     *
     * @param updateApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.UpdateApplicationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.UpdateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdateApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateApplicationResponse> updateApplication(
            Consumer<UpdateApplicationRequest.Builder> updateApplicationRequest) {
        return updateApplication(UpdateApplicationRequest.builder().applyMutation(updateApplicationRequest).build());
    }

    /**
     * <p>
     * Updates a set of chat controls configured for an existing Amazon Q Business application.
     * </p>
     *
     * @param updateChatControlsConfigurationRequest
     * @return A Java Future containing the result of the UpdateChatControlsConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Q Business service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.UpdateChatControlsConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdateChatControlsConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateChatControlsConfigurationResponse> updateChatControlsConfiguration(
            UpdateChatControlsConfigurationRequest updateChatControlsConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a set of chat controls configured for an existing Amazon Q Business application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateChatControlsConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateChatControlsConfigurationRequest#builder()}
     * </p>
     *
     * @param updateChatControlsConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.UpdateChatControlsConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateChatControlsConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Q Business service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.UpdateChatControlsConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdateChatControlsConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateChatControlsConfigurationResponse> updateChatControlsConfiguration(
            Consumer<UpdateChatControlsConfigurationRequest.Builder> updateChatControlsConfigurationRequest) {
        return updateChatControlsConfiguration(UpdateChatControlsConfigurationRequest.builder()
                .applyMutation(updateChatControlsConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates an existing chat response configuration in an Amazon Q Business application. This operation allows
     * administrators to modify configuration settings, display name, and response parameters to refine how the system
     * generates responses.
     * </p>
     *
     * @param updateChatResponseConfigurationRequest
     * @return A Java Future containing the result of the UpdateChatResponseConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.UpdateChatResponseConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdateChatResponseConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateChatResponseConfigurationResponse> updateChatResponseConfiguration(
            UpdateChatResponseConfigurationRequest updateChatResponseConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing chat response configuration in an Amazon Q Business application. This operation allows
     * administrators to modify configuration settings, display name, and response parameters to refine how the system
     * generates responses.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateChatResponseConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateChatResponseConfigurationRequest#builder()}
     * </p>
     *
     * @param updateChatResponseConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.UpdateChatResponseConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateChatResponseConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.UpdateChatResponseConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdateChatResponseConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateChatResponseConfigurationResponse> updateChatResponseConfiguration(
            Consumer<UpdateChatResponseConfigurationRequest.Builder> updateChatResponseConfigurationRequest) {
        return updateChatResponseConfiguration(UpdateChatResponseConfigurationRequest.builder()
                .applyMutation(updateChatResponseConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates an existing data accessor. This operation allows modifying the action configurations (the allowed actions
     * and associated filters) and the display name of the data accessor. It does not allow changing the IAM role
     * associated with the data accessor or other core properties of the data accessor.
     * </p>
     *
     * @param updateDataAccessorRequest
     * @return A Java Future containing the result of the UpdateDataAccessor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.UpdateDataAccessor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdateDataAccessor" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateDataAccessorResponse> updateDataAccessor(UpdateDataAccessorRequest updateDataAccessorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing data accessor. This operation allows modifying the action configurations (the allowed actions
     * and associated filters) and the display name of the data accessor. It does not allow changing the IAM role
     * associated with the data accessor or other core properties of the data accessor.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDataAccessorRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateDataAccessorRequest#builder()}
     * </p>
     *
     * @param updateDataAccessorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.UpdateDataAccessorRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateDataAccessor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.UpdateDataAccessor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdateDataAccessor" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateDataAccessorResponse> updateDataAccessor(
            Consumer<UpdateDataAccessorRequest.Builder> updateDataAccessorRequest) {
        return updateDataAccessor(UpdateDataAccessorRequest.builder().applyMutation(updateDataAccessorRequest).build());
    }

    /**
     * <p>
     * Updates an existing Amazon Q Business data source connector.
     * </p>
     *
     * @param updateDataSourceRequest
     * @return A Java Future containing the result of the UpdateDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.UpdateDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdateDataSource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateDataSourceResponse> updateDataSource(UpdateDataSourceRequest updateDataSourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing Amazon Q Business data source connector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDataSourceRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateDataSourceRequest#builder()}
     * </p>
     *
     * @param updateDataSourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.UpdateDataSourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.UpdateDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdateDataSource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateDataSourceResponse> updateDataSource(
            Consumer<UpdateDataSourceRequest.Builder> updateDataSourceRequest) {
        return updateDataSource(UpdateDataSourceRequest.builder().applyMutation(updateDataSourceRequest).build());
    }

    /**
     * <p>
     * Updates an Amazon Q Business index.
     * </p>
     *
     * @param updateIndexRequest
     * @return A Java Future containing the result of the UpdateIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Q Business service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.UpdateIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdateIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateIndexResponse> updateIndex(UpdateIndexRequest updateIndexRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an Amazon Q Business index.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateIndexRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateIndexRequest#builder()}
     * </p>
     *
     * @param updateIndexRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.UpdateIndexRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Q Business service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.UpdateIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdateIndex" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateIndexResponse> updateIndex(Consumer<UpdateIndexRequest.Builder> updateIndexRequest) {
        return updateIndex(UpdateIndexRequest.builder().applyMutation(updateIndexRequest).build());
    }

    /**
     * <p>
     * Updates an Amazon Q Business plugin.
     * </p>
     *
     * @param updatePluginRequest
     * @return A Java Future containing the result of the UpdatePlugin operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Q Business service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.UpdatePlugin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdatePlugin" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdatePluginResponse> updatePlugin(UpdatePluginRequest updatePluginRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an Amazon Q Business plugin.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePluginRequest.Builder} avoiding the need to
     * create one manually via {@link UpdatePluginRequest#builder()}
     * </p>
     *
     * @param updatePluginRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.UpdatePluginRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdatePlugin operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Q Business service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.UpdatePlugin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdatePlugin" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdatePluginResponse> updatePlugin(Consumer<UpdatePluginRequest.Builder> updatePluginRequest) {
        return updatePlugin(UpdatePluginRequest.builder().applyMutation(updatePluginRequest).build());
    }

    /**
     * <p>
     * Updates the retriever used for your Amazon Q Business application.
     * </p>
     *
     * @param updateRetrieverRequest
     * @return A Java Future containing the result of the UpdateRetriever operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Q Business service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.UpdateRetriever
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdateRetriever" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateRetrieverResponse> updateRetriever(UpdateRetrieverRequest updateRetrieverRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the retriever used for your Amazon Q Business application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRetrieverRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateRetrieverRequest#builder()}
     * </p>
     *
     * @param updateRetrieverRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.UpdateRetrieverRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateRetriever operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Q Business service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.UpdateRetriever
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdateRetriever" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateRetrieverResponse> updateRetriever(
            Consumer<UpdateRetrieverRequest.Builder> updateRetrieverRequest) {
        return updateRetriever(UpdateRetrieverRequest.builder().applyMutation(updateRetrieverRequest).build());
    }

    /**
     * <p>
     * Updates the pricing tier for an Amazon Q Business subscription. Upgrades are instant. Downgrades apply at the
     * start of the next month. Subscription tier determines feature access for the user. For more information on
     * subscriptions and pricing tiers, see <a href="https://aws.amazon.com/q/business/pricing/">Amazon Q Business
     * pricing</a>.
     * </p>
     *
     * @param updateSubscriptionRequest
     * @return A Java Future containing the result of the UpdateSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.UpdateSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdateSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateSubscriptionResponse> updateSubscription(UpdateSubscriptionRequest updateSubscriptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the pricing tier for an Amazon Q Business subscription. Upgrades are instant. Downgrades apply at the
     * start of the next month. Subscription tier determines feature access for the user. For more information on
     * subscriptions and pricing tiers, see <a href="https://aws.amazon.com/q/business/pricing/">Amazon Q Business
     * pricing</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSubscriptionRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateSubscriptionRequest#builder()}
     * </p>
     *
     * @param updateSubscriptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.UpdateSubscriptionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.UpdateSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdateSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateSubscriptionResponse> updateSubscription(
            Consumer<UpdateSubscriptionRequest.Builder> updateSubscriptionRequest) {
        return updateSubscription(UpdateSubscriptionRequest.builder().applyMutation(updateSubscriptionRequest).build());
    }

    /**
     * <p>
     * Updates a information associated with a user id.
     * </p>
     *
     * @param updateUserRequest
     * @return A Java Future containing the result of the UpdateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Q Business service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.UpdateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateUserResponse> updateUser(UpdateUserRequest updateUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a information associated with a user id.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateUserRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateUserRequest#builder()}
     * </p>
     *
     * @param updateUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.UpdateUserRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Q Business service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.UpdateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateUserResponse> updateUser(Consumer<UpdateUserRequest.Builder> updateUserRequest) {
        return updateUser(UpdateUserRequest.builder().applyMutation(updateUserRequest).build());
    }

    /**
     * <p>
     * Updates an Amazon Q Business web experience.
     * </p>
     *
     * @param updateWebExperienceRequest
     * @return A Java Future containing the result of the UpdateWebExperience operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.UpdateWebExperience
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdateWebExperience" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateWebExperienceResponse> updateWebExperience(
            UpdateWebExperienceRequest updateWebExperienceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an Amazon Q Business web experience.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateWebExperienceRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateWebExperienceRequest#builder()}
     * </p>
     *
     * @param updateWebExperienceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qbusiness.model.UpdateWebExperienceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateWebExperience operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Q Business
     *         service. Wait some minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>ResourceNotFoundException The application or plugin resource you want to use doesn’t exist. Make sure
     *         you have provided the correct resource and try again.</li>
     *         <li>ConflictException You are trying to perform an action that conflicts with the current status of your
     *         resource. Fix any inconsistencies with your resources and try again.</li>
     *         <li>ThrottlingException The request was denied due to throttling. Reduce the number of requests and try
     *         again.</li>
     *         <li>ValidationException The input doesn't meet the constraints set by the Amazon Q Business service.
     *         Provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don't have access to perform this action. Make sure you have the required
     *         permission policies and user accounts and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QBusinessAsyncClient.UpdateWebExperience
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdateWebExperience" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateWebExperienceResponse> updateWebExperience(
            Consumer<UpdateWebExperienceRequest.Builder> updateWebExperienceRequest) {
        return updateWebExperience(UpdateWebExperienceRequest.builder().applyMutation(updateWebExperienceRequest).build());
    }

    @Override
    default QBusinessServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link QBusinessAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static QBusinessAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link QBusinessAsyncClient}.
     */
    static QBusinessAsyncClientBuilder builder() {
        return new DefaultQBusinessAsyncClientBuilder();
    }
}
