/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The chat orchestration specific admin controls configured for an Amazon Q Business application. Determines whether
 * Amazon Q Business automatically routes chat requests across configured plugins and data sources in your Amazon Q
 * Business application.
 * </p>
 * <p>
 * For more information, see <a href=
 * "https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/guardrails-global-controls.html#guardrails-global-orchestration"
 * >Chat orchestration settings</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AppliedOrchestrationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AppliedOrchestrationConfiguration.Builder, AppliedOrchestrationConfiguration> {
    private static final SdkField<String> CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("control")
            .getter(getter(AppliedOrchestrationConfiguration::controlAsString)).setter(setter(Builder::control))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("control").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTROL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String control;

    private AppliedOrchestrationConfiguration(BuilderImpl builder) {
        this.control = builder.control;
    }

    /**
     * <p>
     * Information about whether chat orchestration is enabled or disabled for an Amazon Q Business application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #control} will
     * return {@link OrchestrationControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #controlAsString}.
     * </p>
     * 
     * @return Information about whether chat orchestration is enabled or disabled for an Amazon Q Business application.
     * @see OrchestrationControl
     */
    public final OrchestrationControl control() {
        return OrchestrationControl.fromValue(control);
    }

    /**
     * <p>
     * Information about whether chat orchestration is enabled or disabled for an Amazon Q Business application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #control} will
     * return {@link OrchestrationControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #controlAsString}.
     * </p>
     * 
     * @return Information about whether chat orchestration is enabled or disabled for an Amazon Q Business application.
     * @see OrchestrationControl
     */
    public final String controlAsString() {
        return control;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(controlAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppliedOrchestrationConfiguration)) {
            return false;
        }
        AppliedOrchestrationConfiguration other = (AppliedOrchestrationConfiguration) obj;
        return Objects.equals(controlAsString(), other.controlAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AppliedOrchestrationConfiguration").add("Control", controlAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "control":
            return Optional.ofNullable(clazz.cast(controlAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("control", CONTROL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AppliedOrchestrationConfiguration, T> g) {
        return obj -> g.apply((AppliedOrchestrationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AppliedOrchestrationConfiguration> {
        /**
         * <p>
         * Information about whether chat orchestration is enabled or disabled for an Amazon Q Business application.
         * </p>
         * 
         * @param control
         *        Information about whether chat orchestration is enabled or disabled for an Amazon Q Business
         *        application.
         * @see OrchestrationControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrchestrationControl
         */
        Builder control(String control);

        /**
         * <p>
         * Information about whether chat orchestration is enabled or disabled for an Amazon Q Business application.
         * </p>
         * 
         * @param control
         *        Information about whether chat orchestration is enabled or disabled for an Amazon Q Business
         *        application.
         * @see OrchestrationControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrchestrationControl
         */
        Builder control(OrchestrationControl control);
    }

    static final class BuilderImpl implements Builder {
        private String control;

        private BuilderImpl() {
        }

        private BuilderImpl(AppliedOrchestrationConfiguration model) {
            control(model.control);
        }

        public final String getControl() {
            return control;
        }

        public final void setControl(String control) {
            this.control = control;
        }

        @Override
        public final Builder control(String control) {
            this.control = control;
            return this;
        }

        @Override
        public final Builder control(OrchestrationControl control) {
            this.control(control == null ? null : control.toString());
            return this;
        }

        @Override
        public AppliedOrchestrationConfiguration build() {
            return new AppliedOrchestrationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
