/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CancelSubscriptionResponse extends QBusinessResponse implements
        ToCopyableBuilder<CancelSubscriptionResponse.Builder, CancelSubscriptionResponse> {
    private static final SdkField<String> SUBSCRIPTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("subscriptionArn").getter(getter(CancelSubscriptionResponse::subscriptionArn))
            .setter(setter(Builder::subscriptionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscriptionArn").build()).build();

    private static final SdkField<SubscriptionDetails> CURRENT_SUBSCRIPTION_FIELD = SdkField
            .<SubscriptionDetails> builder(MarshallingType.SDK_POJO).memberName("currentSubscription")
            .getter(getter(CancelSubscriptionResponse::currentSubscription)).setter(setter(Builder::currentSubscription))
            .constructor(SubscriptionDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentSubscription").build())
            .build();

    private static final SdkField<SubscriptionDetails> NEXT_SUBSCRIPTION_FIELD = SdkField
            .<SubscriptionDetails> builder(MarshallingType.SDK_POJO).memberName("nextSubscription")
            .getter(getter(CancelSubscriptionResponse::nextSubscription)).setter(setter(Builder::nextSubscription))
            .constructor(SubscriptionDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextSubscription").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBSCRIPTION_ARN_FIELD,
            CURRENT_SUBSCRIPTION_FIELD, NEXT_SUBSCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String subscriptionArn;

    private final SubscriptionDetails currentSubscription;

    private final SubscriptionDetails nextSubscription;

    private CancelSubscriptionResponse(BuilderImpl builder) {
        super(builder);
        this.subscriptionArn = builder.subscriptionArn;
        this.currentSubscription = builder.currentSubscription;
        this.nextSubscription = builder.nextSubscription;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Q Business subscription being cancelled.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Q Business subscription being cancelled.
     */
    public final String subscriptionArn() {
        return subscriptionArn;
    }

    /**
     * <p>
     * The type of your current Amazon Q Business subscription.
     * </p>
     * 
     * @return The type of your current Amazon Q Business subscription.
     */
    public final SubscriptionDetails currentSubscription() {
        return currentSubscription;
    }

    /**
     * <p>
     * The type of the Amazon Q Business subscription for the next month.
     * </p>
     * 
     * @return The type of the Amazon Q Business subscription for the next month.
     */
    public final SubscriptionDetails nextSubscription() {
        return nextSubscription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(subscriptionArn());
        hashCode = 31 * hashCode + Objects.hashCode(currentSubscription());
        hashCode = 31 * hashCode + Objects.hashCode(nextSubscription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelSubscriptionResponse)) {
            return false;
        }
        CancelSubscriptionResponse other = (CancelSubscriptionResponse) obj;
        return Objects.equals(subscriptionArn(), other.subscriptionArn())
                && Objects.equals(currentSubscription(), other.currentSubscription())
                && Objects.equals(nextSubscription(), other.nextSubscription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CancelSubscriptionResponse").add("SubscriptionArn", subscriptionArn())
                .add("CurrentSubscription", currentSubscription()).add("NextSubscription", nextSubscription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "subscriptionArn":
            return Optional.ofNullable(clazz.cast(subscriptionArn()));
        case "currentSubscription":
            return Optional.ofNullable(clazz.cast(currentSubscription()));
        case "nextSubscription":
            return Optional.ofNullable(clazz.cast(nextSubscription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("subscriptionArn", SUBSCRIPTION_ARN_FIELD);
        map.put("currentSubscription", CURRENT_SUBSCRIPTION_FIELD);
        map.put("nextSubscription", NEXT_SUBSCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CancelSubscriptionResponse, T> g) {
        return obj -> g.apply((CancelSubscriptionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QBusinessResponse.Builder, SdkPojo, CopyableBuilder<Builder, CancelSubscriptionResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon Q Business subscription being cancelled.
         * </p>
         * 
         * @param subscriptionArn
         *        The Amazon Resource Name (ARN) of the Amazon Q Business subscription being cancelled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionArn(String subscriptionArn);

        /**
         * <p>
         * The type of your current Amazon Q Business subscription.
         * </p>
         * 
         * @param currentSubscription
         *        The type of your current Amazon Q Business subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentSubscription(SubscriptionDetails currentSubscription);

        /**
         * <p>
         * The type of your current Amazon Q Business subscription.
         * </p>
         * This is a convenience method that creates an instance of the {@link SubscriptionDetails.Builder} avoiding the
         * need to create one manually via {@link SubscriptionDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SubscriptionDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #currentSubscription(SubscriptionDetails)}.
         * 
         * @param currentSubscription
         *        a consumer that will call methods on {@link SubscriptionDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #currentSubscription(SubscriptionDetails)
         */
        default Builder currentSubscription(Consumer<SubscriptionDetails.Builder> currentSubscription) {
            return currentSubscription(SubscriptionDetails.builder().applyMutation(currentSubscription).build());
        }

        /**
         * <p>
         * The type of the Amazon Q Business subscription for the next month.
         * </p>
         * 
         * @param nextSubscription
         *        The type of the Amazon Q Business subscription for the next month.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextSubscription(SubscriptionDetails nextSubscription);

        /**
         * <p>
         * The type of the Amazon Q Business subscription for the next month.
         * </p>
         * This is a convenience method that creates an instance of the {@link SubscriptionDetails.Builder} avoiding the
         * need to create one manually via {@link SubscriptionDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SubscriptionDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #nextSubscription(SubscriptionDetails)}.
         * 
         * @param nextSubscription
         *        a consumer that will call methods on {@link SubscriptionDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nextSubscription(SubscriptionDetails)
         */
        default Builder nextSubscription(Consumer<SubscriptionDetails.Builder> nextSubscription) {
            return nextSubscription(SubscriptionDetails.builder().applyMutation(nextSubscription).build());
        }
    }

    static final class BuilderImpl extends QBusinessResponse.BuilderImpl implements Builder {
        private String subscriptionArn;

        private SubscriptionDetails currentSubscription;

        private SubscriptionDetails nextSubscription;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelSubscriptionResponse model) {
            super(model);
            subscriptionArn(model.subscriptionArn);
            currentSubscription(model.currentSubscription);
            nextSubscription(model.nextSubscription);
        }

        public final String getSubscriptionArn() {
            return subscriptionArn;
        }

        public final void setSubscriptionArn(String subscriptionArn) {
            this.subscriptionArn = subscriptionArn;
        }

        @Override
        public final Builder subscriptionArn(String subscriptionArn) {
            this.subscriptionArn = subscriptionArn;
            return this;
        }

        public final SubscriptionDetails.Builder getCurrentSubscription() {
            return currentSubscription != null ? currentSubscription.toBuilder() : null;
        }

        public final void setCurrentSubscription(SubscriptionDetails.BuilderImpl currentSubscription) {
            this.currentSubscription = currentSubscription != null ? currentSubscription.build() : null;
        }

        @Override
        public final Builder currentSubscription(SubscriptionDetails currentSubscription) {
            this.currentSubscription = currentSubscription;
            return this;
        }

        public final SubscriptionDetails.Builder getNextSubscription() {
            return nextSubscription != null ? nextSubscription.toBuilder() : null;
        }

        public final void setNextSubscription(SubscriptionDetails.BuilderImpl nextSubscription) {
            this.nextSubscription = nextSubscription != null ? nextSubscription.build() : null;
        }

        @Override
        public final Builder nextSubscription(SubscriptionDetails nextSubscription) {
            this.nextSubscription = nextSubscription;
            return this;
        }

        @Override
        public CancelSubscriptionResponse build() {
            return new CancelSubscriptionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
