/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Detailed information about a chat response configuration, including comprehensive settings and parameters that define
 * how Amazon Q Business generates and formats responses.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChatResponseConfigurationDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<ChatResponseConfigurationDetail.Builder, ChatResponseConfigurationDetail> {
    private static final SdkField<Map<String, ResponseConfiguration>> RESPONSE_CONFIGURATIONS_FIELD = SdkField
            .<Map<String, ResponseConfiguration>> builder(MarshallingType.MAP)
            .memberName("responseConfigurations")
            .getter(getter(ChatResponseConfigurationDetail::responseConfigurationsAsStrings))
            .setter(setter(Builder::responseConfigurationsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseConfigurations").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ResponseConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResponseConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> RESPONSE_CONFIGURATION_SUMMARY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("responseConfigurationSummary")
            .getter(getter(ChatResponseConfigurationDetail::responseConfigurationSummary))
            .setter(setter(Builder::responseConfigurationSummary))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseConfigurationSummary")
                    .build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ChatResponseConfigurationDetail::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<ErrorDetail> ERROR_FIELD = SdkField.<ErrorDetail> builder(MarshallingType.SDK_POJO)
            .memberName("error").getter(getter(ChatResponseConfigurationDetail::error)).setter(setter(Builder::error))
            .constructor(ErrorDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt").getter(getter(ChatResponseConfigurationDetail::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESPONSE_CONFIGURATIONS_FIELD,
            RESPONSE_CONFIGURATION_SUMMARY_FIELD, STATUS_FIELD, ERROR_FIELD, UPDATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Map<String, ResponseConfiguration> responseConfigurations;

    private final String responseConfigurationSummary;

    private final String status;

    private final ErrorDetail error;

    private final Instant updatedAt;

    private ChatResponseConfigurationDetail(BuilderImpl builder) {
        this.responseConfigurations = builder.responseConfigurations;
        this.responseConfigurationSummary = builder.responseConfigurationSummary;
        this.status = builder.status;
        this.error = builder.error;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * A collection of specific response configuration settings that collectively define how responses are generated,
     * formatted, and presented to users in chat interactions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResponseConfigurations} method.
     * </p>
     * 
     * @return A collection of specific response configuration settings that collectively define how responses are
     *         generated, formatted, and presented to users in chat interactions.
     */
    public final Map<ResponseConfigurationType, ResponseConfiguration> responseConfigurations() {
        return ResponseConfigurationsCopier.copyStringToEnum(responseConfigurations);
    }

    /**
     * For responses, this returns true if the service returned a value for the ResponseConfigurations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasResponseConfigurations() {
        return responseConfigurations != null && !(responseConfigurations instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A collection of specific response configuration settings that collectively define how responses are generated,
     * formatted, and presented to users in chat interactions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResponseConfigurations} method.
     * </p>
     * 
     * @return A collection of specific response configuration settings that collectively define how responses are
     *         generated, formatted, and presented to users in chat interactions.
     */
    public final Map<String, ResponseConfiguration> responseConfigurationsAsStrings() {
        return responseConfigurations;
    }

    /**
     * <p>
     * A summary of the response configuration details, providing a concise overview of the key parameters and settings
     * that define the response generation behavior.
     * </p>
     * 
     * @return A summary of the response configuration details, providing a concise overview of the key parameters and
     *         settings that define the response generation behavior.
     */
    public final String responseConfigurationSummary() {
        return responseConfigurationSummary;
    }

    /**
     * <p>
     * The current status of the chat response configuration, indicating whether it is active, pending, or in another
     * state that affects its availability for use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ChatResponseConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the chat response configuration, indicating whether it is active, pending, or in
     *         another state that affects its availability for use.
     * @see ChatResponseConfigurationStatus
     */
    public final ChatResponseConfigurationStatus status() {
        return ChatResponseConfigurationStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the chat response configuration, indicating whether it is active, pending, or in another
     * state that affects its availability for use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ChatResponseConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the chat response configuration, indicating whether it is active, pending, or in
     *         another state that affects its availability for use.
     * @see ChatResponseConfigurationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * Returns the value of the Error property for this object.
     * 
     * @return The value of the Error property for this object.
     */
    public final ErrorDetail error() {
        return error;
    }

    /**
     * <p>
     * The timestamp indicating when the detailed chat response configuration was last modified, helping administrators
     * track changes and maintain version awareness.
     * </p>
     * 
     * @return The timestamp indicating when the detailed chat response configuration was last modified, helping
     *         administrators track changes and maintain version awareness.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasResponseConfigurations() ? responseConfigurationsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(responseConfigurationSummary());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChatResponseConfigurationDetail)) {
            return false;
        }
        ChatResponseConfigurationDetail other = (ChatResponseConfigurationDetail) obj;
        return hasResponseConfigurations() == other.hasResponseConfigurations()
                && Objects.equals(responseConfigurationsAsStrings(), other.responseConfigurationsAsStrings())
                && Objects.equals(responseConfigurationSummary(), other.responseConfigurationSummary())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(error(), other.error())
                && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChatResponseConfigurationDetail")
                .add("ResponseConfigurations", hasResponseConfigurations() ? responseConfigurationsAsStrings() : null)
                .add("ResponseConfigurationSummary", responseConfigurationSummary()).add("Status", statusAsString())
                .add("Error", error()).add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "responseConfigurations":
            return Optional.ofNullable(clazz.cast(responseConfigurationsAsStrings()));
        case "responseConfigurationSummary":
            return Optional.ofNullable(clazz.cast(responseConfigurationSummary()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "error":
            return Optional.ofNullable(clazz.cast(error()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("responseConfigurations", RESPONSE_CONFIGURATIONS_FIELD);
        map.put("responseConfigurationSummary", RESPONSE_CONFIGURATION_SUMMARY_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("error", ERROR_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChatResponseConfigurationDetail, T> g) {
        return obj -> g.apply((ChatResponseConfigurationDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChatResponseConfigurationDetail> {
        /**
         * <p>
         * A collection of specific response configuration settings that collectively define how responses are
         * generated, formatted, and presented to users in chat interactions.
         * </p>
         * 
         * @param responseConfigurations
         *        A collection of specific response configuration settings that collectively define how responses are
         *        generated, formatted, and presented to users in chat interactions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseConfigurationsWithStrings(Map<String, ResponseConfiguration> responseConfigurations);

        /**
         * <p>
         * A collection of specific response configuration settings that collectively define how responses are
         * generated, formatted, and presented to users in chat interactions.
         * </p>
         * 
         * @param responseConfigurations
         *        A collection of specific response configuration settings that collectively define how responses are
         *        generated, formatted, and presented to users in chat interactions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseConfigurations(Map<ResponseConfigurationType, ResponseConfiguration> responseConfigurations);

        /**
         * <p>
         * A summary of the response configuration details, providing a concise overview of the key parameters and
         * settings that define the response generation behavior.
         * </p>
         * 
         * @param responseConfigurationSummary
         *        A summary of the response configuration details, providing a concise overview of the key parameters
         *        and settings that define the response generation behavior.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseConfigurationSummary(String responseConfigurationSummary);

        /**
         * <p>
         * The current status of the chat response configuration, indicating whether it is active, pending, or in
         * another state that affects its availability for use.
         * </p>
         * 
         * @param status
         *        The current status of the chat response configuration, indicating whether it is active, pending, or in
         *        another state that affects its availability for use.
         * @see ChatResponseConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChatResponseConfigurationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the chat response configuration, indicating whether it is active, pending, or in
         * another state that affects its availability for use.
         * </p>
         * 
         * @param status
         *        The current status of the chat response configuration, indicating whether it is active, pending, or in
         *        another state that affects its availability for use.
         * @see ChatResponseConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChatResponseConfigurationStatus
         */
        Builder status(ChatResponseConfigurationStatus status);

        /**
         * Sets the value of the Error property for this object.
         *
         * @param error
         *        The new value for the Error property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(ErrorDetail error);

        /**
         * Sets the value of the Error property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ErrorDetail.Builder} avoiding the need to
         * create one manually via {@link ErrorDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ErrorDetail.Builder#build()} is called immediately and its result
         * is passed to {@link #error(ErrorDetail)}.
         * 
         * @param error
         *        a consumer that will call methods on {@link ErrorDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #error(ErrorDetail)
         */
        default Builder error(Consumer<ErrorDetail.Builder> error) {
            return error(ErrorDetail.builder().applyMutation(error).build());
        }

        /**
         * <p>
         * The timestamp indicating when the detailed chat response configuration was last modified, helping
         * administrators track changes and maintain version awareness.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp indicating when the detailed chat response configuration was last modified, helping
         *        administrators track changes and maintain version awareness.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, ResponseConfiguration> responseConfigurations = DefaultSdkAutoConstructMap.getInstance();

        private String responseConfigurationSummary;

        private String status;

        private ErrorDetail error;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(ChatResponseConfigurationDetail model) {
            responseConfigurationsWithStrings(model.responseConfigurations);
            responseConfigurationSummary(model.responseConfigurationSummary);
            status(model.status);
            error(model.error);
            updatedAt(model.updatedAt);
        }

        public final Map<String, ResponseConfiguration.Builder> getResponseConfigurations() {
            Map<String, ResponseConfiguration.Builder> result = ResponseConfigurationsCopier
                    .copyToBuilder(this.responseConfigurations);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setResponseConfigurations(Map<String, ResponseConfiguration.BuilderImpl> responseConfigurations) {
            this.responseConfigurations = ResponseConfigurationsCopier.copyFromBuilder(responseConfigurations);
        }

        @Override
        public final Builder responseConfigurationsWithStrings(Map<String, ResponseConfiguration> responseConfigurations) {
            this.responseConfigurations = ResponseConfigurationsCopier.copy(responseConfigurations);
            return this;
        }

        @Override
        public final Builder responseConfigurations(Map<ResponseConfigurationType, ResponseConfiguration> responseConfigurations) {
            this.responseConfigurations = ResponseConfigurationsCopier.copyEnumToString(responseConfigurations);
            return this;
        }

        public final String getResponseConfigurationSummary() {
            return responseConfigurationSummary;
        }

        public final void setResponseConfigurationSummary(String responseConfigurationSummary) {
            this.responseConfigurationSummary = responseConfigurationSummary;
        }

        @Override
        public final Builder responseConfigurationSummary(String responseConfigurationSummary) {
            this.responseConfigurationSummary = responseConfigurationSummary;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ChatResponseConfigurationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final ErrorDetail.Builder getError() {
            return error != null ? error.toBuilder() : null;
        }

        public final void setError(ErrorDetail.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(ErrorDetail error) {
            this.error = error;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public ChatResponseConfigurationDetail build() {
            return new ChatResponseConfigurationDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
