/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAnonymousWebExperienceUrlResponse extends QBusinessResponse implements
        ToCopyableBuilder<CreateAnonymousWebExperienceUrlResponse.Builder, CreateAnonymousWebExperienceUrlResponse> {
    private static final SdkField<String> ANONYMOUS_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("anonymousUrl").getter(getter(CreateAnonymousWebExperienceUrlResponse::anonymousUrl))
            .setter(setter(Builder::anonymousUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("anonymousUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANONYMOUS_URL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String anonymousUrl;

    private CreateAnonymousWebExperienceUrlResponse(BuilderImpl builder) {
        super(builder);
        this.anonymousUrl = builder.anonymousUrl;
    }

    /**
     * <p>
     * The unique URL for accessing the web experience.
     * </p>
     * <important>
     * <p>
     * This URL can only be used once and must be used within 5 minutes after it's generated.
     * </p>
     * </important>
     * 
     * @return The unique URL for accessing the web experience.</p> <important>
     *         <p>
     *         This URL can only be used once and must be used within 5 minutes after it's generated.
     *         </p>
     */
    public final String anonymousUrl() {
        return anonymousUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(anonymousUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAnonymousWebExperienceUrlResponse)) {
            return false;
        }
        CreateAnonymousWebExperienceUrlResponse other = (CreateAnonymousWebExperienceUrlResponse) obj;
        return Objects.equals(anonymousUrl(), other.anonymousUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAnonymousWebExperienceUrlResponse").add("AnonymousUrl", anonymousUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "anonymousUrl":
            return Optional.ofNullable(clazz.cast(anonymousUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("anonymousUrl", ANONYMOUS_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAnonymousWebExperienceUrlResponse, T> g) {
        return obj -> g.apply((CreateAnonymousWebExperienceUrlResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QBusinessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateAnonymousWebExperienceUrlResponse> {
        /**
         * <p>
         * The unique URL for accessing the web experience.
         * </p>
         * <important>
         * <p>
         * This URL can only be used once and must be used within 5 minutes after it's generated.
         * </p>
         * </important>
         * 
         * @param anonymousUrl
         *        The unique URL for accessing the web experience.</p> <important>
         *        <p>
         *        This URL can only be used once and must be used within 5 minutes after it's generated.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anonymousUrl(String anonymousUrl);
    }

    static final class BuilderImpl extends QBusinessResponse.BuilderImpl implements Builder {
        private String anonymousUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAnonymousWebExperienceUrlResponse model) {
            super(model);
            anonymousUrl(model.anonymousUrl);
        }

        public final String getAnonymousUrl() {
            return anonymousUrl;
        }

        public final void setAnonymousUrl(String anonymousUrl) {
            this.anonymousUrl = anonymousUrl;
        }

        @Override
        public final Builder anonymousUrl(String anonymousUrl) {
            this.anonymousUrl = anonymousUrl;
            return this;
        }

        @Override
        public CreateAnonymousWebExperienceUrlResponse build() {
            return new CreateAnonymousWebExperienceUrlResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
