/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateChatResponseConfigurationResponse extends QBusinessResponse implements
        ToCopyableBuilder<CreateChatResponseConfigurationResponse.Builder, CreateChatResponseConfigurationResponse> {
    private static final SdkField<String> CHAT_RESPONSE_CONFIGURATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("chatResponseConfigurationId")
            .getter(getter(CreateChatResponseConfigurationResponse::chatResponseConfigurationId))
            .setter(setter(Builder::chatResponseConfigurationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("chatResponseConfigurationId")
                    .build()).build();

    private static final SdkField<String> CHAT_RESPONSE_CONFIGURATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("chatResponseConfigurationArn")
            .getter(getter(CreateChatResponseConfigurationResponse::chatResponseConfigurationArn))
            .setter(setter(Builder::chatResponseConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("chatResponseConfigurationArn")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CHAT_RESPONSE_CONFIGURATION_ID_FIELD, CHAT_RESPONSE_CONFIGURATION_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String chatResponseConfigurationId;

    private final String chatResponseConfigurationArn;

    private CreateChatResponseConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.chatResponseConfigurationId = builder.chatResponseConfigurationId;
        this.chatResponseConfigurationArn = builder.chatResponseConfigurationArn;
    }

    /**
     * <p>
     * The unique identifier assigned to a newly created chat response configuration, used for subsequent operations on
     * this resource.
     * </p>
     * 
     * @return The unique identifier assigned to a newly created chat response configuration, used for subsequent
     *         operations on this resource.
     */
    public final String chatResponseConfigurationId() {
        return chatResponseConfigurationId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the newly created chat response configuration, which uniquely identifies the
     * resource across all Amazon Web Services services.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the newly created chat response configuration, which uniquely
     *         identifies the resource across all Amazon Web Services services.
     */
    public final String chatResponseConfigurationArn() {
        return chatResponseConfigurationArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(chatResponseConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(chatResponseConfigurationArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateChatResponseConfigurationResponse)) {
            return false;
        }
        CreateChatResponseConfigurationResponse other = (CreateChatResponseConfigurationResponse) obj;
        return Objects.equals(chatResponseConfigurationId(), other.chatResponseConfigurationId())
                && Objects.equals(chatResponseConfigurationArn(), other.chatResponseConfigurationArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateChatResponseConfigurationResponse")
                .add("ChatResponseConfigurationId", chatResponseConfigurationId())
                .add("ChatResponseConfigurationArn", chatResponseConfigurationArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "chatResponseConfigurationId":
            return Optional.ofNullable(clazz.cast(chatResponseConfigurationId()));
        case "chatResponseConfigurationArn":
            return Optional.ofNullable(clazz.cast(chatResponseConfigurationArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("chatResponseConfigurationId", CHAT_RESPONSE_CONFIGURATION_ID_FIELD);
        map.put("chatResponseConfigurationArn", CHAT_RESPONSE_CONFIGURATION_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateChatResponseConfigurationResponse, T> g) {
        return obj -> g.apply((CreateChatResponseConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QBusinessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateChatResponseConfigurationResponse> {
        /**
         * <p>
         * The unique identifier assigned to a newly created chat response configuration, used for subsequent operations
         * on this resource.
         * </p>
         * 
         * @param chatResponseConfigurationId
         *        The unique identifier assigned to a newly created chat response configuration, used for subsequent
         *        operations on this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chatResponseConfigurationId(String chatResponseConfigurationId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the newly created chat response configuration, which uniquely identifies
         * the resource across all Amazon Web Services services.
         * </p>
         * 
         * @param chatResponseConfigurationArn
         *        The Amazon Resource Name (ARN) of the newly created chat response configuration, which uniquely
         *        identifies the resource across all Amazon Web Services services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chatResponseConfigurationArn(String chatResponseConfigurationArn);
    }

    static final class BuilderImpl extends QBusinessResponse.BuilderImpl implements Builder {
        private String chatResponseConfigurationId;

        private String chatResponseConfigurationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateChatResponseConfigurationResponse model) {
            super(model);
            chatResponseConfigurationId(model.chatResponseConfigurationId);
            chatResponseConfigurationArn(model.chatResponseConfigurationArn);
        }

        public final String getChatResponseConfigurationId() {
            return chatResponseConfigurationId;
        }

        public final void setChatResponseConfigurationId(String chatResponseConfigurationId) {
            this.chatResponseConfigurationId = chatResponseConfigurationId;
        }

        @Override
        public final Builder chatResponseConfigurationId(String chatResponseConfigurationId) {
            this.chatResponseConfigurationId = chatResponseConfigurationId;
            return this;
        }

        public final String getChatResponseConfigurationArn() {
            return chatResponseConfigurationArn;
        }

        public final void setChatResponseConfigurationArn(String chatResponseConfigurationArn) {
            this.chatResponseConfigurationArn = chatResponseConfigurationArn;
        }

        @Override
        public final Builder chatResponseConfigurationArn(String chatResponseConfigurationArn) {
            this.chatResponseConfigurationArn = chatResponseConfigurationArn;
            return this;
        }

        @Override
        public CreateChatResponseConfigurationResponse build() {
            return new CreateChatResponseConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
