/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDataAccessorResponse extends QBusinessResponse implements
        ToCopyableBuilder<CreateDataAccessorResponse.Builder, CreateDataAccessorResponse> {
    private static final SdkField<String> DATA_ACCESSOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataAccessorId").getter(getter(CreateDataAccessorResponse::dataAccessorId))
            .setter(setter(Builder::dataAccessorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataAccessorId").build()).build();

    private static final SdkField<String> IDC_APPLICATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("idcApplicationArn").getter(getter(CreateDataAccessorResponse::idcApplicationArn))
            .setter(setter(Builder::idcApplicationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idcApplicationArn").build()).build();

    private static final SdkField<String> DATA_ACCESSOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataAccessorArn").getter(getter(CreateDataAccessorResponse::dataAccessorArn))
            .setter(setter(Builder::dataAccessorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataAccessorArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_ACCESSOR_ID_FIELD,
            IDC_APPLICATION_ARN_FIELD, DATA_ACCESSOR_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String dataAccessorId;

    private final String idcApplicationArn;

    private final String dataAccessorArn;

    private CreateDataAccessorResponse(BuilderImpl builder) {
        super(builder);
        this.dataAccessorId = builder.dataAccessorId;
        this.idcApplicationArn = builder.idcApplicationArn;
        this.dataAccessorArn = builder.dataAccessorArn;
    }

    /**
     * <p>
     * The unique identifier of the created data accessor.
     * </p>
     * 
     * @return The unique identifier of the created data accessor.
     */
    public final String dataAccessorId() {
        return dataAccessorId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM Identity Center application created for this data accessor.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM Identity Center application created for this data accessor.
     */
    public final String idcApplicationArn() {
        return idcApplicationArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the created data accessor.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the created data accessor.
     */
    public final String dataAccessorArn() {
        return dataAccessorArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dataAccessorId());
        hashCode = 31 * hashCode + Objects.hashCode(idcApplicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(dataAccessorArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataAccessorResponse)) {
            return false;
        }
        CreateDataAccessorResponse other = (CreateDataAccessorResponse) obj;
        return Objects.equals(dataAccessorId(), other.dataAccessorId())
                && Objects.equals(idcApplicationArn(), other.idcApplicationArn())
                && Objects.equals(dataAccessorArn(), other.dataAccessorArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDataAccessorResponse").add("DataAccessorId", dataAccessorId())
                .add("IdcApplicationArn", idcApplicationArn()).add("DataAccessorArn", dataAccessorArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dataAccessorId":
            return Optional.ofNullable(clazz.cast(dataAccessorId()));
        case "idcApplicationArn":
            return Optional.ofNullable(clazz.cast(idcApplicationArn()));
        case "dataAccessorArn":
            return Optional.ofNullable(clazz.cast(dataAccessorArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("dataAccessorId", DATA_ACCESSOR_ID_FIELD);
        map.put("idcApplicationArn", IDC_APPLICATION_ARN_FIELD);
        map.put("dataAccessorArn", DATA_ACCESSOR_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDataAccessorResponse, T> g) {
        return obj -> g.apply((CreateDataAccessorResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QBusinessResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateDataAccessorResponse> {
        /**
         * <p>
         * The unique identifier of the created data accessor.
         * </p>
         * 
         * @param dataAccessorId
         *        The unique identifier of the created data accessor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataAccessorId(String dataAccessorId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM Identity Center application created for this data accessor.
         * </p>
         * 
         * @param idcApplicationArn
         *        The Amazon Resource Name (ARN) of the IAM Identity Center application created for this data accessor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idcApplicationArn(String idcApplicationArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the created data accessor.
         * </p>
         * 
         * @param dataAccessorArn
         *        The Amazon Resource Name (ARN) of the created data accessor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataAccessorArn(String dataAccessorArn);
    }

    static final class BuilderImpl extends QBusinessResponse.BuilderImpl implements Builder {
        private String dataAccessorId;

        private String idcApplicationArn;

        private String dataAccessorArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataAccessorResponse model) {
            super(model);
            dataAccessorId(model.dataAccessorId);
            idcApplicationArn(model.idcApplicationArn);
            dataAccessorArn(model.dataAccessorArn);
        }

        public final String getDataAccessorId() {
            return dataAccessorId;
        }

        public final void setDataAccessorId(String dataAccessorId) {
            this.dataAccessorId = dataAccessorId;
        }

        @Override
        public final Builder dataAccessorId(String dataAccessorId) {
            this.dataAccessorId = dataAccessorId;
            return this;
        }

        public final String getIdcApplicationArn() {
            return idcApplicationArn;
        }

        public final void setIdcApplicationArn(String idcApplicationArn) {
            this.idcApplicationArn = idcApplicationArn;
        }

        @Override
        public final Builder idcApplicationArn(String idcApplicationArn) {
            this.idcApplicationArn = idcApplicationArn;
            return this;
        }

        public final String getDataAccessorArn() {
            return dataAccessorArn;
        }

        public final void setDataAccessorArn(String dataAccessorArn) {
            this.dataAccessorArn = dataAccessorArn;
        }

        @Override
        public final Builder dataAccessorArn(String dataAccessorArn) {
            this.dataAccessorArn = dataAccessorArn;
            return this;
        }

        @Override
        public CreateDataAccessorResponse build() {
            return new CreateDataAccessorResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
