/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDataSourceRequest extends QBusinessRequest implements
        ToCopyableBuilder<CreateDataSourceRequest.Builder, CreateDataSourceRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationId").getter(getter(CreateDataSourceRequest::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()).build();

    private static final SdkField<String> INDEX_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("indexId").getter(getter(CreateDataSourceRequest::indexId)).setter(setter(Builder::indexId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("indexId").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(CreateDataSourceRequest::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<Document> CONFIGURATION_FIELD = SdkField.<Document> builder(MarshallingType.DOCUMENT)
            .memberName("configuration").getter(getter(CreateDataSourceRequest::configuration))
            .setter(setter(Builder::configuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final SdkField<DataSourceVpcConfiguration> VPC_CONFIGURATION_FIELD = SdkField
            .<DataSourceVpcConfiguration> builder(MarshallingType.SDK_POJO).memberName("vpcConfiguration")
            .getter(getter(CreateDataSourceRequest::vpcConfiguration)).setter(setter(Builder::vpcConfiguration))
            .constructor(DataSourceVpcConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConfiguration").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateDataSourceRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateDataSourceRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SYNC_SCHEDULE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("syncSchedule").getter(getter(CreateDataSourceRequest::syncSchedule))
            .setter(setter(Builder::syncSchedule))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("syncSchedule").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(CreateDataSourceRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateDataSourceRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<DocumentEnrichmentConfiguration> DOCUMENT_ENRICHMENT_CONFIGURATION_FIELD = SdkField
            .<DocumentEnrichmentConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("documentEnrichmentConfiguration")
            .getter(getter(CreateDataSourceRequest::documentEnrichmentConfiguration))
            .setter(setter(Builder::documentEnrichmentConfiguration))
            .constructor(DocumentEnrichmentConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentEnrichmentConfiguration")
                    .build()).build();

    private static final SdkField<MediaExtractionConfiguration> MEDIA_EXTRACTION_CONFIGURATION_FIELD = SdkField
            .<MediaExtractionConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("mediaExtractionConfiguration")
            .getter(getter(CreateDataSourceRequest::mediaExtractionConfiguration))
            .setter(setter(Builder::mediaExtractionConfiguration))
            .constructor(MediaExtractionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaExtractionConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            INDEX_ID_FIELD, DISPLAY_NAME_FIELD, CONFIGURATION_FIELD, VPC_CONFIGURATION_FIELD, DESCRIPTION_FIELD, TAGS_FIELD,
            SYNC_SCHEDULE_FIELD, ROLE_ARN_FIELD, CLIENT_TOKEN_FIELD, DOCUMENT_ENRICHMENT_CONFIGURATION_FIELD,
            MEDIA_EXTRACTION_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String applicationId;

    private final String indexId;

    private final String displayName;

    private final Document configuration;

    private final DataSourceVpcConfiguration vpcConfiguration;

    private final String description;

    private final List<Tag> tags;

    private final String syncSchedule;

    private final String roleArn;

    private final String clientToken;

    private final DocumentEnrichmentConfiguration documentEnrichmentConfiguration;

    private final MediaExtractionConfiguration mediaExtractionConfiguration;

    private CreateDataSourceRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.indexId = builder.indexId;
        this.displayName = builder.displayName;
        this.configuration = builder.configuration;
        this.vpcConfiguration = builder.vpcConfiguration;
        this.description = builder.description;
        this.tags = builder.tags;
        this.syncSchedule = builder.syncSchedule;
        this.roleArn = builder.roleArn;
        this.clientToken = builder.clientToken;
        this.documentEnrichmentConfiguration = builder.documentEnrichmentConfiguration;
        this.mediaExtractionConfiguration = builder.mediaExtractionConfiguration;
    }

    /**
     * <p>
     * The identifier of the Amazon Q Business application the data source will be attached to.
     * </p>
     * 
     * @return The identifier of the Amazon Q Business application the data source will be attached to.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The identifier of the index that you want to use with the data source connector.
     * </p>
     * 
     * @return The identifier of the index that you want to use with the data source connector.
     */
    public final String indexId() {
        return indexId;
    }

    /**
     * <p>
     * A name for the data source connector.
     * </p>
     * 
     * @return A name for the data source connector.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * Configuration information to connect your data source repository to Amazon Q Business. Use this parameter to
     * provide a JSON schema with configuration information specific to your data source connector.
     * </p>
     * <p>
     * Each data source has a JSON schema provided by Amazon Q Business that you must use. For example, the Amazon S3
     * and Web Crawler connectors require the following JSON schemas:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/s3-api.html">Amazon S3 JSON schema</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/web-crawler-api.html">Web Crawler JSON
     * schema</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can find configuration templates for your specific data source using the following steps:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Navigate to the <a
     * href="https://docs.aws.amazon.com/amazonq/latest/business-use-dg/connectors-list.html">Supported connectors</a>
     * page in the Amazon Q Business User Guide, and select the data source of your choice.
     * </p>
     * </li>
     * <li>
     * <p>
     * Then, from your specific data source connector page, select <b>Using the API</b>. You will find the JSON schema
     * for your data source, including parameter descriptions, in this section.
     * </p>
     * </li>
     * </ol>
     * 
     * @return Configuration information to connect your data source repository to Amazon Q Business. Use this parameter
     *         to provide a JSON schema with configuration information specific to your data source connector.</p>
     *         <p>
     *         Each data source has a JSON schema provided by Amazon Q Business that you must use. For example, the
     *         Amazon S3 and Web Crawler connectors require the following JSON schemas:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/s3-api.html">Amazon S3 JSON schema</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/web-crawler-api.html">Web Crawler JSON
     *         schema</a>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         You can find configuration templates for your specific data source using the following steps:
     *         </p>
     *         <ol>
     *         <li>
     *         <p>
     *         Navigate to the <a
     *         href="https://docs.aws.amazon.com/amazonq/latest/business-use-dg/connectors-list.html">Supported
     *         connectors</a> page in the Amazon Q Business User Guide, and select the data source of your choice.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Then, from your specific data source connector page, select <b>Using the API</b>. You will find the JSON
     *         schema for your data source, including parameter descriptions, in this section.
     *         </p>
     *         </li>
     */
    public final Document configuration() {
        return configuration;
    }

    /**
     * <p>
     * Configuration information for an Amazon VPC (Virtual Private Cloud) to connect to your data source. For more
     * information, see <a href="https://docs.aws.amazon.com/amazonq/latest/business-use-dg/connector-vpc.html">Using
     * Amazon VPC with Amazon Q Business connectors</a>.
     * </p>
     * 
     * @return Configuration information for an Amazon VPC (Virtual Private Cloud) to connect to your data source. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/amazonq/latest/business-use-dg/connector-vpc.html">Using Amazon VPC
     *         with Amazon Q Business connectors</a>.
     */
    public final DataSourceVpcConfiguration vpcConfiguration() {
        return vpcConfiguration;
    }

    /**
     * <p>
     * A description for the data source connector.
     * </p>
     * 
     * @return A description for the data source connector.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of key-value pairs that identify or categorize the data source connector. You can also use tags to help
     * control access to the data source connector. Tag keys and values can consist of Unicode letters, digits, white
     * space, and any of the following symbols: _ . : / = + - @.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of key-value pairs that identify or categorize the data source connector. You can also use tags to
     *         help control access to the data source connector. Tag keys and values can consist of Unicode letters,
     *         digits, white space, and any of the following symbols: _ . : / = + - @.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * Sets the frequency for Amazon Q Business to check the documents in your data source repository and update your
     * index. If you don't set a schedule, Amazon Q Business won't periodically update the index.
     * </p>
     * <p>
     * Specify a <code>cron-</code> format schedule string or an empty string to indicate that the index is updated on
     * demand. You can't specify the <code>Schedule</code> parameter when the <code>Type</code> parameter is set to
     * <code>CUSTOM</code>. If you do, you receive a <code>ValidationException</code> exception.
     * </p>
     * 
     * @return Sets the frequency for Amazon Q Business to check the documents in your data source repository and update
     *         your index. If you don't set a schedule, Amazon Q Business won't periodically update the index.</p>
     *         <p>
     *         Specify a <code>cron-</code> format schedule string or an empty string to indicate that the index is
     *         updated on demand. You can't specify the <code>Schedule</code> parameter when the <code>Type</code>
     *         parameter is set to <code>CUSTOM</code>. If you do, you receive a <code>ValidationException</code>
     *         exception.
     */
    public final String syncSchedule() {
        return syncSchedule;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM role with permission to access the data source and required resources.
     * This field is required for all connector types except custom connectors, where it is optional.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM role with permission to access the data source and required
     *         resources. This field is required for all connector types except custom connectors, where it is optional.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * A token you provide to identify a request to create a data source connector. Multiple calls to the
     * <code>CreateDataSource</code> API with the same client token will create only one data source connector.
     * </p>
     * 
     * @return A token you provide to identify a request to create a data source connector. Multiple calls to the
     *         <code>CreateDataSource</code> API with the same client token will create only one data source connector.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * Returns the value of the DocumentEnrichmentConfiguration property for this object.
     * 
     * @return The value of the DocumentEnrichmentConfiguration property for this object.
     */
    public final DocumentEnrichmentConfiguration documentEnrichmentConfiguration() {
        return documentEnrichmentConfiguration;
    }

    /**
     * <p>
     * The configuration for extracting information from media in documents during ingestion.
     * </p>
     * 
     * @return The configuration for extracting information from media in documents during ingestion.
     */
    public final MediaExtractionConfiguration mediaExtractionConfiguration() {
        return mediaExtractionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(indexId());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(syncSchedule());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(documentEnrichmentConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(mediaExtractionConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataSourceRequest)) {
            return false;
        }
        CreateDataSourceRequest other = (CreateDataSourceRequest) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(indexId(), other.indexId())
                && Objects.equals(displayName(), other.displayName()) && Objects.equals(configuration(), other.configuration())
                && Objects.equals(vpcConfiguration(), other.vpcConfiguration())
                && Objects.equals(description(), other.description()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(syncSchedule(), other.syncSchedule())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(documentEnrichmentConfiguration(), other.documentEnrichmentConfiguration())
                && Objects.equals(mediaExtractionConfiguration(), other.mediaExtractionConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDataSourceRequest").add("ApplicationId", applicationId()).add("IndexId", indexId())
                .add("DisplayName", displayName()).add("Configuration", configuration())
                .add("VpcConfiguration", vpcConfiguration()).add("Description", description())
                .add("Tags", hasTags() ? tags() : null).add("SyncSchedule", syncSchedule()).add("RoleArn", roleArn())
                .add("ClientToken", clientToken()).add("DocumentEnrichmentConfiguration", documentEnrichmentConfiguration())
                .add("MediaExtractionConfiguration", mediaExtractionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "indexId":
            return Optional.ofNullable(clazz.cast(indexId()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "vpcConfiguration":
            return Optional.ofNullable(clazz.cast(vpcConfiguration()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "syncSchedule":
            return Optional.ofNullable(clazz.cast(syncSchedule()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "documentEnrichmentConfiguration":
            return Optional.ofNullable(clazz.cast(documentEnrichmentConfiguration()));
        case "mediaExtractionConfiguration":
            return Optional.ofNullable(clazz.cast(mediaExtractionConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("applicationId", APPLICATION_ID_FIELD);
        map.put("indexId", INDEX_ID_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("configuration", CONFIGURATION_FIELD);
        map.put("vpcConfiguration", VPC_CONFIGURATION_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("syncSchedule", SYNC_SCHEDULE_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("documentEnrichmentConfiguration", DOCUMENT_ENRICHMENT_CONFIGURATION_FIELD);
        map.put("mediaExtractionConfiguration", MEDIA_EXTRACTION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDataSourceRequest, T> g) {
        return obj -> g.apply((CreateDataSourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QBusinessRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateDataSourceRequest> {
        /**
         * <p>
         * The identifier of the Amazon Q Business application the data source will be attached to.
         * </p>
         * 
         * @param applicationId
         *        The identifier of the Amazon Q Business application the data source will be attached to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The identifier of the index that you want to use with the data source connector.
         * </p>
         * 
         * @param indexId
         *        The identifier of the index that you want to use with the data source connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexId(String indexId);

        /**
         * <p>
         * A name for the data source connector.
         * </p>
         * 
         * @param displayName
         *        A name for the data source connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * Configuration information to connect your data source repository to Amazon Q Business. Use this parameter to
         * provide a JSON schema with configuration information specific to your data source connector.
         * </p>
         * <p>
         * Each data source has a JSON schema provided by Amazon Q Business that you must use. For example, the Amazon
         * S3 and Web Crawler connectors require the following JSON schemas:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/s3-api.html">Amazon S3 JSON schema</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/web-crawler-api.html">Web Crawler JSON
         * schema</a>
         * </p>
         * </li>
         * </ul>
         * <p>
         * You can find configuration templates for your specific data source using the following steps:
         * </p>
         * <ol>
         * <li>
         * <p>
         * Navigate to the <a
         * href="https://docs.aws.amazon.com/amazonq/latest/business-use-dg/connectors-list.html">Supported
         * connectors</a> page in the Amazon Q Business User Guide, and select the data source of your choice.
         * </p>
         * </li>
         * <li>
         * <p>
         * Then, from your specific data source connector page, select <b>Using the API</b>. You will find the JSON
         * schema for your data source, including parameter descriptions, in this section.
         * </p>
         * </li>
         * </ol>
         * 
         * @param configuration
         *        Configuration information to connect your data source repository to Amazon Q Business. Use this
         *        parameter to provide a JSON schema with configuration information specific to your data source
         *        connector.</p>
         *        <p>
         *        Each data source has a JSON schema provided by Amazon Q Business that you must use. For example, the
         *        Amazon S3 and Web Crawler connectors require the following JSON schemas:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/s3-api.html">Amazon S3 JSON
         *        schema</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/web-crawler-api.html">Web Crawler
         *        JSON schema</a>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        You can find configuration templates for your specific data source using the following steps:
         *        </p>
         *        <ol>
         *        <li>
         *        <p>
         *        Navigate to the <a
         *        href="https://docs.aws.amazon.com/amazonq/latest/business-use-dg/connectors-list.html">Supported
         *        connectors</a> page in the Amazon Q Business User Guide, and select the data source of your choice.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Then, from your specific data source connector page, select <b>Using the API</b>. You will find the
         *        JSON schema for your data source, including parameter descriptions, in this section.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(Document configuration);

        /**
         * <p>
         * Configuration information for an Amazon VPC (Virtual Private Cloud) to connect to your data source. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/amazonq/latest/business-use-dg/connector-vpc.html">Using Amazon VPC with
         * Amazon Q Business connectors</a>.
         * </p>
         * 
         * @param vpcConfiguration
         *        Configuration information for an Amazon VPC (Virtual Private Cloud) to connect to your data source.
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/amazonq/latest/business-use-dg/connector-vpc.html">Using Amazon VPC
         *        with Amazon Q Business connectors</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfiguration(DataSourceVpcConfiguration vpcConfiguration);

        /**
         * <p>
         * Configuration information for an Amazon VPC (Virtual Private Cloud) to connect to your data source. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/amazonq/latest/business-use-dg/connector-vpc.html">Using Amazon VPC with
         * Amazon Q Business connectors</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSourceVpcConfiguration.Builder}
         * avoiding the need to create one manually via {@link DataSourceVpcConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSourceVpcConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #vpcConfiguration(DataSourceVpcConfiguration)}.
         * 
         * @param vpcConfiguration
         *        a consumer that will call methods on {@link DataSourceVpcConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfiguration(DataSourceVpcConfiguration)
         */
        default Builder vpcConfiguration(Consumer<DataSourceVpcConfiguration.Builder> vpcConfiguration) {
            return vpcConfiguration(DataSourceVpcConfiguration.builder().applyMutation(vpcConfiguration).build());
        }

        /**
         * <p>
         * A description for the data source connector.
         * </p>
         * 
         * @param description
         *        A description for the data source connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A list of key-value pairs that identify or categorize the data source connector. You can also use tags to
         * help control access to the data source connector. Tag keys and values can consist of Unicode letters, digits,
         * white space, and any of the following symbols: _ . : / = + - @.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs that identify or categorize the data source connector. You can also use tags
         *        to help control access to the data source connector. Tag keys and values can consist of Unicode
         *        letters, digits, white space, and any of the following symbols: _ . : / = + - @.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of key-value pairs that identify or categorize the data source connector. You can also use tags to
         * help control access to the data source connector. Tag keys and values can consist of Unicode letters, digits,
         * white space, and any of the following symbols: _ . : / = + - @.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs that identify or categorize the data source connector. You can also use tags
         *        to help control access to the data source connector. Tag keys and values can consist of Unicode
         *        letters, digits, white space, and any of the following symbols: _ . : / = + - @.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of key-value pairs that identify or categorize the data source connector. You can also use tags to
         * help control access to the data source connector. Tag keys and values can consist of Unicode letters, digits,
         * white space, and any of the following symbols: _ . : / = + - @.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qbusiness.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.qbusiness.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qbusiness.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qbusiness.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Sets the frequency for Amazon Q Business to check the documents in your data source repository and update
         * your index. If you don't set a schedule, Amazon Q Business won't periodically update the index.
         * </p>
         * <p>
         * Specify a <code>cron-</code> format schedule string or an empty string to indicate that the index is updated
         * on demand. You can't specify the <code>Schedule</code> parameter when the <code>Type</code> parameter is set
         * to <code>CUSTOM</code>. If you do, you receive a <code>ValidationException</code> exception.
         * </p>
         * 
         * @param syncSchedule
         *        Sets the frequency for Amazon Q Business to check the documents in your data source repository and
         *        update your index. If you don't set a schedule, Amazon Q Business won't periodically update the
         *        index.</p>
         *        <p>
         *        Specify a <code>cron-</code> format schedule string or an empty string to indicate that the index is
         *        updated on demand. You can't specify the <code>Schedule</code> parameter when the <code>Type</code>
         *        parameter is set to <code>CUSTOM</code>. If you do, you receive a <code>ValidationException</code>
         *        exception.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder syncSchedule(String syncSchedule);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM role with permission to access the data source and required
         * resources. This field is required for all connector types except custom connectors, where it is optional.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of an IAM role with permission to access the data source and required
         *        resources. This field is required for all connector types except custom connectors, where it is
         *        optional.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * A token you provide to identify a request to create a data source connector. Multiple calls to the
         * <code>CreateDataSource</code> API with the same client token will create only one data source connector.
         * </p>
         * 
         * @param clientToken
         *        A token you provide to identify a request to create a data source connector. Multiple calls to the
         *        <code>CreateDataSource</code> API with the same client token will create only one data source
         *        connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * Sets the value of the DocumentEnrichmentConfiguration property for this object.
         *
         * @param documentEnrichmentConfiguration
         *        The new value for the DocumentEnrichmentConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentEnrichmentConfiguration(DocumentEnrichmentConfiguration documentEnrichmentConfiguration);

        /**
         * Sets the value of the DocumentEnrichmentConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DocumentEnrichmentConfiguration.Builder}
         * avoiding the need to create one manually via {@link DocumentEnrichmentConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DocumentEnrichmentConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #documentEnrichmentConfiguration(DocumentEnrichmentConfiguration)}.
         * 
         * @param documentEnrichmentConfiguration
         *        a consumer that will call methods on {@link DocumentEnrichmentConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documentEnrichmentConfiguration(DocumentEnrichmentConfiguration)
         */
        default Builder documentEnrichmentConfiguration(
                Consumer<DocumentEnrichmentConfiguration.Builder> documentEnrichmentConfiguration) {
            return documentEnrichmentConfiguration(DocumentEnrichmentConfiguration.builder()
                    .applyMutation(documentEnrichmentConfiguration).build());
        }

        /**
         * <p>
         * The configuration for extracting information from media in documents during ingestion.
         * </p>
         * 
         * @param mediaExtractionConfiguration
         *        The configuration for extracting information from media in documents during ingestion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaExtractionConfiguration(MediaExtractionConfiguration mediaExtractionConfiguration);

        /**
         * <p>
         * The configuration for extracting information from media in documents during ingestion.
         * </p>
         * This is a convenience method that creates an instance of the {@link MediaExtractionConfiguration.Builder}
         * avoiding the need to create one manually via {@link MediaExtractionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MediaExtractionConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #mediaExtractionConfiguration(MediaExtractionConfiguration)}.
         * 
         * @param mediaExtractionConfiguration
         *        a consumer that will call methods on {@link MediaExtractionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mediaExtractionConfiguration(MediaExtractionConfiguration)
         */
        default Builder mediaExtractionConfiguration(Consumer<MediaExtractionConfiguration.Builder> mediaExtractionConfiguration) {
            return mediaExtractionConfiguration(MediaExtractionConfiguration.builder()
                    .applyMutation(mediaExtractionConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QBusinessRequest.BuilderImpl implements Builder {
        private String applicationId;

        private String indexId;

        private String displayName;

        private Document configuration;

        private DataSourceVpcConfiguration vpcConfiguration;

        private String description;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String syncSchedule;

        private String roleArn;

        private String clientToken;

        private DocumentEnrichmentConfiguration documentEnrichmentConfiguration;

        private MediaExtractionConfiguration mediaExtractionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataSourceRequest model) {
            super(model);
            applicationId(model.applicationId);
            indexId(model.indexId);
            displayName(model.displayName);
            configuration(model.configuration);
            vpcConfiguration(model.vpcConfiguration);
            description(model.description);
            tags(model.tags);
            syncSchedule(model.syncSchedule);
            roleArn(model.roleArn);
            clientToken(model.clientToken);
            documentEnrichmentConfiguration(model.documentEnrichmentConfiguration);
            mediaExtractionConfiguration(model.mediaExtractionConfiguration);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getIndexId() {
            return indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final Document getConfiguration() {
            return configuration;
        }

        public final void setConfiguration(Document configuration) {
            this.configuration = configuration;
        }

        @Override
        public final Builder configuration(Document configuration) {
            this.configuration = configuration;
            return this;
        }

        public final DataSourceVpcConfiguration.Builder getVpcConfiguration() {
            return vpcConfiguration != null ? vpcConfiguration.toBuilder() : null;
        }

        public final void setVpcConfiguration(DataSourceVpcConfiguration.BuilderImpl vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration != null ? vpcConfiguration.build() : null;
        }

        @Override
        public final Builder vpcConfiguration(DataSourceVpcConfiguration vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSyncSchedule() {
            return syncSchedule;
        }

        public final void setSyncSchedule(String syncSchedule) {
            this.syncSchedule = syncSchedule;
        }

        @Override
        public final Builder syncSchedule(String syncSchedule) {
            this.syncSchedule = syncSchedule;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final DocumentEnrichmentConfiguration.Builder getDocumentEnrichmentConfiguration() {
            return documentEnrichmentConfiguration != null ? documentEnrichmentConfiguration.toBuilder() : null;
        }

        public final void setDocumentEnrichmentConfiguration(
                DocumentEnrichmentConfiguration.BuilderImpl documentEnrichmentConfiguration) {
            this.documentEnrichmentConfiguration = documentEnrichmentConfiguration != null ? documentEnrichmentConfiguration
                    .build() : null;
        }

        @Override
        public final Builder documentEnrichmentConfiguration(DocumentEnrichmentConfiguration documentEnrichmentConfiguration) {
            this.documentEnrichmentConfiguration = documentEnrichmentConfiguration;
            return this;
        }

        public final MediaExtractionConfiguration.Builder getMediaExtractionConfiguration() {
            return mediaExtractionConfiguration != null ? mediaExtractionConfiguration.toBuilder() : null;
        }

        public final void setMediaExtractionConfiguration(MediaExtractionConfiguration.BuilderImpl mediaExtractionConfiguration) {
            this.mediaExtractionConfiguration = mediaExtractionConfiguration != null ? mediaExtractionConfiguration.build()
                    : null;
        }

        @Override
        public final Builder mediaExtractionConfiguration(MediaExtractionConfiguration mediaExtractionConfiguration) {
            this.mediaExtractionConfiguration = mediaExtractionConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDataSourceRequest build() {
            return new CreateDataSourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
