/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A data source in an Amazon Q Business application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataSource implements SdkPojo, Serializable, ToCopyableBuilder<DataSource.Builder, DataSource> {
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(DataSource::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> DATA_SOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataSourceId").getter(getter(DataSource::dataSourceId)).setter(setter(Builder::dataSourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceId").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(DataSource::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(DataSource::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt").getter(getter(DataSource::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(DataSource::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISPLAY_NAME_FIELD,
            DATA_SOURCE_ID_FIELD, TYPE_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String displayName;

    private final String dataSourceId;

    private final String type;

    private final Instant createdAt;

    private final Instant updatedAt;

    private final String status;

    private DataSource(BuilderImpl builder) {
        this.displayName = builder.displayName;
        this.dataSourceId = builder.dataSourceId;
        this.type = builder.type;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.status = builder.status;
    }

    /**
     * <p>
     * The name of the Amazon Q Business data source.
     * </p>
     * 
     * @return The name of the Amazon Q Business data source.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The identifier of the Amazon Q Business data source.
     * </p>
     * 
     * @return The identifier of the Amazon Q Business data source.
     */
    public final String dataSourceId() {
        return dataSourceId;
    }

    /**
     * <p>
     * The type of the Amazon Q Business data source.
     * </p>
     * 
     * @return The type of the Amazon Q Business data source.
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * The Unix timestamp when the Amazon Q Business data source was created.
     * </p>
     * 
     * @return The Unix timestamp when the Amazon Q Business data source was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The Unix timestamp when the Amazon Q Business data source was last updated.
     * </p>
     * 
     * @return The Unix timestamp when the Amazon Q Business data source was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The status of the Amazon Q Business data source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DataSourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the Amazon Q Business data source.
     * @see DataSourceStatus
     */
    public final DataSourceStatus status() {
        return DataSourceStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the Amazon Q Business data source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DataSourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the Amazon Q Business data source.
     * @see DataSourceStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSource)) {
            return false;
        }
        DataSource other = (DataSource) obj;
        return Objects.equals(displayName(), other.displayName()) && Objects.equals(dataSourceId(), other.dataSourceId())
                && Objects.equals(type(), other.type()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(updatedAt(), other.updatedAt()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataSource").add("DisplayName", displayName()).add("DataSourceId", dataSourceId())
                .add("Type", type()).add("CreatedAt", createdAt()).add("UpdatedAt", updatedAt()).add("Status", statusAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "dataSourceId":
            return Optional.ofNullable(clazz.cast(dataSourceId()));
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("dataSourceId", DATA_SOURCE_ID_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataSource, T> g) {
        return obj -> g.apply((DataSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataSource> {
        /**
         * <p>
         * The name of the Amazon Q Business data source.
         * </p>
         * 
         * @param displayName
         *        The name of the Amazon Q Business data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The identifier of the Amazon Q Business data source.
         * </p>
         * 
         * @param dataSourceId
         *        The identifier of the Amazon Q Business data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceId(String dataSourceId);

        /**
         * <p>
         * The type of the Amazon Q Business data source.
         * </p>
         * 
         * @param type
         *        The type of the Amazon Q Business data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The Unix timestamp when the Amazon Q Business data source was created.
         * </p>
         * 
         * @param createdAt
         *        The Unix timestamp when the Amazon Q Business data source was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The Unix timestamp when the Amazon Q Business data source was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The Unix timestamp when the Amazon Q Business data source was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The status of the Amazon Q Business data source.
         * </p>
         * 
         * @param status
         *        The status of the Amazon Q Business data source.
         * @see DataSourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSourceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the Amazon Q Business data source.
         * </p>
         * 
         * @param status
         *        The status of the Amazon Q Business data source.
         * @see DataSourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSourceStatus
         */
        Builder status(DataSourceStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String displayName;

        private String dataSourceId;

        private String type;

        private Instant createdAt;

        private Instant updatedAt;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSource model) {
            displayName(model.displayName);
            dataSourceId(model.dataSourceId);
            type(model.type);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            status(model.status);
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getDataSourceId() {
            return dataSourceId;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DataSourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public DataSource build() {
            return new DataSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
