/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Maps a batch delete document request to a specific Amazon Q Business data source connector sync job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataSourceSyncJobMetrics implements SdkPojo, Serializable,
        ToCopyableBuilder<DataSourceSyncJobMetrics.Builder, DataSourceSyncJobMetrics> {
    private static final SdkField<String> DOCUMENTS_ADDED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("documentsAdded").getter(getter(DataSourceSyncJobMetrics::documentsAdded))
            .setter(setter(Builder::documentsAdded))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentsAdded").build()).build();

    private static final SdkField<String> DOCUMENTS_MODIFIED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("documentsModified").getter(getter(DataSourceSyncJobMetrics::documentsModified))
            .setter(setter(Builder::documentsModified))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentsModified").build()).build();

    private static final SdkField<String> DOCUMENTS_DELETED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("documentsDeleted").getter(getter(DataSourceSyncJobMetrics::documentsDeleted))
            .setter(setter(Builder::documentsDeleted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentsDeleted").build()).build();

    private static final SdkField<String> DOCUMENTS_FAILED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("documentsFailed").getter(getter(DataSourceSyncJobMetrics::documentsFailed))
            .setter(setter(Builder::documentsFailed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentsFailed").build()).build();

    private static final SdkField<String> DOCUMENTS_SCANNED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("documentsScanned").getter(getter(DataSourceSyncJobMetrics::documentsScanned))
            .setter(setter(Builder::documentsScanned))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentsScanned").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENTS_ADDED_FIELD,
            DOCUMENTS_MODIFIED_FIELD, DOCUMENTS_DELETED_FIELD, DOCUMENTS_FAILED_FIELD, DOCUMENTS_SCANNED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String documentsAdded;

    private final String documentsModified;

    private final String documentsDeleted;

    private final String documentsFailed;

    private final String documentsScanned;

    private DataSourceSyncJobMetrics(BuilderImpl builder) {
        this.documentsAdded = builder.documentsAdded;
        this.documentsModified = builder.documentsModified;
        this.documentsDeleted = builder.documentsDeleted;
        this.documentsFailed = builder.documentsFailed;
        this.documentsScanned = builder.documentsScanned;
    }

    /**
     * <p>
     * The current count of documents added from the data source during the data source sync.
     * </p>
     * 
     * @return The current count of documents added from the data source during the data source sync.
     */
    public final String documentsAdded() {
        return documentsAdded;
    }

    /**
     * <p>
     * The current count of documents modified in the data source during the data source sync.
     * </p>
     * 
     * @return The current count of documents modified in the data source during the data source sync.
     */
    public final String documentsModified() {
        return documentsModified;
    }

    /**
     * <p>
     * The current count of documents deleted from the data source during the data source sync.
     * </p>
     * 
     * @return The current count of documents deleted from the data source during the data source sync.
     */
    public final String documentsDeleted() {
        return documentsDeleted;
    }

    /**
     * <p>
     * The current count of documents that failed to sync from the data source during the data source sync.
     * </p>
     * 
     * @return The current count of documents that failed to sync from the data source during the data source sync.
     */
    public final String documentsFailed() {
        return documentsFailed;
    }

    /**
     * <p>
     * The current count of documents crawled by the ongoing sync job in the data source.
     * </p>
     * 
     * @return The current count of documents crawled by the ongoing sync job in the data source.
     */
    public final String documentsScanned() {
        return documentsScanned;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(documentsAdded());
        hashCode = 31 * hashCode + Objects.hashCode(documentsModified());
        hashCode = 31 * hashCode + Objects.hashCode(documentsDeleted());
        hashCode = 31 * hashCode + Objects.hashCode(documentsFailed());
        hashCode = 31 * hashCode + Objects.hashCode(documentsScanned());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSourceSyncJobMetrics)) {
            return false;
        }
        DataSourceSyncJobMetrics other = (DataSourceSyncJobMetrics) obj;
        return Objects.equals(documentsAdded(), other.documentsAdded())
                && Objects.equals(documentsModified(), other.documentsModified())
                && Objects.equals(documentsDeleted(), other.documentsDeleted())
                && Objects.equals(documentsFailed(), other.documentsFailed())
                && Objects.equals(documentsScanned(), other.documentsScanned());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataSourceSyncJobMetrics").add("DocumentsAdded", documentsAdded())
                .add("DocumentsModified", documentsModified()).add("DocumentsDeleted", documentsDeleted())
                .add("DocumentsFailed", documentsFailed()).add("DocumentsScanned", documentsScanned()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "documentsAdded":
            return Optional.ofNullable(clazz.cast(documentsAdded()));
        case "documentsModified":
            return Optional.ofNullable(clazz.cast(documentsModified()));
        case "documentsDeleted":
            return Optional.ofNullable(clazz.cast(documentsDeleted()));
        case "documentsFailed":
            return Optional.ofNullable(clazz.cast(documentsFailed()));
        case "documentsScanned":
            return Optional.ofNullable(clazz.cast(documentsScanned()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("documentsAdded", DOCUMENTS_ADDED_FIELD);
        map.put("documentsModified", DOCUMENTS_MODIFIED_FIELD);
        map.put("documentsDeleted", DOCUMENTS_DELETED_FIELD);
        map.put("documentsFailed", DOCUMENTS_FAILED_FIELD);
        map.put("documentsScanned", DOCUMENTS_SCANNED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataSourceSyncJobMetrics, T> g) {
        return obj -> g.apply((DataSourceSyncJobMetrics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataSourceSyncJobMetrics> {
        /**
         * <p>
         * The current count of documents added from the data source during the data source sync.
         * </p>
         * 
         * @param documentsAdded
         *        The current count of documents added from the data source during the data source sync.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentsAdded(String documentsAdded);

        /**
         * <p>
         * The current count of documents modified in the data source during the data source sync.
         * </p>
         * 
         * @param documentsModified
         *        The current count of documents modified in the data source during the data source sync.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentsModified(String documentsModified);

        /**
         * <p>
         * The current count of documents deleted from the data source during the data source sync.
         * </p>
         * 
         * @param documentsDeleted
         *        The current count of documents deleted from the data source during the data source sync.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentsDeleted(String documentsDeleted);

        /**
         * <p>
         * The current count of documents that failed to sync from the data source during the data source sync.
         * </p>
         * 
         * @param documentsFailed
         *        The current count of documents that failed to sync from the data source during the data source sync.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentsFailed(String documentsFailed);

        /**
         * <p>
         * The current count of documents crawled by the ongoing sync job in the data source.
         * </p>
         * 
         * @param documentsScanned
         *        The current count of documents crawled by the ongoing sync job in the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentsScanned(String documentsScanned);
    }

    static final class BuilderImpl implements Builder {
        private String documentsAdded;

        private String documentsModified;

        private String documentsDeleted;

        private String documentsFailed;

        private String documentsScanned;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSourceSyncJobMetrics model) {
            documentsAdded(model.documentsAdded);
            documentsModified(model.documentsModified);
            documentsDeleted(model.documentsDeleted);
            documentsFailed(model.documentsFailed);
            documentsScanned(model.documentsScanned);
        }

        public final String getDocumentsAdded() {
            return documentsAdded;
        }

        public final void setDocumentsAdded(String documentsAdded) {
            this.documentsAdded = documentsAdded;
        }

        @Override
        public final Builder documentsAdded(String documentsAdded) {
            this.documentsAdded = documentsAdded;
            return this;
        }

        public final String getDocumentsModified() {
            return documentsModified;
        }

        public final void setDocumentsModified(String documentsModified) {
            this.documentsModified = documentsModified;
        }

        @Override
        public final Builder documentsModified(String documentsModified) {
            this.documentsModified = documentsModified;
            return this;
        }

        public final String getDocumentsDeleted() {
            return documentsDeleted;
        }

        public final void setDocumentsDeleted(String documentsDeleted) {
            this.documentsDeleted = documentsDeleted;
        }

        @Override
        public final Builder documentsDeleted(String documentsDeleted) {
            this.documentsDeleted = documentsDeleted;
            return this;
        }

        public final String getDocumentsFailed() {
            return documentsFailed;
        }

        public final void setDocumentsFailed(String documentsFailed) {
            this.documentsFailed = documentsFailed;
        }

        @Override
        public final Builder documentsFailed(String documentsFailed) {
            this.documentsFailed = documentsFailed;
            return this;
        }

        public final String getDocumentsScanned() {
            return documentsScanned;
        }

        public final void setDocumentsScanned(String documentsScanned) {
            this.documentsScanned = documentsScanned;
        }

        @Override
        public final Builder documentsScanned(String documentsScanned) {
            this.documentsScanned = documentsScanned;
            return this;
        }

        @Override
        public DataSourceSyncJobMetrics build() {
            return new DataSourceSyncJobMetrics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
