/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A set of instructions that define how Amazon Q Business should generate and format responses to user queries. This
 * collection includes parameters for controlling response characteristics such as length, audience targeting,
 * perspective, style, identity, tone, and custom instructions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstructionCollection implements SdkPojo, Serializable,
        ToCopyableBuilder<InstructionCollection.Builder, InstructionCollection> {
    private static final SdkField<String> RESPONSE_LENGTH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("responseLength").getter(getter(InstructionCollection::responseLength))
            .setter(setter(Builder::responseLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseLength").build()).build();

    private static final SdkField<String> TARGET_AUDIENCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetAudience").getter(getter(InstructionCollection::targetAudience))
            .setter(setter(Builder::targetAudience))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetAudience").build()).build();

    private static final SdkField<String> PERSPECTIVE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("perspective").getter(getter(InstructionCollection::perspective)).setter(setter(Builder::perspective))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("perspective").build()).build();

    private static final SdkField<String> OUTPUT_STYLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("outputStyle").getter(getter(InstructionCollection::outputStyle)).setter(setter(Builder::outputStyle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputStyle").build()).build();

    private static final SdkField<String> IDENTITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identity").getter(getter(InstructionCollection::identity)).setter(setter(Builder::identity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identity").build()).build();

    private static final SdkField<String> TONE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("tone")
            .getter(getter(InstructionCollection::tone)).setter(setter(Builder::tone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tone").build()).build();

    private static final SdkField<String> CUSTOM_INSTRUCTIONS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customInstructions").getter(getter(InstructionCollection::customInstructions))
            .setter(setter(Builder::customInstructions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customInstructions").build())
            .build();

    private static final SdkField<String> EXAMPLES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("examples").getter(getter(InstructionCollection::examples)).setter(setter(Builder::examples))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("examples").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESPONSE_LENGTH_FIELD,
            TARGET_AUDIENCE_FIELD, PERSPECTIVE_FIELD, OUTPUT_STYLE_FIELD, IDENTITY_FIELD, TONE_FIELD, CUSTOM_INSTRUCTIONS_FIELD,
            EXAMPLES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String responseLength;

    private final String targetAudience;

    private final String perspective;

    private final String outputStyle;

    private final String identity;

    private final String tone;

    private final String customInstructions;

    private final String examples;

    private InstructionCollection(BuilderImpl builder) {
        this.responseLength = builder.responseLength;
        this.targetAudience = builder.targetAudience;
        this.perspective = builder.perspective;
        this.outputStyle = builder.outputStyle;
        this.identity = builder.identity;
        this.tone = builder.tone;
        this.customInstructions = builder.customInstructions;
        this.examples = builder.examples;
    }

    /**
     * <p>
     * Specifies the desired length of responses generated by Amazon Q Business. This parameter allows administrators to
     * control whether responses are concise and brief or more detailed and comprehensive.
     * </p>
     * 
     * @return Specifies the desired length of responses generated by Amazon Q Business. This parameter allows
     *         administrators to control whether responses are concise and brief or more detailed and comprehensive.
     */
    public final String responseLength() {
        return responseLength;
    }

    /**
     * <p>
     * Defines the intended audience for the responses, allowing Amazon Q Business to tailor its language, terminology,
     * and explanations appropriately. This could range from technical experts to general users with varying levels of
     * domain knowledge.
     * </p>
     * 
     * @return Defines the intended audience for the responses, allowing Amazon Q Business to tailor its language,
     *         terminology, and explanations appropriately. This could range from technical experts to general users
     *         with varying levels of domain knowledge.
     */
    public final String targetAudience() {
        return targetAudience;
    }

    /**
     * <p>
     * Determines the point of view or perspective from which Amazon Q Business generates responses, such as
     * first-person, second-person, or third-person perspective, affecting how information is presented to users.
     * </p>
     * 
     * @return Determines the point of view or perspective from which Amazon Q Business generates responses, such as
     *         first-person, second-person, or third-person perspective, affecting how information is presented to
     *         users.
     */
    public final String perspective() {
        return perspective;
    }

    /**
     * <p>
     * Specifies the formatting and structural style of responses, such as bullet points, paragraphs, step-by-step
     * instructions, or other organizational formats that enhance readability and comprehension.
     * </p>
     * 
     * @return Specifies the formatting and structural style of responses, such as bullet points, paragraphs,
     *         step-by-step instructions, or other organizational formats that enhance readability and comprehension.
     */
    public final String outputStyle() {
        return outputStyle;
    }

    /**
     * <p>
     * Defines the persona or identity that Amazon Q Business should adopt when responding to users, allowing for
     * customization of the assistant's character, role, or representation within an organization.
     * </p>
     * 
     * @return Defines the persona or identity that Amazon Q Business should adopt when responding to users, allowing
     *         for customization of the assistant's character, role, or representation within an organization.
     */
    public final String identity() {
        return identity;
    }

    /**
     * <p>
     * Controls the emotional tone and communication style of responses, such as formal, casual, technical, friendly, or
     * professional, to align with organizational communication standards and user expectations.
     * </p>
     * 
     * @return Controls the emotional tone and communication style of responses, such as formal, casual, technical,
     *         friendly, or professional, to align with organizational communication standards and user expectations.
     */
    public final String tone() {
        return tone;
    }

    /**
     * <p>
     * Allows administrators to provide specific, custom instructions that guide how Amazon Q Business should respond in
     * particular scenarios or to certain types of queries, enabling fine-grained control over response generation.
     * </p>
     * 
     * @return Allows administrators to provide specific, custom instructions that guide how Amazon Q Business should
     *         respond in particular scenarios or to certain types of queries, enabling fine-grained control over
     *         response generation.
     */
    public final String customInstructions() {
        return customInstructions;
    }

    /**
     * <p>
     * Provides sample responses or templates that Amazon Q Business can reference when generating responses, helping to
     * establish consistent patterns and formats for different types of user queries.
     * </p>
     * 
     * @return Provides sample responses or templates that Amazon Q Business can reference when generating responses,
     *         helping to establish consistent patterns and formats for different types of user queries.
     */
    public final String examples() {
        return examples;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(responseLength());
        hashCode = 31 * hashCode + Objects.hashCode(targetAudience());
        hashCode = 31 * hashCode + Objects.hashCode(perspective());
        hashCode = 31 * hashCode + Objects.hashCode(outputStyle());
        hashCode = 31 * hashCode + Objects.hashCode(identity());
        hashCode = 31 * hashCode + Objects.hashCode(tone());
        hashCode = 31 * hashCode + Objects.hashCode(customInstructions());
        hashCode = 31 * hashCode + Objects.hashCode(examples());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstructionCollection)) {
            return false;
        }
        InstructionCollection other = (InstructionCollection) obj;
        return Objects.equals(responseLength(), other.responseLength())
                && Objects.equals(targetAudience(), other.targetAudience()) && Objects.equals(perspective(), other.perspective())
                && Objects.equals(outputStyle(), other.outputStyle()) && Objects.equals(identity(), other.identity())
                && Objects.equals(tone(), other.tone()) && Objects.equals(customInstructions(), other.customInstructions())
                && Objects.equals(examples(), other.examples());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstructionCollection").add("ResponseLength", responseLength())
                .add("TargetAudience", targetAudience()).add("Perspective", perspective()).add("OutputStyle", outputStyle())
                .add("Identity", identity()).add("Tone", tone()).add("CustomInstructions", customInstructions())
                .add("Examples", examples()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "responseLength":
            return Optional.ofNullable(clazz.cast(responseLength()));
        case "targetAudience":
            return Optional.ofNullable(clazz.cast(targetAudience()));
        case "perspective":
            return Optional.ofNullable(clazz.cast(perspective()));
        case "outputStyle":
            return Optional.ofNullable(clazz.cast(outputStyle()));
        case "identity":
            return Optional.ofNullable(clazz.cast(identity()));
        case "tone":
            return Optional.ofNullable(clazz.cast(tone()));
        case "customInstructions":
            return Optional.ofNullable(clazz.cast(customInstructions()));
        case "examples":
            return Optional.ofNullable(clazz.cast(examples()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("responseLength", RESPONSE_LENGTH_FIELD);
        map.put("targetAudience", TARGET_AUDIENCE_FIELD);
        map.put("perspective", PERSPECTIVE_FIELD);
        map.put("outputStyle", OUTPUT_STYLE_FIELD);
        map.put("identity", IDENTITY_FIELD);
        map.put("tone", TONE_FIELD);
        map.put("customInstructions", CUSTOM_INSTRUCTIONS_FIELD);
        map.put("examples", EXAMPLES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstructionCollection, T> g) {
        return obj -> g.apply((InstructionCollection) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstructionCollection> {
        /**
         * <p>
         * Specifies the desired length of responses generated by Amazon Q Business. This parameter allows
         * administrators to control whether responses are concise and brief or more detailed and comprehensive.
         * </p>
         * 
         * @param responseLength
         *        Specifies the desired length of responses generated by Amazon Q Business. This parameter allows
         *        administrators to control whether responses are concise and brief or more detailed and comprehensive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseLength(String responseLength);

        /**
         * <p>
         * Defines the intended audience for the responses, allowing Amazon Q Business to tailor its language,
         * terminology, and explanations appropriately. This could range from technical experts to general users with
         * varying levels of domain knowledge.
         * </p>
         * 
         * @param targetAudience
         *        Defines the intended audience for the responses, allowing Amazon Q Business to tailor its language,
         *        terminology, and explanations appropriately. This could range from technical experts to general users
         *        with varying levels of domain knowledge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetAudience(String targetAudience);

        /**
         * <p>
         * Determines the point of view or perspective from which Amazon Q Business generates responses, such as
         * first-person, second-person, or third-person perspective, affecting how information is presented to users.
         * </p>
         * 
         * @param perspective
         *        Determines the point of view or perspective from which Amazon Q Business generates responses, such as
         *        first-person, second-person, or third-person perspective, affecting how information is presented to
         *        users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder perspective(String perspective);

        /**
         * <p>
         * Specifies the formatting and structural style of responses, such as bullet points, paragraphs, step-by-step
         * instructions, or other organizational formats that enhance readability and comprehension.
         * </p>
         * 
         * @param outputStyle
         *        Specifies the formatting and structural style of responses, such as bullet points, paragraphs,
         *        step-by-step instructions, or other organizational formats that enhance readability and comprehension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputStyle(String outputStyle);

        /**
         * <p>
         * Defines the persona or identity that Amazon Q Business should adopt when responding to users, allowing for
         * customization of the assistant's character, role, or representation within an organization.
         * </p>
         * 
         * @param identity
         *        Defines the persona or identity that Amazon Q Business should adopt when responding to users, allowing
         *        for customization of the assistant's character, role, or representation within an organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identity(String identity);

        /**
         * <p>
         * Controls the emotional tone and communication style of responses, such as formal, casual, technical,
         * friendly, or professional, to align with organizational communication standards and user expectations.
         * </p>
         * 
         * @param tone
         *        Controls the emotional tone and communication style of responses, such as formal, casual, technical,
         *        friendly, or professional, to align with organizational communication standards and user expectations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tone(String tone);

        /**
         * <p>
         * Allows administrators to provide specific, custom instructions that guide how Amazon Q Business should
         * respond in particular scenarios or to certain types of queries, enabling fine-grained control over response
         * generation.
         * </p>
         * 
         * @param customInstructions
         *        Allows administrators to provide specific, custom instructions that guide how Amazon Q Business should
         *        respond in particular scenarios or to certain types of queries, enabling fine-grained control over
         *        response generation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customInstructions(String customInstructions);

        /**
         * <p>
         * Provides sample responses or templates that Amazon Q Business can reference when generating responses,
         * helping to establish consistent patterns and formats for different types of user queries.
         * </p>
         * 
         * @param examples
         *        Provides sample responses or templates that Amazon Q Business can reference when generating responses,
         *        helping to establish consistent patterns and formats for different types of user queries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder examples(String examples);
    }

    static final class BuilderImpl implements Builder {
        private String responseLength;

        private String targetAudience;

        private String perspective;

        private String outputStyle;

        private String identity;

        private String tone;

        private String customInstructions;

        private String examples;

        private BuilderImpl() {
        }

        private BuilderImpl(InstructionCollection model) {
            responseLength(model.responseLength);
            targetAudience(model.targetAudience);
            perspective(model.perspective);
            outputStyle(model.outputStyle);
            identity(model.identity);
            tone(model.tone);
            customInstructions(model.customInstructions);
            examples(model.examples);
        }

        public final String getResponseLength() {
            return responseLength;
        }

        public final void setResponseLength(String responseLength) {
            this.responseLength = responseLength;
        }

        @Override
        public final Builder responseLength(String responseLength) {
            this.responseLength = responseLength;
            return this;
        }

        public final String getTargetAudience() {
            return targetAudience;
        }

        public final void setTargetAudience(String targetAudience) {
            this.targetAudience = targetAudience;
        }

        @Override
        public final Builder targetAudience(String targetAudience) {
            this.targetAudience = targetAudience;
            return this;
        }

        public final String getPerspective() {
            return perspective;
        }

        public final void setPerspective(String perspective) {
            this.perspective = perspective;
        }

        @Override
        public final Builder perspective(String perspective) {
            this.perspective = perspective;
            return this;
        }

        public final String getOutputStyle() {
            return outputStyle;
        }

        public final void setOutputStyle(String outputStyle) {
            this.outputStyle = outputStyle;
        }

        @Override
        public final Builder outputStyle(String outputStyle) {
            this.outputStyle = outputStyle;
            return this;
        }

        public final String getIdentity() {
            return identity;
        }

        public final void setIdentity(String identity) {
            this.identity = identity;
        }

        @Override
        public final Builder identity(String identity) {
            this.identity = identity;
            return this;
        }

        public final String getTone() {
            return tone;
        }

        public final void setTone(String tone) {
            this.tone = tone;
        }

        @Override
        public final Builder tone(String tone) {
            this.tone = tone;
            return this;
        }

        public final String getCustomInstructions() {
            return customInstructions;
        }

        public final void setCustomInstructions(String customInstructions) {
            this.customInstructions = customInstructions;
        }

        @Override
        public final Builder customInstructions(String customInstructions) {
            this.customInstructions = customInstructions;
            return this;
        }

        public final String getExamples() {
            return examples;
        }

        public final void setExamples(String examples) {
            this.examples = examples;
        }

        @Override
        public final Builder examples(String examples) {
            this.examples = examples;
            return this;
        }

        @Override
        public InstructionCollection build() {
            return new InstructionCollection(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
