/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListIndicesResponse extends QBusinessResponse implements
        ToCopyableBuilder<ListIndicesResponse.Builder, ListIndicesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListIndicesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<Index>> INDICES_FIELD = SdkField
            .<List<Index>> builder(MarshallingType.LIST)
            .memberName("indices")
            .getter(getter(ListIndicesResponse::indices))
            .setter(setter(Builder::indices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indices").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Index> builder(MarshallingType.SDK_POJO)
                                            .constructor(Index::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            INDICES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<Index> indices;

    private ListIndicesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.indices = builder.indices;
    }

    /**
     * <p>
     * If the response is truncated, Amazon Q Business returns this token that you can use in the subsequent request to
     * retrieve the next set of indexes.
     * </p>
     * 
     * @return If the response is truncated, Amazon Q Business returns this token that you can use in the subsequent
     *         request to retrieve the next set of indexes.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Indices property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasIndices() {
        return indices != null && !(indices instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of information on the items in one or more indexes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIndices} method.
     * </p>
     * 
     * @return An array of information on the items in one or more indexes.
     */
    public final List<Index> indices() {
        return indices;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasIndices() ? indices() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIndicesResponse)) {
            return false;
        }
        ListIndicesResponse other = (ListIndicesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasIndices() == other.hasIndices()
                && Objects.equals(indices(), other.indices());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListIndicesResponse").add("NextToken", nextToken())
                .add("Indices", hasIndices() ? indices() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "indices":
            return Optional.ofNullable(clazz.cast(indices()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("indices", INDICES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListIndicesResponse, T> g) {
        return obj -> g.apply((ListIndicesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QBusinessResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListIndicesResponse> {
        /**
         * <p>
         * If the response is truncated, Amazon Q Business returns this token that you can use in the subsequent request
         * to retrieve the next set of indexes.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, Amazon Q Business returns this token that you can use in the subsequent
         *        request to retrieve the next set of indexes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * An array of information on the items in one or more indexes.
         * </p>
         * 
         * @param indices
         *        An array of information on the items in one or more indexes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indices(Collection<Index> indices);

        /**
         * <p>
         * An array of information on the items in one or more indexes.
         * </p>
         * 
         * @param indices
         *        An array of information on the items in one or more indexes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indices(Index... indices);

        /**
         * <p>
         * An array of information on the items in one or more indexes.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qbusiness.model.Index.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.qbusiness.model.Index#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qbusiness.model.Index.Builder#build()} is called immediately and its
         * result is passed to {@link #indices(List<Index>)}.
         * 
         * @param indices
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qbusiness.model.Index.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #indices(java.util.Collection<Index>)
         */
        Builder indices(Consumer<Index.Builder>... indices);
    }

    static final class BuilderImpl extends QBusinessResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<Index> indices = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListIndicesResponse model) {
            super(model);
            nextToken(model.nextToken);
            indices(model.indices);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<Index.Builder> getIndices() {
            List<Index.Builder> result = IndicesCopier.copyToBuilder(this.indices);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIndices(Collection<Index.BuilderImpl> indices) {
            this.indices = IndicesCopier.copyFromBuilder(indices);
        }

        @Override
        public final Builder indices(Collection<Index> indices) {
            this.indices = IndicesCopier.copy(indices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder indices(Index... indices) {
            indices(Arrays.asList(indices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder indices(Consumer<Index.Builder>... indices) {
            indices(Stream.of(indices).map(c -> Index.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListIndicesResponse build() {
            return new ListIndicesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
