/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration settings to define how Amazon Q Business generates and formats responses to user queries. This includes
 * customization options for response style, tone, length, and other characteristics.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResponseConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ResponseConfiguration.Builder, ResponseConfiguration> {
    private static final SdkField<InstructionCollection> INSTRUCTION_COLLECTION_FIELD = SdkField
            .<InstructionCollection> builder(MarshallingType.SDK_POJO).memberName("instructionCollection")
            .getter(getter(ResponseConfiguration::instructionCollection)).setter(setter(Builder::instructionCollection))
            .constructor(InstructionCollection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instructionCollection").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTRUCTION_COLLECTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final InstructionCollection instructionCollection;

    private ResponseConfiguration(BuilderImpl builder) {
        this.instructionCollection = builder.instructionCollection;
    }

    /**
     * <p>
     * A collection of instructions that guide how Amazon Q Business generates responses, including parameters for
     * response length, target audience, perspective, output style, identity, tone, and custom instructions.
     * </p>
     * 
     * @return A collection of instructions that guide how Amazon Q Business generates responses, including parameters
     *         for response length, target audience, perspective, output style, identity, tone, and custom instructions.
     */
    public final InstructionCollection instructionCollection() {
        return instructionCollection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instructionCollection());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResponseConfiguration)) {
            return false;
        }
        ResponseConfiguration other = (ResponseConfiguration) obj;
        return Objects.equals(instructionCollection(), other.instructionCollection());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResponseConfiguration").add("InstructionCollection", instructionCollection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "instructionCollection":
            return Optional.ofNullable(clazz.cast(instructionCollection()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("instructionCollection", INSTRUCTION_COLLECTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResponseConfiguration, T> g) {
        return obj -> g.apply((ResponseConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResponseConfiguration> {
        /**
         * <p>
         * A collection of instructions that guide how Amazon Q Business generates responses, including parameters for
         * response length, target audience, perspective, output style, identity, tone, and custom instructions.
         * </p>
         * 
         * @param instructionCollection
         *        A collection of instructions that guide how Amazon Q Business generates responses, including
         *        parameters for response length, target audience, perspective, output style, identity, tone, and custom
         *        instructions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instructionCollection(InstructionCollection instructionCollection);

        /**
         * <p>
         * A collection of instructions that guide how Amazon Q Business generates responses, including parameters for
         * response length, target audience, perspective, output style, identity, tone, and custom instructions.
         * </p>
         * This is a convenience method that creates an instance of the {@link InstructionCollection.Builder} avoiding
         * the need to create one manually via {@link InstructionCollection#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstructionCollection.Builder#build()} is called immediately and
         * its result is passed to {@link #instructionCollection(InstructionCollection)}.
         * 
         * @param instructionCollection
         *        a consumer that will call methods on {@link InstructionCollection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instructionCollection(InstructionCollection)
         */
        default Builder instructionCollection(Consumer<InstructionCollection.Builder> instructionCollection) {
            return instructionCollection(InstructionCollection.builder().applyMutation(instructionCollection).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private InstructionCollection instructionCollection;

        private BuilderImpl() {
        }

        private BuilderImpl(ResponseConfiguration model) {
            instructionCollection(model.instructionCollection);
        }

        public final InstructionCollection.Builder getInstructionCollection() {
            return instructionCollection != null ? instructionCollection.toBuilder() : null;
        }

        public final void setInstructionCollection(InstructionCollection.BuilderImpl instructionCollection) {
            this.instructionCollection = instructionCollection != null ? instructionCollection.build() : null;
        }

        @Override
        public final Builder instructionCollection(InstructionCollection instructionCollection) {
            this.instructionCollection = instructionCollection;
            return this;
        }

        @Override
        public ResponseConfiguration build() {
            return new ResponseConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
