/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The documents used to generate an Amazon Q Business web experience response.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SourceAttribution implements SdkPojo, Serializable,
        ToCopyableBuilder<SourceAttribution.Builder, SourceAttribution> {
    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("title")
            .getter(getter(SourceAttribution::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()).build();

    private static final SdkField<String> SNIPPET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("snippet")
            .getter(getter(SourceAttribution::snippet)).setter(setter(Builder::snippet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snippet").build()).build();

    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("url")
            .getter(getter(SourceAttribution::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()).build();

    private static final SdkField<Integer> CITATION_NUMBER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("citationNumber").getter(getter(SourceAttribution::citationNumber))
            .setter(setter(Builder::citationNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("citationNumber").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt").getter(getter(SourceAttribution::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final SdkField<List<TextSegment>> TEXT_MESSAGE_SEGMENTS_FIELD = SdkField
            .<List<TextSegment>> builder(MarshallingType.LIST)
            .memberName("textMessageSegments")
            .getter(getter(SourceAttribution::textMessageSegments))
            .setter(setter(Builder::textMessageSegments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("textMessageSegments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TextSegment> builder(MarshallingType.SDK_POJO)
                                            .constructor(TextSegment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DOCUMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("documentId").getter(getter(SourceAttribution::documentId)).setter(setter(Builder::documentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentId").build()).build();

    private static final SdkField<String> INDEX_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("indexId").getter(getter(SourceAttribution::indexId)).setter(setter(Builder::indexId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexId").build()).build();

    private static final SdkField<String> DATASOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datasourceId").getter(getter(SourceAttribution::datasourceId)).setter(setter(Builder::datasourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasourceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TITLE_FIELD, SNIPPET_FIELD,
            URL_FIELD, CITATION_NUMBER_FIELD, UPDATED_AT_FIELD, TEXT_MESSAGE_SEGMENTS_FIELD, DOCUMENT_ID_FIELD, INDEX_ID_FIELD,
            DATASOURCE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String title;

    private final String snippet;

    private final String url;

    private final Integer citationNumber;

    private final Instant updatedAt;

    private final List<TextSegment> textMessageSegments;

    private final String documentId;

    private final String indexId;

    private final String datasourceId;

    private SourceAttribution(BuilderImpl builder) {
        this.title = builder.title;
        this.snippet = builder.snippet;
        this.url = builder.url;
        this.citationNumber = builder.citationNumber;
        this.updatedAt = builder.updatedAt;
        this.textMessageSegments = builder.textMessageSegments;
        this.documentId = builder.documentId;
        this.indexId = builder.indexId;
        this.datasourceId = builder.datasourceId;
    }

    /**
     * <p>
     * The title of the document which is the source for the Amazon Q Business generated response.
     * </p>
     * 
     * @return The title of the document which is the source for the Amazon Q Business generated response.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * The content extract from the document on which the generated response is based.
     * </p>
     * 
     * @return The content extract from the document on which the generated response is based.
     */
    public final String snippet() {
        return snippet;
    }

    /**
     * <p>
     * The URL of the document which is the source for the Amazon Q Business generated response.
     * </p>
     * 
     * @return The URL of the document which is the source for the Amazon Q Business generated response.
     */
    public final String url() {
        return url;
    }

    /**
     * <p>
     * The number attached to a citation in an Amazon Q Business generated response.
     * </p>
     * 
     * @return The number attached to a citation in an Amazon Q Business generated response.
     */
    public final Integer citationNumber() {
        return citationNumber;
    }

    /**
     * <p>
     * The Unix timestamp when the Amazon Q Business application was last updated.
     * </p>
     * 
     * @return The Unix timestamp when the Amazon Q Business application was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the TextMessageSegments property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTextMessageSegments() {
        return textMessageSegments != null && !(textMessageSegments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A text extract from a source document that is used for source attribution.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTextMessageSegments} method.
     * </p>
     * 
     * @return A text extract from a source document that is used for source attribution.
     */
    public final List<TextSegment> textMessageSegments() {
        return textMessageSegments;
    }

    /**
     * <p>
     * The unique identifier of the source document used in the citation, obtained from the Amazon Q Business index
     * during chat response generation. This ID is used as input to the <code>GetDocumentContent</code> API to retrieve
     * the actual document content for user verification.
     * </p>
     * 
     * @return The unique identifier of the source document used in the citation, obtained from the Amazon Q Business
     *         index during chat response generation. This ID is used as input to the <code>GetDocumentContent</code>
     *         API to retrieve the actual document content for user verification.
     */
    public final String documentId() {
        return documentId;
    }

    /**
     * <p>
     * The identifier of the index containing the source document's metadata and access control information. This links
     * the citation back to the specific Amazon Q Business index where the document's searchable content and permissions
     * are stored.
     * </p>
     * 
     * @return The identifier of the index containing the source document's metadata and access control information.
     *         This links the citation back to the specific Amazon Q Business index where the document's searchable
     *         content and permissions are stored.
     */
    public final String indexId() {
        return indexId;
    }

    /**
     * <p>
     * The identifier of the data source from which the document was ingested. This field is not present if the document
     * is ingested by directly calling the BatchPutDocument API (similar to checkDocumentAccess). If the document is
     * from a file-upload data source, the datasource will be "uploaded-docs-file-stat-datasourceid".
     * </p>
     * 
     * @return The identifier of the data source from which the document was ingested. This field is not present if the
     *         document is ingested by directly calling the BatchPutDocument API (similar to checkDocumentAccess). If
     *         the document is from a file-upload data source, the datasource will be
     *         "uploaded-docs-file-stat-datasourceid".
     */
    public final String datasourceId() {
        return datasourceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(snippet());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        hashCode = 31 * hashCode + Objects.hashCode(citationNumber());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasTextMessageSegments() ? textMessageSegments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(documentId());
        hashCode = 31 * hashCode + Objects.hashCode(indexId());
        hashCode = 31 * hashCode + Objects.hashCode(datasourceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceAttribution)) {
            return false;
        }
        SourceAttribution other = (SourceAttribution) obj;
        return Objects.equals(title(), other.title()) && Objects.equals(snippet(), other.snippet())
                && Objects.equals(url(), other.url()) && Objects.equals(citationNumber(), other.citationNumber())
                && Objects.equals(updatedAt(), other.updatedAt()) && hasTextMessageSegments() == other.hasTextMessageSegments()
                && Objects.equals(textMessageSegments(), other.textMessageSegments())
                && Objects.equals(documentId(), other.documentId()) && Objects.equals(indexId(), other.indexId())
                && Objects.equals(datasourceId(), other.datasourceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SourceAttribution").add("Title", title()).add("Snippet", snippet()).add("Url", url())
                .add("CitationNumber", citationNumber()).add("UpdatedAt", updatedAt())
                .add("TextMessageSegments", hasTextMessageSegments() ? textMessageSegments() : null)
                .add("DocumentId", documentId()).add("IndexId", indexId()).add("DatasourceId", datasourceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "title":
            return Optional.ofNullable(clazz.cast(title()));
        case "snippet":
            return Optional.ofNullable(clazz.cast(snippet()));
        case "url":
            return Optional.ofNullable(clazz.cast(url()));
        case "citationNumber":
            return Optional.ofNullable(clazz.cast(citationNumber()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "textMessageSegments":
            return Optional.ofNullable(clazz.cast(textMessageSegments()));
        case "documentId":
            return Optional.ofNullable(clazz.cast(documentId()));
        case "indexId":
            return Optional.ofNullable(clazz.cast(indexId()));
        case "datasourceId":
            return Optional.ofNullable(clazz.cast(datasourceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("title", TITLE_FIELD);
        map.put("snippet", SNIPPET_FIELD);
        map.put("url", URL_FIELD);
        map.put("citationNumber", CITATION_NUMBER_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("textMessageSegments", TEXT_MESSAGE_SEGMENTS_FIELD);
        map.put("documentId", DOCUMENT_ID_FIELD);
        map.put("indexId", INDEX_ID_FIELD);
        map.put("datasourceId", DATASOURCE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SourceAttribution, T> g) {
        return obj -> g.apply((SourceAttribution) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SourceAttribution> {
        /**
         * <p>
         * The title of the document which is the source for the Amazon Q Business generated response.
         * </p>
         * 
         * @param title
         *        The title of the document which is the source for the Amazon Q Business generated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * The content extract from the document on which the generated response is based.
         * </p>
         * 
         * @param snippet
         *        The content extract from the document on which the generated response is based.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snippet(String snippet);

        /**
         * <p>
         * The URL of the document which is the source for the Amazon Q Business generated response.
         * </p>
         * 
         * @param url
         *        The URL of the document which is the source for the Amazon Q Business generated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);

        /**
         * <p>
         * The number attached to a citation in an Amazon Q Business generated response.
         * </p>
         * 
         * @param citationNumber
         *        The number attached to a citation in an Amazon Q Business generated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder citationNumber(Integer citationNumber);

        /**
         * <p>
         * The Unix timestamp when the Amazon Q Business application was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The Unix timestamp when the Amazon Q Business application was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * A text extract from a source document that is used for source attribution.
         * </p>
         * 
         * @param textMessageSegments
         *        A text extract from a source document that is used for source attribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textMessageSegments(Collection<TextSegment> textMessageSegments);

        /**
         * <p>
         * A text extract from a source document that is used for source attribution.
         * </p>
         * 
         * @param textMessageSegments
         *        A text extract from a source document that is used for source attribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textMessageSegments(TextSegment... textMessageSegments);

        /**
         * <p>
         * A text extract from a source document that is used for source attribution.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qbusiness.model.TextSegment.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.qbusiness.model.TextSegment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qbusiness.model.TextSegment.Builder#build()} is called immediately and
         * its result is passed to {@link #textMessageSegments(List<TextSegment>)}.
         * 
         * @param textMessageSegments
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qbusiness.model.TextSegment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #textMessageSegments(java.util.Collection<TextSegment>)
         */
        Builder textMessageSegments(Consumer<TextSegment.Builder>... textMessageSegments);

        /**
         * <p>
         * The unique identifier of the source document used in the citation, obtained from the Amazon Q Business index
         * during chat response generation. This ID is used as input to the <code>GetDocumentContent</code> API to
         * retrieve the actual document content for user verification.
         * </p>
         * 
         * @param documentId
         *        The unique identifier of the source document used in the citation, obtained from the Amazon Q Business
         *        index during chat response generation. This ID is used as input to the <code>GetDocumentContent</code>
         *        API to retrieve the actual document content for user verification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentId(String documentId);

        /**
         * <p>
         * The identifier of the index containing the source document's metadata and access control information. This
         * links the citation back to the specific Amazon Q Business index where the document's searchable content and
         * permissions are stored.
         * </p>
         * 
         * @param indexId
         *        The identifier of the index containing the source document's metadata and access control information.
         *        This links the citation back to the specific Amazon Q Business index where the document's searchable
         *        content and permissions are stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexId(String indexId);

        /**
         * <p>
         * The identifier of the data source from which the document was ingested. This field is not present if the
         * document is ingested by directly calling the BatchPutDocument API (similar to checkDocumentAccess). If the
         * document is from a file-upload data source, the datasource will be "uploaded-docs-file-stat-datasourceid".
         * </p>
         * 
         * @param datasourceId
         *        The identifier of the data source from which the document was ingested. This field is not present if
         *        the document is ingested by directly calling the BatchPutDocument API (similar to
         *        checkDocumentAccess). If the document is from a file-upload data source, the datasource will be
         *        "uploaded-docs-file-stat-datasourceid".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasourceId(String datasourceId);
    }

    static final class BuilderImpl implements Builder {
        private String title;

        private String snippet;

        private String url;

        private Integer citationNumber;

        private Instant updatedAt;

        private List<TextSegment> textMessageSegments = DefaultSdkAutoConstructList.getInstance();

        private String documentId;

        private String indexId;

        private String datasourceId;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceAttribution model) {
            title(model.title);
            snippet(model.snippet);
            url(model.url);
            citationNumber(model.citationNumber);
            updatedAt(model.updatedAt);
            textMessageSegments(model.textMessageSegments);
            documentId(model.documentId);
            indexId(model.indexId);
            datasourceId(model.datasourceId);
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getSnippet() {
            return snippet;
        }

        public final void setSnippet(String snippet) {
            this.snippet = snippet;
        }

        @Override
        public final Builder snippet(String snippet) {
            this.snippet = snippet;
            return this;
        }

        public final String getUrl() {
            return url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final Integer getCitationNumber() {
            return citationNumber;
        }

        public final void setCitationNumber(Integer citationNumber) {
            this.citationNumber = citationNumber;
        }

        @Override
        public final Builder citationNumber(Integer citationNumber) {
            this.citationNumber = citationNumber;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final List<TextSegment.Builder> getTextMessageSegments() {
            List<TextSegment.Builder> result = TextSegmentListCopier.copyToBuilder(this.textMessageSegments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTextMessageSegments(Collection<TextSegment.BuilderImpl> textMessageSegments) {
            this.textMessageSegments = TextSegmentListCopier.copyFromBuilder(textMessageSegments);
        }

        @Override
        public final Builder textMessageSegments(Collection<TextSegment> textMessageSegments) {
            this.textMessageSegments = TextSegmentListCopier.copy(textMessageSegments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder textMessageSegments(TextSegment... textMessageSegments) {
            textMessageSegments(Arrays.asList(textMessageSegments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder textMessageSegments(Consumer<TextSegment.Builder>... textMessageSegments) {
            textMessageSegments(Stream.of(textMessageSegments).map(c -> TextSegment.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getDocumentId() {
            return documentId;
        }

        public final void setDocumentId(String documentId) {
            this.documentId = documentId;
        }

        @Override
        public final Builder documentId(String documentId) {
            this.documentId = documentId;
            return this;
        }

        public final String getIndexId() {
            return indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final String getDatasourceId() {
            return datasourceId;
        }

        public final void setDatasourceId(String datasourceId) {
            this.datasourceId = datasourceId;
        }

        @Override
        public final Builder datasourceId(String datasourceId) {
            this.datasourceId = datasourceId;
            return this;
        }

        @Override
        public SourceAttribution build() {
            return new SourceAttribution(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
