/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an Amazon Q Business subscription.
 * </p>
 * <p>
 * Subscriptions are used to provide access for an IAM Identity Center user or a group to an Amazon Q Business
 * application.
 * </p>
 * <p>
 * Amazon Q Business offers two subscription tiers: <code>Q_LITE</code> and <code>Q_BUSINESS</code>. Subscription tier
 * determines feature access for the user. For more information on subscriptions and pricing tiers, see <a
 * href="https://aws.amazon.com/q/business/pricing/">Amazon Q Business pricing</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Subscription implements SdkPojo, Serializable, ToCopyableBuilder<Subscription.Builder, Subscription> {
    private static final SdkField<String> SUBSCRIPTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("subscriptionId").getter(getter(Subscription::subscriptionId)).setter(setter(Builder::subscriptionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscriptionId").build()).build();

    private static final SdkField<String> SUBSCRIPTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("subscriptionArn").getter(getter(Subscription::subscriptionArn)).setter(setter(Builder::subscriptionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscriptionArn").build()).build();

    private static final SdkField<SubscriptionPrincipal> PRINCIPAL_FIELD = SdkField
            .<SubscriptionPrincipal> builder(MarshallingType.SDK_POJO).memberName("principal")
            .getter(getter(Subscription::principal)).setter(setter(Builder::principal))
            .constructor(SubscriptionPrincipal::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principal").build()).build();

    private static final SdkField<SubscriptionDetails> CURRENT_SUBSCRIPTION_FIELD = SdkField
            .<SubscriptionDetails> builder(MarshallingType.SDK_POJO).memberName("currentSubscription")
            .getter(getter(Subscription::currentSubscription)).setter(setter(Builder::currentSubscription))
            .constructor(SubscriptionDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentSubscription").build())
            .build();

    private static final SdkField<SubscriptionDetails> NEXT_SUBSCRIPTION_FIELD = SdkField
            .<SubscriptionDetails> builder(MarshallingType.SDK_POJO).memberName("nextSubscription")
            .getter(getter(Subscription::nextSubscription)).setter(setter(Builder::nextSubscription))
            .constructor(SubscriptionDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextSubscription").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBSCRIPTION_ID_FIELD,
            SUBSCRIPTION_ARN_FIELD, PRINCIPAL_FIELD, CURRENT_SUBSCRIPTION_FIELD, NEXT_SUBSCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String subscriptionId;

    private final String subscriptionArn;

    private final SubscriptionPrincipal principal;

    private final SubscriptionDetails currentSubscription;

    private final SubscriptionDetails nextSubscription;

    private Subscription(BuilderImpl builder) {
        this.subscriptionId = builder.subscriptionId;
        this.subscriptionArn = builder.subscriptionArn;
        this.principal = builder.principal;
        this.currentSubscription = builder.currentSubscription;
        this.nextSubscription = builder.nextSubscription;
    }

    /**
     * <p>
     * The identifier of the Amazon Q Business subscription to be updated.
     * </p>
     * 
     * @return The identifier of the Amazon Q Business subscription to be updated.
     */
    public final String subscriptionId() {
        return subscriptionId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Q Business subscription that was updated.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Q Business subscription that was updated.
     */
    public final String subscriptionArn() {
        return subscriptionArn;
    }

    /**
     * <p>
     * The IAM Identity Center <code>UserId</code> or <code>GroupId</code> of a user or group in the IAM Identity Center
     * instance connected to the Amazon Q Business application.
     * </p>
     * 
     * @return The IAM Identity Center <code>UserId</code> or <code>GroupId</code> of a user or group in the IAM
     *         Identity Center instance connected to the Amazon Q Business application.
     */
    public final SubscriptionPrincipal principal() {
        return principal;
    }

    /**
     * <p>
     * The type of your current Amazon Q Business subscription.
     * </p>
     * 
     * @return The type of your current Amazon Q Business subscription.
     */
    public final SubscriptionDetails currentSubscription() {
        return currentSubscription;
    }

    /**
     * <p>
     * The type of the Amazon Q Business subscription for the next month.
     * </p>
     * 
     * @return The type of the Amazon Q Business subscription for the next month.
     */
    public final SubscriptionDetails nextSubscription() {
        return nextSubscription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(subscriptionId());
        hashCode = 31 * hashCode + Objects.hashCode(subscriptionArn());
        hashCode = 31 * hashCode + Objects.hashCode(principal());
        hashCode = 31 * hashCode + Objects.hashCode(currentSubscription());
        hashCode = 31 * hashCode + Objects.hashCode(nextSubscription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Subscription)) {
            return false;
        }
        Subscription other = (Subscription) obj;
        return Objects.equals(subscriptionId(), other.subscriptionId())
                && Objects.equals(subscriptionArn(), other.subscriptionArn()) && Objects.equals(principal(), other.principal())
                && Objects.equals(currentSubscription(), other.currentSubscription())
                && Objects.equals(nextSubscription(), other.nextSubscription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Subscription").add("SubscriptionId", subscriptionId()).add("SubscriptionArn", subscriptionArn())
                .add("Principal", principal()).add("CurrentSubscription", currentSubscription())
                .add("NextSubscription", nextSubscription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "subscriptionId":
            return Optional.ofNullable(clazz.cast(subscriptionId()));
        case "subscriptionArn":
            return Optional.ofNullable(clazz.cast(subscriptionArn()));
        case "principal":
            return Optional.ofNullable(clazz.cast(principal()));
        case "currentSubscription":
            return Optional.ofNullable(clazz.cast(currentSubscription()));
        case "nextSubscription":
            return Optional.ofNullable(clazz.cast(nextSubscription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("subscriptionId", SUBSCRIPTION_ID_FIELD);
        map.put("subscriptionArn", SUBSCRIPTION_ARN_FIELD);
        map.put("principal", PRINCIPAL_FIELD);
        map.put("currentSubscription", CURRENT_SUBSCRIPTION_FIELD);
        map.put("nextSubscription", NEXT_SUBSCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Subscription, T> g) {
        return obj -> g.apply((Subscription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Subscription> {
        /**
         * <p>
         * The identifier of the Amazon Q Business subscription to be updated.
         * </p>
         * 
         * @param subscriptionId
         *        The identifier of the Amazon Q Business subscription to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionId(String subscriptionId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon Q Business subscription that was updated.
         * </p>
         * 
         * @param subscriptionArn
         *        The Amazon Resource Name (ARN) of the Amazon Q Business subscription that was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionArn(String subscriptionArn);

        /**
         * <p>
         * The IAM Identity Center <code>UserId</code> or <code>GroupId</code> of a user or group in the IAM Identity
         * Center instance connected to the Amazon Q Business application.
         * </p>
         * 
         * @param principal
         *        The IAM Identity Center <code>UserId</code> or <code>GroupId</code> of a user or group in the IAM
         *        Identity Center instance connected to the Amazon Q Business application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principal(SubscriptionPrincipal principal);

        /**
         * <p>
         * The IAM Identity Center <code>UserId</code> or <code>GroupId</code> of a user or group in the IAM Identity
         * Center instance connected to the Amazon Q Business application.
         * </p>
         * This is a convenience method that creates an instance of the {@link SubscriptionPrincipal.Builder} avoiding
         * the need to create one manually via {@link SubscriptionPrincipal#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SubscriptionPrincipal.Builder#build()} is called immediately and
         * its result is passed to {@link #principal(SubscriptionPrincipal)}.
         * 
         * @param principal
         *        a consumer that will call methods on {@link SubscriptionPrincipal.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #principal(SubscriptionPrincipal)
         */
        default Builder principal(Consumer<SubscriptionPrincipal.Builder> principal) {
            return principal(SubscriptionPrincipal.builder().applyMutation(principal).build());
        }

        /**
         * <p>
         * The type of your current Amazon Q Business subscription.
         * </p>
         * 
         * @param currentSubscription
         *        The type of your current Amazon Q Business subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentSubscription(SubscriptionDetails currentSubscription);

        /**
         * <p>
         * The type of your current Amazon Q Business subscription.
         * </p>
         * This is a convenience method that creates an instance of the {@link SubscriptionDetails.Builder} avoiding the
         * need to create one manually via {@link SubscriptionDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SubscriptionDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #currentSubscription(SubscriptionDetails)}.
         * 
         * @param currentSubscription
         *        a consumer that will call methods on {@link SubscriptionDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #currentSubscription(SubscriptionDetails)
         */
        default Builder currentSubscription(Consumer<SubscriptionDetails.Builder> currentSubscription) {
            return currentSubscription(SubscriptionDetails.builder().applyMutation(currentSubscription).build());
        }

        /**
         * <p>
         * The type of the Amazon Q Business subscription for the next month.
         * </p>
         * 
         * @param nextSubscription
         *        The type of the Amazon Q Business subscription for the next month.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextSubscription(SubscriptionDetails nextSubscription);

        /**
         * <p>
         * The type of the Amazon Q Business subscription for the next month.
         * </p>
         * This is a convenience method that creates an instance of the {@link SubscriptionDetails.Builder} avoiding the
         * need to create one manually via {@link SubscriptionDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SubscriptionDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #nextSubscription(SubscriptionDetails)}.
         * 
         * @param nextSubscription
         *        a consumer that will call methods on {@link SubscriptionDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nextSubscription(SubscriptionDetails)
         */
        default Builder nextSubscription(Consumer<SubscriptionDetails.Builder> nextSubscription) {
            return nextSubscription(SubscriptionDetails.builder().applyMutation(nextSubscription).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String subscriptionId;

        private String subscriptionArn;

        private SubscriptionPrincipal principal;

        private SubscriptionDetails currentSubscription;

        private SubscriptionDetails nextSubscription;

        private BuilderImpl() {
        }

        private BuilderImpl(Subscription model) {
            subscriptionId(model.subscriptionId);
            subscriptionArn(model.subscriptionArn);
            principal(model.principal);
            currentSubscription(model.currentSubscription);
            nextSubscription(model.nextSubscription);
        }

        public final String getSubscriptionId() {
            return subscriptionId;
        }

        public final void setSubscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
        }

        @Override
        public final Builder subscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
            return this;
        }

        public final String getSubscriptionArn() {
            return subscriptionArn;
        }

        public final void setSubscriptionArn(String subscriptionArn) {
            this.subscriptionArn = subscriptionArn;
        }

        @Override
        public final Builder subscriptionArn(String subscriptionArn) {
            this.subscriptionArn = subscriptionArn;
            return this;
        }

        public final SubscriptionPrincipal.Builder getPrincipal() {
            return principal != null ? principal.toBuilder() : null;
        }

        public final void setPrincipal(SubscriptionPrincipal.BuilderImpl principal) {
            this.principal = principal != null ? principal.build() : null;
        }

        @Override
        public final Builder principal(SubscriptionPrincipal principal) {
            this.principal = principal;
            return this;
        }

        public final SubscriptionDetails.Builder getCurrentSubscription() {
            return currentSubscription != null ? currentSubscription.toBuilder() : null;
        }

        public final void setCurrentSubscription(SubscriptionDetails.BuilderImpl currentSubscription) {
            this.currentSubscription = currentSubscription != null ? currentSubscription.build() : null;
        }

        @Override
        public final Builder currentSubscription(SubscriptionDetails currentSubscription) {
            this.currentSubscription = currentSubscription;
            return this;
        }

        public final SubscriptionDetails.Builder getNextSubscription() {
            return nextSubscription != null ? nextSubscription.toBuilder() : null;
        }

        public final void setNextSubscription(SubscriptionDetails.BuilderImpl nextSubscription) {
            this.nextSubscription = nextSubscription != null ? nextSubscription.build() : null;
        }

        @Override
        public final Builder nextSubscription(SubscriptionDetails nextSubscription) {
            this.nextSubscription = nextSubscription;
            return this;
        }

        @Override
        public Subscription build() {
            return new Subscription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
