/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePluginRequest extends QBusinessRequest implements
        ToCopyableBuilder<UpdatePluginRequest.Builder, UpdatePluginRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationId").getter(getter(UpdatePluginRequest::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()).build();

    private static final SdkField<String> PLUGIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pluginId").getter(getter(UpdatePluginRequest::pluginId)).setter(setter(Builder::pluginId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("pluginId").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(UpdatePluginRequest::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("state")
            .getter(getter(UpdatePluginRequest::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<String> SERVER_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serverUrl").getter(getter(UpdatePluginRequest::serverUrl)).setter(setter(Builder::serverUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverUrl").build()).build();

    private static final SdkField<CustomPluginConfiguration> CUSTOM_PLUGIN_CONFIGURATION_FIELD = SdkField
            .<CustomPluginConfiguration> builder(MarshallingType.SDK_POJO).memberName("customPluginConfiguration")
            .getter(getter(UpdatePluginRequest::customPluginConfiguration)).setter(setter(Builder::customPluginConfiguration))
            .constructor(CustomPluginConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customPluginConfiguration").build())
            .build();

    private static final SdkField<PluginAuthConfiguration> AUTH_CONFIGURATION_FIELD = SdkField
            .<PluginAuthConfiguration> builder(MarshallingType.SDK_POJO).memberName("authConfiguration")
            .getter(getter(UpdatePluginRequest::authConfiguration)).setter(setter(Builder::authConfiguration))
            .constructor(PluginAuthConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            PLUGIN_ID_FIELD, DISPLAY_NAME_FIELD, STATE_FIELD, SERVER_URL_FIELD, CUSTOM_PLUGIN_CONFIGURATION_FIELD,
            AUTH_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String applicationId;

    private final String pluginId;

    private final String displayName;

    private final String state;

    private final String serverUrl;

    private final CustomPluginConfiguration customPluginConfiguration;

    private final PluginAuthConfiguration authConfiguration;

    private UpdatePluginRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.pluginId = builder.pluginId;
        this.displayName = builder.displayName;
        this.state = builder.state;
        this.serverUrl = builder.serverUrl;
        this.customPluginConfiguration = builder.customPluginConfiguration;
        this.authConfiguration = builder.authConfiguration;
    }

    /**
     * <p>
     * The identifier of the application the plugin is attached to.
     * </p>
     * 
     * @return The identifier of the application the plugin is attached to.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The identifier of the plugin.
     * </p>
     * 
     * @return The identifier of the plugin.
     */
    public final String pluginId() {
        return pluginId;
    }

    /**
     * <p>
     * The name of the plugin.
     * </p>
     * 
     * @return The name of the plugin.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The status of the plugin.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link PluginState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The status of the plugin.
     * @see PluginState
     */
    public final PluginState state() {
        return PluginState.fromValue(state);
    }

    /**
     * <p>
     * The status of the plugin.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link PluginState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The status of the plugin.
     * @see PluginState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The source URL used for plugin configuration.
     * </p>
     * 
     * @return The source URL used for plugin configuration.
     */
    public final String serverUrl() {
        return serverUrl;
    }

    /**
     * <p>
     * The configuration for a custom plugin.
     * </p>
     * 
     * @return The configuration for a custom plugin.
     */
    public final CustomPluginConfiguration customPluginConfiguration() {
        return customPluginConfiguration;
    }

    /**
     * <p>
     * The authentication configuration the plugin is using.
     * </p>
     * 
     * @return The authentication configuration the plugin is using.
     */
    public final PluginAuthConfiguration authConfiguration() {
        return authConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(pluginId());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(serverUrl());
        hashCode = 31 * hashCode + Objects.hashCode(customPluginConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(authConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePluginRequest)) {
            return false;
        }
        UpdatePluginRequest other = (UpdatePluginRequest) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(pluginId(), other.pluginId())
                && Objects.equals(displayName(), other.displayName()) && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(serverUrl(), other.serverUrl())
                && Objects.equals(customPluginConfiguration(), other.customPluginConfiguration())
                && Objects.equals(authConfiguration(), other.authConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdatePluginRequest").add("ApplicationId", applicationId()).add("PluginId", pluginId())
                .add("DisplayName", displayName()).add("State", stateAsString()).add("ServerUrl", serverUrl())
                .add("CustomPluginConfiguration", customPluginConfiguration()).add("AuthConfiguration", authConfiguration())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "pluginId":
            return Optional.ofNullable(clazz.cast(pluginId()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "state":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "serverUrl":
            return Optional.ofNullable(clazz.cast(serverUrl()));
        case "customPluginConfiguration":
            return Optional.ofNullable(clazz.cast(customPluginConfiguration()));
        case "authConfiguration":
            return Optional.ofNullable(clazz.cast(authConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("applicationId", APPLICATION_ID_FIELD);
        map.put("pluginId", PLUGIN_ID_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("state", STATE_FIELD);
        map.put("serverUrl", SERVER_URL_FIELD);
        map.put("customPluginConfiguration", CUSTOM_PLUGIN_CONFIGURATION_FIELD);
        map.put("authConfiguration", AUTH_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdatePluginRequest, T> g) {
        return obj -> g.apply((UpdatePluginRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QBusinessRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdatePluginRequest> {
        /**
         * <p>
         * The identifier of the application the plugin is attached to.
         * </p>
         * 
         * @param applicationId
         *        The identifier of the application the plugin is attached to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The identifier of the plugin.
         * </p>
         * 
         * @param pluginId
         *        The identifier of the plugin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pluginId(String pluginId);

        /**
         * <p>
         * The name of the plugin.
         * </p>
         * 
         * @param displayName
         *        The name of the plugin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The status of the plugin.
         * </p>
         * 
         * @param state
         *        The status of the plugin.
         * @see PluginState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PluginState
         */
        Builder state(String state);

        /**
         * <p>
         * The status of the plugin.
         * </p>
         * 
         * @param state
         *        The status of the plugin.
         * @see PluginState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PluginState
         */
        Builder state(PluginState state);

        /**
         * <p>
         * The source URL used for plugin configuration.
         * </p>
         * 
         * @param serverUrl
         *        The source URL used for plugin configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverUrl(String serverUrl);

        /**
         * <p>
         * The configuration for a custom plugin.
         * </p>
         * 
         * @param customPluginConfiguration
         *        The configuration for a custom plugin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customPluginConfiguration(CustomPluginConfiguration customPluginConfiguration);

        /**
         * <p>
         * The configuration for a custom plugin.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomPluginConfiguration.Builder}
         * avoiding the need to create one manually via {@link CustomPluginConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomPluginConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #customPluginConfiguration(CustomPluginConfiguration)}.
         * 
         * @param customPluginConfiguration
         *        a consumer that will call methods on {@link CustomPluginConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customPluginConfiguration(CustomPluginConfiguration)
         */
        default Builder customPluginConfiguration(Consumer<CustomPluginConfiguration.Builder> customPluginConfiguration) {
            return customPluginConfiguration(CustomPluginConfiguration.builder().applyMutation(customPluginConfiguration).build());
        }

        /**
         * <p>
         * The authentication configuration the plugin is using.
         * </p>
         * 
         * @param authConfiguration
         *        The authentication configuration the plugin is using.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authConfiguration(PluginAuthConfiguration authConfiguration);

        /**
         * <p>
         * The authentication configuration the plugin is using.
         * </p>
         * This is a convenience method that creates an instance of the {@link PluginAuthConfiguration.Builder} avoiding
         * the need to create one manually via {@link PluginAuthConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PluginAuthConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #authConfiguration(PluginAuthConfiguration)}.
         * 
         * @param authConfiguration
         *        a consumer that will call methods on {@link PluginAuthConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authConfiguration(PluginAuthConfiguration)
         */
        default Builder authConfiguration(Consumer<PluginAuthConfiguration.Builder> authConfiguration) {
            return authConfiguration(PluginAuthConfiguration.builder().applyMutation(authConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QBusinessRequest.BuilderImpl implements Builder {
        private String applicationId;

        private String pluginId;

        private String displayName;

        private String state;

        private String serverUrl;

        private CustomPluginConfiguration customPluginConfiguration;

        private PluginAuthConfiguration authConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePluginRequest model) {
            super(model);
            applicationId(model.applicationId);
            pluginId(model.pluginId);
            displayName(model.displayName);
            state(model.state);
            serverUrl(model.serverUrl);
            customPluginConfiguration(model.customPluginConfiguration);
            authConfiguration(model.authConfiguration);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getPluginId() {
            return pluginId;
        }

        public final void setPluginId(String pluginId) {
            this.pluginId = pluginId;
        }

        @Override
        public final Builder pluginId(String pluginId) {
            this.pluginId = pluginId;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(PluginState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getServerUrl() {
            return serverUrl;
        }

        public final void setServerUrl(String serverUrl) {
            this.serverUrl = serverUrl;
        }

        @Override
        public final Builder serverUrl(String serverUrl) {
            this.serverUrl = serverUrl;
            return this;
        }

        public final CustomPluginConfiguration.Builder getCustomPluginConfiguration() {
            return customPluginConfiguration != null ? customPluginConfiguration.toBuilder() : null;
        }

        public final void setCustomPluginConfiguration(CustomPluginConfiguration.BuilderImpl customPluginConfiguration) {
            this.customPluginConfiguration = customPluginConfiguration != null ? customPluginConfiguration.build() : null;
        }

        @Override
        public final Builder customPluginConfiguration(CustomPluginConfiguration customPluginConfiguration) {
            this.customPluginConfiguration = customPluginConfiguration;
            return this;
        }

        public final PluginAuthConfiguration.Builder getAuthConfiguration() {
            return authConfiguration != null ? authConfiguration.toBuilder() : null;
        }

        public final void setAuthConfiguration(PluginAuthConfiguration.BuilderImpl authConfiguration) {
            this.authConfiguration = authConfiguration != null ? authConfiguration.build() : null;
        }

        @Override
        public final Builder authConfiguration(PluginAuthConfiguration authConfiguration) {
            this.authConfiguration = authConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePluginRequest build() {
            return new UpdatePluginRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
