/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The text of the document.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DocumentText implements SdkPojo, Serializable, ToCopyableBuilder<DocumentText.Builder, DocumentText> {
    private static final SdkField<List<Highlight>> HIGHLIGHTS_FIELD = SdkField
            .<List<Highlight>> builder(MarshallingType.LIST)
            .memberName("highlights")
            .getter(getter(DocumentText::highlights))
            .setter(setter(Builder::highlights))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("highlights").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Highlight> builder(MarshallingType.SDK_POJO)
                                            .constructor(Highlight::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("text")
            .getter(getter(DocumentText::text)).setter(setter(Builder::text))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("text").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HIGHLIGHTS_FIELD, TEXT_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<Highlight> highlights;

    private final String text;

    private DocumentText(BuilderImpl builder) {
        this.highlights = builder.highlights;
        this.text = builder.text;
    }

    /**
     * For responses, this returns true if the service returned a value for the Highlights property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasHighlights() {
        return highlights != null && !(highlights instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Highlights in the document text.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHighlights} method.
     * </p>
     * 
     * @return Highlights in the document text.
     */
    public final List<Highlight> highlights() {
        return highlights;
    }

    /**
     * <p>
     * Text in the document.
     * </p>
     * 
     * @return Text in the document.
     */
    public final String text() {
        return text;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasHighlights() ? highlights() : null);
        hashCode = 31 * hashCode + Objects.hashCode(text());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentText)) {
            return false;
        }
        DocumentText other = (DocumentText) obj;
        return hasHighlights() == other.hasHighlights() && Objects.equals(highlights(), other.highlights())
                && Objects.equals(text(), other.text());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DocumentText").add("Highlights", hasHighlights() ? highlights() : null)
                .add("Text", text() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "highlights":
            return Optional.ofNullable(clazz.cast(highlights()));
        case "text":
            return Optional.ofNullable(clazz.cast(text()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DocumentText, T> g) {
        return obj -> g.apply((DocumentText) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DocumentText> {
        /**
         * <p>
         * Highlights in the document text.
         * </p>
         * 
         * @param highlights
         *        Highlights in the document text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder highlights(Collection<Highlight> highlights);

        /**
         * <p>
         * Highlights in the document text.
         * </p>
         * 
         * @param highlights
         *        Highlights in the document text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder highlights(Highlight... highlights);

        /**
         * <p>
         * Highlights in the document text.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qconnect.model.Highlight.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.qconnect.model.Highlight#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qconnect.model.Highlight.Builder#build()} is called immediately and
         * its result is passed to {@link #highlights(List<Highlight>)}.
         * 
         * @param highlights
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qconnect.model.Highlight.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #highlights(java.util.Collection<Highlight>)
         */
        Builder highlights(Consumer<Highlight.Builder>... highlights);

        /**
         * <p>
         * Text in the document.
         * </p>
         * 
         * @param text
         *        Text in the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder text(String text);
    }

    static final class BuilderImpl implements Builder {
        private List<Highlight> highlights = DefaultSdkAutoConstructList.getInstance();

        private String text;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentText model) {
            highlights(model.highlights);
            text(model.text);
        }

        public final List<Highlight.Builder> getHighlights() {
            List<Highlight.Builder> result = HighlightsCopier.copyToBuilder(this.highlights);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHighlights(Collection<Highlight.BuilderImpl> highlights) {
            this.highlights = HighlightsCopier.copyFromBuilder(highlights);
        }

        @Override
        public final Builder highlights(Collection<Highlight> highlights) {
            this.highlights = HighlightsCopier.copy(highlights);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder highlights(Highlight... highlights) {
            highlights(Arrays.asList(highlights));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder highlights(Consumer<Highlight.Builder>... highlights) {
            highlights(Stream.of(highlights).map(c -> Highlight.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getText() {
            return text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        @Override
        public DocumentText build() {
            return new DocumentText(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
