/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateKnowledgeBaseRequest extends QConnectRequest implements
        ToCopyableBuilder<CreateKnowledgeBaseRequest.Builder, CreateKnowledgeBaseRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateKnowledgeBaseRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateKnowledgeBaseRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> KNOWLEDGE_BASE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("knowledgeBaseType").getter(getter(CreateKnowledgeBaseRequest::knowledgeBaseTypeAsString))
            .setter(setter(Builder::knowledgeBaseType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseType").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateKnowledgeBaseRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<RenderingConfiguration> RENDERING_CONFIGURATION_FIELD = SdkField
            .<RenderingConfiguration> builder(MarshallingType.SDK_POJO).memberName("renderingConfiguration")
            .getter(getter(CreateKnowledgeBaseRequest::renderingConfiguration)).setter(setter(Builder::renderingConfiguration))
            .constructor(RenderingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("renderingConfiguration").build())
            .build();

    private static final SdkField<ServerSideEncryptionConfiguration> SERVER_SIDE_ENCRYPTION_CONFIGURATION_FIELD = SdkField
            .<ServerSideEncryptionConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("serverSideEncryptionConfiguration")
            .getter(getter(CreateKnowledgeBaseRequest::serverSideEncryptionConfiguration))
            .setter(setter(Builder::serverSideEncryptionConfiguration))
            .constructor(ServerSideEncryptionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverSideEncryptionConfiguration")
                    .build()).build();

    private static final SdkField<SourceConfiguration> SOURCE_CONFIGURATION_FIELD = SdkField
            .<SourceConfiguration> builder(MarshallingType.SDK_POJO).memberName("sourceConfiguration")
            .getter(getter(CreateKnowledgeBaseRequest::sourceConfiguration)).setter(setter(Builder::sourceConfiguration))
            .constructor(SourceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceConfiguration").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateKnowledgeBaseRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            DESCRIPTION_FIELD, KNOWLEDGE_BASE_TYPE_FIELD, NAME_FIELD, RENDERING_CONFIGURATION_FIELD,
            SERVER_SIDE_ENCRYPTION_CONFIGURATION_FIELD, SOURCE_CONFIGURATION_FIELD, TAGS_FIELD));

    private final String clientToken;

    private final String description;

    private final String knowledgeBaseType;

    private final String name;

    private final RenderingConfiguration renderingConfiguration;

    private final ServerSideEncryptionConfiguration serverSideEncryptionConfiguration;

    private final SourceConfiguration sourceConfiguration;

    private final Map<String, String> tags;

    private CreateKnowledgeBaseRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.knowledgeBaseType = builder.knowledgeBaseType;
        this.name = builder.name;
        this.renderingConfiguration = builder.renderingConfiguration;
        this.serverSideEncryptionConfiguration = builder.serverSideEncryptionConfiguration;
        this.sourceConfiguration = builder.sourceConfiguration;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided,
     * the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
     * href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with
     * idempotent APIs</a>.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
     *         provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see
     *         <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making
     *         retries safe with idempotent APIs</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The description.
     * </p>
     * 
     * @return The description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The type of knowledge base. Only CUSTOM knowledge bases allow you to upload your own content. EXTERNAL knowledge
     * bases support integrations with third-party systems whose content is synchronized automatically.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #knowledgeBaseType}
     * will return {@link KnowledgeBaseType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #knowledgeBaseTypeAsString}.
     * </p>
     * 
     * @return The type of knowledge base. Only CUSTOM knowledge bases allow you to upload your own content. EXTERNAL
     *         knowledge bases support integrations with third-party systems whose content is synchronized
     *         automatically.
     * @see KnowledgeBaseType
     */
    public final KnowledgeBaseType knowledgeBaseType() {
        return KnowledgeBaseType.fromValue(knowledgeBaseType);
    }

    /**
     * <p>
     * The type of knowledge base. Only CUSTOM knowledge bases allow you to upload your own content. EXTERNAL knowledge
     * bases support integrations with third-party systems whose content is synchronized automatically.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #knowledgeBaseType}
     * will return {@link KnowledgeBaseType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #knowledgeBaseTypeAsString}.
     * </p>
     * 
     * @return The type of knowledge base. Only CUSTOM knowledge bases allow you to upload your own content. EXTERNAL
     *         knowledge bases support integrations with third-party systems whose content is synchronized
     *         automatically.
     * @see KnowledgeBaseType
     */
    public final String knowledgeBaseTypeAsString() {
        return knowledgeBaseType;
    }

    /**
     * <p>
     * The name of the knowledge base.
     * </p>
     * 
     * @return The name of the knowledge base.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Information about how to render the content.
     * </p>
     * 
     * @return Information about how to render the content.
     */
    public final RenderingConfiguration renderingConfiguration() {
        return renderingConfiguration;
    }

    /**
     * <p>
     * The configuration information for the customer managed key used for encryption.
     * </p>
     * <p>
     * This KMS key must have a policy that allows <code>kms:CreateGrant</code>, <code>kms:DescribeKey</code>,
     * <code>kms:Decrypt</code>, and <code>kms:GenerateDataKey*</code> permissions to the IAM identity using the key to
     * invoke Amazon Q.
     * </p>
     * <p>
     * For more information about setting up a customer managed key for Amazon Q, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/enable-q.html">Enable Amazon Q in Connect for your
     * instance</a>.
     * </p>
     * 
     * @return The configuration information for the customer managed key used for encryption. </p>
     *         <p>
     *         This KMS key must have a policy that allows <code>kms:CreateGrant</code>, <code>kms:DescribeKey</code>,
     *         <code>kms:Decrypt</code>, and <code>kms:GenerateDataKey*</code> permissions to the IAM identity using the
     *         key to invoke Amazon Q.
     *         </p>
     *         <p>
     *         For more information about setting up a customer managed key for Amazon Q, see <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/enable-q.html">Enable Amazon Q in Connect for
     *         your instance</a>.
     */
    public final ServerSideEncryptionConfiguration serverSideEncryptionConfiguration() {
        return serverSideEncryptionConfiguration;
    }

    /**
     * <p>
     * The source of the knowledge base content. Only set this argument for EXTERNAL knowledge bases.
     * </p>
     * 
     * @return The source of the knowledge base content. Only set this argument for EXTERNAL knowledge bases.
     */
    public final SourceConfiguration sourceConfiguration() {
        return sourceConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for this resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags used to organize, track, or control access for this resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(renderingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(serverSideEncryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(sourceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateKnowledgeBaseRequest)) {
            return false;
        }
        CreateKnowledgeBaseRequest other = (CreateKnowledgeBaseRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(description(), other.description())
                && Objects.equals(knowledgeBaseTypeAsString(), other.knowledgeBaseTypeAsString())
                && Objects.equals(name(), other.name())
                && Objects.equals(renderingConfiguration(), other.renderingConfiguration())
                && Objects.equals(serverSideEncryptionConfiguration(), other.serverSideEncryptionConfiguration())
                && Objects.equals(sourceConfiguration(), other.sourceConfiguration()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateKnowledgeBaseRequest").add("ClientToken", clientToken()).add("Description", description())
                .add("KnowledgeBaseType", knowledgeBaseTypeAsString()).add("Name", name())
                .add("RenderingConfiguration", renderingConfiguration())
                .add("ServerSideEncryptionConfiguration", serverSideEncryptionConfiguration())
                .add("SourceConfiguration", sourceConfiguration()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "knowledgeBaseType":
            return Optional.ofNullable(clazz.cast(knowledgeBaseTypeAsString()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "renderingConfiguration":
            return Optional.ofNullable(clazz.cast(renderingConfiguration()));
        case "serverSideEncryptionConfiguration":
            return Optional.ofNullable(clazz.cast(serverSideEncryptionConfiguration()));
        case "sourceConfiguration":
            return Optional.ofNullable(clazz.cast(sourceConfiguration()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateKnowledgeBaseRequest, T> g) {
        return obj -> g.apply((CreateKnowledgeBaseRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateKnowledgeBaseRequest> {
        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         * provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
         * href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe
         * with idempotent APIs</a>.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         *        provided, the Amazon Web Services SDK populates this field. For more information about idempotency,
         *        see <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making
         *        retries safe with idempotent APIs</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The description.
         * </p>
         * 
         * @param description
         *        The description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The type of knowledge base. Only CUSTOM knowledge bases allow you to upload your own content. EXTERNAL
         * knowledge bases support integrations with third-party systems whose content is synchronized automatically.
         * </p>
         * 
         * @param knowledgeBaseType
         *        The type of knowledge base. Only CUSTOM knowledge bases allow you to upload your own content. EXTERNAL
         *        knowledge bases support integrations with third-party systems whose content is synchronized
         *        automatically.
         * @see KnowledgeBaseType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KnowledgeBaseType
         */
        Builder knowledgeBaseType(String knowledgeBaseType);

        /**
         * <p>
         * The type of knowledge base. Only CUSTOM knowledge bases allow you to upload your own content. EXTERNAL
         * knowledge bases support integrations with third-party systems whose content is synchronized automatically.
         * </p>
         * 
         * @param knowledgeBaseType
         *        The type of knowledge base. Only CUSTOM knowledge bases allow you to upload your own content. EXTERNAL
         *        knowledge bases support integrations with third-party systems whose content is synchronized
         *        automatically.
         * @see KnowledgeBaseType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KnowledgeBaseType
         */
        Builder knowledgeBaseType(KnowledgeBaseType knowledgeBaseType);

        /**
         * <p>
         * The name of the knowledge base.
         * </p>
         * 
         * @param name
         *        The name of the knowledge base.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Information about how to render the content.
         * </p>
         * 
         * @param renderingConfiguration
         *        Information about how to render the content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder renderingConfiguration(RenderingConfiguration renderingConfiguration);

        /**
         * <p>
         * Information about how to render the content.
         * </p>
         * This is a convenience method that creates an instance of the {@link RenderingConfiguration.Builder} avoiding
         * the need to create one manually via {@link RenderingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RenderingConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #renderingConfiguration(RenderingConfiguration)}.
         * 
         * @param renderingConfiguration
         *        a consumer that will call methods on {@link RenderingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #renderingConfiguration(RenderingConfiguration)
         */
        default Builder renderingConfiguration(Consumer<RenderingConfiguration.Builder> renderingConfiguration) {
            return renderingConfiguration(RenderingConfiguration.builder().applyMutation(renderingConfiguration).build());
        }

        /**
         * <p>
         * The configuration information for the customer managed key used for encryption.
         * </p>
         * <p>
         * This KMS key must have a policy that allows <code>kms:CreateGrant</code>, <code>kms:DescribeKey</code>,
         * <code>kms:Decrypt</code>, and <code>kms:GenerateDataKey*</code> permissions to the IAM identity using the key
         * to invoke Amazon Q.
         * </p>
         * <p>
         * For more information about setting up a customer managed key for Amazon Q, see <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/enable-q.html">Enable Amazon Q in Connect for
         * your instance</a>.
         * </p>
         * 
         * @param serverSideEncryptionConfiguration
         *        The configuration information for the customer managed key used for encryption. </p>
         *        <p>
         *        This KMS key must have a policy that allows <code>kms:CreateGrant</code>, <code>kms:DescribeKey</code>, <code>kms:Decrypt</code>, and <code>kms:GenerateDataKey*</code> permissions to the IAM identity
         *        using the key to invoke Amazon Q.
         *        </p>
         *        <p>
         *        For more information about setting up a customer managed key for Amazon Q, see <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/enable-q.html">Enable Amazon Q in Connect
         *        for your instance</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration serverSideEncryptionConfiguration);

        /**
         * <p>
         * The configuration information for the customer managed key used for encryption.
         * </p>
         * <p>
         * This KMS key must have a policy that allows <code>kms:CreateGrant</code>, <code>kms:DescribeKey</code>,
         * <code>kms:Decrypt</code>, and <code>kms:GenerateDataKey*</code> permissions to the IAM identity using the key
         * to invoke Amazon Q.
         * </p>
         * <p>
         * For more information about setting up a customer managed key for Amazon Q, see <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/enable-q.html">Enable Amazon Q in Connect for
         * your instance</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ServerSideEncryptionConfiguration.Builder} avoiding the need to create one manually via
         * {@link ServerSideEncryptionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServerSideEncryptionConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration)}.
         * 
         * @param serverSideEncryptionConfiguration
         *        a consumer that will call methods on {@link ServerSideEncryptionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration)
         */
        default Builder serverSideEncryptionConfiguration(
                Consumer<ServerSideEncryptionConfiguration.Builder> serverSideEncryptionConfiguration) {
            return serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration.builder()
                    .applyMutation(serverSideEncryptionConfiguration).build());
        }

        /**
         * <p>
         * The source of the knowledge base content. Only set this argument for EXTERNAL knowledge bases.
         * </p>
         * 
         * @param sourceConfiguration
         *        The source of the knowledge base content. Only set this argument for EXTERNAL knowledge bases.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceConfiguration(SourceConfiguration sourceConfiguration);

        /**
         * <p>
         * The source of the knowledge base content. Only set this argument for EXTERNAL knowledge bases.
         * </p>
         * This is a convenience method that creates an instance of the {@link SourceConfiguration.Builder} avoiding the
         * need to create one manually via {@link SourceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SourceConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #sourceConfiguration(SourceConfiguration)}.
         * 
         * @param sourceConfiguration
         *        a consumer that will call methods on {@link SourceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceConfiguration(SourceConfiguration)
         */
        default Builder sourceConfiguration(Consumer<SourceConfiguration.Builder> sourceConfiguration) {
            return sourceConfiguration(SourceConfiguration.builder().applyMutation(sourceConfiguration).build());
        }

        /**
         * <p>
         * The tags used to organize, track, or control access for this resource.
         * </p>
         * 
         * @param tags
         *        The tags used to organize, track, or control access for this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QConnectRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String description;

        private String knowledgeBaseType;

        private String name;

        private RenderingConfiguration renderingConfiguration;

        private ServerSideEncryptionConfiguration serverSideEncryptionConfiguration;

        private SourceConfiguration sourceConfiguration;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateKnowledgeBaseRequest model) {
            super(model);
            clientToken(model.clientToken);
            description(model.description);
            knowledgeBaseType(model.knowledgeBaseType);
            name(model.name);
            renderingConfiguration(model.renderingConfiguration);
            serverSideEncryptionConfiguration(model.serverSideEncryptionConfiguration);
            sourceConfiguration(model.sourceConfiguration);
            tags(model.tags);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getKnowledgeBaseType() {
            return knowledgeBaseType;
        }

        public final void setKnowledgeBaseType(String knowledgeBaseType) {
            this.knowledgeBaseType = knowledgeBaseType;
        }

        @Override
        public final Builder knowledgeBaseType(String knowledgeBaseType) {
            this.knowledgeBaseType = knowledgeBaseType;
            return this;
        }

        @Override
        public final Builder knowledgeBaseType(KnowledgeBaseType knowledgeBaseType) {
            this.knowledgeBaseType(knowledgeBaseType == null ? null : knowledgeBaseType.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final RenderingConfiguration.Builder getRenderingConfiguration() {
            return renderingConfiguration != null ? renderingConfiguration.toBuilder() : null;
        }

        public final void setRenderingConfiguration(RenderingConfiguration.BuilderImpl renderingConfiguration) {
            this.renderingConfiguration = renderingConfiguration != null ? renderingConfiguration.build() : null;
        }

        @Override
        public final Builder renderingConfiguration(RenderingConfiguration renderingConfiguration) {
            this.renderingConfiguration = renderingConfiguration;
            return this;
        }

        public final ServerSideEncryptionConfiguration.Builder getServerSideEncryptionConfiguration() {
            return serverSideEncryptionConfiguration != null ? serverSideEncryptionConfiguration.toBuilder() : null;
        }

        public final void setServerSideEncryptionConfiguration(
                ServerSideEncryptionConfiguration.BuilderImpl serverSideEncryptionConfiguration) {
            this.serverSideEncryptionConfiguration = serverSideEncryptionConfiguration != null ? serverSideEncryptionConfiguration
                    .build() : null;
        }

        @Override
        public final Builder serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration serverSideEncryptionConfiguration) {
            this.serverSideEncryptionConfiguration = serverSideEncryptionConfiguration;
            return this;
        }

        public final SourceConfiguration.Builder getSourceConfiguration() {
            return sourceConfiguration != null ? sourceConfiguration.toBuilder() : null;
        }

        public final void setSourceConfiguration(SourceConfiguration.BuilderImpl sourceConfiguration) {
            this.sourceConfiguration = sourceConfiguration != null ? sourceConfiguration.build() : null;
        }

        @Override
        public final Builder sourceConfiguration(SourceConfiguration sourceConfiguration) {
            this.sourceConfiguration = sourceConfiguration;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateKnowledgeBaseRequest build() {
            return new CreateKnowledgeBaseRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
